/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.desc.Column;
import dm.jdbc.desc.ExecuteRetInfo;
import dm.jdbc.desc.convert.DB2J;
import dm.jdbc.desc.convert.ResultSetUpdataData;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbArray;
import dm.jdbc.driver.DmdbBFile;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbInputStream;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbReader;
import dm.jdbc.driver.DmdbRef;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbRowId;
import dm.jdbc.driver.DmdbSQLXML;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.driver.DmdbStruct;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.filter.Filterable;
import dm.jdbc.util.CaseUnsensitiveMap;
import dm.jdbc.util.ConvertUtil;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.StringUtil;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class DmdbResultSet
extends Filterable
implements ResultSet {
    public DmdbConnection connection;
    public DmdbStatement statement;
    public short id = 0;
    public Column[] columns;
    public byte[][][] datas;
    public int datasOffset = -1;
    public long datasStartPos = 0L;
    public long currentPos = -1L;
    public long totalRowCount;
    public boolean updatable = false;
    public boolean bdta = false;
    public int bdtaRowidCol = 0;
    public boolean wasNull = false;
    public boolean closed = false;
    public SQLWarning warning;
    public int type = 1003;
    public int concurrency = 1007;
    public int holdability = 2;
    public int fetchDirection = 1000;
    public int fetchSize;
    public int sizeOfRow = 0;
    public ResultSetUpdataData[] insertRow;
    public boolean[] insertRowBindIndicator = null;
    public ResultSetUpdataData[] updateRow;
    public boolean[] updateRowBindIndicator = null;
    public ResultSetUpdataData[] currentRow;
    public boolean[] currentRowBindIndicator;
    private Map<String, Integer> colNameToIndexMap;
    public static AtomicLong IDGenerator = new AtomicLong(0L);

    @Override
    public long getID() {
        if (this.ID < 0L) {
            this.ID = IDGenerator.incrementAndGet();
        }
        return this.ID;
    }

    public DmdbResultSet(short id, DmdbStatement statement, ExecuteRetInfo execInfo) throws SQLException {
        this(statement, statement.columns, execInfo.rsDatas == null ? new byte[][][]{} : (byte[][][])execInfo.rsDatas);
        this.id = id;
        this.totalRowCount = execInfo.updateCount;
        this.updatable = execInfo.rsUpdatable;
        this.bdta = execInfo.rsBdta;
        this.bdtaRowidCol = execInfo.rsBdtaRowidCol;
        int n2 = this.sizeOfRow = this.datas.length > 0 ? (int)(execInfo.rsSizeof / (long)this.datas.length) : 0;
        if (this.updatable) {
            this.updateRow = new ResultSetUpdataData[this.columns.length];
            this.updateRowBindIndicator = new boolean[this.columns.length];
            this.currentRow = this.updateRow;
            this.currentRowBindIndicator = this.updateRowBindIndicator;
        }
    }

    protected DmdbResultSet(DmdbStatement stmt, Column[] columns, byte[][][] rsDatas) throws SQLException {
        super(stmt.connection, null);
        this.statement = stmt;
        this.connection = stmt.connection;
        this.type = this.statement.resultSetType;
        this.concurrency = this.statement.resultSetConcurrency;
        this.holdability = this.statement.resultSetHoldability;
        this.fetchDirection = this.statement.fetchDirection;
        this.fetchSize = this.statement.fetchSize;
        this.columns = columns == null ? new Column[]{} : columns;
        this.colNameToIndexMap = this.connection.getIgnoreCase() ? new CaseUnsensitiveMap() : new HashMap(16);
        int i2 = this.columns.length - 1;
        while (i2 >= 0) {
            this.colNameToIndexMap.put(this.columns[i2].name, i2 + 1);
            --i2;
        }
        this.datas = rsDatas == null ? (Object)new byte[0][][] : rsDatas;
        this.totalRowCount = rsDatas == null ? 0 : rsDatas.length;
        this.updatable = false;
        this.bdta = false;
    }

    public static DmdbResultSet newLocalResultSet(DmdbStatement stmt, Column[] columns, byte[][][] rsDatas) throws SQLException {
        return new DmdbResultSet(stmt, columns, rsDatas);
    }

    public static DmdbResultSet newEmptyResultSet(DmdbStatement stmt) throws SQLException {
        return new DmdbResultSet(stmt, null, null);
    }

    public void checkClosed() throws SQLException {
        if (this.closed) {
            DBError.ECJDBC_RESULTSET_CLOSED.throwz(new Object[0]);
        }
    }

    public void do_close() throws SQLException {
        this.closed = true;
        if (this.statement != null && this.statement.openedResultSets != null && this.statement.openedResultSets.contains(this)) {
            this.statement.openedResultSets.remove(this);
        }
        if (this.statement != null && this.statement.do_isCloseOnCompletion() && (this.statement.openedResultSets == null || this.statement.openedResultSets.size() == 0) && (this.statement.curResultSet == null || this.statement.curResultSet.closed)) {
            this.statement.do_close();
        }
        this.statement = null;
        this.columns = null;
        this.datas = null;
        this.insertRow = null;
        this.insertRowBindIndicator = null;
        this.updateRow = null;
        this.updateRowBindIndicator = null;
    }

    public SQLWarning do_getWarnings() throws SQLException {
        this.checkClosed();
        return this.warning;
    }

    public void do_clearWarnings() throws SQLException {
        this.checkClosed();
        this.warning = null;
    }

    public String do_getCursorName() throws SQLException {
        this.checkClosed();
        if (this.statement == null) {
            return null;
        }
        if (this.statement.cursorName == null) {
            this.statement.do_setCursorName("BPXLYBHQ" + this.statement.handle);
        }
        return this.statement.cursorName;
    }

    public DmdbResultSetMetaData do_getMetaData() throws SQLException {
        this.checkClosed();
        return new DmdbResultSetMetaData(this.connection, this.columns);
    }

    public boolean do_isBeforeFirst() throws SQLException {
        this.checkClosed();
        return this.totalRowCount != 0L && this.currentPos <= -1L;
    }

    public boolean do_isAfterLast() throws SQLException {
        this.checkClosed();
        return this.currentPos >= this.totalRowCount;
    }

    public boolean do_isFirst() throws SQLException {
        this.checkClosed();
        return this.currentPos == 0L && this.totalRowCount > 0L;
    }

    public boolean do_isLast() throws SQLException {
        this.checkClosed();
        if (this.type == 1003) {
            DBError.ECJDBC_INVALID_RESULTSET_TYPE.throwz(new Object[0]);
        }
        if (this.totalRowCount == Long.MAX_VALUE) {
            this.totalRowCount = this.connection.dbAccess.a(this);
        }
        return this.currentPos == this.totalRowCount - 1L && this.totalRowCount > 0L;
    }

    public void do_beforeFirst() throws SQLException {
        this.checkClosed();
        if (this.type == 1003) {
            DBError.ECJDBC_INVALID_RESULTSET_TYPE.throwz(new Object[0]);
        }
        this.currentPos = -1L;
        this.datasOffset = -1;
    }

    public void do_afterLast() throws SQLException {
        this.checkClosed();
        if (this.type == 1003) {
            DBError.ECJDBC_INVALID_RESULTSET_TYPE.throwz(new Object[0]);
        }
        if (this.totalRowCount == Long.MAX_VALUE) {
            this.totalRowCount = this.connection.dbAccess.a(this);
        }
        this.currentPos = this.totalRowCount;
        this.datasOffset = this.datas == null ? 0 : this.datas.length;
    }

    public boolean do_first() throws SQLException {
        this.checkClosed();
        if (this.type == 1003) {
            DBError.ECJDBC_INVALID_RESULTSET_TYPE.throwz(new Object[0]);
        }
        return this.do_absolute(1);
    }

    public boolean do_last() throws SQLException {
        this.checkClosed();
        if (this.type == 1003) {
            DBError.ECJDBC_INVALID_RESULTSET_TYPE.throwz(new Object[0]);
        }
        if (this.totalRowCount == Long.MAX_VALUE) {
            this.totalRowCount = this.connection.dbAccess.a(this);
        }
        return this.totalRowCount == 0L ? false : this.do_absolute((int)this.totalRowCount);
    }

    public int do_getRow() throws SQLException {
        this.checkClosed();
        return (int)(this.currentPos + 1L);
    }

    public boolean do_absolute(int row) throws SQLException {
        this.checkClosed();
        if (row == 0) {
            DBError.ECJDBC_INVALUID_ROW_NUMBER.throwz(new Object[0]);
        }
        if (this.type == 1003) {
            DBError.ECJDBC_INVALID_RESULTSET_TYPE.throwz(new Object[0]);
        }
        long destRow = row;
        if (row < 0) {
            if (this.totalRowCount == Long.MAX_VALUE) {
                this.totalRowCount = this.connection.dbAccess.a(this);
            }
            destRow = this.totalRowCount + (long)row;
        } else {
            --destRow;
        }
        if (destRow >= this.datasStartPos && destRow < this.datasStartPos + (long)this.datas.length) {
            this.currentPos = destRow;
            this.datasOffset = (int)(this.currentPos - this.datasStartPos);
            return true;
        }
        if (destRow >= 0L && destRow < this.totalRowCount) {
            this.currentPos = destRow;
            if (this.fetchData(destRow)) {
                this.datasOffset = 0;
                return true;
            }
            return false;
        }
        if (row > 0) {
            this.currentPos = this.totalRowCount;
            this.datasOffset = this.datas.length;
        } else {
            this.currentPos = -1L;
            this.datasOffset = -1;
        }
        return false;
    }

    public boolean do_relative(int rows) throws SQLException {
        int rowNum;
        this.checkClosed();
        if (this.type == 1003) {
            DBError.ECJDBC_INVALID_RESULTSET_TYPE.throwz(new Object[0]);
        }
        if ((rowNum = (int)(this.currentPos + (long)rows + 1L)) < 1) {
            this.do_beforeFirst();
            return false;
        }
        if ((long)rowNum > this.totalRowCount) {
            this.do_afterLast();
            return false;
        }
        return this.do_absolute(rowNum);
    }

    public boolean do_next() throws SQLException {
        this.checkClosed();
        if (this.totalRowCount == 0L) {
            ++this.currentPos;
            return false;
        }
        if (this.currentPos >= this.totalRowCount) {
            return false;
        }
        if (this.currentPos == this.totalRowCount - 1L) {
            ++this.currentPos;
            ++this.datasOffset;
            return false;
        }
        if (this.currentPos + 1L < this.datasStartPos || this.currentPos + 1L >= this.datasStartPos + (long)this.datas.length) {
            if (this.fetchData(this.currentPos + 1L)) {
                ++this.currentPos;
                return true;
            }
            ++this.currentPos;
            ++this.datasOffset;
            return false;
        }
        ++this.datasOffset;
        ++this.currentPos;
        return true;
    }

    public boolean do_previous() throws SQLException {
        this.checkClosed();
        if (this.type == 1003) {
            DBError.ECJDBC_INVALID_RESULTSET_TYPE.throwz(new Object[0]);
        }
        if (this.currentPos <= -1L) {
            return false;
        }
        if (this.currentPos == 0L) {
            --this.currentPos;
            --this.datasOffset;
            return false;
        }
        if (this.currentPos - 1L < this.datasStartPos || this.currentPos - 1L >= this.datasStartPos + (long)this.datas.length) {
            int maxRowSize = Column.getMaxTupleLen(this.columns, this.connection.maxRowSize);
            int maxRowCount = 32640 / maxRowSize;
            long startPos = this.currentPos - (long)(maxRowCount / 2);
            if (startPos < 0L) {
                startPos = 0L;
            }
            this.fetchData(startPos);
            this.datasOffset = (int)(this.currentPos - startPos) - 1;
            --this.currentPos;
            return true;
        }
        --this.datasOffset;
        --this.currentPos;
        return true;
    }

    public boolean fetchData(long startPos) throws SQLException {
        ExecuteRetInfo execInfo = this.connection.dbAccess.a(this, startPos);
        this.totalRowCount = execInfo.updateCount;
        if (execInfo.rsDatas != null) {
            this.datas = execInfo.rsDatas;
            this.datasStartPos = startPos;
            this.datasOffset = 0;
            return true;
        }
        return false;
    }

    public void do_setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        if (direction != 1002 && direction != 1000 && direction != 1001) {
            DBError.ECJDBC_INVALID_CURSOR_MOVE_DIRECTION.throwz(new Object[0]);
        }
        if (this.type == 1003 && direction != 1000) {
            DBError.ECJDBC_FORWORD_ONLY_RESULTSET.throwz(new Object[0]);
        }
        this.fetchDirection = direction;
    }

    public int do_getFetchDirection() throws SQLException {
        this.checkClosed();
        return this.fetchDirection;
    }

    public void do_setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (rows < 0 || this.statement != null && this.statement.maxRows > 0L && (long)rows > this.statement.maxRows) {
            DBError.ECJDBC_INVALUID_ROW_NUMBER.throwz(new Object[0]);
        }
        this.fetchSize = rows;
    }

    public int do_getFetchSize() throws SQLException {
        this.checkClosed();
        return ConvertUtil.toInt(this.fetchSize);
    }

    public int do_getType() throws SQLException {
        this.checkClosed();
        return this.type;
    }

    public int do_getConcurrency() throws SQLException {
        this.checkClosed();
        return this.concurrency;
    }

    public DmdbStatement do_getStatement() throws SQLException {
        this.checkClosed();
        return this.statement;
    }

    private byte[] getColumnData(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkCurrentRow();
        this.checkColumnIndex(columnIndex);
        byte[] data = this.datas[this.datasOffset][columnIndex];
        this.wasNull = data == null;
        this.columns[columnIndex - 1].isBdta = this.bdta;
        return data;
    }

    private void checkColumnIndex(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.columns.length) {
            DBError.ECJDBC_INVALID_SEQUENCE_NUMBER.throwz(new Object[0]);
        }
    }

    private void checkCurrentRow() throws SQLException {
        if (this.totalRowCount == 0L || this.do_isBeforeFirst() || this.do_isAfterLast()) {
            DBError.ECJDBC_CURSOR_NOT_IN_RESULTSET.throwz(new Object[0]);
        }
    }

    public boolean do_wasNull() throws SQLException {
        this.checkClosed();
        return this.wasNull;
    }

    public String do_getString(int columnIndex) throws SQLException {
        byte[] colBytes = this.getColumnData(columnIndex);
        return colBytes != null ? DB2J.toString(colBytes, this.columns[columnIndex - 1], this.connection) : null;
    }

    public boolean do_getBoolean(int columnIndex) throws SQLException {
        byte[] colBytes = this.getColumnData(columnIndex);
        return colBytes != null && DB2J.toBoolean(colBytes, this.columns[columnIndex - 1], this.connection);
    }

    public byte do_getByte(int columnIndex) throws SQLException {
        byte[] colBytes = this.getColumnData(columnIndex);
        return colBytes != null ? DB2J.toByte(colBytes, this.columns[columnIndex - 1], this.connection) : (byte)0;
    }

    public short do_getShort(int columnIndex) throws SQLException {
        byte[] colBytes = this.getColumnData(columnIndex);
        return colBytes != null ? DB2J.toShort(colBytes, this.columns[columnIndex - 1], this.connection) : (short)0;
    }

    public int do_getInt(int columnIndex) throws SQLException {
        byte[] colBytes = this.getColumnData(columnIndex);
        return colBytes != null ? DB2J.toInt(colBytes, this.columns[columnIndex - 1], this.connection) : 0;
    }

    public long do_getLong(int columnIndex) throws SQLException {
        byte[] colBytes = this.getColumnData(columnIndex);
        return colBytes != null ? DB2J.toLong(colBytes, this.columns[columnIndex - 1], this.connection) : 0L;
    }

    public float do_getFloat(int columnIndex) throws SQLException {
        byte[] colBytes = this.getColumnData(columnIndex);
        return colBytes != null ? DB2J.toFloat(colBytes, this.columns[columnIndex - 1], this.connection) : 0.0f;
    }

    public double do_getDouble(int columnIndex) throws SQLException {
        byte[] colBytes = this.getColumnData(columnIndex);
        return colBytes != null ? DB2J.toDouble(colBytes, this.columns[columnIndex - 1], this.connection) : 0.0;
    }

    public BigDecimal do_getBigDecimal(int columnIndex, int scale) throws SQLException {
        byte[] colBytes = this.getColumnData(columnIndex);
        return colBytes != null ? DB2J.toBigDecimal(colBytes, this.columns[columnIndex - 1], this.connection, scale) : null;
    }

    public byte[] do_getBytes(int columnIndex) throws SQLException {
        byte[] colBytes = this.getColumnData(columnIndex);
        return colBytes != null ? DB2J.toBytes(colBytes, this.columns[columnIndex - 1], this.connection) : null;
    }

    public Date do_getDate(int columnIndex) throws SQLException {
        return this.do_getDate(columnIndex, null);
    }

    public Time do_getTime(int columnIndex) throws SQLException {
        return this.do_getTime(columnIndex, null);
    }

    public Timestamp do_getTimestamp(int columnIndex) throws SQLException {
        return this.do_getTimestamp(columnIndex, null);
    }

    public DmdbInputStream do_getAsciiStream(int columnIndex) throws SQLException {
        byte[] colBytes = this.getColumnData(columnIndex);
        return colBytes != null ? DB2J.toAsciiStream(colBytes, this.columns[columnIndex - 1], this.connection) : null;
    }

    public DmdbInputStream do_getUnicodeStream(int columnIndex) throws SQLException {
        byte[] colBytes = this.getColumnData(columnIndex);
        return colBytes != null ? DB2J.toUnicodeStream(colBytes, this.columns[columnIndex - 1], this.connection) : null;
    }

    public DmdbInputStream do_getBinaryStream(int columnIndex) throws SQLException {
        byte[] colBytes = this.getColumnData(columnIndex);
        return colBytes != null ? DB2J.toBinaryStream(colBytes, this.columns[columnIndex - 1], this.connection) : null;
    }

    public Object do_getObject(int columnIndex) throws SQLException {
        return this.do_getObject(columnIndex, this.connection.do_getTypeMap());
    }

    public DmdbReader do_getCharacterStream(int columnIndex) throws SQLException {
        byte[] colBytes = this.getColumnData(columnIndex);
        return colBytes != null ? DB2J.toCharacterStream(colBytes, this.columns[columnIndex - 1], this.connection) : null;
    }

    public BigDecimal do_getBigDecimal(int columnIndex) throws SQLException {
        byte[] colBytes = this.getColumnData(columnIndex);
        return colBytes != null ? DB2J.toBigDecimal(colBytes, this.columns[columnIndex - 1], this.connection) : null;
    }

    public Object do_getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        this.checkColumnIndex(columnIndex);
        Object val = null;
        Column column = this.columns[columnIndex - 1];
        if (this.connection.compatibleOracle() && DmdbType.isNumeric(column.type)) {
            return this.do_getBigDecimal(columnIndex);
        }
        switch (column.type) {
            case 3: 
            case 13: {
                val = this.do_getBoolean(columnIndex);
                break;
            }
            case 5: {
                val = this.do_getByte(columnIndex);
                break;
            }
            case 6: {
                val = this.do_getShort(columnIndex);
                break;
            }
            case 7: {
                val = this.do_getInt(columnIndex);
                break;
            }
            case 8: {
                val = this.do_getLong(columnIndex);
                break;
            }
            case 9: {
                val = this.do_getBigDecimal(columnIndex);
                break;
            }
            case 10: {
                val = Float.valueOf(this.do_getFloat(columnIndex));
                break;
            }
            case 11: {
                val = this.do_getDouble(columnIndex);
                break;
            }
            case 14: {
                val = this.do_getDate(columnIndex);
                break;
            }
            case 15: {
                val = this.do_getTime(columnIndex);
                break;
            }
            case 16: 
            case 26: {
                val = this.do_getTimestamp(columnIndex);
                break;
            }
            case 22: 
            case 23: 
            case 27: {
                val = this.getTIMESTAMP(columnIndex);
                break;
            }
            case 17: 
            case 18: {
                val = this.do_getBytes(columnIndex);
                break;
            }
            case 12: {
                if (DmdbType.isComplexType(column.type, column.scale)) {
                    byte[] bytes = this.getColumnData(columnIndex);
                    val = bytes != null ? DB2J.toComplexType(bytes, column, this.connection, map) : null;
                    break;
                }
                if (StringUtil.equalsIgnoreCase(column.typeName, "LONGVARBINARY")) {
                    val = this.do_getBytes(columnIndex);
                    break;
                }
                val = this.do_getBlob(columnIndex);
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                val = this.do_getString(columnIndex);
                if (val == null || column.mask != 3) break;
                val = new DmdbBFile((String)val);
                break;
            }
            case 19: {
                val = StringUtil.equalsIgnoreCase(column.typeName, "LONGVARCHAR") ? this.do_getString(columnIndex) : this.do_getClob(columnIndex);
                break;
            }
            case 20: {
                val = this.getINTERVALYM(columnIndex);
                break;
            }
            case 21: {
                val = this.getINTERVALDT(columnIndex);
                break;
            }
            case 117: 
            case 119: 
            case 121: 
            case 122: {
                byte[] bytes = this.getColumnData(columnIndex);
                val = bytes != null ? DB2J.toComplexType(bytes, column, this.connection, map) : null;
                break;
            }
            case 28: {
                val = this.do_getRowId(columnIndex);
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            }
        }
        return this.wasNull ? null : val;
    }

    public Ref do_getRef(int columnIndex) throws SQLException {
        Object obj = this.do_getObject(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Struct || obj instanceof SQLData) {
            return new DmdbRef(obj);
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        return null;
    }

    public DmdbBlob do_getBlob(int columnIndex) throws SQLException {
        byte[] colBytes = this.getColumnData(columnIndex);
        return colBytes != null ? DB2J.toBlob(colBytes, this.columns[columnIndex - 1], this.connection) : null;
    }

    public DmdbClob do_getClob(int columnIndex) throws SQLException {
        byte[] colBytes = this.getColumnData(columnIndex);
        return colBytes != null ? DB2J.toClob(colBytes, this.columns[columnIndex - 1], this.connection) : null;
    }

    public DmdbArray do_getArray(int columnIndex) throws SQLException {
        byte[] colBytes = this.getColumnData(columnIndex);
        return colBytes != null ? DB2J.toArray(colBytes, this.columns[columnIndex - 1], this.connection) : null;
    }

    public DmdbStruct do_getStruct(int columnIndex) throws SQLException {
        byte[] colBytes = this.getColumnData(columnIndex);
        return colBytes != null ? DB2J.toStruct(colBytes, this.columns[columnIndex - 1], this.connection) : null;
    }

    public Date do_getDate(int columnIndex, Calendar cal) throws SQLException {
        byte[] colBytes = this.getColumnData(columnIndex);
        return colBytes != null ? DB2J.toDate(colBytes, this.columns[columnIndex - 1], this.connection, cal) : null;
    }

    public Time do_getTime(int columnIndex, Calendar cal) throws SQLException {
        byte[] colBytes = this.getColumnData(columnIndex);
        return colBytes != null ? DB2J.toTime(colBytes, this.columns[columnIndex - 1], this.connection, cal != null ? (Calendar)cal.clone() : null) : null;
    }

    public Timestamp do_getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        byte[] colBytes = this.getColumnData(columnIndex);
        return colBytes != null ? DB2J.toTimestamp(colBytes, this.columns[columnIndex - 1], this.connection, cal != null ? (Calendar)cal.clone() : null) : null;
    }

    public URL do_getURL(int columnIndex) throws SQLException {
        String str = this.do_getString(columnIndex);
        if (str == null) {
            return null;
        }
        try {
            return new URL(str);
        }
        catch (Exception e2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
            return null;
        }
    }

    public int do_findColumn(String columnLabel) throws SQLException {
        Integer retIndex;
        this.checkClosed();
        if (StringUtil.isEmpty(columnLabel)) {
            DBError.ECJDBC_INVALID_COLUMN_NAME.throwz(new Object[0]);
        }
        if ((retIndex = this.colNameToIndexMap.get(columnLabel)) == null) {
            DBError.ECJDBC_INVALID_COLUMN_NAME.throwz(new Object[0]);
        }
        return retIndex;
    }

    public String do_getString(String columnLabel) throws SQLException {
        return this.do_getString(this.do_findColumn(columnLabel));
    }

    public boolean do_getBoolean(String columnLabel) throws SQLException {
        return this.do_getBoolean(this.do_findColumn(columnLabel));
    }

    public byte do_getByte(String columnLabel) throws SQLException {
        return this.do_getByte(this.do_findColumn(columnLabel));
    }

    public short do_getShort(String columnLabel) throws SQLException {
        return this.do_getShort(this.do_findColumn(columnLabel));
    }

    public int do_getInt(String columnLabel) throws SQLException {
        return this.do_getInt(this.do_findColumn(columnLabel));
    }

    public long do_getLong(String columnLabel) throws SQLException {
        return this.do_getLong(this.do_findColumn(columnLabel));
    }

    public float do_getFloat(String columnLabel) throws SQLException {
        return this.do_getFloat(this.do_findColumn(columnLabel));
    }

    public double do_getDouble(String columnLabel) throws SQLException {
        return this.do_getDouble(this.do_findColumn(columnLabel));
    }

    public BigDecimal do_getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.do_getBigDecimal(this.do_findColumn(columnLabel), scale);
    }

    public byte[] do_getBytes(String columnLabel) throws SQLException {
        return this.do_getBytes(this.do_findColumn(columnLabel));
    }

    public Date do_getDate(String columnLabel) throws SQLException {
        return this.do_getDate(this.do_findColumn(columnLabel));
    }

    public Time do_getTime(String columnLabel) throws SQLException {
        return this.do_getTime(this.do_findColumn(columnLabel));
    }

    public Timestamp do_getTimestamp(String columnLabel) throws SQLException {
        return this.do_getTimestamp(this.do_findColumn(columnLabel));
    }

    public DmdbInputStream do_getAsciiStream(String columnLabel) throws SQLException {
        return this.do_getAsciiStream(this.do_findColumn(columnLabel));
    }

    public DmdbInputStream do_getUnicodeStream(String columnLabel) throws SQLException {
        return this.do_getUnicodeStream(this.do_findColumn(columnLabel));
    }

    public DmdbInputStream do_getBinaryStream(String columnLabel) throws SQLException {
        return this.do_getBinaryStream(this.do_findColumn(columnLabel));
    }

    public Object do_getObject(String columnLabel) throws SQLException {
        return this.do_getObject(this.do_findColumn(columnLabel));
    }

    public DmdbReader do_getCharacterStream(String columnLabel) throws SQLException {
        return this.do_getCharacterStream(this.do_findColumn(columnLabel));
    }

    public BigDecimal do_getBigDecimal(String columnLabel) throws SQLException {
        return this.do_getBigDecimal(this.do_findColumn(columnLabel));
    }

    public Object do_getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return this.do_getObject(this.do_findColumn(columnLabel), map);
    }

    public Ref do_getRef(String columnLabel) throws SQLException {
        return this.do_getRef(this.do_findColumn(columnLabel));
    }

    public DmdbBlob do_getBlob(String columnLabel) throws SQLException {
        return this.do_getBlob(this.do_findColumn(columnLabel));
    }

    public DmdbClob do_getClob(String columnLabel) throws SQLException {
        return this.do_getClob(this.do_findColumn(columnLabel));
    }

    public DmdbArray do_getArray(String columnLabel) throws SQLException {
        return this.do_getArray(this.do_findColumn(columnLabel));
    }

    public Date do_getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.do_getDate(this.do_findColumn(columnLabel), cal);
    }

    public Time do_getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.do_getTime(this.do_findColumn(columnLabel), cal);
    }

    public Timestamp do_getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.do_getTimestamp(this.do_findColumn(columnLabel), cal);
    }

    public URL do_getURL(String columnLabel) throws SQLException {
        return this.do_getURL(this.do_findColumn(columnLabel));
    }

    public boolean do_rowUpdated() throws SQLException {
        this.checkClosed();
        return false;
    }

    public boolean do_rowInserted() throws SQLException {
        this.checkClosed();
        return false;
    }

    public boolean do_rowDeleted() throws SQLException {
        this.checkClosed();
        return false;
    }

    public void do_insertRow() throws SQLException {
        this.checkClosed();
        this.checkUpdatable();
        if (this.currentRow != this.insertRow) {
            DBError.ECJDBC_RESULTSET_NOT_IN_INSERT_STATUS.throwz(new Object[0]);
        }
        if (!this.checkColumnBindes()) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ");
        sql.append("\"").append(StringUtil.processDoubleQuoteOfName(this.columns[0].schemaName)).append("\"");
        sql.append(".\"").append(StringUtil.processDoubleQuoteOfName(this.columns[0].tableName)).append("\" ( ");
        StringBuilder paramEntity = new StringBuilder();
        int count = 0;
        int i2 = 0;
        while (i2 < this.columns.length) {
            if (this.insertRowBindIndicator[i2]) {
                if (count > 0) {
                    sql.append(" , ");
                    paramEntity.append(" , ");
                }
                sql.append("\"").append(StringUtil.processDoubleQuoteOfName(this.columns[i2].name)).append("\"");
                paramEntity.append(" ? ");
                ++count;
            }
            ++i2;
        }
        sql.append(") values(").append((CharSequence)paramEntity).append(")");
        DriverUtil.executePrepare(this.connection, sql.toString(), this.insertRow, this.insertRowBindIndicator);
        this.clearInsertRow();
    }

    public void do_updateRow() throws SQLException {
        this.checkClosed();
        this.checkUpdatable();
        if (this.currentRow == this.insertRow) {
            DBError.ECJDBC_RESULTSET_IN_INSERT_STATUS.throwz(new Object[0]);
        }
        this.checkCurrentRow();
        if (!this.checkColumnBindes()) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("update ");
        sql.append("\"").append(StringUtil.processDoubleQuoteOfName(this.columns[0].schemaName)).append("\"");
        sql.append(".\"").append(StringUtil.processDoubleQuoteOfName(this.columns[0].tableName)).append("\" ");
        int count = 0;
        int i2 = 0;
        while (i2 < this.updateRow.length) {
            if (this.updateRowBindIndicator[i2]) {
                sql.append(count == 0 ? "set " : ", ");
                sql.append("\"").append(StringUtil.processDoubleQuoteOfName(this.columns[i2].name)).append("\" = ? ");
                ++count;
            }
            ++i2;
        }
        sql.append(" where current of \"").append(StringUtil.processDoubleQuoteOfName(this.do_getCursorName())).append("\"");
        DriverUtil.executePrepareCursorUpdate(this.connection, sql.toString(), this.updateRow, this.updateRowBindIndicator, this.currentPos);
        this.clearUpdateRow();
    }

    public void do_deleteRow() throws SQLException {
        this.checkClosed();
        this.checkUpdatable();
        if (this.currentRow == this.insertRow) {
            DBError.ECJDBC_RESULTSET_IN_INSERT_STATUS.throwz(new Object[0]);
        }
        this.checkCurrentRow();
        String sql = "DELETE FROM \"" + StringUtil.processDoubleQuoteOfName(this.columns[0].schemaName) + "\".\"" + StringUtil.processDoubleQuoteOfName(this.columns[0].tableName) + "\" WHERE CURRENT OF \"" + StringUtil.processDoubleQuoteOfName(this.do_getCursorName()) + "\"";
        DriverUtil.executeCursorUpdate(this.connection, sql, this.currentPos);
        this.clearUpdateRow();
    }

    public void do_refreshRow() throws SQLException {
        this.checkClosed();
        if (this.type == 1003) {
            DBError.ECJDBC_INVALID_RESULTSET_TYPE.throwz(new Object[0]);
        }
        if (this.currentRow == this.insertRow) {
            DBError.ECJDBC_RESULTSET_IN_INSERT_STATUS.throwz(new Object[0]);
        }
        this.clearUpdateRow();
    }

    public void do_cancelRowUpdates() throws SQLException {
        this.checkClosed();
        this.checkUpdatable();
        this.clearUpdateRow();
        this.clearInsertRow();
    }

    public void do_moveToInsertRow() throws SQLException {
        this.checkClosed();
        this.checkUpdatable();
        if (this.insertRow == null) {
            this.insertRow = new ResultSetUpdataData[this.columns.length];
            this.insertRowBindIndicator = new boolean[this.columns.length];
        }
        this.currentRow = this.insertRow;
        this.currentRowBindIndicator = this.insertRowBindIndicator;
    }

    public void do_moveToCurrentRow() throws SQLException {
        this.checkClosed();
        this.checkUpdatable();
        this.currentRow = this.updateRow;
        this.currentRowBindIndicator = this.updateRowBindIndicator;
    }

    private void updateColumn(int columnIndex, Object x2) throws SQLException {
        this.checkClosed();
        this.checkUpdatable();
        this.checkColumnIndex(columnIndex);
        if (this.currentRow != this.insertRow) {
            this.checkCurrentRow();
        }
        if (x2 == null) {
            this.checkColumnNullable(columnIndex);
        }
        this.currentRow[columnIndex - 1] = new ResultSetUpdataData(x2);
        this.currentRowBindIndicator[columnIndex - 1] = true;
    }

    private void updateColumn(int columnIndex, Object x2, int targetSqlType) throws SQLException {
        this.updateColumn(columnIndex, x2);
        this.currentRow[columnIndex - 1].jType = targetSqlType;
    }

    private void updateColumn(int columnIndex, Object x2, int targetSqlType, long length) throws SQLException {
        this.updateColumn(columnIndex, x2, targetSqlType);
        this.currentRow[columnIndex - 1].scaleOrLength = length;
    }

    public void do_updateNull(int columnIndex) throws SQLException {
        this.updateColumn(columnIndex, null);
    }

    public void do_updateBoolean(int columnIndex, boolean x2) throws SQLException {
        this.updateColumn(columnIndex, x2);
    }

    public void do_updateByte(int columnIndex, byte x2) throws SQLException {
        this.updateColumn(columnIndex, x2);
    }

    public void do_updateShort(int columnIndex, short x2) throws SQLException {
        this.updateColumn(columnIndex, x2);
    }

    public void do_updateInt(int columnIndex, int x2) throws SQLException {
        this.updateColumn(columnIndex, x2);
    }

    public void do_updateLong(int columnIndex, long x2) throws SQLException {
        this.updateColumn(columnIndex, x2);
    }

    public void do_updateFloat(int columnIndex, float x2) throws SQLException {
        this.updateColumn(columnIndex, Float.valueOf(x2));
    }

    public void do_updateDouble(int columnIndex, double x2) throws SQLException {
        this.updateColumn(columnIndex, x2);
    }

    public void do_updateBigDecimal(int columnIndex, BigDecimal x2) throws SQLException {
        this.updateColumn(columnIndex, x2);
    }

    public void do_updateString(int columnIndex, String x2) throws SQLException {
        this.updateColumn(columnIndex, x2);
    }

    public void do_updateBytes(int columnIndex, byte[] x2) throws SQLException {
        this.updateColumn(columnIndex, x2);
    }

    public void do_updateDate(int columnIndex, Date x2) throws SQLException {
        this.updateColumn(columnIndex, x2);
    }

    public void do_updateTime(int columnIndex, Time x2) throws SQLException {
        this.updateColumn(columnIndex, x2);
    }

    public void do_updateTimestamp(int columnIndex, Timestamp x2) throws SQLException {
        this.updateColumn(columnIndex, x2);
    }

    public void do_updateAsciiStream(int columnIndex, InputStream x2, int length) throws SQLException {
        this.updateColumn(columnIndex, x2, 2004, length);
    }

    public void do_updateBinaryStream(int columnIndex, InputStream x2, int length) throws SQLException {
        this.updateColumn(columnIndex, x2, 2004, length);
    }

    public void do_updateCharacterStream(int columnIndex, Reader x2, int length) throws SQLException {
        this.updateColumn(columnIndex, x2, 2005, length);
    }

    public void do_updateObject(int columnIndex, Object x2, int scaleOrLength) throws SQLException {
        this.updateColumn(columnIndex, x2, 1111, scaleOrLength);
    }

    public void do_updateObject(int columnIndex, Object x2) throws SQLException {
        this.updateColumn(columnIndex, x2);
    }

    public void do_updateRef(int columnIndex, Ref x2) throws SQLException {
        this.updateColumn(columnIndex, x2 == null ? null : x2.getObject());
    }

    public void do_updateBlob(int columnIndex, Blob x2) throws SQLException {
        this.updateColumn(columnIndex, x2);
    }

    public void do_updateClob(int columnIndex, Clob x2) throws SQLException {
        this.updateColumn(columnIndex, x2);
    }

    public void do_updateArray(int columnIndex, Array x2) throws SQLException {
        this.updateColumn(columnIndex, x2);
    }

    public void do_updateNull(String columnLabel) throws SQLException {
        this.do_updateNull(this.do_findColumn(columnLabel));
    }

    public void do_updateBoolean(String columnLabel, boolean x2) throws SQLException {
        this.do_updateBoolean(this.do_findColumn(columnLabel), x2);
    }

    public void do_updateByte(String columnLabel, byte x2) throws SQLException {
        this.do_updateByte(this.do_findColumn(columnLabel), x2);
    }

    public void do_updateShort(String columnLabel, short x2) throws SQLException {
        this.do_updateShort(this.do_findColumn(columnLabel), x2);
    }

    public void do_updateInt(String columnLabel, int x2) throws SQLException {
        this.do_updateInt(this.do_findColumn(columnLabel), x2);
    }

    public void do_updateLong(String columnLabel, long x2) throws SQLException {
        this.do_updateLong(this.do_findColumn(columnLabel), x2);
    }

    public void do_updateFloat(String columnLabel, float x2) throws SQLException {
        this.do_updateFloat(this.do_findColumn(columnLabel), x2);
    }

    public void do_updateDouble(String columnLabel, double x2) throws SQLException {
        this.do_updateDouble(this.do_findColumn(columnLabel), x2);
    }

    public void do_updateBigDecimal(String columnLabel, BigDecimal x2) throws SQLException {
        this.do_updateBigDecimal(this.do_findColumn(columnLabel), x2);
    }

    public void do_updateString(String columnLabel, String x2) throws SQLException {
        this.do_updateString(this.do_findColumn(columnLabel), x2);
    }

    public void do_updateBytes(String columnLabel, byte[] x2) throws SQLException {
        this.do_updateBytes(this.do_findColumn(columnLabel), x2);
    }

    public void do_updateDate(String columnLabel, Date x2) throws SQLException {
        this.do_updateDate(this.do_findColumn(columnLabel), x2);
    }

    public void do_updateTime(String columnLabel, Time x2) throws SQLException {
        this.do_updateTime(this.do_findColumn(columnLabel), x2);
    }

    public void do_updateTimestamp(String columnLabel, Timestamp x2) throws SQLException {
        this.do_updateTimestamp(this.do_findColumn(columnLabel), x2);
    }

    public void do_updateAsciiStream(String columnLabel, InputStream x2, int length) throws SQLException {
        this.do_updateAsciiStream(this.do_findColumn(columnLabel), x2, length);
    }

    public void do_updateBinaryStream(String columnLabel, InputStream x2, int length) throws SQLException {
        this.do_updateBinaryStream(this.do_findColumn(columnLabel), x2, length);
    }

    public void do_updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        this.do_updateCharacterStream(this.do_findColumn(columnLabel), reader, length);
    }

    public void do_updateObject(String columnLabel, Object x2, int scaleOrLength) throws SQLException {
        this.do_updateObject(this.do_findColumn(columnLabel), x2, scaleOrLength);
    }

    public void do_updateObject(String columnLabel, Object x2) throws SQLException {
        this.do_updateObject(this.do_findColumn(columnLabel), x2);
    }

    public void do_updateRef(String columnLabel, Ref x2) throws SQLException {
        this.do_updateObject(this.do_findColumn(columnLabel), x2 == null ? null : x2.getObject());
    }

    public void do_updateBlob(String columnLabel, Blob x2) throws SQLException {
        this.do_updateBlob(this.do_findColumn(columnLabel), x2);
    }

    public void do_updateClob(String columnLabel, Clob x2) throws SQLException {
        this.do_updateClob(this.do_findColumn(columnLabel), x2);
    }

    public void do_updateArray(String columnLabel, Array x2) throws SQLException {
        this.do_updateArray(this.do_findColumn(columnLabel), x2);
    }

    private void checkUpdatable() throws SQLException {
        if (!this.updatable || this.concurrency != 1008) {
            DBError.ECJDBC_RESULTSET_IS_READ_ONLY.throwz(new Object[0]);
        }
    }

    private void checkColumnNullable(int columnIndex) throws SQLException {
        if (!this.columns[columnIndex - 1].nullable) {
            DBError.ECJDBC_NOT_ALLOW_NULL.throwz(new Object[0]);
        }
    }

    private void clearUpdateRow() {
        if (this.updateRow == null) {
            return;
        }
        int i2 = 0;
        while (i2 < this.updateRow.length) {
            this.updateRow[i2] = null;
            this.updateRowBindIndicator[i2] = false;
            ++i2;
        }
    }

    private void clearInsertRow() {
        if (this.insertRow == null) {
            return;
        }
        int i2 = 0;
        while (i2 < this.insertRow.length) {
            this.insertRow[i2] = null;
            this.insertRowBindIndicator[i2] = false;
            ++i2;
        }
    }

    private boolean checkColumnBindes() {
        int count = 0;
        int i2 = 0;
        while (i2 < this.currentRow.length) {
            if (this.currentRowBindIndicator[i2]) {
                ++count;
            }
            ++i2;
        }
        return count > 0;
    }

    public int do_getHoldability() throws SQLException {
        return 1;
    }

    public void do_updateNString(int columnIndex, String nString) throws SQLException {
        this.do_updateString(columnIndex, nString);
    }

    public void do_updateNString(String columnLabel, String nString) throws SQLException {
        this.do_updateString(columnLabel, nString);
    }

    public String do_getNString(int columnIndex) throws SQLException {
        return this.do_getString(columnIndex);
    }

    public String do_getNString(String columnLabel) throws SQLException {
        return this.do_getString(columnLabel);
    }

    public DmdbReader do_getNCharacterStream(int columnIndex) throws SQLException {
        return this.do_getCharacterStream(columnIndex);
    }

    public DmdbReader do_getNCharacterStream(String columnLabel) throws SQLException {
        return this.do_getCharacterStream(columnLabel);
    }

    public void do_updateNCharacterStream(int columnIndex, Reader x2, long length) throws SQLException {
        this.do_updateCharacterStream(columnIndex, x2, length);
    }

    public void do_updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.do_updateCharacterStream(columnLabel, reader, length);
    }

    public void do_updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.do_updateClob(columnIndex, reader, length);
    }

    public void do_updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.do_updateClob(columnLabel, reader, length);
    }

    public void do_updateNCharacterStream(int columnIndex, Reader x2) throws SQLException {
        this.do_updateCharacterStream(columnIndex, x2);
    }

    public void do_updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.do_updateCharacterStream(columnLabel, reader);
    }

    public void do_updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.do_updateClob(columnIndex, reader);
    }

    public void do_updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.do_updateClob(columnLabel, reader);
    }

    public RowId do_getRowId(int columnIndex) throws SQLException {
        byte[] colBytes = this.getColumnData(columnIndex);
        return colBytes == null ? null : new DmdbRowId(colBytes);
    }

    public RowId do_getRowId(String columnLabel) throws SQLException {
        return this.do_getRowId(this.do_findColumn(columnLabel));
    }

    public void do_updateRowId(int columnIndex, RowId x2) throws SQLException {
        this.updateColumn(columnIndex, x2);
    }

    public void do_updateRowId(String columnLabel, RowId x2) throws SQLException {
        this.do_updateRowId(this.do_findColumn(columnLabel), x2);
    }

    public boolean do_isClosed() throws SQLException {
        return this.closed;
    }

    public void do_updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.do_updateClob(columnIndex, (Clob)nClob);
    }

    public void do_updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.do_updateClob(columnLabel, (Clob)nClob);
    }

    public NClob do_getNClob(int columnIndex) throws SQLException {
        return (NClob)((Object)this.do_getClob(columnIndex));
    }

    public NClob do_getNClob(String columnLabel) throws SQLException {
        return (NClob)((Object)this.do_getClob(columnLabel));
    }

    public SQLXML do_getSQLXML(int columnIndex) throws SQLException {
        byte[] bytes = this.getColumnData(columnIndex);
        if (bytes == null) {
            return null;
        }
        return new DmdbSQLXML(bytes, this.columns[columnIndex - 1], this.connection);
    }

    public SQLXML do_getSQLXML(String columnLabel) throws SQLException {
        return this.do_getSQLXML(this.do_findColumn(columnLabel));
    }

    public void do_updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.updateColumn(columnIndex, xmlObject == null ? null : ((DmdbSQLXML)xmlObject).serializeAsCharacterStream());
    }

    public void do_updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.do_updateSQLXML(this.do_findColumn(columnLabel), xmlObject);
    }

    public void do_updateAsciiStream(int columnIndex, InputStream x2, long length) throws SQLException {
        this.updateColumn(columnIndex, x2, 2004, length);
    }

    public void do_updateBinaryStream(int columnIndex, InputStream x2, long length) throws SQLException {
        this.updateColumn(columnIndex, x2, 2004, length);
    }

    public void do_updateCharacterStream(int columnIndex, Reader x2, long length) throws SQLException {
        this.updateColumn(columnIndex, x2, 2005, length);
    }

    public void do_updateAsciiStream(String columnLabel, InputStream x2, long length) throws SQLException {
        this.do_updateBinaryStream(this.do_findColumn(columnLabel), x2, length);
    }

    public void do_updateBinaryStream(String columnLabel, InputStream x2, long length) throws SQLException {
        this.do_updateBinaryStream(this.do_findColumn(columnLabel), x2, length);
    }

    public void do_updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.do_updateCharacterStream(this.do_findColumn(columnLabel), reader, length);
    }

    public void do_updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.updateColumn(columnIndex, inputStream, 2004, length);
    }

    public void do_updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.do_updateBlob(this.do_findColumn(columnLabel), inputStream, length);
    }

    public void do_updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.updateColumn(columnIndex, reader, 2005, length);
    }

    public void do_updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.do_updateClob(this.do_findColumn(columnLabel), reader, length);
    }

    public void do_updateAsciiStream(int columnIndex, InputStream x2) throws SQLException {
        this.updateColumn(columnIndex, x2);
    }

    public void do_updateBinaryStream(int columnIndex, InputStream x2) throws SQLException {
        this.updateColumn(columnIndex, x2);
    }

    public void do_updateCharacterStream(int columnIndex, Reader x2) throws SQLException {
        this.updateColumn(columnIndex, x2);
    }

    public void do_updateAsciiStream(String columnLabel, InputStream x2) throws SQLException {
        this.do_updateAsciiStream(this.do_findColumn(columnLabel), x2);
    }

    public void do_updateBinaryStream(String columnLabel, InputStream x2) throws SQLException {
        this.do_updateBinaryStream(this.do_findColumn(columnLabel), x2);
    }

    public void do_updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.do_updateCharacterStream(this.do_findColumn(columnLabel), reader);
    }

    public void do_updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.updateColumn(columnIndex, inputStream);
    }

    public void do_updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.do_updateBlob(this.do_findColumn(columnLabel), inputStream);
    }

    public void do_updateClob(int columnIndex, Reader reader) throws SQLException {
        this.updateColumn(columnIndex, reader);
    }

    public void do_updateClob(String columnLabel, Reader reader) throws SQLException {
        this.do_updateClob(this.do_findColumn(columnLabel), reader);
    }

    public <T> T do_getObject(int columnIndex, Class<T> type) throws SQLException {
        if (type == String.class) {
            return (T)this.do_getString(columnIndex);
        }
        if (type == Clob.class) {
            return (T)this.do_getClob(columnIndex);
        }
        if (type == NClob.class) {
            return (T)this.do_getNClob(columnIndex);
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(this.do_getBoolean(columnIndex));
        }
        if (type == Long.class) {
            return (T)Long.valueOf(this.do_getLong(columnIndex));
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(this.do_getInt(columnIndex));
        }
        if (type == Short.class) {
            return (T)Short.valueOf(this.do_getShort(columnIndex));
        }
        if (type == BigDecimal.class) {
            return (T)this.do_getBigDecimal(columnIndex);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(this.do_getFloat(columnIndex));
        }
        if (type == Double.class) {
            return (T)Double.valueOf(this.do_getDouble(columnIndex));
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(this.do_getByte(columnIndex));
        }
        if (type == byte[].class) {
            return (T)this.do_getBytes(columnIndex);
        }
        if (type == Blob.class) {
            return (T)this.do_getBlob(columnIndex);
        }
        if (type == Date.class) {
            return (T)this.do_getDate(columnIndex);
        }
        if (type == Time.class) {
            return (T)this.do_getTime(columnIndex);
        }
        if (type == Timestamp.class) {
            return (T)this.do_getTimestamp(columnIndex);
        }
        if (type == java.util.Date.class) {
            Timestamp t2 = this.do_getTimestamp(columnIndex);
            return (T)(t2 == null ? null : new java.util.Date(t2.getTime()));
        }
        if (type == LocalDateTime.class) {
            DmdbTimestamp t3 = this.getTIMESTAMP(columnIndex);
            return (T)(t3 == null ? null : LocalDateTime.of(t3.dt[0], t3.dt[1], t3.dt[2], t3.dt[3], t3.dt[4], t3.dt[5], t3.dt[6]));
        }
        if (type == LocalDate.class) {
            DmdbTimestamp t4 = this.getTIMESTAMP(columnIndex);
            return (T)(t4 == null ? null : LocalDate.of(t4.dt[0], t4.dt[1], t4.dt[2]));
        }
        if (type == LocalTime.class) {
            DmdbTimestamp t5 = this.getTIMESTAMP(columnIndex);
            return (T)(t5 == null ? null : LocalTime.of(t5.dt[3], t5.dt[4], t5.dt[5], t5.dt[6]));
        }
        if (type == ZonedDateTime.class) {
            DmdbTimestamp t6 = this.getTIMESTAMP(columnIndex);
            return (T)(t6 == null ? null : ZonedDateTime.of(t6.dt[0], t6.dt[1], t6.dt[2], t6.dt[3], t6.dt[4], t6.dt[5], t6.dt[6], ZoneOffset.ofTotalSeconds(t6.dt[7] != Integer.MIN_VALUE ? t6.dt[7] * 60 : this.connection.localTimezone * 60)));
        }
        if (type == OffsetDateTime.class) {
            DmdbTimestamp t7 = this.getTIMESTAMP(columnIndex);
            return (T)(t7 == null ? null : OffsetDateTime.of(t7.dt[0], t7.dt[1], t7.dt[2], t7.dt[3], t7.dt[4], t7.dt[5], t7.dt[6], ZoneOffset.ofTotalSeconds(t7.dt[7] != Integer.MIN_VALUE ? t7.dt[7] * 60 : this.connection.localTimezone * 60)));
        }
        if (type == OffsetTime.class) {
            DmdbTimestamp t8 = this.getTIMESTAMP(columnIndex);
            return (T)(t8 == null ? null : OffsetTime.of(t8.dt[3], t8.dt[4], t8.dt[5], t8.dt[6], ZoneOffset.ofTotalSeconds(t8.dt[7] != Integer.MIN_VALUE ? t8.dt[7] * 60 : this.connection.localTimezone * 60)));
        }
        if (type == Array.class) {
            return (T)this.do_getArray(columnIndex);
        }
        if (type == Struct.class) {
            return (T)this.do_getStruct(columnIndex);
        }
        if (type == Ref.class) {
            return (T)this.do_getRef(columnIndex);
        }
        if (type == SQLXML.class) {
            return (T)this.do_getSQLXML(columnIndex);
        }
        if (type == URL.class) {
            return (T)this.do_getURL(columnIndex);
        }
        if (type == RowId.class) {
            return (T)this.do_getRowId(columnIndex);
        }
        DBError.ECJDBC_UNSUPPORTED_TYPE.throwz(new Object[0]);
        return null;
    }

    public <T> T do_getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.do_getObject(this.do_findColumn(columnLabel), type);
    }

    public void do_updateObject(int columnIndex, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    public void do_updateObject(String columnLabel, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    public void do_updateObject(int columnIndex, Object x2, SQLType targetSqlType) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    public void do_updateObject(String columnLabel, Object x2, SQLType targetSqlType) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    private void checkConnection() throws SQLException {
        if (this.connection == null) {
            DBError.ECJDBC_CONNECTION_CLOSED.throwz(new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean next() throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_next();
            }
            return this.filterChain.reset().ResultSet_next(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void close() throws SQLException {
        if (this.connection == null) {
            return;
        }
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_close();
            } else {
                this.filterChain.reset().ResultSet_close(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean wasNull() throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_wasNull();
            }
            return this.filterChain.reset().ResultSet_wasNull(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public String getString(int columnIndex) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getString(columnIndex);
            }
            return this.filterChain.reset().ResultSet_getString(this, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBoolean(columnIndex);
            }
            return this.filterChain.reset().ResultSet_getBoolean(this, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public byte getByte(int columnIndex) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getByte(columnIndex);
            }
            return this.filterChain.reset().ResultSet_getByte(this, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public short getShort(int columnIndex) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getShort(columnIndex);
            }
            return this.filterChain.reset().ResultSet_getShort(this, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public int getInt(int columnIndex) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getInt(columnIndex);
            }
            return this.filterChain.reset().ResultSet_getInt(this, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public long getLong(int columnIndex) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getLong(columnIndex);
            }
            return this.filterChain.reset().ResultSet_getLong(this, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public float getFloat(int columnIndex) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getFloat(columnIndex);
            }
            return this.filterChain.reset().ResultSet_getFloat(this, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public double getDouble(int columnIndex) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getDouble(columnIndex);
            }
            return this.filterChain.reset().ResultSet_getDouble(this, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBigDecimal(columnIndex, scale);
            }
            return this.filterChain.reset().ResultSet_getBigDecimal(this, columnIndex, scale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public byte[] getBytes(int columnIndex) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBytes(columnIndex);
            }
            return this.filterChain.reset().ResultSet_getBytes(this, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Date getDate(int columnIndex) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getDate(columnIndex);
            }
            return this.filterChain.reset().ResultSet_getDate(this, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Time getTime(int columnIndex) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTime(columnIndex);
            }
            return this.filterChain.reset().ResultSet_getTime(this, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTimestamp(columnIndex);
            }
            return this.filterChain.reset().ResultSet_getTimestamp(this, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getAsciiStream(columnIndex);
            }
            return this.filterChain.reset().ResultSet_getAsciiStream(this, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getUnicodeStream(columnIndex);
            }
            return this.filterChain.reset().ResultSet_getUnicodeStream(this, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBinaryStream(columnIndex);
            }
            return this.filterChain.reset().ResultSet_getBinaryStream(this, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public String getString(String columnLabel) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getString(columnLabel);
            }
            return this.filterChain.reset().ResultSet_getString(this, columnLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean getBoolean(String columnLabel) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBoolean(columnLabel);
            }
            return this.filterChain.reset().ResultSet_getBoolean(this, columnLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public byte getByte(String columnLabel) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getByte(columnLabel);
            }
            return this.filterChain.reset().ResultSet_getByte(this, columnLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public short getShort(String columnLabel) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getShort(columnLabel);
            }
            return this.filterChain.reset().ResultSet_getShort(this, columnLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public int getInt(String columnLabel) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getInt(columnLabel);
            }
            return this.filterChain.reset().ResultSet_getInt(this, columnLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public long getLong(String columnLabel) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getLong(columnLabel);
            }
            return this.filterChain.reset().ResultSet_getLong(this, columnLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public float getFloat(String columnLabel) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getFloat(columnLabel);
            }
            return this.filterChain.reset().ResultSet_getFloat(this, columnLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public double getDouble(String columnLabel) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getDouble(columnLabel);
            }
            return this.filterChain.reset().ResultSet_getDouble(this, columnLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBigDecimal(columnLabel, scale);
            }
            return this.filterChain.reset().ResultSet_getBigDecimal(this, columnLabel, scale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public byte[] getBytes(String columnLabel) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBytes(columnLabel);
            }
            return this.filterChain.reset().ResultSet_getBytes(this, columnLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Date getDate(String columnLabel) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getDate(columnLabel);
            }
            return this.filterChain.reset().ResultSet_getDate(this, columnLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Time getTime(String columnLabel) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTime(columnLabel);
            }
            return this.filterChain.reset().ResultSet_getTime(this, columnLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTimestamp(columnLabel);
            }
            return this.filterChain.reset().ResultSet_getTimestamp(this, columnLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getAsciiStream(columnLabel);
            }
            return this.filterChain.reset().ResultSet_getAsciiStream(this, columnLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getUnicodeStream(columnLabel);
            }
            return this.filterChain.reset().ResultSet_getUnicodeStream(this, columnLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBinaryStream(columnLabel);
            }
            return this.filterChain.reset().ResultSet_getBinaryStream(this, columnLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public SQLWarning getWarnings() throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getWarnings();
            }
            return this.filterChain.reset().ResultSet_getWarnings(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void clearWarnings() throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_clearWarnings();
            } else {
                this.filterChain.reset().ResultSet_clearWarnings(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public String getCursorName() throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getCursorName();
            }
            return this.filterChain.reset().ResultSet_getCursorName(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ResultSetMetaData getMetaData() throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getMetaData();
            }
            return this.filterChain.reset().ResultSet_getMetaData(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Object getObject(int columnIndex) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getObject(columnIndex);
            }
            return this.filterChain.reset().ResultSet_getObject(this, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Object getObject(String columnLabel) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getObject(columnLabel);
            }
            return this.filterChain.reset().ResultSet_getObject(this, columnLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public int findColumn(String columnLabel) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_findColumn(columnLabel);
            }
            return this.filterChain.reset().ResultSet_findColumn(this, columnLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getCharacterStream(columnIndex);
            }
            return this.filterChain.reset().ResultSet_getCharacterStream(this, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getCharacterStream(columnLabel);
            }
            return this.filterChain.reset().ResultSet_getCharacterStream(this, columnLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBigDecimal(columnIndex);
            }
            return this.filterChain.reset().ResultSet_getBigDecimal(this, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBigDecimal(columnLabel);
            }
            return this.filterChain.reset().ResultSet_getBigDecimal(this, columnLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean isBeforeFirst() throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_isBeforeFirst();
            }
            return this.filterChain.reset().ResultSet_isBeforeFirst(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean isAfterLast() throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_isAfterLast();
            }
            return this.filterChain.reset().ResultSet_isAfterLast(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean isFirst() throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_isFirst();
            }
            return this.filterChain.reset().ResultSet_isFirst(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean isLast() throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_isLast();
            }
            return this.filterChain.reset().ResultSet_isLast(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void beforeFirst() throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_beforeFirst();
            } else {
                this.filterChain.reset().ResultSet_beforeFirst(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void afterLast() throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_afterLast();
            } else {
                this.filterChain.reset().ResultSet_afterLast(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean first() throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_first();
            }
            return this.filterChain.reset().ResultSet_first(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean last() throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_last();
            }
            return this.filterChain.reset().ResultSet_last(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public int getRow() throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getRow();
            }
            return this.filterChain.reset().ResultSet_getRow(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean absolute(int row) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_absolute(row);
            }
            return this.filterChain.reset().ResultSet_absolute(this, row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean relative(int rows) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_relative(rows);
            }
            return this.filterChain.reset().ResultSet_relative(this, rows);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean previous() throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_previous();
            }
            return this.filterChain.reset().ResultSet_previous(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void setFetchDirection(int direction) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setFetchDirection(direction);
            } else {
                this.filterChain.reset().ResultSet_setFetchDirection(this, direction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public int getFetchDirection() throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getFetchDirection();
            }
            return this.filterChain.reset().ResultSet_getFetchDirection(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void setFetchSize(int rows) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setFetchSize(rows);
            } else {
                this.filterChain.reset().ResultSet_setFetchSize(this, rows);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public int getFetchSize() throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getFetchSize();
            }
            return this.filterChain.reset().ResultSet_getFetchSize(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public int getType() throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getType();
            }
            return this.filterChain.reset().ResultSet_getType(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public int getConcurrency() throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getConcurrency();
            }
            return this.filterChain.reset().ResultSet_getConcurrency(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean rowUpdated() throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_rowUpdated();
            }
            return this.filterChain.reset().ResultSet_rowUpdated(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean rowInserted() throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_rowInserted();
            }
            return this.filterChain.reset().ResultSet_rowInserted(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean rowDeleted() throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_rowDeleted();
            }
            return this.filterChain.reset().ResultSet_rowDeleted(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateNull(int columnIndex) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateNull(columnIndex);
            } else {
                this.filterChain.reset().ResultSet_updateNull(this, columnIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateBoolean(int columnIndex, boolean x2) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBoolean(columnIndex, x2);
            } else {
                this.filterChain.reset().ResultSet_updateBoolean(this, columnIndex, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateByte(int columnIndex, byte x2) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateByte(columnIndex, x2);
            } else {
                this.filterChain.reset().ResultSet_updateByte(this, columnIndex, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateShort(int columnIndex, short x2) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateShort(columnIndex, x2);
            } else {
                this.filterChain.reset().ResultSet_updateShort(this, columnIndex, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateInt(int columnIndex, int x2) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateInt(columnIndex, x2);
            } else {
                this.filterChain.reset().ResultSet_updateInt(this, columnIndex, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateLong(int columnIndex, long x2) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateLong(columnIndex, x2);
            } else {
                this.filterChain.reset().ResultSet_updateLong(this, columnIndex, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateFloat(int columnIndex, float x2) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateFloat(columnIndex, x2);
            } else {
                this.filterChain.reset().ResultSet_updateFloat(this, columnIndex, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateDouble(int columnIndex, double x2) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateDouble(columnIndex, x2);
            } else {
                this.filterChain.reset().ResultSet_updateDouble(this, columnIndex, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateBigDecimal(int columnIndex, BigDecimal x2) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBigDecimal(columnIndex, x2);
            } else {
                this.filterChain.reset().ResultSet_updateBigDecimal(this, columnIndex, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateString(int columnIndex, String x2) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateString(columnIndex, x2);
            } else {
                this.filterChain.reset().ResultSet_updateString(this, columnIndex, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateBytes(int columnIndex, byte[] x2) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBytes(columnIndex, x2);
            } else {
                this.filterChain.reset().ResultSet_updateBytes(this, columnIndex, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateDate(int columnIndex, Date x2) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateDate(columnIndex, x2);
            } else {
                this.filterChain.reset().ResultSet_updateDate(this, columnIndex, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateTime(int columnIndex, Time x2) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateTime(columnIndex, x2);
            } else {
                this.filterChain.reset().ResultSet_updateTime(this, columnIndex, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateTimestamp(int columnIndex, Timestamp x2) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateTimestamp(columnIndex, x2);
            } else {
                this.filterChain.reset().ResultSet_updateTimestamp(this, columnIndex, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateAsciiStream(int columnIndex, InputStream x2, int length) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateAsciiStream(columnIndex, x2, length);
            } else {
                this.filterChain.reset().ResultSet_updateAsciiStream(this, columnIndex, x2, length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateBinaryStream(int columnIndex, InputStream x2, int length) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBinaryStream(columnIndex, x2, length);
            } else {
                this.filterChain.reset().ResultSet_updateBinaryStream(this, columnIndex, x2, length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateCharacterStream(int columnIndex, Reader x2, int length) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateCharacterStream(columnIndex, x2, length);
            } else {
                this.filterChain.reset().ResultSet_updateCharacterStream(this, columnIndex, x2, length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateObject(int columnIndex, Object x2, int scaleOrLength) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateObject(columnIndex, x2, scaleOrLength);
            } else {
                this.filterChain.reset().ResultSet_updateObject(this, columnIndex, x2, scaleOrLength);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateObject(int columnIndex, Object x2) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateObject(columnIndex, x2);
            } else {
                this.filterChain.reset().ResultSet_updateObject(this, columnIndex, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateNull(String columnLabel) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateNull(columnLabel);
            } else {
                this.filterChain.reset().ResultSet_updateNull(this, columnLabel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateBoolean(String columnLabel, boolean x2) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBoolean(columnLabel, x2);
            } else {
                this.filterChain.reset().ResultSet_updateBoolean(this, columnLabel, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateByte(String columnLabel, byte x2) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateByte(columnLabel, x2);
            } else {
                this.filterChain.reset().ResultSet_updateByte(this, columnLabel, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateShort(String columnLabel, short x2) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateShort(columnLabel, x2);
            } else {
                this.filterChain.reset().ResultSet_updateShort(this, columnLabel, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateInt(String columnLabel, int x2) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateInt(columnLabel, x2);
            } else {
                this.filterChain.reset().ResultSet_updateInt(this, columnLabel, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateLong(String columnLabel, long x2) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateLong(columnLabel, x2);
            } else {
                this.filterChain.reset().ResultSet_updateLong(this, columnLabel, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateFloat(String columnLabel, float x2) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateFloat(columnLabel, x2);
            } else {
                this.filterChain.reset().ResultSet_updateFloat(this, columnLabel, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateDouble(String columnLabel, double x2) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateDouble(columnLabel, x2);
            } else {
                this.filterChain.reset().ResultSet_updateDouble(this, columnLabel, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateBigDecimal(String columnLabel, BigDecimal x2) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBigDecimal(columnLabel, x2);
            } else {
                this.filterChain.reset().ResultSet_updateBigDecimal(this, columnLabel, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateString(String columnLabel, String x2) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateString(columnLabel, x2);
            } else {
                this.filterChain.reset().ResultSet_updateString(this, columnLabel, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateBytes(String columnLabel, byte[] x2) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBytes(columnLabel, x2);
            } else {
                this.filterChain.reset().ResultSet_updateBytes(this, columnLabel, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateDate(String columnLabel, Date x2) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateDate(columnLabel, x2);
            } else {
                this.filterChain.reset().ResultSet_updateDate(this, columnLabel, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateTime(String columnLabel, Time x2) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateTime(columnLabel, x2);
            } else {
                this.filterChain.reset().ResultSet_updateTime(this, columnLabel, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateTimestamp(String columnLabel, Timestamp x2) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateTimestamp(columnLabel, x2);
            } else {
                this.filterChain.reset().ResultSet_updateTimestamp(this, columnLabel, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateAsciiStream(String columnLabel, InputStream x2, int length) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateAsciiStream(columnLabel, x2, length);
            } else {
                this.filterChain.reset().ResultSet_updateAsciiStream(this, columnLabel, x2, length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateBinaryStream(String columnLabel, InputStream x2, int length) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBinaryStream(columnLabel, x2, length);
            } else {
                this.filterChain.reset().ResultSet_updateBinaryStream(this, columnLabel, x2, length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateCharacterStream(columnLabel, reader, length);
            } else {
                this.filterChain.reset().ResultSet_updateCharacterStream(this, columnLabel, reader, length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateObject(String columnLabel, Object x2, int scaleOrLength) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateObject(columnLabel, x2, scaleOrLength);
            } else {
                this.filterChain.reset().ResultSet_updateObject(this, columnLabel, x2, scaleOrLength);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateObject(String columnLabel, Object x2) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateObject(columnLabel, x2);
            } else {
                this.filterChain.reset().ResultSet_updateObject(this, columnLabel, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void insertRow() throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_insertRow();
            } else {
                this.filterChain.reset().ResultSet_insertRow(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateRow() throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateRow();
            } else {
                this.filterChain.reset().ResultSet_updateRow(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void deleteRow() throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_deleteRow();
            } else {
                this.filterChain.reset().ResultSet_deleteRow(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void refreshRow() throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_refreshRow();
            } else {
                this.filterChain.reset().ResultSet_refreshRow(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void cancelRowUpdates() throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_cancelRowUpdates();
            } else {
                this.filterChain.reset().ResultSet_cancelRowUpdates(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void moveToInsertRow() throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_moveToInsertRow();
            } else {
                this.filterChain.reset().ResultSet_moveToInsertRow(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void moveToCurrentRow() throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_moveToCurrentRow();
            } else {
                this.filterChain.reset().ResultSet_moveToCurrentRow(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Statement getStatement() throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getStatement();
            }
            return this.filterChain.reset().ResultSet_getStatement(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getObject(columnIndex, map);
            }
            return this.filterChain.reset().ResultSet_getObject(this, columnIndex, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Ref getRef(int columnIndex) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getRef(columnIndex);
            }
            return this.filterChain.reset().ResultSet_getRef(this, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Blob getBlob(int columnIndex) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBlob(columnIndex);
            }
            return this.filterChain.reset().ResultSet_getBlob(this, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Clob getClob(int columnIndex) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getClob(columnIndex);
            }
            return this.filterChain.reset().ResultSet_getClob(this, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Array getArray(int columnIndex) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getArray(columnIndex);
            }
            return this.filterChain.reset().ResultSet_getArray(this, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getObject(columnLabel, map);
            }
            return this.filterChain.reset().ResultSet_getObject(this, columnLabel, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Ref getRef(String columnLabel) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getRef(columnLabel);
            }
            return this.filterChain.reset().ResultSet_getRef(this, columnLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Blob getBlob(String columnLabel) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBlob(columnLabel);
            }
            return this.filterChain.reset().ResultSet_getBlob(this, columnLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Clob getClob(String columnLabel) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getClob(columnLabel);
            }
            return this.filterChain.reset().ResultSet_getClob(this, columnLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Array getArray(String columnLabel) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getArray(columnLabel);
            }
            return this.filterChain.reset().ResultSet_getArray(this, columnLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getDate(columnIndex, cal);
            }
            return this.filterChain.reset().ResultSet_getDate(this, columnIndex, cal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getDate(columnLabel, cal);
            }
            return this.filterChain.reset().ResultSet_getDate(this, columnLabel, cal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTime(columnIndex, cal);
            }
            return this.filterChain.reset().ResultSet_getTime(this, columnIndex, cal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTime(columnLabel, cal);
            }
            return this.filterChain.reset().ResultSet_getTime(this, columnLabel, cal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTimestamp(columnIndex, cal);
            }
            return this.filterChain.reset().ResultSet_getTimestamp(this, columnIndex, cal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTimestamp(columnLabel, cal);
            }
            return this.filterChain.reset().ResultSet_getTimestamp(this, columnLabel, cal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public URL getURL(int columnIndex) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getURL(columnIndex);
            }
            return this.filterChain.reset().ResultSet_getURL(this, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public URL getURL(String columnLabel) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getURL(columnLabel);
            }
            return this.filterChain.reset().ResultSet_getURL(this, columnLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateRef(int columnIndex, Ref x2) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateRef(columnIndex, x2);
            } else {
                this.filterChain.reset().ResultSet_updateRef(this, columnIndex, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateRef(String columnLabel, Ref x2) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateRef(columnLabel, x2);
            } else {
                this.filterChain.reset().ResultSet_updateRef(this, columnLabel, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateBlob(int columnIndex, Blob x2) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBlob(columnIndex, x2);
            } else {
                this.filterChain.reset().ResultSet_updateBlob(this, columnIndex, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateBlob(String columnLabel, Blob x2) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBlob(columnLabel, x2);
            } else {
                this.filterChain.reset().ResultSet_updateBlob(this, columnLabel, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateClob(int columnIndex, Clob x2) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateClob(columnIndex, x2);
            } else {
                this.filterChain.reset().ResultSet_updateClob(this, columnIndex, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateClob(String columnLabel, Clob x2) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateClob(columnLabel, x2);
            } else {
                this.filterChain.reset().ResultSet_updateClob(this, columnLabel, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateArray(int columnIndex, Array x2) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateArray(columnIndex, x2);
            } else {
                this.filterChain.reset().ResultSet_updateArray(this, columnIndex, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateArray(String columnLabel, Array x2) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateArray(columnLabel, x2);
            } else {
                this.filterChain.reset().ResultSet_updateArray(this, columnLabel, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public RowId getRowId(int columnIndex) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getRowId(columnIndex);
            }
            return this.filterChain.reset().ResultSet_getRowId(this, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public RowId getRowId(String columnLabel) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getRowId(columnLabel);
            }
            return this.filterChain.reset().ResultSet_getRowId(this, columnLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateRowId(int columnIndex, RowId x2) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateRowId(columnIndex, x2);
            } else {
                this.filterChain.reset().ResultSet_updateRowId(this, columnIndex, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateRowId(String columnLabel, RowId x2) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateRowId(columnLabel, x2);
            } else {
                this.filterChain.reset().ResultSet_updateRowId(this, columnLabel, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public int getHoldability() throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getHoldability();
            }
            return this.filterChain.reset().ResultSet_getHoldability(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean isClosed() throws SQLException {
        if (this.connection == null) {
            return true;
        }
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_isClosed();
            }
            return this.filterChain.reset().ResultSet_isClosed(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateNString(columnIndex, nString);
            } else {
                this.filterChain.reset().ResultSet_updateNString(this, columnIndex, nString);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateNString(columnLabel, nString);
            } else {
                this.filterChain.reset().ResultSet_updateNString(this, columnLabel, nString);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateNClob(columnIndex, nClob);
            } else {
                this.filterChain.reset().ResultSet_updateNClob(this, columnIndex, nClob);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateNClob(columnLabel, nClob);
            } else {
                this.filterChain.reset().ResultSet_updateNClob(this, columnLabel, nClob);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public NClob getNClob(int columnIndex) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getNClob(columnIndex);
            }
            return this.filterChain.reset().ResultSet_getNClob(this, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public NClob getNClob(String columnLabel) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getNClob(columnLabel);
            }
            return this.filterChain.reset().ResultSet_getNClob(this, columnLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getSQLXML(columnIndex);
            }
            return this.filterChain.reset().ResultSet_getSQLXML(this, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getSQLXML(columnLabel);
            }
            return this.filterChain.reset().ResultSet_getSQLXML(this, columnLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateSQLXML(columnIndex, xmlObject);
            } else {
                this.filterChain.reset().ResultSet_updateSQLXML(this, columnIndex, xmlObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateSQLXML(columnLabel, xmlObject);
            } else {
                this.filterChain.reset().ResultSet_updateSQLXML(this, columnLabel, xmlObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public String getNString(int columnIndex) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getNString(columnIndex);
            }
            return this.filterChain.reset().ResultSet_getNString(this, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public String getNString(String columnLabel) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getNString(columnLabel);
            }
            return this.filterChain.reset().ResultSet_getNString(this, columnLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getNCharacterStream(columnIndex);
            }
            return this.filterChain.reset().ResultSet_getNCharacterStream(this, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getNCharacterStream(columnLabel);
            }
            return this.filterChain.reset().ResultSet_getNCharacterStream(this, columnLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateNCharacterStream(int columnIndex, Reader x2, long length) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateNCharacterStream(columnIndex, x2, length);
            } else {
                this.filterChain.reset().ResultSet_updateNCharacterStream(this, columnIndex, x2, length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateNCharacterStream(columnLabel, reader, length);
            } else {
                this.filterChain.reset().ResultSet_updateNCharacterStream(this, columnLabel, reader, length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateAsciiStream(int columnIndex, InputStream x2, long length) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateAsciiStream(columnIndex, x2, length);
            } else {
                this.filterChain.reset().ResultSet_updateAsciiStream(this, columnIndex, x2, length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateBinaryStream(int columnIndex, InputStream x2, long length) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBinaryStream(columnIndex, x2, length);
            } else {
                this.filterChain.reset().ResultSet_updateBinaryStream(this, columnIndex, x2, length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateCharacterStream(int columnIndex, Reader x2, long length) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateCharacterStream(columnIndex, x2, length);
            } else {
                this.filterChain.reset().ResultSet_updateCharacterStream(this, columnIndex, x2, length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateAsciiStream(String columnLabel, InputStream x2, long length) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateAsciiStream(columnLabel, x2, length);
            } else {
                this.filterChain.reset().ResultSet_updateAsciiStream(this, columnLabel, x2, length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateBinaryStream(String columnLabel, InputStream x2, long length) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBinaryStream(columnLabel, x2, length);
            } else {
                this.filterChain.reset().ResultSet_updateBinaryStream(this, columnLabel, x2, length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateCharacterStream(columnLabel, reader, length);
            } else {
                this.filterChain.reset().ResultSet_updateCharacterStream(this, columnLabel, reader, length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBlob(columnIndex, inputStream, length);
            } else {
                this.filterChain.reset().ResultSet_updateBlob(this, columnIndex, inputStream, length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBlob(columnLabel, inputStream, length);
            } else {
                this.filterChain.reset().ResultSet_updateBlob(this, columnLabel, inputStream, length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateClob(columnIndex, reader, length);
            } else {
                this.filterChain.reset().ResultSet_updateClob(this, columnIndex, reader, length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateClob(columnLabel, reader, length);
            } else {
                this.filterChain.reset().ResultSet_updateClob(this, columnLabel, reader, length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateNClob(columnIndex, reader, length);
            } else {
                this.filterChain.reset().ResultSet_updateNClob(this, columnIndex, reader, length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateNClob(columnLabel, reader, length);
            } else {
                this.filterChain.reset().ResultSet_updateNClob(this, columnLabel, reader, length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateNCharacterStream(int columnIndex, Reader x2) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateNCharacterStream(columnIndex, x2);
            } else {
                this.filterChain.reset().ResultSet_updateNCharacterStream(this, columnIndex, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateNCharacterStream(columnLabel, reader);
            } else {
                this.filterChain.reset().ResultSet_updateNCharacterStream(this, columnLabel, reader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateAsciiStream(int columnIndex, InputStream x2) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateAsciiStream(columnIndex, x2);
            } else {
                this.filterChain.reset().ResultSet_updateAsciiStream(this, columnIndex, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateBinaryStream(int columnIndex, InputStream x2) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBinaryStream(columnIndex, x2);
            } else {
                this.filterChain.reset().ResultSet_updateBinaryStream(this, columnIndex, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateCharacterStream(int columnIndex, Reader x2) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateCharacterStream(columnIndex, x2);
            } else {
                this.filterChain.reset().ResultSet_updateCharacterStream(this, columnIndex, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateAsciiStream(String columnLabel, InputStream x2) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateAsciiStream(columnLabel, x2);
            } else {
                this.filterChain.reset().ResultSet_updateAsciiStream(this, columnLabel, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateBinaryStream(String columnLabel, InputStream x2) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBinaryStream(columnLabel, x2);
            } else {
                this.filterChain.reset().ResultSet_updateBinaryStream(this, columnLabel, x2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateCharacterStream(columnLabel, reader);
            } else {
                this.filterChain.reset().ResultSet_updateCharacterStream(this, columnLabel, reader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBlob(columnIndex, inputStream);
            } else {
                this.filterChain.reset().ResultSet_updateBlob(this, columnIndex, inputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateBlob(columnLabel, inputStream);
            } else {
                this.filterChain.reset().ResultSet_updateBlob(this, columnLabel, inputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateClob(columnIndex, reader);
            } else {
                this.filterChain.reset().ResultSet_updateClob(this, columnIndex, reader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateClob(columnLabel, reader);
            } else {
                this.filterChain.reset().ResultSet_updateClob(this, columnLabel, reader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateNClob(columnIndex, reader);
            } else {
                this.filterChain.reset().ResultSet_updateNClob(this, columnIndex, reader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateNClob(columnLabel, reader);
            } else {
                this.filterChain.reset().ResultSet_updateNClob(this, columnLabel, reader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getObject(columnIndex, type);
            }
            return this.filterChain.reset().ResultSet_getObject(this, columnIndex, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getObject(columnLabel, type);
            }
            return this.filterChain.reset().ResultSet_getObject(this, columnLabel, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateObject(int columnIndex, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateObject(columnIndex, x2, targetSqlType, scaleOrLength);
            } else {
                this.filterChain.reset().ResultSet_updateObject(this, columnIndex, x2, targetSqlType, scaleOrLength);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateObject(String columnLabel, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateObject(columnLabel, x2, targetSqlType, scaleOrLength);
            } else {
                this.filterChain.reset().ResultSet_updateObject(this, columnLabel, x2, targetSqlType, scaleOrLength);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateObject(int columnIndex, Object x2, SQLType targetSqlType) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateObject(columnIndex, x2, targetSqlType);
            } else {
                this.filterChain.reset().ResultSet_updateObject(this, columnIndex, x2, targetSqlType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void updateObject(String columnLabel, Object x2, SQLType targetSqlType) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_updateObject(columnLabel, x2, targetSqlType);
            } else {
                this.filterChain.reset().ResultSet_updateObject(this, columnLabel, x2, targetSqlType);
            }
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmdbIntervalYM getINTERVALYM(int columnIndex) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            byte[] colBytes = this.getColumnData(columnIndex);
            return colBytes != null ? new DmdbIntervalYM(colBytes) : null;
        }
    }

    public DmdbIntervalYM getINTERVALYM(String columnLabel) throws SQLException {
        return this.getINTERVALYM(this.do_findColumn(columnLabel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmdbIntervalDT getINTERVALDT(int columnIndex) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            byte[] colBytes = this.getColumnData(columnIndex);
            return colBytes != null ? new DmdbIntervalDT(colBytes) : null;
        }
    }

    public DmdbIntervalDT getINTERVALDT(String columnLabel) throws SQLException {
        return this.getINTERVALDT(this.do_findColumn(columnLabel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmdbTimestamp getTIMESTAMP(int columnIndex) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            byte[] colBytes = this.getColumnData(columnIndex);
            return colBytes != null ? DB2J.toDmdbTimestamp(colBytes, this.columns[columnIndex - 1], this.connection) : null;
        }
    }

    public DmdbTimestamp getTIMESTAMP(String columnLabel) throws SQLException {
        return this.getTIMESTAMP(this.do_findColumn(columnLabel));
    }

    public void updateINTERVALYM(int columnIndex, DmdbIntervalYM x2) throws SQLException {
        this.updateColumn(columnIndex, x2);
    }

    public void updateINTERVALYM(String columnLabel, DmdbIntervalYM x2) throws SQLException {
        this.updateINTERVALYM(this.do_findColumn(columnLabel), x2);
    }

    public void updateINTERVALDT(int columnIndex, DmdbIntervalDT x2) throws SQLException {
        this.updateColumn(columnIndex, x2);
    }

    public void updateINTERVALDT(String columnLabel, DmdbIntervalDT x2) throws SQLException {
        this.updateINTERVALDT(this.do_findColumn(columnLabel), x2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getRowCount() throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            this.checkClosed();
            if (this.totalRowCount != Long.MAX_VALUE) {
                return this.totalRowCount;
            }
            if (this.type == 1003) {
                return -1L;
            }
            return this.connection.dbAccess.a(this);
        }
    }
}

