/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.desc.ExecuteRetInfo;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.util.ConvertUtil;
import java.sql.SQLException;
import java.util.Calendar;

public class DmdbResultSetCache {
    private long m_lastChkTime;
    private long[] m_TbIds = null;
    private long[] m_TbTss = null;
    public ExecuteRetInfo execInfo;

    DmdbResultSetCache(ExecuteRetInfo execInfo) throws SQLException {
        this.execInfo = execInfo;
        this.m_TbIds = (long[])execInfo.tbIds.clone();
        this.m_TbTss = (long[])execInfo.tbTss.clone();
        this.m_lastChkTime = Calendar.getInstance().getTimeInMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean refreshed(DmdbConnection conn) throws SQLException {
        DmdbConnection dmdbConnection = conn;
        synchronized (dmdbConnection) {
            int tbCount;
            if (conn.rsRefreshFreq == 0) {
                return false;
            }
            if (this.m_lastChkTime + (long)(conn.rsRefreshFreq * 1000) > Calendar.getInstance().getTimeInMillis()) {
                return false;
            }
            long[] tss = conn.dbAccess.a(conn, this.m_TbIds);
            this.m_lastChkTime = Calendar.getInstance().getTimeInMillis();
            int n2 = tbCount = tss == null ? 0 : tss.length;
            if (tbCount != this.m_TbTss.length) {
                return true;
            }
            int i2 = 0;
            while (true) {
                if (i2 >= tbCount) {
                    return false;
                }
                if (this.m_TbTss[i2] != tss[i2]) {
                    return true;
                }
                ++i2;
            }
        }
    }

    DmdbResultSet getResultSet(DmdbStatement stmt) throws SQLException {
        int totalRows;
        Object destDatas = this.execInfo.rsDatas;
        int n2 = totalRows = this.execInfo.rsDatas == null ? 0 : this.execInfo.rsDatas.length;
        if (stmt.maxRows > 0L && stmt.maxRows < (long)totalRows) {
            destDatas = new byte[ConvertUtil.toInt(stmt.maxRows)][][];
            System.arraycopy(this.execInfo.rsDatas, 0, destDatas, 0, ((byte[][][])destDatas).length);
        }
        DmdbResultSet rs = DmdbResultSet.newLocalResultSet(stmt, stmt.columns, destDatas);
        rs.id = 1;
        return rs;
    }

    long getLastChkTime() {
        return this.m_lastChkTime;
    }

    long getDataLen() {
        return this.execInfo.rsSizeof;
    }
}

