/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.util.StringUtil;
import java.util.Arrays;

public class DmdbResultSetKey {
    public String dbGuid = null;
    public String currentSchema = null;
    public String sql = null;
    public int paramCount = 0;
    public Object[] paramObjects = null;
    private boolean codeCalced = false;
    private int codeVal = 0;

    public DmdbResultSetKey(String guid, String curSch, String sql, DmdbStatement stmt) {
        this.dbGuid = guid;
        this.currentSchema = curSch;
        this.sql = sql;
        if (stmt instanceof DmdbPreparedStatement || stmt instanceof DmdbCallableStatement) {
            this.paramObjects = ((DmdbPreparedStatement)stmt).curRowDatas;
            this.paramCount = ((DmdbPreparedStatement)stmt).paramCount;
        }
    }

    public int hashCode() {
        if (this.codeCalced) {
            return this.codeVal;
        }
        int result = 1;
        result = 31 * result + (this.dbGuid != null ? this.dbGuid.hashCode() : 0);
        result = 31 * result + (this.currentSchema != null ? this.currentSchema.hashCode() : 0);
        result = 31 * result + (this.sql != null ? this.sql.hashCode() : 0);
        this.codeVal = result = 31 * result + Arrays.deepHashCode(this.paramObjects);
        this.codeCalced = true;
        return this.codeVal;
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof DmdbResultSetKey)) {
            return false;
        }
        DmdbResultSetKey rsKey = (DmdbResultSetKey)o2;
        return StringUtil.equals(this.dbGuid, rsKey.dbGuid) && StringUtil.equals(this.currentSchema, rsKey.currentSchema) && StringUtil.equals(this.sql, rsKey.sql) && this.paramCount == rsKey.paramCount && Arrays.deepEquals(this.paramObjects, rsKey.paramObjects);
    }
}

