/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.desc.Column;
import dm.jdbc.desc.convert.DB2J;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.SQLException;
import java.sql.SQLXML;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DmdbSQLXML
implements SQLXML {
    private boolean isClosed = false;
    private boolean workingWithResult;
    private boolean fromResultSet;
    private byte[] bytes;
    private Column column;
    private DmdbConnection connection;
    private String stringRep;
    private XMLInputFactory inputFactory;
    private XMLOutputFactory outputFactory;
    private DOMResult asDOMResult;
    private SAXResult asSAXResult;
    private StringWriter asStringWriter;
    private ByteArrayOutputStream asByteArrayOutputStream;
    private SimpleSaxToReader saxToReaderConverter;

    protected DmdbSQLXML(byte[] bytes, Column column, DmdbConnection connection) {
        this.bytes = bytes;
        this.column = column;
        this.connection = connection;
        this.fromResultSet = true;
    }

    protected DmdbSQLXML() {
        this.fromResultSet = false;
    }

    @Override
    public synchronized void free() throws SQLException {
        this.stringRep = null;
        this.asDOMResult = null;
        this.asSAXResult = null;
        this.inputFactory = null;
        this.outputFactory = null;
        this.bytes = null;
        this.column = null;
        this.connection = null;
        this.workingWithResult = false;
        this.isClosed = true;
    }

    @Override
    public synchronized String getString() throws SQLException {
        this.checkClosed();
        this.checkWorkingWithResult();
        if (this.fromResultSet) {
            return DB2J.toString(this.bytes, this.column, this.connection);
        }
        return this.stringRep;
    }

    private synchronized void checkClosed() throws SQLException {
        if (this.isClosed) {
            DBError.ECJDBC_OBJ_CLOSED.throwz(new Object[0]);
        }
    }

    private synchronized void checkWorkingWithResult() throws SQLException {
        if (this.workingWithResult) {
            DBError.ECJDBC_SQLXML_WORKING_WITH_RESULT.throwz(new Object[0]);
        }
    }

    @Override
    public synchronized void setString(String str) throws SQLException {
        this.checkClosed();
        this.checkWorkingWithResult();
        this.stringRep = str;
        this.fromResultSet = false;
        this.workingWithResult = true;
    }

    public synchronized boolean isEmpty() throws SQLException {
        this.checkClosed();
        if (!this.fromResultSet) {
            return this.stringRep == null || this.stringRep.length() == 0;
        }
        return false;
    }

    @Override
    public synchronized InputStream getBinaryStream() throws SQLException {
        this.checkClosed();
        this.checkWorkingWithResult();
        return DB2J.toBinaryStream(this.bytes, this.column, this.connection);
    }

    @Override
    public synchronized Reader getCharacterStream() throws SQLException {
        this.checkClosed();
        this.checkWorkingWithResult();
        return DB2J.toCharacterStream(this.bytes, this.column, this.connection);
    }

    @Override
    public <T extends Source> T getSource(Class<T> clazz) throws SQLException {
        this.checkClosed();
        this.checkWorkingWithResult();
        if (clazz == null || clazz.equals(SAXSource.class)) {
            InputSource inputSource = null;
            inputSource = this.fromResultSet ? new InputSource(DB2J.toCharacterStream(this.bytes, this.column, this.connection)) : new InputSource(new StringReader(this.stringRep));
            return (T)new SAXSource(inputSource);
        }
        if (clazz.equals(DOMSource.class)) {
            try {
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                builderFactory.setNamespaceAware(true);
                builderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                builderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                InputSource inputSource = null;
                inputSource = this.fromResultSet ? new InputSource(DB2J.toCharacterStream(this.bytes, this.column, this.connection)) : new InputSource(new StringReader(this.stringRep));
                return (T)new DOMSource(builder.parse(inputSource));
            }
            catch (Throwable throwable) {
                DBError.ECJDBC_UNSUPPORTED_TYPE.throwz(new Object[0]);
            }
        } else {
            if (clazz.equals(StreamSource.class)) {
                Reader reader = null;
                reader = this.fromResultSet ? DB2J.toCharacterStream(this.bytes, this.column, this.connection) : new StringReader(this.stringRep);
                return (T)new StreamSource(reader);
            }
            if (clazz.equals(StAXSource.class)) {
                try {
                    Reader reader = null;
                    reader = this.fromResultSet ? DB2J.toCharacterStream(this.bytes, this.column, this.connection) : new StringReader(this.stringRep);
                    return (T)new StAXSource(this.inputFactory.createXMLStreamReader(reader));
                }
                catch (XMLStreamException xMLStreamException) {
                    DBError.ECJDBC_UNSUPPORTED_TYPE.throwz(new Object[0]);
                }
            } else {
                DBError.ECJDBC_UNSUPPORTED_TYPE.throwz(new Object[0]);
            }
        }
        return null;
    }

    @Override
    public synchronized OutputStream setBinaryStream() throws SQLException {
        this.checkClosed();
        this.checkWorkingWithResult();
        this.workingWithResult = true;
        this.asByteArrayOutputStream = new ByteArrayOutputStream();
        return this.asByteArrayOutputStream;
    }

    @Override
    public synchronized Writer setCharacterStream() throws SQLException {
        this.checkClosed();
        this.checkWorkingWithResult();
        this.workingWithResult = true;
        return this.setCharacterStreamInternal();
    }

    private synchronized Writer setCharacterStreamInternal() throws SQLException {
        this.asStringWriter = new StringWriter();
        return this.asStringWriter;
    }

    @Override
    public <T extends Result> T setResult(Class<T> clazz) throws SQLException {
        this.checkClosed();
        this.checkWorkingWithResult();
        this.workingWithResult = true;
        this.asDOMResult = null;
        this.asSAXResult = null;
        this.saxToReaderConverter = null;
        this.stringRep = null;
        this.asStringWriter = null;
        this.asByteArrayOutputStream = null;
        if (clazz == null || clazz.equals(SAXResult.class)) {
            this.saxToReaderConverter = new SimpleSaxToReader();
            this.asSAXResult = new SAXResult(this.saxToReaderConverter);
            return (T)this.asSAXResult;
        }
        if (clazz.equals(DOMResult.class)) {
            this.asDOMResult = new DOMResult();
            return (T)this.asDOMResult;
        }
        if (clazz.equals(StreamResult.class)) {
            return (T)new StreamResult(this.setCharacterStreamInternal());
        }
        if (clazz.equals(StAXResult.class)) {
            try {
                if (this.outputFactory == null) {
                    this.outputFactory = XMLOutputFactory.newInstance();
                }
                return (T)new StAXResult(this.outputFactory.createXMLEventWriter(this.setCharacterStreamInternal()));
            }
            catch (XMLStreamException xMLStreamException) {
                DBError.ECJDBC_UNSUPPORTED_TYPE.throwz(new Object[0]);
            }
        } else {
            DBError.ECJDBC_UNSUPPORTED_TYPE.throwz(new Object[0]);
        }
        return null;
    }

    private Reader binaryInputStreamStreamToReader(ByteArrayOutputStream out) {
        try {
            String encoding = "UTF-8";
            try {
                ByteArrayInputStream bIn = new ByteArrayInputStream(out.toByteArray());
                XMLStreamReader reader = this.inputFactory.createXMLStreamReader(bIn);
                int eventType = 0;
                while ((eventType = reader.next()) != 8) {
                    if (eventType != 7) continue;
                    String possibleEncoding = reader.getEncoding();
                    if (possibleEncoding != null) {
                        encoding = possibleEncoding;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {}
            return new StringReader(new String(out.toByteArray(), encoding));
        }
        catch (UnsupportedEncodingException badEnc) {
            throw new RuntimeException(badEnc);
        }
    }

    protected String readerToString(Reader reader) throws SQLException {
        StringBuffer buf = new StringBuffer();
        int charsRead = 0;
        char[] charBuf = new char[512];
        try {
            while ((charsRead = reader.read(charBuf)) != -1) {
                buf.append(charBuf, 0, charsRead);
            }
        }
        catch (IOException ioEx) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(ioEx);
        }
        return buf.toString();
    }

    public synchronized Reader serializeAsCharacterStream() throws SQLException {
        this.checkClosed();
        if (this.workingWithResult) {
            if (this.stringRep != null) {
                return new StringReader(this.stringRep);
            }
            if (this.asDOMResult != null) {
                return new StringReader(this.domSourceToString());
            }
            if (this.asStringWriter != null) {
                return new StringReader(this.asStringWriter.toString());
            }
            if (this.asSAXResult != null) {
                return this.saxToReaderConverter.toReader();
            }
            if (this.asByteArrayOutputStream != null) {
                return this.binaryInputStreamStreamToReader(this.asByteArrayOutputStream);
            }
        }
        return DB2J.toCharacterStream(this.bytes, this.column, this.connection);
    }

    protected String domSourceToString() throws SQLException {
        try {
            DOMSource source = new DOMSource(this.asDOMResult.getNode());
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            Transformer identity = factory.newTransformer();
            StringWriter stringOut = new StringWriter();
            StreamResult result = new StreamResult(stringOut);
            identity.transform(source, result);
            return stringOut.toString();
        }
        catch (Throwable t2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(t2);
            return null;
        }
    }

    public synchronized String serializeAsString() throws SQLException {
        this.checkClosed();
        if (this.workingWithResult) {
            if (this.stringRep != null) {
                return this.stringRep;
            }
            if (this.asDOMResult != null) {
                return this.domSourceToString();
            }
            if (this.asStringWriter != null) {
                return this.asStringWriter.toString();
            }
            if (this.asSAXResult != null) {
                return this.readerToString(this.saxToReaderConverter.toReader());
            }
            if (this.asByteArrayOutputStream != null) {
                return this.readerToString(this.binaryInputStreamStreamToReader(this.asByteArrayOutputStream));
            }
        }
        return DB2J.toString(this.bytes, this.column, this.connection);
    }

    public String toString() {
        try {
            return this.serializeAsString();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    class SimpleSaxToReader
    extends DefaultHandler {
        StringBuffer buf = new StringBuffer();
        private boolean inCDATA = false;

        SimpleSaxToReader() {
        }

        @Override
        public void startDocument() throws SAXException {
            this.buf.append("<?xml version='1.0' encoding='UTF-8'?>");
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
            this.buf.append("<");
            this.buf.append(qName);
            if (attrs != null) {
                int i2 = 0;
                while (i2 < attrs.getLength()) {
                    this.buf.append(" ");
                    this.buf.append(attrs.getQName(i2)).append("=\"");
                    this.escapeCharsForXml(attrs.getValue(i2), true);
                    this.buf.append("\"");
                    ++i2;
                }
            }
            this.buf.append(">");
        }

        @Override
        public void characters(char[] buf, int offset, int len) throws SAXException {
            if (!this.inCDATA) {
                this.escapeCharsForXml(buf, offset, len, false);
            } else {
                this.buf.append(buf, offset, len);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.characters(ch, start, length);
        }

        public void startCDATA() throws SAXException {
            this.buf.append("<![CDATA[");
            this.inCDATA = true;
        }

        public void endCDATA() throws SAXException {
            this.inCDATA = false;
            this.buf.append("]]>");
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            this.buf.append("<!--");
            int i2 = 0;
            while (i2 < length) {
                this.buf.append(ch[start + i2]);
                ++i2;
            }
            this.buf.append("-->");
        }

        Reader toReader() {
            return new StringReader(this.buf.toString());
        }

        private void escapeCharsForXml(String str, boolean isAttributeData) {
            if (str == null) {
                return;
            }
            int strLen = str.length();
            int i2 = 0;
            while (i2 < strLen) {
                this.escapeCharsForXml(str.charAt(i2), isAttributeData);
                ++i2;
            }
        }

        private void escapeCharsForXml(char[] buf, int offset, int len, boolean isAttributeData) {
            if (buf == null) {
                return;
            }
            int i2 = 0;
            while (i2 < len) {
                this.escapeCharsForXml(buf[offset + i2], isAttributeData);
                ++i2;
            }
        }

        private void escapeCharsForXml(char c2, boolean isAttributeData) {
            switch (c2) {
                case '<': {
                    this.buf.append("&lt;");
                    break;
                }
                case '>': {
                    this.buf.append("&gt;");
                    break;
                }
                case '&': {
                    this.buf.append("&amp;");
                    break;
                }
                case '\"': {
                    if (!isAttributeData) {
                        this.buf.append("\"");
                        break;
                    }
                    this.buf.append("&quot;");
                    break;
                }
                case '\r': {
                    this.buf.append("&#xD;");
                    break;
                }
                default: {
                    if (c2 >= '\u0001' && c2 <= '\u001f' && c2 != '\t' && c2 != '\n' || c2 >= '\u007f' && c2 <= '\u009f' || c2 == '\u2028' || isAttributeData && (c2 == '\t' || c2 == '\n')) {
                        this.buf.append("&#x");
                        this.buf.append(Integer.toHexString(c2).toUpperCase());
                        this.buf.append(";");
                        break;
                    }
                    this.buf.append(c2);
                }
            }
        }
    }
}

