/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.log;

import dm.jdbc.desc.conf.DmSvcConf;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbDatabaseMetaData;
import dm.jdbc.driver.DmdbParameterMetaData;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.filter.log.ILogger;
import dm.jdbc.filter.log.LogRecord;
import dm.jdbc.filter.log.LogWriter;
import dm.jdbc.internal.AbstractLob;
import dm.jdbc.util.DateUtil;
import dm.jdbc.util.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;

public class Logger
implements ILogger {
    public Logger(String name) {
    }

    public boolean isAssertEnabled() {
        return DmSvcConf.GLOBAL.logLevel >= 1;
    }

    @Override
    public boolean isDebugEnabled() {
        return DmSvcConf.GLOBAL.logLevel >= 6;
    }

    @Override
    public boolean isErrorEnabled() {
        return DmSvcConf.GLOBAL.logLevel >= 2;
    }

    @Override
    public boolean isInfoEnabled() {
        return DmSvcConf.GLOBAL.logLevel >= 5;
    }

    @Override
    public boolean isWarnEnabled() {
        return DmSvcConf.GLOBAL.logLevel >= 3;
    }

    @Override
    public boolean isSqlEnabled() {
        return DmSvcConf.GLOBAL.logLevel >= 4;
    }

    @Override
    public void debug(String message) {
        try {
            if (this.isDebugEnabled()) {
                this.println(String.valueOf(this.formatHead("DEBUG")) + message);
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void debug(String message, Throwable t2) {
        try {
            if (this.isDebugEnabled()) {
                this.println(String.valueOf(this.formatHead("DEBUG")) + message + StringUtil.LINE_SEPARATOR + Logger.getStackTrace(t2));
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void debug(Object source, String method, Object ... params) {
        try {
            if (this.isDebugEnabled()) {
                this.println(String.valueOf(this.formatHead("DEBUG")) + Logger.formatTrace(source, method, params));
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void debug(Object source, String method, String info) {
        try {
            if (this.isDebugEnabled()) {
                this.println(String.valueOf(this.formatHead("DEBUG")) + Logger.formatTrace(source, method, info));
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void info(String message) {
        try {
            if (this.isInfoEnabled()) {
                this.println(String.valueOf(this.formatHead("INFO ")) + message.toString());
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void info(Object source, String method, String info) {
        try {
            if (this.isInfoEnabled()) {
                this.println(String.valueOf(this.formatHead("INFO ")) + Logger.formatTrace(source, method, info));
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void info(Object source, String method, Object ... params) {
        try {
            if (this.isInfoEnabled()) {
                this.println(String.valueOf(this.formatHead("INFO ")) + Logger.formatTrace(source, method, params));
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void sql(String message) {
        try {
            if (this.isSqlEnabled()) {
                this.println(String.valueOf(this.formatHead("SQL  ")) + message);
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void warn(String message) {
        try {
            if (this.isWarnEnabled()) {
                this.println(String.valueOf(this.formatHead("WARN ")) + message);
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void warn(Object source, String method, String info) {
        try {
            if (this.isWarnEnabled()) {
                this.println(String.valueOf(this.formatHead("WARN ")) + Logger.formatTrace(source, method, info));
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void error(String message) {
        this.error(message, null);
    }

    @Override
    public void error(String message, Throwable t2) {
        try {
            if (this.isErrorEnabled()) {
                this.println(String.valueOf(this.formatHead("ERROR")) + message + StringUtil.LINE_SEPARATOR + Logger.getStackTrace(t2));
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void asserts(String message, Throwable t2) {
        try {
            if (this.isAssertEnabled()) {
                this.println(String.valueOf(this.formatHead("ASSERT")) + message + StringUtil.LINE_SEPARATOR + Logger.getStackTrace(t2));
            }
        }
        catch (Exception exception) {}
    }

    private String formatHead(String head) {
        return "[" + head + " - " + DateUtil.formatDate(new Date(System.currentTimeMillis()), 2) + "] tid:" + Thread.currentThread().getId() + " - [" + Thread.currentThread().getName() + "] ";
    }

    private void println(String msg) {
        LogWriter.getInstance().writeLine(StringUtil.trimToEmpty(msg));
    }

    public static String getStackTrace(Throwable t2) {
        if (t2 == null) {
            return "";
        }
        StringWriter out = new StringWriter(256);
        t2.printStackTrace(new PrintWriter(out));
        return String.valueOf(out.toString()) + StringUtil.LINE_SEPARATOR;
    }

    public static String formatTrace(Object source, String method, String info) {
        StringBuilder str = new StringBuilder();
        if (source != null) {
            str.append("{ " + Logger.formatSource(source) + " } ");
        }
        str.append(method).append("();  ");
        str.append(info);
        return str.toString();
    }

    public static String formatTrace(Object source, String method, Object ... params) {
        return Logger.formatTrace(source, method, null, params);
    }

    public static String formatTrace(Object source, String method, Object returnValue, Object ... params) {
        int i2;
        StringBuilder str = new StringBuilder(128);
        if (source != null) {
            str.append("{ " + Logger.formatSource(source) + " } ");
        }
        str.append(String.valueOf(method) + "(");
        int paramStartIndex = 0;
        if (params != null && params.length > paramStartIndex) {
            i2 = paramStartIndex;
            while (i2 < params.length) {
                if (i2 != paramStartIndex) {
                    str.append(", ");
                }
                if (params[i2] != null) {
                    str.append(params[i2].getClass().getSimpleName());
                } else {
                    str.append("null");
                }
                ++i2;
            }
        }
        str.append(")");
        if (returnValue != null) {
            str.append(": " + Logger.formatReturn(returnValue));
        }
        str.append(";  ");
        if (params != null && params.length > paramStartIndex) {
            str.append("[PARAMS]: ");
            i2 = paramStartIndex;
            while (i2 < params.length) {
                if (i2 != 0) {
                    str.append(", ");
                }
                if (params[i2] instanceof String) {
                    str.append("\"").append(params[i2]).append("\"");
                } else {
                    str.append(params[i2]);
                }
                ++i2;
            }
            str.append("; ");
        }
        return str.toString();
    }

    public static String formatSource(Object source) {
        if (source != null) {
            StringBuffer str = new StringBuffer(128);
            if (source instanceof String) {
                str.append(source);
            } else if (source instanceof DmdbConnection) {
                str.append(Logger.formatConn((DmdbConnection)source));
            } else if (source instanceof DmdbStatement) {
                str.append(Logger.formatConn(((DmdbStatement)source).connection)).append(", ");
                str.append(Logger.formatStmt((DmdbStatement)source));
            } else if (source instanceof DmdbResultSet) {
                str.append(Logger.formatConn(((DmdbResultSet)source).connection)).append(", ");
                str.append(Logger.formatStmt(((DmdbResultSet)source).statement)).append(", ");
                str.append(Logger.formatRs((DmdbResultSet)source));
            } else if (source instanceof DmdbDatabaseMetaData) {
                str.append(Logger.formatConn(((DmdbDatabaseMetaData)source).connection)).append(", ");
                str.append(((DmdbDatabaseMetaData)source).logInfo != null ? "dbmd-" + ((DmdbDatabaseMetaData)source).getID() : "dbmd-null");
            } else if (source instanceof DmdbResultSetMetaData) {
                str.append(((DmdbResultSetMetaData)source).logInfo != null ? "rsmd-" + ((DmdbResultSetMetaData)source).getID() : "rsmd-null");
            } else if (source instanceof DmdbParameterMetaData) {
                str.append(((DmdbParameterMetaData)source).logInfo != null ? "pmd-" + ((DmdbParameterMetaData)source).getID() : "pmd-null");
            } else if (source instanceof AbstractLob) {
                str.append(Logger.formatConn(((AbstractLob)source).connection)).append(", ");
                str.append(String.valueOf(source.getClass().getSimpleName()) + "@" + Integer.toHexString(source.hashCode()));
            } else {
                str.append(String.valueOf(source.getClass().getSimpleName()) + "@" + Integer.toHexString(source.hashCode()));
            }
            return str.toString();
        }
        return "";
    }

    public static String formatReturn(Object returnObject) {
        String str = "";
        if (returnObject instanceof DmdbConnection) {
            str = Logger.formatConn((DmdbConnection)returnObject);
            long sessID = ((DmdbConnection)returnObject).sessionID;
            str = String.valueOf(str) + (sessID != -1L ? ", sessionID-0x" + Long.toHexString(((DmdbConnection)returnObject).sessionID) : "");
        } else if (returnObject instanceof DmdbStatement) {
            str = Logger.formatStmt((DmdbStatement)returnObject);
            str = String.valueOf(str) + ", handle-" + ((DmdbStatement)returnObject).handle;
        } else {
            str = returnObject instanceof DmdbResultSet ? Logger.formatRs((DmdbResultSet)returnObject) : (returnObject instanceof DmdbDatabaseMetaData ? (((DmdbDatabaseMetaData)returnObject).logInfo != null ? "dbmd-" + ((DmdbDatabaseMetaData)returnObject).getID() : "dbmd-null") : (returnObject instanceof DmdbResultSetMetaData ? (((DmdbResultSetMetaData)returnObject).logInfo != null ? "rsmd-" + ((DmdbResultSetMetaData)returnObject).getID() : "rsmd-null") : (returnObject instanceof DmdbParameterMetaData ? (((DmdbParameterMetaData)returnObject).logInfo != null ? "pmd-" + ((DmdbParameterMetaData)returnObject).getID() : "pmd-null") : (returnObject instanceof String ? "\"" + returnObject.toString() + "\"" : (returnObject instanceof LogRecord.NullData ? "null" : returnObject.toString())))));
        }
        return str;
    }

    public static String formatConn(DmdbConnection connection) {
        if (connection != null && connection.logInfo != null) {
            return "conn-" + connection.getID();
        }
        return "conn-null";
    }

    public static String formatStmt(DmdbStatement statement) {
        if (statement != null && statement.logInfo != null) {
            if (statement instanceof DmdbCallableStatement) {
                return "cstmt-" + statement.getID();
            }
            if (statement instanceof DmdbPreparedStatement) {
                return "pstmt-" + statement.getID();
            }
            return "stmt-" + statement.getID();
        }
        return "stmt-null";
    }

    public static String formatRs(DmdbResultSet resultSet) {
        if (resultSet != null && resultSet.logInfo != null) {
            return "rs-" + resultSet.getID();
        }
        return "rs-null";
    }
}

