/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.reconnect;

import dm.jdbc.desc.conf.DmProperties;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbDatabaseMetaData;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbParameterMetaData;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.driver.DmdbXAResource;
import dm.jdbc.filter.Filter;
import dm.jdbc.filter.FilterChain;
import dm.jdbc.filter.reconnect.ReconnectController;
import dm.jdbc.filter.rw.RWUtil2;
import dm.jdbc.util.CacheQueue;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.StringUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.RowIdLifetime;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class ReconnectFilter
implements Filter {
    private static ReconnectController controller;

    private ReconnectFilter() {
    }

    public static ReconnectFilter getInstance() {
        return ReconnectFilterThreadHolder.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConnection(DmdbConnection ret) {
        if (ret.epGroup == null || (ret.epGroup.reconnect & 4) == 0 && (ret.epGroup.reconnect & 2) == 0) {
            return;
        }
        CacheQueue<DmdbConnection> cacheQueue = ReconnectController.connQueue;
        synchronized (cacheQueue) {
            if (controller == null) {
                controller = new ReconnectController();
                controller.start();
            }
            ReconnectController.connQueue.put(ret);
        }
    }

    private boolean whenError(DmdbConnection connection, SQLException e2) throws SQLException {
        if (e2 == null) {
            return false;
        }
        if (!this.whenErrorInner(connection, e2.getErrorCode(), e2.getMessage())) {
            throw e2;
        }
        return true;
    }

    private boolean whenError(DmdbConnection connection, XAException e2) throws XAException {
        if (e2 == null) {
            return false;
        }
        try {
            int errorCode = e2.errorCode;
            String message = e2.getMessage();
            if (e2.getCause() instanceof SQLException) {
                SQLException sqle = (SQLException)e2.getCause();
                errorCode = sqle.getErrorCode();
                message = sqle.getMessage();
            }
            if (!this.whenErrorInner(connection, errorCode, message)) {
                throw e2;
            }
        }
        catch (Exception exception) {
            throw e2;
        }
        return true;
    }

    private boolean whenErrorInner(DmdbConnection connection, int errorCode, String errorMessage) throws SQLException {
        if (connection.epGroup == null || !connection.epGroup.isReconnectWhenError()) {
            return false;
        }
        if (errorCode == DBError.EC_SWITCH_TO_EP_SEQNO.errCode) {
            block10: {
                String errMsg = errorMessage;
                int idx = errMsg.lastIndexOf("_");
                String ep = StringUtil.trimToEmpty(errMsg.substring(idx + 1));
                try {
                    connection.switchToEpSeqno = Integer.parseInt(ep);
                }
                catch (Exception exception) {
                    int i2 = -1;
                    i2 = ep.lastIndexOf(":");
                    if (i2 == -1) break block10;
                    connection.switchToHost = StringUtil.trimToEmpty(ep.substring(0, i2));
                    connection.switchToPort = Integer.parseInt(StringUtil.trimToEmpty(ep.substring(i2 + 1, ep.length())));
                }
            }
            if (connection.getTransFinish()) {
                connection.do_reconnect();
                return true;
            }
            connection.do_reconnect();
            DBError.ECJDBC_CONNECTION_SWITCHED.throwz(errorMessage);
        }
        if (errorCode == DBError.ECJDBC_COMMUNITION_ERROR.errCode || errorCode == DBError.ECJDBC_CONNECTION_CLOSED.errCode) {
            try {
                if (connection.rwSeparate > 0) {
                    RWUtil2.reconnect(connection);
                } else {
                    connection.do_reconnect();
                }
            }
            catch (Throwable throwable) {
                DBError.ECJDBC_CONNECTION_SWITCH_FAILED.throwz(errorMessage);
            }
            DBError.ECJDBC_CONNECTION_SWITCHED.throwz(errorMessage);
        }
        return false;
    }

    private void afterCommitRollback(DmdbConnection connection) throws SQLException {
        if (!connection.getTransFinish() || connection.switchToEpSeqno < 0 && StringUtil.isEmpty(connection.switchToHost)) {
            return;
        }
        connection.do_reconnect();
        if (connection.epGroup.cluster == 3) {
            DriverUtil.execute(connection, "alter session set 'DSC_TABLESPACE_BALANCE'=0;");
        }
    }

    private void beforeExecute(DmdbConnection connection) throws SQLException {
        if (!connection.getTransFinish() || connection.switchToEpSeqno < 0 && StringUtil.isEmpty(connection.switchToHost)) {
            return;
        }
        connection.do_reconnect();
        if (connection.epGroup.cluster == 3) {
            DriverUtil.execute(connection, "alter session set 'DSC_TABLESPACE_BALANCE'=0;");
        }
    }

    @Override
    public long Blob_length(FilterChain filterChain, DmdbBlob blob) throws SQLException {
        try {
            return filterChain.Blob_length(blob);
        }
        catch (SQLException e2) {
            this.whenError(blob.connection, e2);
            return 0L;
        }
    }

    @Override
    public byte[] Blob_getBytes(FilterChain filterChain, DmdbBlob blob, long pos, int length) throws SQLException {
        try {
            return filterChain.Blob_getBytes(blob, pos, length);
        }
        catch (SQLException e2) {
            this.whenError(blob.connection, e2);
            return null;
        }
    }

    @Override
    public InputStream Blob_getBinaryStream(FilterChain filterChain, DmdbBlob blob) throws SQLException {
        try {
            return filterChain.Blob_getBinaryStream(blob);
        }
        catch (SQLException e2) {
            this.whenError(blob.connection, e2);
            return null;
        }
    }

    @Override
    public long Blob_position(FilterChain filterChain, DmdbBlob blob, byte[] pattern, long start) throws SQLException {
        try {
            return filterChain.Blob_position(blob, pattern, start);
        }
        catch (SQLException e2) {
            this.whenError(blob.connection, e2);
            return 0L;
        }
    }

    @Override
    public long Blob_position(FilterChain filterChain, DmdbBlob blob, Blob pattern, long start) throws SQLException {
        try {
            return filterChain.Blob_position(blob, pattern, start);
        }
        catch (SQLException e2) {
            this.whenError(blob.connection, e2);
            return 0L;
        }
    }

    @Override
    public int Blob_setBytes(FilterChain filterChain, DmdbBlob blob, long pos, byte[] bytes) throws SQLException {
        try {
            return filterChain.Blob_setBytes(blob, pos, bytes);
        }
        catch (SQLException e2) {
            this.whenError(blob.connection, e2);
            return 0;
        }
    }

    @Override
    public int Blob_setBytes(FilterChain filterChain, DmdbBlob blob, long pos, byte[] bytes, int offset, int len) throws SQLException {
        try {
            return filterChain.Blob_setBytes(blob, pos, bytes, offset, len);
        }
        catch (SQLException e2) {
            this.whenError(blob.connection, e2);
            return 0;
        }
    }

    @Override
    public OutputStream Blob_setBinaryStream(FilterChain filterChain, DmdbBlob blob, long pos) throws SQLException {
        try {
            return filterChain.Blob_setBinaryStream(blob, pos);
        }
        catch (SQLException e2) {
            this.whenError(blob.connection, e2);
            return null;
        }
    }

    @Override
    public void Blob_truncate(FilterChain filterChain, DmdbBlob blob, long len) throws SQLException {
        try {
            filterChain.Blob_truncate(blob, len);
        }
        catch (SQLException e2) {
            this.whenError(blob.connection, e2);
        }
    }

    @Override
    public void Blob_free(FilterChain filterChain, DmdbBlob blob) throws SQLException {
        try {
            filterChain.Blob_free(blob);
        }
        catch (SQLException e2) {
            this.whenError(blob.connection, e2);
        }
    }

    @Override
    public InputStream Blob_getBinaryStream(FilterChain filterChain, DmdbBlob blob, long pos, long length) throws SQLException {
        try {
            return filterChain.Blob_getBinaryStream(blob, pos, length);
        }
        catch (SQLException e2) {
            this.whenError(blob.connection, e2);
            return null;
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, int sqlType) throws SQLException {
        try {
            filterChain.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, int sqlType, int scale) throws SQLException {
        try {
            filterChain.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType, scale);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public boolean CallableStatement_wasNull(FilterChain filterChain, DmdbCallableStatement callableStatement) throws SQLException {
        try {
            return filterChain.CallableStatement_wasNull(callableStatement);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return false;
        }
    }

    @Override
    public String CallableStatement_getString(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return filterChain.CallableStatement_getString(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public boolean CallableStatement_getBoolean(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return filterChain.CallableStatement_getBoolean(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return false;
        }
    }

    @Override
    public byte CallableStatement_getByte(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return filterChain.CallableStatement_getByte(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return 0;
        }
    }

    @Override
    public short CallableStatement_getShort(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return filterChain.CallableStatement_getShort(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return 0;
        }
    }

    @Override
    public int CallableStatement_getInt(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return filterChain.CallableStatement_getInt(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return 0;
        }
    }

    @Override
    public long CallableStatement_getLong(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return filterChain.CallableStatement_getLong(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return 0L;
        }
    }

    @Override
    public float CallableStatement_getFloat(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return filterChain.CallableStatement_getFloat(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return 0.0f;
        }
    }

    @Override
    public double CallableStatement_getDouble(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return filterChain.CallableStatement_getDouble(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return 0.0;
        }
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, int scale) throws SQLException {
        try {
            return filterChain.CallableStatement_getBigDecimal(callableStatement, parameterIndex, scale);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public byte[] CallableStatement_getBytes(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return filterChain.CallableStatement_getBytes(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Date CallableStatement_getDate(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return filterChain.CallableStatement_getDate(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Time CallableStatement_getTime(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return filterChain.CallableStatement_getTime(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return filterChain.CallableStatement_getTimestamp(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Object CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return filterChain.CallableStatement_getObject(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return filterChain.CallableStatement_getBigDecimal(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Object CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        try {
            return filterChain.CallableStatement_getObject(callableStatement, parameterIndex, map);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Ref CallableStatement_getRef(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return filterChain.CallableStatement_getRef(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Blob CallableStatement_getBlob(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return filterChain.CallableStatement_getBlob(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Clob CallableStatement_getClob(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return filterChain.CallableStatement_getClob(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Array CallableStatement_getArray(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return filterChain.CallableStatement_getArray(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Date CallableStatement_getDate(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        try {
            return filterChain.CallableStatement_getDate(callableStatement, parameterIndex, cal);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Time CallableStatement_getTime(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        try {
            return filterChain.CallableStatement_getTime(callableStatement, parameterIndex, cal);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        try {
            return filterChain.CallableStatement_getTimestamp(callableStatement, parameterIndex, cal);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, int sqlType, String typeName) throws SQLException {
        try {
            filterChain.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType, typeName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, int sqlType) throws SQLException {
        try {
            filterChain.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, int sqlType, int scale) throws SQLException {
        try {
            filterChain.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType, scale);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, int sqlType, String typeName) throws SQLException {
        try {
            filterChain.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType, typeName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public URL CallableStatement_getURL(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return filterChain.CallableStatement_getURL(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public void CallableStatement_setURL(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, URL val) throws SQLException {
        try {
            filterChain.CallableStatement_setURL(callableStatement, parameterName, val);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setNull(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, int sqlType) throws SQLException {
        try {
            filterChain.CallableStatement_setNull(callableStatement, parameterName, sqlType);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setBoolean(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, boolean x2) throws SQLException {
        try {
            filterChain.CallableStatement_setBoolean(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setByte(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, byte x2) throws SQLException {
        try {
            filterChain.CallableStatement_setByte(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setShort(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, short x2) throws SQLException {
        try {
            filterChain.CallableStatement_setShort(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setInt(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, int x2) throws SQLException {
        try {
            filterChain.CallableStatement_setInt(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setLong(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, long x2) throws SQLException {
        try {
            filterChain.CallableStatement_setLong(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setFloat(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, float x2) throws SQLException {
        try {
            filterChain.CallableStatement_setFloat(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setDouble(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, double x2) throws SQLException {
        try {
            filterChain.CallableStatement_setDouble(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setBigDecimal(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, BigDecimal x2) throws SQLException {
        try {
            filterChain.CallableStatement_setBigDecimal(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setString(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, String x2) throws SQLException {
        try {
            filterChain.CallableStatement_setString(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setBytes(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, byte[] x2) throws SQLException {
        try {
            filterChain.CallableStatement_setBytes(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setDate(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Date x2) throws SQLException {
        try {
            filterChain.CallableStatement_setDate(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setTime(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Time x2) throws SQLException {
        try {
            filterChain.CallableStatement_setTime(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setTimestamp(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Timestamp x2) throws SQLException {
        try {
            filterChain.CallableStatement_setTimestamp(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setAsciiStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2, int length) throws SQLException {
        try {
            filterChain.CallableStatement_setAsciiStream(callableStatement, parameterName, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setBinaryStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2, int length) throws SQLException {
        try {
            filterChain.CallableStatement_setBinaryStream(callableStatement, parameterName, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Object x2, int targetSqlType, int scale) throws SQLException {
        try {
            filterChain.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType, scale);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Object x2, int targetSqlType) throws SQLException {
        try {
            filterChain.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Object x2) throws SQLException {
        try {
            filterChain.CallableStatement_setObject(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader reader, int length) throws SQLException {
        try {
            filterChain.CallableStatement_setCharacterStream(callableStatement, parameterName, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setDate(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Date x2, Calendar cal) throws SQLException {
        try {
            filterChain.CallableStatement_setDate(callableStatement, parameterName, x2, cal);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setTime(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Time x2, Calendar cal) throws SQLException {
        try {
            filterChain.CallableStatement_setTime(callableStatement, parameterName, x2, cal);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setTimestamp(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Timestamp x2, Calendar cal) throws SQLException {
        try {
            filterChain.CallableStatement_setTimestamp(callableStatement, parameterName, x2, cal);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setNull(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, int sqlType, String typeName) throws SQLException {
        try {
            filterChain.CallableStatement_setNull(callableStatement, parameterName, sqlType, typeName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public String CallableStatement_getString(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return filterChain.CallableStatement_getString(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public boolean CallableStatement_getBoolean(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return filterChain.CallableStatement_getBoolean(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return false;
        }
    }

    @Override
    public byte CallableStatement_getByte(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return filterChain.CallableStatement_getByte(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return 0;
        }
    }

    @Override
    public short CallableStatement_getShort(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return filterChain.CallableStatement_getShort(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return 0;
        }
    }

    @Override
    public int CallableStatement_getInt(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return filterChain.CallableStatement_getInt(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return 0;
        }
    }

    @Override
    public long CallableStatement_getLong(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return filterChain.CallableStatement_getLong(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return 0L;
        }
    }

    @Override
    public float CallableStatement_getFloat(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return filterChain.CallableStatement_getFloat(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return 0.0f;
        }
    }

    @Override
    public double CallableStatement_getDouble(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return filterChain.CallableStatement_getDouble(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return 0.0;
        }
    }

    @Override
    public byte[] CallableStatement_getBytes(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return filterChain.CallableStatement_getBytes(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Date CallableStatement_getDate(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return filterChain.CallableStatement_getDate(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Time CallableStatement_getTime(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return filterChain.CallableStatement_getTime(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return filterChain.CallableStatement_getTimestamp(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Object CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return filterChain.CallableStatement_getObject(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return filterChain.CallableStatement_getBigDecimal(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Object CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Map<String, Class<?>> map) throws SQLException {
        try {
            return filterChain.CallableStatement_getObject(callableStatement, parameterName, map);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Ref CallableStatement_getRef(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return filterChain.CallableStatement_getRef(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Blob CallableStatement_getBlob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return filterChain.CallableStatement_getBlob(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Clob CallableStatement_getClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return filterChain.CallableStatement_getClob(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Array CallableStatement_getArray(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return filterChain.CallableStatement_getArray(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Date CallableStatement_getDate(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        try {
            return filterChain.CallableStatement_getDate(callableStatement, parameterName, cal);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Time CallableStatement_getTime(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        try {
            return filterChain.CallableStatement_getTime(callableStatement, parameterName, cal);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        try {
            return filterChain.CallableStatement_getTimestamp(callableStatement, parameterName, cal);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public URL CallableStatement_getURL(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return filterChain.CallableStatement_getURL(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public RowId CallableStatement_getRowId(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return filterChain.CallableStatement_getRowId(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public RowId CallableStatement_getRowId(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return filterChain.CallableStatement_getRowId(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public void CallableStatement_setRowId(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, RowId x2) throws SQLException {
        try {
            filterChain.CallableStatement_setRowId(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setNString(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, String value) throws SQLException {
        try {
            filterChain.CallableStatement_setNString(callableStatement, parameterName, value);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setNCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader value, long length) throws SQLException {
        try {
            filterChain.CallableStatement_setNCharacterStream(callableStatement, parameterName, value, length);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setNClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, NClob value) throws SQLException {
        try {
            filterChain.CallableStatement_setNClob(callableStatement, parameterName, value);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        try {
            filterChain.CallableStatement_setClob(callableStatement, parameterName, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setBlob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream inputStream, long length) throws SQLException {
        try {
            filterChain.CallableStatement_setBlob(callableStatement, parameterName, inputStream, length);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setNClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        try {
            filterChain.CallableStatement_setNClob(callableStatement, parameterName, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public NClob CallableStatement_getNClob(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return filterChain.CallableStatement_getNClob(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public NClob CallableStatement_getNClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return filterChain.CallableStatement_getNClob(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public void CallableStatement_setSQLXML(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, SQLXML xmlObject) throws SQLException {
        try {
            filterChain.CallableStatement_setSQLXML(callableStatement, parameterName, xmlObject);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public SQLXML CallableStatement_getSQLXML(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return filterChain.CallableStatement_getSQLXML(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public SQLXML CallableStatement_getSQLXML(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return filterChain.CallableStatement_getSQLXML(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public String CallableStatement_getNString(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return filterChain.CallableStatement_getNString(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public String CallableStatement_getNString(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return filterChain.CallableStatement_getNString(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Reader CallableStatement_getNCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return filterChain.CallableStatement_getNCharacterStream(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Reader CallableStatement_getNCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return filterChain.CallableStatement_getNCharacterStream(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Reader CallableStatement_getCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return filterChain.CallableStatement_getCharacterStream(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Reader CallableStatement_getCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return filterChain.CallableStatement_getCharacterStream(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public void CallableStatement_setBlob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Blob x2) throws SQLException {
        try {
            filterChain.CallableStatement_setBlob(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Clob x2) throws SQLException {
        try {
            filterChain.CallableStatement_setClob(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setAsciiStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2, long length) throws SQLException {
        try {
            filterChain.CallableStatement_setAsciiStream(callableStatement, parameterName, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setBinaryStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2, long length) throws SQLException {
        try {
            filterChain.CallableStatement_setBinaryStream(callableStatement, parameterName, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        try {
            filterChain.CallableStatement_setCharacterStream(callableStatement, parameterName, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setAsciiStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2) throws SQLException {
        try {
            filterChain.CallableStatement_setAsciiStream(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setBinaryStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2) throws SQLException {
        try {
            filterChain.CallableStatement_setBinaryStream(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        try {
            filterChain.CallableStatement_setCharacterStream(callableStatement, parameterName, reader);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setNCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader value) throws SQLException {
        try {
            filterChain.CallableStatement_setNCharacterStream(callableStatement, parameterName, value);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        try {
            filterChain.CallableStatement_setClob(callableStatement, parameterName, reader);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setBlob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream inputStream) throws SQLException {
        try {
            filterChain.CallableStatement_setBlob(callableStatement, parameterName, inputStream);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setNClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        try {
            filterChain.CallableStatement_setNClob(callableStatement, parameterName, reader);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public <T> T CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, Class<T> type) throws SQLException {
        try {
            return filterChain.CallableStatement_getObject(callableStatement, parameterIndex, type);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public <T> T CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Class<T> type) throws SQLException {
        try {
            return filterChain.CallableStatement_getObject(callableStatement, parameterName, type);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        try {
            filterChain.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType, scaleOrLength);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Object x2, SQLType targetSqlType) throws SQLException {
        try {
            filterChain.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, SQLType sqlType) throws SQLException {
        try {
            filterChain.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, SQLType sqlType, int scale) throws SQLException {
        try {
            filterChain.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType, scale);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
        try {
            filterChain.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType, typeName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, SQLType sqlType) throws SQLException {
        try {
            filterChain.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, SQLType sqlType, int scale) throws SQLException {
        try {
            filterChain.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType, scale);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, SQLType sqlType, String typeName) throws SQLException {
        try {
            filterChain.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType, typeName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public long Clob_length(FilterChain filterChain, DmdbClob clob) throws SQLException {
        try {
            return filterChain.Clob_length(clob);
        }
        catch (SQLException e2) {
            this.whenError(clob.connection, e2);
            return 0L;
        }
    }

    @Override
    public String Clob_getSubString(FilterChain filterChain, DmdbClob clob, long pos, int length) throws SQLException {
        try {
            return filterChain.Clob_getSubString(clob, pos, length);
        }
        catch (SQLException e2) {
            this.whenError(clob.connection, e2);
            return null;
        }
    }

    @Override
    public Reader Clob_getCharacterStream(FilterChain filterChain, DmdbClob clob) throws SQLException {
        try {
            return filterChain.Clob_getCharacterStream(clob);
        }
        catch (SQLException e2) {
            this.whenError(clob.connection, e2);
            return null;
        }
    }

    @Override
    public InputStream Clob_getAsciiStream(FilterChain filterChain, DmdbClob clob) throws SQLException {
        try {
            return filterChain.Clob_getAsciiStream(clob);
        }
        catch (SQLException e2) {
            this.whenError(clob.connection, e2);
            return null;
        }
    }

    @Override
    public long Clob_position(FilterChain filterChain, DmdbClob clob, String searchstr, long start) throws SQLException {
        try {
            return filterChain.Clob_position(clob, searchstr, start);
        }
        catch (SQLException e2) {
            this.whenError(clob.connection, e2);
            return 0L;
        }
    }

    @Override
    public long Clob_position(FilterChain filterChain, DmdbClob clob, Clob searchstr, long start) throws SQLException {
        try {
            return filterChain.Clob_position(clob, searchstr, start);
        }
        catch (SQLException e2) {
            this.whenError(clob.connection, e2);
            return 0L;
        }
    }

    @Override
    public int Clob_setString(FilterChain filterChain, DmdbClob clob, long pos, String str) throws SQLException {
        try {
            return filterChain.Clob_setString(clob, pos, str);
        }
        catch (SQLException e2) {
            this.whenError(clob.connection, e2);
            return 0;
        }
    }

    @Override
    public int Clob_setString(FilterChain filterChain, DmdbClob clob, long pos, String str, int offset, int len) throws SQLException {
        try {
            return filterChain.Clob_setString(clob, pos, str, offset, len);
        }
        catch (SQLException e2) {
            this.whenError(clob.connection, e2);
            return 0;
        }
    }

    @Override
    public OutputStream Clob_setAsciiStream(FilterChain filterChain, DmdbClob clob, long pos) throws SQLException {
        try {
            return filterChain.Clob_setAsciiStream(clob, pos);
        }
        catch (SQLException e2) {
            this.whenError(clob.connection, e2);
            return null;
        }
    }

    @Override
    public Writer Clob_setCharacterStream(FilterChain filterChain, DmdbClob clob, long pos) throws SQLException {
        try {
            return filterChain.Clob_setCharacterStream(clob, pos);
        }
        catch (SQLException e2) {
            this.whenError(clob.connection, e2);
            return null;
        }
    }

    @Override
    public void Clob_truncate(FilterChain filterChain, DmdbClob clob, long len) throws SQLException {
        try {
            filterChain.Clob_truncate(clob, len);
        }
        catch (SQLException e2) {
            this.whenError(clob.connection, e2);
        }
    }

    @Override
    public void Clob_free(FilterChain filterChain, DmdbClob clob) throws SQLException {
        try {
            filterChain.Clob_free(clob);
        }
        catch (SQLException e2) {
            this.whenError(clob.connection, e2);
        }
    }

    @Override
    public Reader Clob_getCharacterStream(FilterChain filterChain, DmdbClob clob, long pos, long length) throws SQLException {
        try {
            return filterChain.Clob_getCharacterStream(clob, pos, length);
        }
        catch (SQLException e2) {
            this.whenError(clob.connection, e2);
            return null;
        }
    }

    @Override
    public void Connection_reconnect(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        try {
            filterChain.Connection_reconnect(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public Statement Connection_createStatement(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        try {
            return filterChain.Connection_createStatement(connection);
        }
        catch (SQLException e2) {
            if (this.whenError(connection, e2)) {
                connection.do_createStatement();
            }
            return null;
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection connection, String sql) throws SQLException {
        try {
            return filterChain.Connection_prepareStatement(connection, sql);
        }
        catch (SQLException e2) {
            if (this.whenError(connection, e2)) {
                connection.do_prepareStatement(sql);
            }
            return null;
        }
    }

    @Override
    public CallableStatement Connection_prepareCall(FilterChain filterChain, DmdbConnection connection, String sql) throws SQLException {
        try {
            return filterChain.Connection_prepareCall(connection, sql);
        }
        catch (SQLException e2) {
            if (this.whenError(connection, e2)) {
                connection.do_prepareCall(sql);
            }
            return null;
        }
    }

    @Override
    public String Connection_nativeSQL(FilterChain filterChain, DmdbConnection connection, String sql) throws SQLException {
        try {
            return filterChain.Connection_nativeSQL(connection, sql);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public void Connection_setAutoCommit(FilterChain filterChain, DmdbConnection connection, boolean autoCommit) throws SQLException {
        try {
            filterChain.Connection_setAutoCommit(connection, autoCommit);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public boolean Connection_getAutoCommit(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        try {
            return filterChain.Connection_getAutoCommit(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return false;
        }
    }

    @Override
    public void Connection_commit(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        block2: {
            try {
                filterChain.Connection_commit(connection);
                this.afterCommitRollback(connection);
            }
            catch (SQLException e2) {
                if (!this.whenError(connection, e2)) break block2;
                connection.do_commit();
            }
        }
    }

    @Override
    public void Connection_rollback(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        block2: {
            try {
                filterChain.Connection_rollback(connection);
                this.afterCommitRollback(connection);
            }
            catch (SQLException e2) {
                if (!this.whenError(connection, e2)) break block2;
                connection.do_rollback();
            }
        }
    }

    @Override
    public void Connection_close(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        try {
            filterChain.Connection_close(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public boolean Connection_isClosed(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        try {
            return filterChain.Connection_isClosed(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return false;
        }
    }

    @Override
    public DatabaseMetaData Connection_getMetaData(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        try {
            return filterChain.Connection_getMetaData(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public void Connection_setReadOnly(FilterChain filterChain, DmdbConnection connection, boolean readOnly) throws SQLException {
        try {
            filterChain.Connection_setReadOnly(connection, readOnly);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public boolean Connection_isReadOnly(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        try {
            return filterChain.Connection_isReadOnly(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return false;
        }
    }

    @Override
    public void Connection_setCatalog(FilterChain filterChain, DmdbConnection connection, String catalog) throws SQLException {
        try {
            filterChain.Connection_setCatalog(connection, catalog);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public String Connection_getCatalog(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        try {
            return filterChain.Connection_getCatalog(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public void Connection_setTransactionIsolation(FilterChain filterChain, DmdbConnection connection, int level) throws SQLException {
        try {
            filterChain.Connection_setTransactionIsolation(connection, level);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public int Connection_getTransactionIsolation(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        try {
            return filterChain.Connection_getTransactionIsolation(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return 0;
        }
    }

    @Override
    public SQLWarning Connection_getWarnings(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        try {
            return filterChain.Connection_getWarnings(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public void Connection_clearWarnings(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        try {
            filterChain.Connection_clearWarnings(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public Statement Connection_createStatement(FilterChain filterChain, DmdbConnection connection, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return filterChain.Connection_createStatement(connection, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e2) {
            if (this.whenError(connection, e2)) {
                connection.do_createStatement(resultSetType, resultSetConcurrency);
            }
            return null;
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return filterChain.Connection_prepareStatement(connection, sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e2) {
            if (this.whenError(connection, e2)) {
                connection.do_prepareStatement(sql, resultSetType, resultSetConcurrency);
            }
            return null;
        }
    }

    @Override
    public CallableStatement Connection_prepareCall(FilterChain filterChain, DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return filterChain.Connection_prepareCall(connection, sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e2) {
            if (this.whenError(connection, e2)) {
                connection.do_prepareCall(sql, resultSetType, resultSetConcurrency);
            }
            return null;
        }
    }

    @Override
    public Map<String, Class<?>> Connection_getTypeMap(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        try {
            return filterChain.Connection_getTypeMap(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public void Connection_setTypeMap(FilterChain filterChain, DmdbConnection connection, Map<String, Class<?>> map) throws SQLException {
        try {
            filterChain.Connection_setTypeMap(connection, map);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public void Connection_setHoldability(FilterChain filterChain, DmdbConnection connection, int holdability) throws SQLException {
        try {
            filterChain.Connection_setHoldability(connection, holdability);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public int Connection_getHoldability(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        try {
            return filterChain.Connection_getHoldability(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return 0;
        }
    }

    @Override
    public Savepoint Connection_setSavepoint(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        try {
            return filterChain.Connection_setSavepoint(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public Savepoint Connection_setSavepoint(FilterChain filterChain, DmdbConnection connection, String name) throws SQLException {
        try {
            return filterChain.Connection_setSavepoint(connection, name);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public void Connection_rollback(FilterChain filterChain, DmdbConnection connection, Savepoint savepoint) throws SQLException {
        try {
            filterChain.Connection_rollback(connection, savepoint);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public void Connection_releaseSavepoint(FilterChain filterChain, DmdbConnection connection, Savepoint savepoint) throws SQLException {
        try {
            filterChain.Connection_releaseSavepoint(connection, savepoint);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public Statement Connection_createStatement(FilterChain filterChain, DmdbConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return filterChain.Connection_createStatement(connection, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e2) {
            if (this.whenError(connection, e2)) {
                connection.do_createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            return null;
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return filterChain.Connection_prepareStatement(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e2) {
            if (this.whenError(connection, e2)) {
                connection.do_prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            return null;
        }
    }

    @Override
    public CallableStatement Connection_prepareCall(FilterChain filterChain, DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return filterChain.Connection_prepareCall(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e2) {
            if (this.whenError(connection, e2)) {
                connection.do_prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            return null;
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection connection, String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return filterChain.Connection_prepareStatement(connection, sql, autoGeneratedKeys);
        }
        catch (SQLException e2) {
            if (this.whenError(connection, e2)) {
                connection.do_prepareStatement(sql, autoGeneratedKeys);
            }
            return null;
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection connection, String sql, int[] columnIndexes) throws SQLException {
        try {
            return filterChain.Connection_prepareStatement(connection, sql, columnIndexes);
        }
        catch (SQLException e2) {
            if (this.whenError(connection, e2)) {
                connection.do_prepareStatement(sql, columnIndexes);
            }
            return null;
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection connection, String sql, String[] columnNames) throws SQLException {
        try {
            return filterChain.Connection_prepareStatement(connection, sql, columnNames);
        }
        catch (SQLException e2) {
            if (this.whenError(connection, e2)) {
                connection.do_prepareStatement(sql, columnNames);
            }
            return null;
        }
    }

    @Override
    public Clob Connection_createClob(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        try {
            return filterChain.Connection_createClob(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public Blob Connection_createBlob(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        try {
            return filterChain.Connection_createBlob(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public NClob Connection_createNClob(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        try {
            return filterChain.Connection_createNClob(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public SQLXML Connection_createSQLXML(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        try {
            return filterChain.Connection_createSQLXML(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public boolean Connection_isValid(FilterChain filterChain, DmdbConnection connection, int timeout) throws SQLException {
        try {
            return filterChain.Connection_isValid(connection, timeout);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return false;
        }
    }

    @Override
    public void Connection_setClientInfo(FilterChain filterChain, DmdbConnection connection, String name, String value) throws SQLClientInfoException {
        filterChain.Connection_setClientInfo(connection, name, value);
    }

    @Override
    public void Connection_setClientInfo(FilterChain filterChain, DmdbConnection connection, Properties properties) throws SQLClientInfoException {
        filterChain.Connection_setClientInfo(connection, properties);
    }

    @Override
    public String Connection_getClientInfo(FilterChain filterChain, DmdbConnection connection, String name) throws SQLException {
        try {
            return filterChain.Connection_getClientInfo(connection, name);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public Properties Connection_getClientInfo(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        try {
            return filterChain.Connection_getClientInfo(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public Array Connection_createArrayOf(FilterChain filterChain, DmdbConnection connection, String typeName, Object[] elements) throws SQLException {
        try {
            return filterChain.Connection_createArrayOf(connection, typeName, elements);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public Struct Connection_createStruct(FilterChain filterChain, DmdbConnection connection, String typeName, Object[] attributes) throws SQLException {
        try {
            return filterChain.Connection_createStruct(connection, typeName, attributes);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public void Connection_setSchema(FilterChain filterChain, DmdbConnection connection, String schema) throws SQLException {
        try {
            filterChain.Connection_setSchema(connection, schema);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public String Connection_getSchema(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        try {
            return filterChain.Connection_getSchema(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public void Connection_abort(FilterChain filterChain, DmdbConnection connection, Executor executor) throws SQLException {
        try {
            filterChain.Connection_abort(connection, executor);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public void Connection_setNetworkTimeout(FilterChain filterChain, DmdbConnection connection, Executor executor, int milliseconds) throws SQLException {
        try {
            filterChain.Connection_setNetworkTimeout(connection, executor, milliseconds);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public int Connection_getNetworkTimeout(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        try {
            return filterChain.Connection_getNetworkTimeout(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return 0;
        }
    }

    @Override
    public boolean DatabaseMetaData_allProceduresAreCallable(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_allProceduresAreCallable(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_allTablesAreSelectable(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_allTablesAreSelectable(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public String DatabaseMetaData_getURL(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getURL(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getUserName(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getUserName(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public boolean DatabaseMetaData_isReadOnly(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_isReadOnly(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedHigh(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_nullsAreSortedHigh(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedLow(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_nullsAreSortedLow(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedAtStart(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_nullsAreSortedAtStart(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedAtEnd(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_nullsAreSortedAtEnd(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public String DatabaseMetaData_getDatabaseProductName(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getDatabaseProductName(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getDatabaseProductVersion(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getDatabaseProductVersion(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getDriverName(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getDriverName(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getDriverVersion(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getDriverVersion(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public int DatabaseMetaData_getDriverMajorVersion(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) {
        return filterChain.DatabaseMetaData_getDriverMajorVersion(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getDriverMinorVersion(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) {
        return filterChain.DatabaseMetaData_getDriverMinorVersion(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_usesLocalFiles(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_usesLocalFiles(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_usesLocalFilePerTable(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_usesLocalFilePerTable(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMixedCaseIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsMixedCaseIdentifiers(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_storesUpperCaseIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_storesUpperCaseIdentifiers(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_storesLowerCaseIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_storesLowerCaseIdentifiers(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_storesMixedCaseIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_storesMixedCaseIdentifiers(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMixedCaseQuotedIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsMixedCaseIdentifiers(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_storesUpperCaseQuotedIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_storesUpperCaseQuotedIdentifiers(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_storesLowerCaseQuotedIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_storesLowerCaseQuotedIdentifiers(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_storesMixedCaseQuotedIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_storesMixedCaseQuotedIdentifiers(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public String DatabaseMetaData_getIdentifierQuoteString(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getIdentifierQuoteString(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getSQLKeywords(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getSQLKeywords(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getNumericFunctions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getNumericFunctions(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getStringFunctions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getStringFunctions(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getSystemFunctions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getSystemFunctions(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getTimeDateFunctions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getTimeDateFunctions(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getSearchStringEscape(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getSearchStringEscape(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getExtraNameCharacters(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getExtraNameCharacters(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsAlterTableWithAddColumn(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsAlterTableWithAddColumn(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsAlterTableWithDropColumn(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsAlterTableWithDropColumn(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsColumnAliasing(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsColumnAliasing(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_nullPlusNonNullIsNull(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_nullPlusNonNullIsNull(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsConvert(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsConvert(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsConvert(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int fromType, int toType) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsConvert(databaseMetaData, fromType, toType);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsTableCorrelationNames(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsTableCorrelationNames(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsDifferentTableCorrelationNames(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsDifferentTableCorrelationNames(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsExpressionsInOrderBy(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsExpressionsInOrderBy(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOrderByUnrelated(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsOrderByUnrelated(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupBy(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsGroupBy(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupByUnrelated(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsGroupByUnrelated(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupByBeyondSelect(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsGroupByBeyondSelect(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsLikeEscapeClause(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsLikeEscapeClause(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleResultSets(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsMultipleResultSets(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleTransactions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsMultipleTransactions(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsNonNullableColumns(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsNonNullableColumns(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMinimumSQLGrammar(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsMinimumSQLGrammar(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCoreSQLGrammar(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsCoreSQLGrammar(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsExtendedSQLGrammar(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsExtendedSQLGrammar(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92EntryLevelSQL(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsANSI92EntryLevelSQL(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92IntermediateSQL(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsANSI92IntermediateSQL(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92FullSQL(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsANSI92FullSQL(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsIntegrityEnhancementFacility(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsIntegrityEnhancementFacility(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOuterJoins(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsOuterJoins(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsFullOuterJoins(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsFullOuterJoins(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsLimitedOuterJoins(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsLimitedOuterJoins(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public String DatabaseMetaData_getSchemaTerm(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getSchemaTerm(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getProcedureTerm(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getProcedureTerm(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getCatalogTerm(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getCatalogTerm(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public boolean DatabaseMetaData_isCatalogAtStart(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_isCatalogAtStart(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public String DatabaseMetaData_getCatalogSeparator(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getCatalogSeparator(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInDataManipulation(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsSchemasInDataManipulation(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInProcedureCalls(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsSchemasInProcedureCalls(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInTableDefinitions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsSchemasInTableDefinitions(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInIndexDefinitions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsSchemasInIndexDefinitions(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInPrivilegeDefinitions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsSchemasInPrivilegeDefinitions(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInDataManipulation(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsCatalogsInDataManipulation(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInProcedureCalls(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsCatalogsInProcedureCalls(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInTableDefinitions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsCatalogsInTableDefinitions(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInIndexDefinitions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsCatalogsInIndexDefinitions(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInPrivilegeDefinitions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsCatalogsInPrivilegeDefinitions(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsPositionedDelete(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsPositionedDelete(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsPositionedUpdate(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsPositionedUpdate(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSelectForUpdate(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsSelectForUpdate(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsStoredProcedures(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsStoredProcedures(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInComparisons(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsSubqueriesInComparisons(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInExists(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsSubqueriesInExists(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInIns(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsSubqueriesInIns(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInQuantifieds(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsSubqueriesInQuantifieds(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCorrelatedSubqueries(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsCorrelatedSubqueries(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsUnion(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsUnion(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsUnionAll(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsUnionAll(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenCursorsAcrossCommit(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsOpenCursorsAcrossCommit(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenCursorsAcrossRollback(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsOpenCursorsAcrossRollback(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenStatementsAcrossCommit(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsOpenStatementsAcrossCommit(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenStatementsAcrossRollback(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsOpenStatementsAcrossRollback(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxBinaryLiteralLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getMaxBinaryLiteralLength(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxCharLiteralLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getMaxCharLiteralLength(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnNameLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getMaxColumnNameLength(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInGroupBy(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getMaxColumnsInGroupBy(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInIndex(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getMaxColumnsInIndex(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInOrderBy(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getMaxColumnsInOrderBy(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInSelect(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getMaxColumnsInSelect(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInTable(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getMaxColumnsInTable(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxConnections(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getMaxConnections(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxCursorNameLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getMaxCursorNameLength(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxIndexLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getMaxIndexLength(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxSchemaNameLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getMaxSchemaNameLength(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxProcedureNameLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getMaxProcedureNameLength(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxCatalogNameLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getMaxCatalogNameLength(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxRowSize(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getMaxRowSize(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public boolean DatabaseMetaData_doesMaxRowSizeIncludeBlobs(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_doesMaxRowSizeIncludeBlobs(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxStatementLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getMaxStatementLength(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxStatements(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getMaxStatements(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxTableNameLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getMaxTableNameLength(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxTablesInSelect(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getMaxTablesInSelect(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxUserNameLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getMaxUserNameLength(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getDefaultTransactionIsolation(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getDefaultTransactionIsolation(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsTransactions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsTransactions(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsTransactionIsolationLevel(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int level) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsTransactionIsolationLevel(databaseMetaData, level);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsDataDefinitionAndDataManipulationTransactions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsDataDefinitionAndDataManipulationTransactions(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsDataManipulationTransactionsOnly(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsDataManipulationTransactionsOnly(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_dataDefinitionCausesTransactionCommit(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_dataDefinitionCausesTransactionCommit(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_dataDefinitionIgnoredInTransactions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_dataDefinitionIgnoredInTransactions(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getProcedures(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getProcedures(databaseMetaData, catalog, schemaPattern, procedureNamePattern);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getProcedureColumns(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getProcedureColumns(databaseMetaData, catalog, schemaPattern, procedureNamePattern, columnNamePattern);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getTables(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getTables(databaseMetaData, catalog, schemaPattern, tableNamePattern, types);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getSchemas(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getSchemas(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getCatalogs(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getCatalogs(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getTableTypes(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getTableTypes(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getColumns(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getColumns(databaseMetaData, catalog, schemaPattern, tableNamePattern, columnNamePattern);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getColumnPrivileges(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getColumnPrivileges(databaseMetaData, catalog, schema, table, columnNamePattern);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getTablePrivileges(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getTablePrivileges(databaseMetaData, catalog, schemaPattern, tableNamePattern);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getBestRowIdentifier(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getBestRowIdentifier(databaseMetaData, catalog, schema, table, scope, nullable);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getVersionColumns(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getVersionColumns(databaseMetaData, catalog, schema, table);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getPrimaryKeys(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getPrimaryKeys(databaseMetaData, catalog, schema, table);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getImportedKeys(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getImportedKeys(databaseMetaData, catalog, schema, table);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getExportedKeys(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getExportedKeys(databaseMetaData, catalog, schema, table);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getCrossReference(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getCrossReference(databaseMetaData, parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getTypeInfo(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getTypeInfo(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getIndexInfo(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getIndexInfo(databaseMetaData, catalog, schema, table, unique, approximate);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetType(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsResultSetType(databaseMetaData, type);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetConcurrency(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type, int concurrency) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsResultSetConcurrency(databaseMetaData, type, concurrency);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_ownUpdatesAreVisible(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_ownUpdatesAreVisible(databaseMetaData, type);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_ownDeletesAreVisible(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_ownDeletesAreVisible(databaseMetaData, type);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_ownInsertsAreVisible(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_ownInsertsAreVisible(databaseMetaData, type);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_othersUpdatesAreVisible(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_othersUpdatesAreVisible(databaseMetaData, type);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_othersDeletesAreVisible(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_othersDeletesAreVisible(databaseMetaData, type);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_othersInsertsAreVisible(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_othersInsertsAreVisible(databaseMetaData, type);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_updatesAreDetected(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_updatesAreDetected(databaseMetaData, type);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_deletesAreDetected(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_deletesAreDetected(databaseMetaData, type);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_insertsAreDetected(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_insertsAreDetected(databaseMetaData, type);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsBatchUpdates(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsBatchUpdates(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getUDTs(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getUDTs(databaseMetaData, catalog, schemaPattern, typeNamePattern, types);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public Connection DatabaseMetaData_getConnection(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getConnection(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSavepoints(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsSavepoints(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsNamedParameters(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsNamedParameters(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleOpenResults(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsMultipleOpenResults(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsGetGeneratedKeys(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsGetGeneratedKeys(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getSuperTypes(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getSuperTypes(databaseMetaData, catalog, schemaPattern, typeNamePattern);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getSuperTables(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getSuperTables(databaseMetaData, catalog, schemaPattern, tableNamePattern);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getAttributes(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getAttributes(databaseMetaData, catalog, schemaPattern, typeNamePattern, attributeNamePattern);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetHoldability(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int holdability) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsResultSetHoldability(databaseMetaData, holdability);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public int DatabaseMetaData_getResultSetHoldability(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getResultSetHoldability(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getDatabaseMajorVersion(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getDatabaseMajorVersion(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getDatabaseMinorVersion(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getDatabaseMinorVersion(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getJDBCMajorVersion(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getJDBCMajorVersion(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getJDBCMinorVersion(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getJDBCMinorVersion(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getSQLStateType(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getSQLStateType(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public boolean DatabaseMetaData_locatorsUpdateCopy(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_locatorsUpdateCopy(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsStatementPooling(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsStatementPooling(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public RowIdLifetime DatabaseMetaData_getRowIdLifetime(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getRowIdLifetime(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getSchemas(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getSchemas(databaseMetaData, catalog, schemaPattern);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsStoredFunctionsUsingCallSyntax(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsStoredFunctionsUsingCallSyntax(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_autoCommitFailureClosesAllResultSets(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_autoCommitFailureClosesAllResultSets(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getClientInfoProperties(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getClientInfoProperties(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getFunctions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getFunctions(databaseMetaData, catalog, schemaPattern, functionNamePattern);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getFunctionColumns(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getFunctionColumns(databaseMetaData, catalog, schemaPattern, functionNamePattern, columnNamePattern);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getPseudoColumns(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getPseudoColumns(databaseMetaData, catalog, schemaPattern, tableNamePattern, columnNamePattern);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public boolean DatabaseMetaData_generatedKeyAlwaysReturned(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_generatedKeyAlwaysReturned(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public long DatabaseMetaData_getMaxLogicalLobSize(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_getMaxLogicalLobSize(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0L;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsRefCursors(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return filterChain.DatabaseMetaData_supportsRefCursors(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public Connection Driver_connect(FilterChain filterChain, DmDriver driver, DmProperties props) throws SQLException {
        Connection conn = filterChain.Driver_connect(driver, props);
        this.addConnection((DmdbConnection)conn);
        return conn;
    }

    @Override
    public int ParameterMetaData_getParameterCount(FilterChain filterChain, DmdbParameterMetaData parameterMetaData) throws SQLException {
        try {
            return filterChain.ParameterMetaData_getParameterCount(parameterMetaData);
        }
        catch (SQLException e2) {
            this.whenError(parameterMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int ParameterMetaData_isNullable(FilterChain filterChain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        try {
            return filterChain.ParameterMetaData_isNullable(parameterMetaData, param);
        }
        catch (SQLException e2) {
            this.whenError(parameterMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public boolean ParameterMetaData_isSigned(FilterChain filterChain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        try {
            return filterChain.ParameterMetaData_isSigned(parameterMetaData, param);
        }
        catch (SQLException e2) {
            this.whenError(parameterMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public int ParameterMetaData_getPrecision(FilterChain filterChain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        try {
            return filterChain.ParameterMetaData_getPrecision(parameterMetaData, param);
        }
        catch (SQLException e2) {
            this.whenError(parameterMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int ParameterMetaData_getScale(FilterChain filterChain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        try {
            return filterChain.ParameterMetaData_getScale(parameterMetaData, param);
        }
        catch (SQLException e2) {
            this.whenError(parameterMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int ParameterMetaData_getParameterType(FilterChain filterChain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        try {
            return filterChain.ParameterMetaData_getParameterType(parameterMetaData, param);
        }
        catch (SQLException e2) {
            this.whenError(parameterMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public String ParameterMetaData_getParameterTypeName(FilterChain filterChain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        try {
            return filterChain.ParameterMetaData_getParameterTypeName(parameterMetaData, param);
        }
        catch (SQLException e2) {
            this.whenError(parameterMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String ParameterMetaData_getParameterClassName(FilterChain filterChain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        try {
            return filterChain.ParameterMetaData_getParameterClassName(parameterMetaData, param);
        }
        catch (SQLException e2) {
            this.whenError(parameterMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public int ParameterMetaData_getParameterMode(FilterChain filterChain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        try {
            return filterChain.ParameterMetaData_getParameterMode(parameterMetaData, param);
        }
        catch (SQLException e2) {
            this.whenError(parameterMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public ResultSet PreparedStatement_executeQuery(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            this.beforeExecute(preparedStatement.connection);
            return filterChain.PreparedStatement_executeQuery(preparedStatement);
        }
        catch (SQLException e2) {
            if (this.whenError(preparedStatement.connection, e2)) {
                return preparedStatement.do_executeQuery();
            }
            return null;
        }
    }

    @Override
    public int PreparedStatement_executeUpdate(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            this.beforeExecute(preparedStatement.connection);
            return filterChain.PreparedStatement_executeUpdate(preparedStatement);
        }
        catch (SQLException e2) {
            if (this.whenError(preparedStatement.connection, e2)) {
                return preparedStatement.do_executeUpdate();
            }
            return 0;
        }
    }

    @Override
    public int[] PreparedStatement_executeBatch(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            this.beforeExecute(preparedStatement.connection);
            preparedStatement.clearBatch = false;
            int[] nArray = filterChain.PreparedStatement_executeBatch(preparedStatement);
            return nArray;
        }
        catch (SQLException e2) {
            if (this.whenError(preparedStatement.connection, e2)) {
                int[] nArray = preparedStatement.do_executeBatch();
                return nArray;
            }
            return null;
        }
        finally {
            preparedStatement.clearBatch = true;
            preparedStatement.do_clearBatch();
        }
    }

    @Override
    public long[] PreparedStatement_executeLargeBatch(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            this.beforeExecute(preparedStatement.connection);
            preparedStatement.clearBatch = false;
            long[] lArray = filterChain.PreparedStatement_executeLargeBatch(preparedStatement);
            return lArray;
        }
        catch (SQLException e2) {
            if (this.whenError(preparedStatement.connection, e2)) {
                long[] lArray = preparedStatement.do_executeLargeBatch();
                return lArray;
            }
            return null;
        }
        finally {
            preparedStatement.clearBatch = true;
            preparedStatement.do_clearBatch();
        }
    }

    @Override
    public void PreparedStatement_setNull(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, int sqlType) throws SQLException {
        try {
            filterChain.PreparedStatement_setNull(preparedStatement, parameterIndex, sqlType);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setBoolean(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, boolean x2) throws SQLException {
        try {
            filterChain.PreparedStatement_setBoolean(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setByte(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, byte x2) throws SQLException {
        try {
            filterChain.PreparedStatement_setByte(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setShort(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, short x2) throws SQLException {
        try {
            filterChain.PreparedStatement_setShort(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setInt(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, int x2) throws SQLException {
        try {
            filterChain.PreparedStatement_setInt(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setLong(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, long x2) throws SQLException {
        try {
            filterChain.PreparedStatement_setLong(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setFloat(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, float x2) throws SQLException {
        try {
            filterChain.PreparedStatement_setFloat(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setDouble(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, double x2) throws SQLException {
        try {
            filterChain.PreparedStatement_setDouble(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setBigDecimal(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, BigDecimal x2) throws SQLException {
        try {
            filterChain.PreparedStatement_setBigDecimal(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setString(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, String x2) throws SQLException {
        try {
            filterChain.PreparedStatement_setString(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setBytes(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, byte[] x2) throws SQLException {
        try {
            filterChain.PreparedStatement_setBytes(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setDate(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Date x2) throws SQLException {
        try {
            filterChain.PreparedStatement_setDate(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setTime(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Time x2) throws SQLException {
        try {
            filterChain.PreparedStatement_setTime(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setTimestamp(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Timestamp x2) throws SQLException {
        try {
            filterChain.PreparedStatement_setTimestamp(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setAsciiStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        try {
            filterChain.PreparedStatement_setAsciiStream(preparedStatement, parameterIndex, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setUnicodeStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        try {
            filterChain.PreparedStatement_setUnicodeStream(preparedStatement, parameterIndex, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setBinaryStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        try {
            filterChain.PreparedStatement_setBinaryStream(preparedStatement, parameterIndex, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_clearParameters(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            filterChain.PreparedStatement_clearParameters(preparedStatement);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, int targetSqlType) throws SQLException {
        try {
            filterChain.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, targetSqlType);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2) throws SQLException {
        try {
            filterChain.PreparedStatement_setObject(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public boolean PreparedStatement_execute(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            this.beforeExecute(preparedStatement.connection);
            return filterChain.PreparedStatement_execute(preparedStatement);
        }
        catch (SQLException e2) {
            if (this.whenError(preparedStatement.connection, e2)) {
                return preparedStatement.do_execute();
            }
            return false;
        }
    }

    @Override
    public void PreparedStatement_addBatch(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            filterChain.PreparedStatement_addBatch(preparedStatement);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setCharacterStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, int length) throws SQLException {
        try {
            filterChain.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setRef(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Ref x2) throws SQLException {
        try {
            filterChain.PreparedStatement_setRef(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setBlob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Blob x2) throws SQLException {
        try {
            filterChain.PreparedStatement_setBlob(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setClob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Clob x2) throws SQLException {
        try {
            filterChain.PreparedStatement_setClob(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setArray(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Array x2) throws SQLException {
        try {
            filterChain.PreparedStatement_setArray(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public ResultSetMetaData PreparedStatement_getMetaData(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            return filterChain.PreparedStatement_getMetaData(preparedStatement);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
            return null;
        }
    }

    @Override
    public void PreparedStatement_setDate(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Date x2, Calendar cal) throws SQLException {
        try {
            filterChain.PreparedStatement_setDate(preparedStatement, parameterIndex, x2, cal);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setTime(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Time x2, Calendar cal) throws SQLException {
        try {
            filterChain.PreparedStatement_setTime(preparedStatement, parameterIndex, x2, cal);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setTimestamp(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Timestamp x2, Calendar cal) throws SQLException {
        try {
            filterChain.PreparedStatement_setTimestamp(preparedStatement, parameterIndex, x2, cal);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setNull(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, int sqlType, String typeName) throws SQLException {
        try {
            filterChain.PreparedStatement_setNull(preparedStatement, parameterIndex, sqlType, typeName);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setURL(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, URL x2) throws SQLException {
        try {
            filterChain.PreparedStatement_setURL(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public ParameterMetaData PreparedStatement_getParameterMetaData(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            return filterChain.PreparedStatement_getParameterMetaData(preparedStatement);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
            return null;
        }
    }

    @Override
    public void PreparedStatement_setRowId(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, RowId x2) throws SQLException {
        try {
            filterChain.PreparedStatement_setRowId(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setNString(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, String value) throws SQLException {
        try {
            filterChain.PreparedStatement_setNString(preparedStatement, parameterIndex, value);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setNCharacterStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader value, long length) throws SQLException {
        try {
            filterChain.PreparedStatement_setNCharacterStream(preparedStatement, parameterIndex, value, length);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setNClob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, NClob value) throws SQLException {
        try {
            filterChain.PreparedStatement_setNClob(preparedStatement, parameterIndex, value);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setClob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        try {
            filterChain.PreparedStatement_setClob(preparedStatement, parameterIndex, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setBlob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream inputStream, long length) throws SQLException {
        try {
            filterChain.PreparedStatement_setBlob(preparedStatement, parameterIndex, inputStream, length);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setNClob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        try {
            filterChain.PreparedStatement_setNClob(preparedStatement, parameterIndex, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setSQLXML(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, SQLXML xmlObject) throws SQLException {
        try {
            filterChain.PreparedStatement_setSQLXML(preparedStatement, parameterIndex, xmlObject);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, int targetSqlType, int scaleOrLength) throws SQLException {
        try {
            filterChain.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, targetSqlType, scaleOrLength);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setAsciiStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, long length) throws SQLException {
        try {
            filterChain.PreparedStatement_setAsciiStream(preparedStatement, parameterIndex, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setBinaryStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, long length) throws SQLException {
        try {
            filterChain.PreparedStatement_setBinaryStream(preparedStatement, parameterIndex, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setCharacterStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        try {
            filterChain.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setAsciiStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2) throws SQLException {
        try {
            filterChain.PreparedStatement_setAsciiStream(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setBinaryStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2) throws SQLException {
        try {
            filterChain.PreparedStatement_setBinaryStream(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setCharacterStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        try {
            filterChain.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, reader);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setNCharacterStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader value) throws SQLException {
        try {
            filterChain.PreparedStatement_setNCharacterStream(preparedStatement, parameterIndex, value);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setClob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        try {
            filterChain.PreparedStatement_setClob(preparedStatement, parameterIndex, reader);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setBlob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream inputStream) throws SQLException {
        try {
            filterChain.PreparedStatement_setBlob(preparedStatement, parameterIndex, inputStream);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setNClob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        try {
            filterChain.PreparedStatement_setNClob(preparedStatement, parameterIndex, reader);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        try {
            filterChain.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, targetSqlType, scaleOrLength);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, SQLType targetSqlType) throws SQLException {
        try {
            filterChain.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, targetSqlType);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public long PreparedStatement_executeLargeUpdate(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            this.beforeExecute(preparedStatement.connection);
            return filterChain.PreparedStatement_executeLargeUpdate(preparedStatement);
        }
        catch (SQLException e2) {
            if (this.whenError(preparedStatement.connection, e2)) {
                return preparedStatement.do_executeLargeUpdate();
            }
            return 0L;
        }
    }

    @Override
    public void PreparedStatement_preCompile(FilterChain filterChain, DmdbPreparedStatement preparedStatement, String sql) throws SQLException {
        try {
            filterChain.PreparedStatement_preCompile(preparedStatement, sql);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setTIMESTAMP(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, DmdbTimestamp x2) throws SQLException {
        try {
            filterChain.PreparedStatement_setTIMESTAMP(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setINTERVALYM(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, DmdbIntervalYM x2) throws SQLException {
        try {
            filterChain.PreparedStatement_setINTERVALYM(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setINTERVALDT(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, DmdbIntervalDT x2) throws SQLException {
        try {
            filterChain.PreparedStatement_setINTERVALDT(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public boolean ResultSet_next(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            return filterChain.ResultSet_next(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public void ResultSet_close(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            filterChain.ResultSet_close(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public boolean ResultSet_wasNull(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            return filterChain.ResultSet_wasNull(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public String ResultSet_getString(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return filterChain.ResultSet_getString(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public boolean ResultSet_getBoolean(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return filterChain.ResultSet_getBoolean(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public byte ResultSet_getByte(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return filterChain.ResultSet_getByte(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0;
        }
    }

    @Override
    public short ResultSet_getShort(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return filterChain.ResultSet_getShort(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0;
        }
    }

    @Override
    public int ResultSet_getInt(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return filterChain.ResultSet_getInt(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0;
        }
    }

    @Override
    public long ResultSet_getLong(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return filterChain.ResultSet_getLong(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0L;
        }
    }

    @Override
    public float ResultSet_getFloat(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return filterChain.ResultSet_getFloat(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0.0f;
        }
    }

    @Override
    public double ResultSet_getDouble(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return filterChain.ResultSet_getDouble(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0.0;
        }
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, int scale) throws SQLException {
        try {
            return filterChain.ResultSet_getBigDecimal(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public byte[] ResultSet_getBytes(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return filterChain.ResultSet_getBytes(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Date ResultSet_getDate(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return filterChain.ResultSet_getDate(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Time ResultSet_getTime(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return filterChain.ResultSet_getTime(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Timestamp ResultSet_getTimestamp(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return filterChain.ResultSet_getTimestamp(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public InputStream ResultSet_getAsciiStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return filterChain.ResultSet_getAsciiStream(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public InputStream ResultSet_getUnicodeStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return filterChain.ResultSet_getUnicodeStream(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public InputStream ResultSet_getBinaryStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return filterChain.ResultSet_getBinaryStream(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public String ResultSet_getString(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return filterChain.ResultSet_getString(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public boolean ResultSet_getBoolean(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return filterChain.ResultSet_getBoolean(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public byte ResultSet_getByte(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return filterChain.ResultSet_getByte(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0;
        }
    }

    @Override
    public short ResultSet_getShort(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return filterChain.ResultSet_getShort(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0;
        }
    }

    @Override
    public int ResultSet_getInt(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return filterChain.ResultSet_getInt(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0;
        }
    }

    @Override
    public long ResultSet_getLong(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return filterChain.ResultSet_getLong(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0L;
        }
    }

    @Override
    public float ResultSet_getFloat(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return filterChain.ResultSet_getFloat(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0.0f;
        }
    }

    @Override
    public double ResultSet_getDouble(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return filterChain.ResultSet_getDouble(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0.0;
        }
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, int scale) throws SQLException {
        try {
            return filterChain.ResultSet_getBigDecimal(resultSet, columnLabel, scale);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public byte[] ResultSet_getBytes(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return filterChain.ResultSet_getBytes(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Date ResultSet_getDate(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return filterChain.ResultSet_getDate(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Time ResultSet_getTime(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return filterChain.ResultSet_getTime(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Timestamp ResultSet_getTimestamp(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return filterChain.ResultSet_getTimestamp(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public InputStream ResultSet_getAsciiStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return filterChain.ResultSet_getAsciiStream(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public InputStream ResultSet_getUnicodeStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return filterChain.ResultSet_getUnicodeStream(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public InputStream ResultSet_getBinaryStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return filterChain.ResultSet_getBinaryStream(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public SQLWarning ResultSet_getWarnings(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            return filterChain.ResultSet_getWarnings(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public void ResultSet_clearWarnings(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            filterChain.ResultSet_clearWarnings(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public String ResultSet_getCursorName(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            return filterChain.ResultSet_getCursorName(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSetMetaData ResultSet_getMetaData(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            return filterChain.ResultSet_getMetaData(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Object ResultSet_getObject(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return filterChain.ResultSet_getObject(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Object ResultSet_getObject(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return filterChain.ResultSet_getObject(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public int ResultSet_findColumn(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return filterChain.ResultSet_findColumn(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0;
        }
    }

    @Override
    public Reader ResultSet_getCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return filterChain.ResultSet_getCharacterStream(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Reader ResultSet_getCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return filterChain.ResultSet_getCharacterStream(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return filterChain.ResultSet_getBigDecimal(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return filterChain.ResultSet_getBigDecimal(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public boolean ResultSet_isBeforeFirst(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            return filterChain.ResultSet_isBeforeFirst(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public boolean ResultSet_isAfterLast(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            return filterChain.ResultSet_isAfterLast(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public boolean ResultSet_isFirst(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            return filterChain.ResultSet_isFirst(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public boolean ResultSet_isLast(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            return filterChain.ResultSet_isLast(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public void ResultSet_beforeFirst(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            filterChain.ResultSet_beforeFirst(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_afterLast(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            filterChain.ResultSet_afterLast(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public boolean ResultSet_first(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            return filterChain.ResultSet_first(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public boolean ResultSet_last(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            return filterChain.ResultSet_last(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public int ResultSet_getRow(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            return filterChain.ResultSet_getRow(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0;
        }
    }

    @Override
    public boolean ResultSet_absolute(FilterChain filterChain, DmdbResultSet resultSet, int row) throws SQLException {
        try {
            return filterChain.ResultSet_absolute(resultSet, row);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public boolean ResultSet_relative(FilterChain filterChain, DmdbResultSet resultSet, int rows) throws SQLException {
        try {
            return filterChain.ResultSet_relative(resultSet, rows);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public boolean ResultSet_previous(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            return filterChain.ResultSet_previous(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public void ResultSet_setFetchDirection(FilterChain filterChain, DmdbResultSet resultSet, int direction) throws SQLException {
        try {
            filterChain.ResultSet_setFetchDirection(resultSet, direction);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public int ResultSet_getFetchDirection(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            return filterChain.ResultSet_getFetchDirection(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0;
        }
    }

    @Override
    public void ResultSet_setFetchSize(FilterChain filterChain, DmdbResultSet resultSet, int rows) throws SQLException {
        try {
            filterChain.ResultSet_setFetchSize(resultSet, rows);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public int ResultSet_getFetchSize(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            return filterChain.ResultSet_getFetchSize(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0;
        }
    }

    @Override
    public int ResultSet_getType(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            return filterChain.ResultSet_getType(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0;
        }
    }

    @Override
    public int ResultSet_getConcurrency(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            return filterChain.ResultSet_getConcurrency(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0;
        }
    }

    @Override
    public boolean ResultSet_rowUpdated(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            return filterChain.ResultSet_rowUpdated(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public boolean ResultSet_rowInserted(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            return filterChain.ResultSet_rowInserted(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public boolean ResultSet_rowDeleted(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            return filterChain.ResultSet_rowDeleted(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public void ResultSet_updateNull(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            filterChain.ResultSet_updateNull(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBoolean(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, boolean x2) throws SQLException {
        try {
            filterChain.ResultSet_updateBoolean(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateByte(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, byte x2) throws SQLException {
        try {
            filterChain.ResultSet_updateByte(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateShort(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, short x2) throws SQLException {
        try {
            filterChain.ResultSet_updateShort(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateInt(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, int x2) throws SQLException {
        try {
            filterChain.ResultSet_updateInt(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateLong(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, long x2) throws SQLException {
        try {
            filterChain.ResultSet_updateLong(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateFloat(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, float x2) throws SQLException {
        try {
            filterChain.ResultSet_updateFloat(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateDouble(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, double x2) throws SQLException {
        try {
            filterChain.ResultSet_updateDouble(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBigDecimal(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, BigDecimal x2) throws SQLException {
        try {
            filterChain.ResultSet_updateBigDecimal(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateString(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, String x2) throws SQLException {
        try {
            filterChain.ResultSet_updateString(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBytes(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, byte[] x2) throws SQLException {
        try {
            filterChain.ResultSet_updateBytes(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateDate(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Date x2) throws SQLException {
        try {
            filterChain.ResultSet_updateDate(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateTime(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Time x2) throws SQLException {
        try {
            filterChain.ResultSet_updateTime(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateTimestamp(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Timestamp x2) throws SQLException {
        try {
            filterChain.ResultSet_updateTimestamp(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, InputStream x2, int length) throws SQLException {
        try {
            filterChain.ResultSet_updateAsciiStream(resultSet, columnIndex, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, InputStream x2, int length) throws SQLException {
        try {
            filterChain.ResultSet_updateBinaryStream(resultSet, columnIndex, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Reader x2, int length) throws SQLException {
        try {
            filterChain.ResultSet_updateCharacterStream(resultSet, columnIndex, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Object x2, int scaleOrLength) throws SQLException {
        try {
            filterChain.ResultSet_updateObject(resultSet, columnIndex, x2, scaleOrLength);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Object x2) throws SQLException {
        try {
            filterChain.ResultSet_updateObject(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateNull(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            filterChain.ResultSet_updateNull(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBoolean(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, boolean x2) throws SQLException {
        try {
            filterChain.ResultSet_updateBoolean(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateByte(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, byte x2) throws SQLException {
        try {
            filterChain.ResultSet_updateByte(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateShort(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, short x2) throws SQLException {
        try {
            filterChain.ResultSet_updateShort(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateInt(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, int x2) throws SQLException {
        try {
            filterChain.ResultSet_updateInt(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateLong(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, long x2) throws SQLException {
        try {
            filterChain.ResultSet_updateLong(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateFloat(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, float x2) throws SQLException {
        try {
            filterChain.ResultSet_updateFloat(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateDouble(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, double x2) throws SQLException {
        try {
            filterChain.ResultSet_updateDouble(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBigDecimal(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, BigDecimal x2) throws SQLException {
        try {
            filterChain.ResultSet_updateBigDecimal(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateString(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, String x2) throws SQLException {
        try {
            filterChain.ResultSet_updateString(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBytes(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, byte[] x2) throws SQLException {
        try {
            filterChain.ResultSet_updateBytes(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateDate(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Date x2) throws SQLException {
        try {
            filterChain.ResultSet_updateDate(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateTime(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Time x2) throws SQLException {
        try {
            filterChain.ResultSet_updateTime(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateTimestamp(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Timestamp x2) throws SQLException {
        try {
            filterChain.ResultSet_updateTimestamp(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, InputStream x2, int length) throws SQLException {
        try {
            filterChain.ResultSet_updateAsciiStream(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, InputStream x2, int length) throws SQLException {
        try {
            filterChain.ResultSet_updateBinaryStream(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Reader reader, int length) throws SQLException {
        try {
            filterChain.ResultSet_updateCharacterStream(resultSet, columnLabel, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Object x2, int scaleOrLength) throws SQLException {
        try {
            filterChain.ResultSet_updateObject(resultSet, columnLabel, x2, scaleOrLength);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Object x2) throws SQLException {
        try {
            filterChain.ResultSet_updateObject(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_insertRow(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            filterChain.ResultSet_insertRow(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateRow(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            filterChain.ResultSet_updateRow(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_deleteRow(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            filterChain.ResultSet_deleteRow(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_refreshRow(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            filterChain.ResultSet_refreshRow(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_cancelRowUpdates(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            filterChain.ResultSet_cancelRowUpdates(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_moveToInsertRow(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            filterChain.ResultSet_moveToInsertRow(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_moveToCurrentRow(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            filterChain.ResultSet_moveToCurrentRow(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public Statement ResultSet_getStatement(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            return filterChain.ResultSet_getStatement(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Object ResultSet_getObject(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Map<String, Class<?>> map) throws SQLException {
        try {
            return filterChain.ResultSet_getObject(resultSet, columnIndex, map);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Ref ResultSet_getRef(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return filterChain.ResultSet_getRef(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Blob ResultSet_getBlob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return filterChain.ResultSet_getBlob(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Clob ResultSet_getClob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return filterChain.ResultSet_getClob(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Array ResultSet_getArray(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return filterChain.ResultSet_getArray(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Object ResultSet_getObject(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Map<String, Class<?>> map) throws SQLException {
        try {
            return filterChain.ResultSet_getObject(resultSet, columnLabel, map);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Ref ResultSet_getRef(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return filterChain.ResultSet_getRef(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Blob ResultSet_getBlob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return filterChain.ResultSet_getBlob(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Clob ResultSet_getClob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return filterChain.ResultSet_getClob(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Array ResultSet_getArray(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return filterChain.ResultSet_getArray(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Date ResultSet_getDate(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        try {
            return filterChain.ResultSet_getDate(resultSet, columnIndex, cal);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Date ResultSet_getDate(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        try {
            return filterChain.ResultSet_getDate(resultSet, columnLabel, cal);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Time ResultSet_getTime(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        try {
            return filterChain.ResultSet_getTime(resultSet, columnIndex, cal);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Time ResultSet_getTime(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        try {
            return filterChain.ResultSet_getTime(resultSet, columnLabel, cal);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Timestamp ResultSet_getTimestamp(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        try {
            return filterChain.ResultSet_getTimestamp(resultSet, columnIndex, cal);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Timestamp ResultSet_getTimestamp(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        try {
            return filterChain.ResultSet_getTimestamp(resultSet, columnLabel, cal);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public URL ResultSet_getURL(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return filterChain.ResultSet_getURL(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public URL ResultSet_getURL(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return filterChain.ResultSet_getURL(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public void ResultSet_updateRef(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Ref x2) throws SQLException {
        try {
            filterChain.ResultSet_updateRef(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateRef(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Ref x2) throws SQLException {
        try {
            filterChain.ResultSet_updateRef(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBlob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Blob x2) throws SQLException {
        try {
            filterChain.ResultSet_updateBlob(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBlob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Blob x2) throws SQLException {
        try {
            filterChain.ResultSet_updateBlob(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateClob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Clob x2) throws SQLException {
        try {
            filterChain.ResultSet_updateClob(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateClob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Clob x2) throws SQLException {
        try {
            filterChain.ResultSet_updateClob(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateArray(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Array x2) throws SQLException {
        try {
            filterChain.ResultSet_updateArray(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateArray(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Array x2) throws SQLException {
        try {
            filterChain.ResultSet_updateArray(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public RowId ResultSet_getRowId(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return filterChain.ResultSet_getRowId(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public RowId ResultSet_getRowId(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return filterChain.ResultSet_getRowId(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public void ResultSet_updateRowId(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, RowId x2) throws SQLException {
        try {
            filterChain.ResultSet_updateRowId(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateRowId(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, RowId x2) throws SQLException {
        try {
            filterChain.ResultSet_updateRowId(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public int ResultSet_getHoldability(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            return filterChain.ResultSet_getHoldability(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0;
        }
    }

    @Override
    public boolean ResultSet_isClosed(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        try {
            return filterChain.ResultSet_isClosed(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public void ResultSet_updateNString(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, String nString) throws SQLException {
        try {
            filterChain.ResultSet_updateNString(resultSet, columnIndex, nString);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateNString(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, String nString) throws SQLException {
        try {
            filterChain.ResultSet_updateNString(resultSet, columnLabel, nString);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateNClob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, NClob nClob) throws SQLException {
        try {
            filterChain.ResultSet_updateNClob(resultSet, columnIndex, nClob);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateNClob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, NClob nClob) throws SQLException {
        try {
            filterChain.ResultSet_updateNClob(resultSet, columnLabel, nClob);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public NClob ResultSet_getNClob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return filterChain.ResultSet_getNClob(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public NClob ResultSet_getNClob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return filterChain.ResultSet_getNClob(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public SQLXML ResultSet_getSQLXML(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return filterChain.ResultSet_getSQLXML(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public SQLXML ResultSet_getSQLXML(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return filterChain.ResultSet_getSQLXML(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public void ResultSet_updateSQLXML(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, SQLXML xmlObject) throws SQLException {
        try {
            filterChain.ResultSet_updateSQLXML(resultSet, columnIndex, xmlObject);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateSQLXML(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, SQLXML xmlObject) throws SQLException {
        try {
            filterChain.ResultSet_updateSQLXML(resultSet, columnLabel, xmlObject);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public String ResultSet_getNString(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return filterChain.ResultSet_getNString(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public String ResultSet_getNString(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return filterChain.ResultSet_getNString(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Reader ResultSet_getNCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return filterChain.ResultSet_getNCharacterStream(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Reader ResultSet_getNCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return filterChain.ResultSet_getNCharacterStream(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public void ResultSet_updateNCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Reader x2, long length) throws SQLException {
        try {
            filterChain.ResultSet_updateNCharacterStream(resultSet, columnIndex, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateNCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        try {
            filterChain.ResultSet_updateNCharacterStream(resultSet, columnLabel, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, InputStream x2, long length) throws SQLException {
        try {
            filterChain.ResultSet_updateAsciiStream(resultSet, columnIndex, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, InputStream x2, long length) throws SQLException {
        try {
            filterChain.ResultSet_updateBinaryStream(resultSet, columnIndex, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Reader x2, long length) throws SQLException {
        try {
            filterChain.ResultSet_updateCharacterStream(resultSet, columnIndex, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, InputStream x2, long length) throws SQLException {
        try {
            filterChain.ResultSet_updateAsciiStream(resultSet, columnLabel, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, InputStream x2, long length) throws SQLException {
        try {
            filterChain.ResultSet_updateBinaryStream(resultSet, columnLabel, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        try {
            filterChain.ResultSet_updateCharacterStream(resultSet, columnLabel, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBlob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, InputStream inputStream, long length) throws SQLException {
        try {
            filterChain.ResultSet_updateBlob(resultSet, columnIndex, inputStream, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBlob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, InputStream inputStream, long length) throws SQLException {
        try {
            filterChain.ResultSet_updateBlob(resultSet, columnLabel, inputStream, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateClob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Reader reader, long length) throws SQLException {
        try {
            filterChain.ResultSet_updateClob(resultSet, columnIndex, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateClob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        try {
            filterChain.ResultSet_updateClob(resultSet, columnLabel, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateNClob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Reader reader, long length) throws SQLException {
        try {
            filterChain.ResultSet_updateNClob(resultSet, columnIndex, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateNClob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        try {
            filterChain.ResultSet_updateNClob(resultSet, columnLabel, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateNCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Reader x2) throws SQLException {
        try {
            filterChain.ResultSet_updateNCharacterStream(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateNCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        try {
            filterChain.ResultSet_updateNCharacterStream(resultSet, columnLabel, reader);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, InputStream x2) throws SQLException {
        try {
            filterChain.ResultSet_updateAsciiStream(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, InputStream x2) throws SQLException {
        try {
            filterChain.ResultSet_updateBinaryStream(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Reader x2) throws SQLException {
        try {
            filterChain.ResultSet_updateCharacterStream(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, InputStream x2) throws SQLException {
        try {
            filterChain.ResultSet_updateAsciiStream(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, InputStream x2) throws SQLException {
        try {
            filterChain.ResultSet_updateBinaryStream(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        try {
            filterChain.ResultSet_updateCharacterStream(resultSet, columnLabel, reader);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBlob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, InputStream inputStream) throws SQLException {
        try {
            filterChain.ResultSet_updateBlob(resultSet, columnIndex, inputStream);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBlob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, InputStream inputStream) throws SQLException {
        try {
            filterChain.ResultSet_updateBlob(resultSet, columnLabel, inputStream);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateClob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Reader reader) throws SQLException {
        try {
            filterChain.ResultSet_updateClob(resultSet, columnIndex, reader);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateClob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        try {
            filterChain.ResultSet_updateClob(resultSet, columnLabel, reader);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateNClob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Reader reader) throws SQLException {
        try {
            filterChain.ResultSet_updateNClob(resultSet, columnIndex, reader);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateNClob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        try {
            filterChain.ResultSet_updateNClob(resultSet, columnLabel, reader);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public <T> T ResultSet_getObject(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Class<T> type) throws SQLException {
        try {
            return filterChain.ResultSet_getObject(resultSet, columnIndex, type);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public <T> T ResultSet_getObject(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Class<T> type) throws SQLException {
        try {
            return filterChain.ResultSet_getObject(resultSet, columnLabel, type);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        try {
            filterChain.ResultSet_updateObject(resultSet, columnIndex, x2, targetSqlType, scaleOrLength);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        try {
            filterChain.ResultSet_updateObject(resultSet, columnLabel, x2, targetSqlType, scaleOrLength);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Object x2, SQLType targetSqlType) throws SQLException {
        try {
            filterChain.ResultSet_updateObject(resultSet, columnIndex, x2, targetSqlType);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Object x2, SQLType targetSqlType) throws SQLException {
        try {
            filterChain.ResultSet_updateObject(resultSet, columnLabel, x2, targetSqlType);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public int ResultSetMetaData_getColumnCount(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData) throws SQLException {
        try {
            return filterChain.ResultSetMetaData_getColumnCount(resultSetMetaData);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public boolean ResultSetMetaData_isAutoIncrement(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return filterChain.ResultSetMetaData_isAutoIncrement(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean ResultSetMetaData_isCaseSensitive(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return filterChain.ResultSetMetaData_isCaseSensitive(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean ResultSetMetaData_isSearchable(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return filterChain.ResultSetMetaData_isSearchable(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean ResultSetMetaData_isCurrency(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return filterChain.ResultSetMetaData_isCurrency(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public int ResultSetMetaData_isNullable(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return filterChain.ResultSetMetaData_isNullable(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public boolean ResultSetMetaData_isSigned(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return filterChain.ResultSetMetaData_isSigned(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public int ResultSetMetaData_getColumnDisplaySize(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return filterChain.ResultSetMetaData_getColumnDisplaySize(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public String ResultSetMetaData_getColumnLabel(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return filterChain.ResultSetMetaData_getColumnLabel(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String ResultSetMetaData_getColumnName(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return filterChain.ResultSetMetaData_getColumnName(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String ResultSetMetaData_getSchemaName(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return filterChain.ResultSetMetaData_getSchemaName(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public int ResultSetMetaData_getPrecision(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return filterChain.ResultSetMetaData_getPrecision(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int ResultSetMetaData_getScale(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return filterChain.ResultSetMetaData_getScale(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public String ResultSetMetaData_getTableName(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return filterChain.ResultSetMetaData_getTableName(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String ResultSetMetaData_getCatalogName(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return filterChain.ResultSetMetaData_getCatalogName(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public int ResultSetMetaData_getColumnType(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return filterChain.ResultSetMetaData_getColumnType(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public String ResultSetMetaData_getColumnTypeName(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return filterChain.ResultSetMetaData_getColumnTypeName(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public boolean ResultSetMetaData_isReadOnly(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return filterChain.ResultSetMetaData_isReadOnly(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean ResultSetMetaData_isWritable(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return filterChain.ResultSetMetaData_isWritable(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean ResultSetMetaData_isDefinitelyWritable(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return filterChain.ResultSetMetaData_isDefinitelyWritable(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public String ResultSetMetaData_getColumnClassName(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return filterChain.ResultSetMetaData_getColumnClassName(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet Statement_executeQuery(FilterChain filterChain, DmdbStatement statement, String sql) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            return filterChain.Statement_executeQuery(statement, sql);
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                return statement.do_executeQuery(sql);
            }
            return null;
        }
    }

    @Override
    public int Statement_executeUpdate(FilterChain filterChain, DmdbStatement statement, String sql) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            return filterChain.Statement_executeUpdate(statement, sql);
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                return statement.do_executeUpdate(sql);
            }
            return 0;
        }
    }

    @Override
    public void Statement_close(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            filterChain.Statement_close(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public int Statement_getMaxFieldSize(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            return filterChain.Statement_getMaxFieldSize(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return 0;
        }
    }

    @Override
    public void Statement_setMaxFieldSize(FilterChain filterChain, DmdbStatement statement, int max) throws SQLException {
        try {
            filterChain.Statement_setMaxFieldSize(statement, max);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public int Statement_getMaxRows(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            return filterChain.Statement_getMaxRows(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return 0;
        }
    }

    @Override
    public void Statement_setMaxRows(FilterChain filterChain, DmdbStatement statement, int max) throws SQLException {
        try {
            filterChain.Statement_setMaxRows(statement, max);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public void Statement_setEscapeProcessing(FilterChain filterChain, DmdbStatement statement, boolean enable) throws SQLException {
        try {
            filterChain.Statement_setEscapeProcessing(statement, enable);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public int Statement_getQueryTimeout(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            return filterChain.Statement_getQueryTimeout(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return 0;
        }
    }

    @Override
    public void Statement_setQueryTimeout(FilterChain filterChain, DmdbStatement statement, int seconds) throws SQLException {
        try {
            filterChain.Statement_setQueryTimeout(statement, seconds);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public void Statement_cancel(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            filterChain.Statement_cancel(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public SQLWarning Statement_getWarnings(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            return filterChain.Statement_getWarnings(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return null;
        }
    }

    @Override
    public void Statement_clearWarnings(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            filterChain.Statement_clearWarnings(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public void Statement_setCursorName(FilterChain filterChain, DmdbStatement statement, String name) throws SQLException {
        try {
            filterChain.Statement_setCursorName(statement, name);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public boolean Statement_execute(FilterChain filterChain, DmdbStatement statement, String sql) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            return filterChain.Statement_execute(statement, sql);
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                return statement.do_execute(sql);
            }
            return false;
        }
    }

    @Override
    public ResultSet Statement_getResultSet(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            return filterChain.Statement_getResultSet(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return null;
        }
    }

    @Override
    public int Statement_getUpdateCount(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            return filterChain.Statement_getUpdateCount(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return 0;
        }
    }

    @Override
    public boolean Statement_getMoreResults(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            return filterChain.Statement_getMoreResults(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return false;
        }
    }

    @Override
    public void Statement_setFetchDirection(FilterChain filterChain, DmdbStatement statement, int direction) throws SQLException {
        try {
            filterChain.Statement_setFetchDirection(statement, direction);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public int Statement_getFetchDirection(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            return filterChain.Statement_getFetchDirection(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return 0;
        }
    }

    @Override
    public void Statement_setFetchSize(FilterChain filterChain, DmdbStatement statement, int rows) throws SQLException {
        try {
            filterChain.Statement_setFetchSize(statement, rows);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public int Statement_getFetchSize(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            return filterChain.Statement_getFetchSize(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return 0;
        }
    }

    @Override
    public int Statement_getResultSetConcurrency(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            return filterChain.Statement_getResultSetConcurrency(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return 0;
        }
    }

    @Override
    public int Statement_getResultSetType(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            return filterChain.Statement_getResultSetType(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return 0;
        }
    }

    @Override
    public void Statement_addBatch(FilterChain filterChain, DmdbStatement statement, String sql) throws SQLException {
        try {
            filterChain.Statement_addBatch(statement, sql);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public void Statement_clearBatch(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            filterChain.Statement_clearBatch(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public int[] Statement_executeBatch(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            statement.clearBatch = false;
            int[] nArray = filterChain.Statement_executeBatch(statement);
            return nArray;
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                int[] nArray = statement.do_executeBatch();
                return nArray;
            }
            return null;
        }
        finally {
            statement.clearBatch = true;
            statement.do_clearBatch();
        }
    }

    @Override
    public Connection Statement_getConnection(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            return filterChain.Statement_getConnection(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return null;
        }
    }

    @Override
    public boolean Statement_getMoreResults(FilterChain filterChain, DmdbStatement statement, int current) throws SQLException {
        try {
            return filterChain.Statement_getMoreResults(statement, current);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return false;
        }
    }

    @Override
    public ResultSet Statement_getGeneratedKeys(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            return filterChain.Statement_getGeneratedKeys(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return null;
        }
    }

    @Override
    public int Statement_executeUpdate(FilterChain filterChain, DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            return filterChain.Statement_executeUpdate(statement, sql, autoGeneratedKeys);
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                return statement.do_executeUpdate(sql, autoGeneratedKeys);
            }
            return 0;
        }
    }

    @Override
    public int Statement_executeUpdate(FilterChain filterChain, DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            return filterChain.Statement_executeUpdate(statement, sql, columnIndexes);
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                return statement.do_executeUpdate(sql, columnIndexes);
            }
            return 0;
        }
    }

    @Override
    public int Statement_executeUpdate(FilterChain filterChain, DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            return filterChain.Statement_executeUpdate(statement, sql, columnNames);
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                return statement.do_executeUpdate(sql, columnNames);
            }
            return 0;
        }
    }

    @Override
    public boolean Statement_execute(FilterChain filterChain, DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            return filterChain.Statement_execute(statement, sql, autoGeneratedKeys);
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                return statement.do_execute(sql, autoGeneratedKeys);
            }
            return false;
        }
    }

    @Override
    public boolean Statement_execute(FilterChain filterChain, DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            return filterChain.Statement_execute(statement, sql, columnIndexes);
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                return statement.do_execute(sql, columnIndexes);
            }
            return false;
        }
    }

    @Override
    public boolean Statement_execute(FilterChain filterChain, DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            return filterChain.Statement_execute(statement, sql, columnNames);
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                return statement.do_execute(sql, columnNames);
            }
            return false;
        }
    }

    @Override
    public int Statement_getResultSetHoldability(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            return filterChain.Statement_getResultSetHoldability(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return 0;
        }
    }

    @Override
    public boolean Statement_isClosed(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            return filterChain.Statement_isClosed(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return false;
        }
    }

    @Override
    public void Statement_setPoolable(FilterChain filterChain, DmdbStatement statement, boolean poolable) throws SQLException {
        try {
            filterChain.Statement_setPoolable(statement, poolable);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public boolean Statement_isPoolable(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            return filterChain.Statement_isPoolable(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return false;
        }
    }

    @Override
    public void Statement_closeOnCompletion(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            filterChain.Statement_closeOnCompletion(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public boolean Statement_isCloseOnCompletion(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            return filterChain.Statement_isCloseOnCompletion(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return false;
        }
    }

    @Override
    public long Statement_getLargeUpdateCount(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            return filterChain.Statement_getLargeUpdateCount(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return 0L;
        }
    }

    @Override
    public void Statement_setLargeMaxRows(FilterChain filterChain, DmdbStatement statement, long max) throws SQLException {
        try {
            filterChain.Statement_setLargeMaxRows(statement, max);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public long Statement_getLargeMaxRows(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            return filterChain.Statement_getLargeMaxRows(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return 0L;
        }
    }

    @Override
    public long[] Statement_executeLargeBatch(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            statement.clearBatch = false;
            long[] lArray = filterChain.Statement_executeLargeBatch(statement);
            return lArray;
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                long[] lArray = statement.do_executeLargeBatch();
                return lArray;
            }
            return null;
        }
        finally {
            statement.clearBatch = true;
            statement.do_clearBatch();
        }
    }

    @Override
    public long Statement_executeLargeUpdate(FilterChain filterChain, DmdbStatement statement, String sql) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            return filterChain.Statement_executeLargeUpdate(statement, sql);
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                return statement.do_executeLargeUpdate(sql);
            }
            return 0L;
        }
    }

    @Override
    public long Statement_executeLargeUpdate(FilterChain filterChain, DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            return filterChain.Statement_executeLargeUpdate(statement, sql, autoGeneratedKeys);
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                return statement.do_executeLargeUpdate(sql, autoGeneratedKeys);
            }
            return 0L;
        }
    }

    @Override
    public long Statement_executeLargeUpdate(FilterChain filterChain, DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            return filterChain.Statement_executeLargeUpdate(statement, sql, columnIndexes);
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                return statement.do_executeLargeUpdate(sql, columnIndexes);
            }
            return 0L;
        }
    }

    @Override
    public long Statement_executeLargeUpdate(FilterChain filterChain, DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            return filterChain.Statement_executeLargeUpdate(statement, sql, columnNames);
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                return statement.do_executeLargeUpdate(sql, columnNames);
            }
            return 0L;
        }
    }

    @Override
    public long Statement_getExecuteId(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            return filterChain.Statement_getExecuteId(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return 0L;
        }
    }

    @Override
    public String Statement_getPrintMsg(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            return filterChain.Statement_getPrintMsg(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return null;
        }
    }

    @Override
    public int Statement_getSqlType(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            return filterChain.Statement_getSqlType(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return 0;
        }
    }

    @Override
    public RowId Statement_getRowId(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            return filterChain.Statement_getRowId(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet[] Statement_getResultSets(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            return filterChain.Statement_getResultSets(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return null;
        }
    }

    @Override
    public DmdbIntervalYM CallableStatement_getINTERVALYM(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return filterChain.CallableStatement_getINTERVALYM(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public DmdbIntervalDT CallableStatement_getINTERVALDT(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return filterChain.CallableStatement_getINTERVALDT(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public DmdbTimestamp CallableStatement_getTIMESTAMP(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return filterChain.CallableStatement_getTIMESTAMP(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet CallableStatement_getCursor(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return filterChain.CallableStatement_getCursor(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public void Connection_reset(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        try {
            filterChain.Connection_reset(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public String Statement_getExplain(FilterChain filterChain, DmdbStatement dmdbStatement) {
        return filterChain.Statement_getExplain(dmdbStatement);
    }

    @Override
    public ResultSet CallableStatement_getCursor(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return filterChain.CallableStatement_getCursor(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public void CallableStatement_setINTERVALDT(FilterChain filterChain, DmdbCallableStatement callableStatement, String paramName, DmdbIntervalDT x2) throws SQLException {
        try {
            filterChain.CallableStatement_setINTERVALDT(callableStatement, paramName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setINTERVALYM(FilterChain filterChain, DmdbCallableStatement callableStatement, String paramName, DmdbIntervalYM x2) throws SQLException {
        try {
            filterChain.CallableStatement_setINTERVALYM(callableStatement, paramName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setTIMESTAMP(FilterChain filterChain, DmdbCallableStatement callableStatement, String paramName, DmdbTimestamp x2) throws SQLException {
        try {
            filterChain.CallableStatement_setTIMESTAMP(callableStatement, paramName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public DmdbTimestamp CallableStatement_getTIMESTAMP(FilterChain filterChain, DmdbCallableStatement callableStatement, String paramName) throws SQLException {
        try {
            return filterChain.CallableStatement_getTIMESTAMP(callableStatement, paramName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public DmdbIntervalDT CallableStatement_getINTERVALDT(FilterChain filterChain, DmdbCallableStatement callableStatement, String paramName) throws SQLException {
        try {
            return filterChain.CallableStatement_getINTERVALDT(callableStatement, paramName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public DmdbIntervalYM CallableStatement_getINTERVALYM(FilterChain filterChain, DmdbCallableStatement callableStatement, String paramName) throws SQLException {
        try {
            return filterChain.CallableStatement_getINTERVALYM(callableStatement, paramName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public void XAResource_start(FilterChain filterChain, DmdbXAResource xaResource, Xid xid, int flags) throws XAException {
        try {
            filterChain.XAResource_start(xaResource, xid, flags);
        }
        catch (XAException e2) {
            this.whenError(xaResource.conn, e2);
        }
    }

    @Override
    public void XAResource_end(FilterChain filterChain, DmdbXAResource xaResource, Xid xid, int flags) throws XAException {
        try {
            filterChain.XAResource_end(xaResource, xid, flags);
        }
        catch (XAException e2) {
            this.whenError(xaResource.conn, e2);
        }
    }

    @Override
    public boolean XAResource_setTransactionTimeout(FilterChain filterChain, DmdbXAResource xaResource, int seconds) throws XAException {
        try {
            return filterChain.XAResource_setTransactionTimeout(xaResource, seconds);
        }
        catch (XAException e2) {
            this.whenError(xaResource.conn, e2);
            return false;
        }
    }

    @Override
    public int XAResource_getTransactionTimeout(FilterChain filterChain, DmdbXAResource xaResource) throws XAException {
        try {
            return filterChain.XAResource_getTransactionTimeout(xaResource);
        }
        catch (XAException e2) {
            this.whenError(xaResource.conn, e2);
            return 0;
        }
    }

    @Override
    public void XAResource_rollback(FilterChain filterChain, DmdbXAResource xaResource, Xid xid) throws XAException {
        try {
            filterChain.XAResource_rollback(xaResource, xid);
        }
        catch (XAException e2) {
            this.whenError(xaResource.conn, e2);
        }
    }

    @Override
    public void XAResource_commit(FilterChain filterChain, DmdbXAResource xaResource, Xid xid, boolean onePhase) throws XAException {
        try {
            filterChain.XAResource_commit(xaResource, xid, onePhase);
        }
        catch (XAException e2) {
            this.whenError(xaResource.conn, e2);
        }
    }

    @Override
    public Xid[] XAResource_recover(FilterChain filterChain, DmdbXAResource xaResource, int flag) throws XAException {
        try {
            return filterChain.XAResource_recover(xaResource, flag);
        }
        catch (XAException e2) {
            this.whenError(xaResource.conn, e2);
            return null;
        }
    }

    @Override
    public int XAResource_prepare(FilterChain filterChain, DmdbXAResource xaResource, Xid xid) throws XAException {
        try {
            return filterChain.XAResource_prepare(xaResource, xid);
        }
        catch (XAException e2) {
            this.whenError(xaResource.conn, e2);
            return 0;
        }
    }

    @Override
    public boolean XAResource_isSameRM(FilterChain filterChain, DmdbXAResource xaResource, XAResource xaRes) throws XAException {
        try {
            return filterChain.XAResource_isSameRM(xaResource, xaRes);
        }
        catch (XAException e2) {
            this.whenError(xaResource.conn, e2);
            return false;
        }
    }

    @Override
    public void XAResource_forget(FilterChain filterChain, DmdbXAResource xaResource, Xid xid) throws XAException {
        try {
            filterChain.XAResource_forget(xaResource, xid);
        }
        catch (XAException e2) {
            this.whenError(xaResource.conn, e2);
        }
    }

    /* synthetic */ ReconnectFilter(ReconnectFilter reconnectFilter) {
        this();
    }

    private static class ReconnectFilterThreadHolder {
        private static final ReconnectFilter instance = new ReconnectFilter(null);

        private ReconnectFilterThreadHolder() {
        }
    }
}

