/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.rw;

import dm.jdbc.desc.conf.DmProperties;
import dm.jdbc.desc.conf.EP;
import dm.jdbc.desc.enums.RWSite;
import dm.jdbc.driver.Configuration;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.filter.log.ILogger;
import dm.jdbc.filter.log.LogFactory;
import dm.jdbc.filter.rw.ExecuteCallBack;
import dm.jdbc.filter.rw.RWCounter;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.MiscUtil;
import dm.jdbc.util.StringUtil;
import java.sql.SQLException;

public class RWUtil2 {
    private static ILogger log = LogFactory.getLog(RWUtil2.class);
    public static final String SQL_SELECT_STANDBY = "select distinct mailIni.inst_name, mailIni.INST_IP, mailIni.INST_PORT, archIni.arch_status from  v$arch_status archIni left join (select * from V$DM_MAL_INI) mailIni on archIni.arch_dest = mailIni.inst_name left join V$MAL_LINK_STATUS on CTL_LINK_STATUS  = 'CONNECTED' AND DATA_LINK_STATUS = 'CONNECTED' where archIni.arch_type in ('TIMELY', 'REALTIME') AND  archIni.arch_status = 'VALID'";
    public static final String SQL_SELECT_STANDBY2 = "select distinct mailIni.mal_inst_name, mailIni.mal_INST_HOST, mailIni.mal_INST_PORT, archIni.arch_status from v$arch_status archIni left join (select * from V$DM_MAL_INI) mailIni on archIni.arch_dest = mailIni.mal_inst_name left join V$MAL_LINK_STATUS on CTL_LINK_STATUS  = 'CONNECTED' AND DATA_LINK_STATUS = 'CONNECTED' where archIni.arch_type in ('TIMELY', 'REALTIME') AND  archIni.arch_status = 'VALID'";

    public static DmdbConnection connect(DmDriver driver, DmProperties props) throws SQLException {
        props.setProperty(Configuration.loginMode.getName(), "1");
        DmdbConnection connection = driver.do_connect(props);
        connection.rwInfo.rwCounter = RWCounter.getInstance(connection, connection.standbyCount);
        RWUtil2.connectStandby(connection);
        return connection;
    }

    public static void reconnect(DmdbConnection connection) throws SQLException {
        if (connection.rwInfo == null) {
            return;
        }
        RWUtil2.removeStandby(connection);
        connection.do_reconnect();
        connection.rwInfo.cleanup();
        connection.rwInfo.rwCounter = RWCounter.getInstance(connection, connection.standbyCount);
        RWUtil2.connectStandby(connection);
    }

    public static void recoverStandby(DmdbConnection connection) {
        if (connection.do_isClosed() || RWUtil2.isStandbyAlive(connection)) {
            return;
        }
        long ts = System.currentTimeMillis();
        int freq = connection.rwStandbyRecoverTime;
        if (freq <= 0 || ts - connection.rwInfo.tryRecoverTs < (long)freq) {
            return;
        }
        RWUtil2.connectStandby(connection);
        connection.rwInfo.tryRecoverTs = ts;
    }

    private static void connectStandby(DmdbConnection connection) {
        EP db = RWUtil2.chooseValidStandby(connection);
        if (db == null) {
            log.warn(connection, "connStandby", "no valid standby");
            return;
        }
        try {
            DmProperties standbyProps = (DmProperties)connection.props.clone();
            standbyProps.setProperty(Configuration.host.getName(), db.host);
            standbyProps.setProperty(Configuration.port.getName(), String.valueOf(db.port));
            standbyProps.setProperty(Configuration.rwStandby.getName(), String.valueOf(true));
            standbyProps.setProperty(Configuration.epGroup.getName(), null);
            standbyProps.setProperty(Configuration.loginMode.getName(), String.valueOf(2));
            standbyProps.setProperty(Configuration.switchTimes.getName(), "0");
            connection.rwInfo.connStandby = DmDriver.driver.do_connect(standbyProps);
            if (connection.rwInfo.connStandby.svrMode != 2 || connection.rwInfo.connStandby.svrStat != 4) {
                RWUtil2.removeStandby(connection);
            }
        }
        catch (Throwable ignore) {
            log.warn(connection, "connStandby", ignore.getMessage());
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static EP chooseValidStandby(DmdbConnection connection) {
        EP eP;
        DmdbResultSet rs;
        block19: {
            Throwable exception;
            block20: {
                block18: {
                    int i2;
                    rs = null;
                    exception = null;
                    String filter = "";
                    String filter2 = "";
                    try {
                        if (connection.rwSeparate == 2) {
                            String epStr = "";
                            if (connection.epGroup != null) {
                                i2 = 0;
                                for (EP ep : connection.epGroup.epList) {
                                    if (i2 != 0) {
                                        epStr = String.valueOf(epStr) + ",";
                                    }
                                    epStr = String.valueOf(epStr) + "'" + ep.host + ":" + ep.port + "'";
                                    ++i2;
                                }
                            }
                            if (StringUtil.isNotEmpty(epStr)) {
                                filter = " and (mailIni.INST_IP || ':'|| mailIni.INST_PORT) in (" + epStr + ")";
                                filter2 = " and (mailIni.mal_INST_HOST || ':'|| mailIni.mal_INST_PORT) in (" + epStr + ")";
                            }
                        }
                        rs = DriverUtil.executeQuery(connection, connection.malini2 ? SQL_SELECT_STANDBY2 + filter2 : SQL_SELECT_STANDBY + filter);
                    }
                    catch (SQLException sQLException) {
                        MiscUtil.close(rs);
                        try {
                            rs = DriverUtil.executeQuery(connection, connection.malini2 ? SQL_SELECT_STANDBY + filter : SQL_SELECT_STANDBY2 + filter2);
                        }
                        catch (Throwable ignore) {
                            exception = ignore;
                        }
                    }
                    catch (Throwable ignore) {
                        exception = ignore;
                    }
                    try {
                        int count;
                        int n2 = count = rs == null ? 0 : (int)rs.getRowCount();
                        if (count <= 0) break block18;
                        connection.rwInfo.rwCounter = RWCounter.getInstance(connection, count);
                        i2 = 0;
                        int rowIndex = connection.rwInfo.rwCounter.chooseStandbyIndex(count);
                        while (rs.do_next()) {
                            if (i2 == rowIndex) {
                                eP = new EP(rs.do_getString(2), rs.do_getInt(3));
                                break block19;
                            }
                            ++i2;
                        }
                    }
                    catch (Throwable throwable) {
                        MiscUtil.close(rs);
                        throw throwable;
                    }
                    {
                        catch (Throwable ignore) {
                            exception = ignore;
                            MiscUtil.close(rs);
                            break block20;
                            break;
                        }
                    }
                }
                MiscUtil.close(rs);
            }
            if (exception != null) {
                DBError.throwRuntimeException("choose valid standby error!", exception);
            }
            return null;
        }
        MiscUtil.close(rs);
        return eP;
    }

    public static void afterExceptionOnStandby(DmdbConnection connection, SQLException e2) {
        if (e2.getErrorCode() == DBError.ECJDBC_COMMUNITION_ERROR.errCode) {
            RWUtil2.removeStandby(connection);
        }
    }

    private static void removeStandby(DmdbConnection connection) {
        try {
            if (connection.rwInfo.connStandby != null) {
                connection.rwInfo.connStandby.do_close();
                connection.rwInfo.connStandby = null;
            }
        }
        catch (Throwable throwable) {}
    }

    public static boolean isCreateStandbyStmt(DmdbStatement stmt) {
        return stmt != null && stmt.rwInfo.readOnly && RWUtil2.isStandbyAlive(stmt.connection);
    }

    public static <T> T execute(DmdbStatement stmt, String sql, ExecuteCallBack<T> callback) throws SQLException {
        DmdbStatement orgStmt = stmt.rwInfo.stmtCurrent;
        RWUtil2.recoverStandby(stmt.connection);
        RWUtil2.distribute(stmt, sql);
        if (orgStmt != stmt.rwInfo.stmtCurrent) {
            stmt.rwInfo.stmtCurrent.resetParams(orgStmt);
        }
        T ret = null;
        boolean turnToPrimary = false;
        try {
            ret = callback.execute();
            DmdbStatement curStmt = stmt.rwInfo.stmtCurrent;
            switch (curStmt.getRetType()) {
                case 147: 
                case 148: 
                case 151: 
                case 153: 
                case 165: 
                case 166: {
                    try {
                        DmdbStatement otherStmt;
                        DmdbStatement dmdbStatement = otherStmt = curStmt != stmt ? stmt : stmt.rwInfo.stmtStandby;
                        if (otherStmt == null) break;
                        otherStmt.resetParams(curStmt);
                        callback.execute(otherStmt);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 162: {
                    String tmpsql = StringUtil.isNotEmpty(sql) ? sql.trim() : (StringUtil.isNotEmpty(stmt.nativeSql) ? stmt.nativeSql.trim() : "");
                    String sqlhead = tmpsql.split("[ (]", 2)[0];
                    if (sqlhead.equalsIgnoreCase("SP_SET_PARA_VALUE") || sqlhead.equalsIgnoreCase("SP_SET_SESSION_READONLY")) {
                        try {
                            DmdbStatement otherStmt;
                            DmdbStatement dmdbStatement = otherStmt = curStmt != stmt ? stmt : stmt.rwInfo.stmtStandby;
                            if (otherStmt == null) break;
                            otherStmt.resetParams(curStmt);
                            callback.execute(otherStmt);
                        }
                        catch (Exception exception) {}
                    }
                    break;
                }
                case 160: {
                    if (stmt.connection.rwHA && curStmt == stmt.rwInfo.stmtStandby && (curStmt.execInfo.rsDatas == null || curStmt.execInfo.rsDatas.length == 0)) {
                        turnToPrimary = true;
                    }
                    break;
                }
            }
        }
        catch (SQLException e2) {
            if (stmt.rwInfo.stmtCurrent == stmt.rwInfo.stmtStandby) {
                RWUtil2.afterExceptionOnStandby(stmt.connection, e2);
                turnToPrimary = true;
            }
            throw e2;
        }
        if (turnToPrimary) {
            stmt.connection.rwInfo.toPrimary();
            stmt.rwInfo.stmtCurrent = stmt;
            stmt.resetParams(stmt.rwInfo.stmtStandby);
            return callback.execute(stmt);
        }
        return ret;
    }

    public static boolean checkReadonly(DmdbStatement stmt, String sql) {
        boolean readonly = true;
        if (StringUtil.isNotEmpty(sql) && !stmt.connection.rwIgnoreSql) {
            String tmpsql = sql.trim();
            String sqlhead = tmpsql.split(" ", 2)[0];
            readonly = sqlhead.equalsIgnoreCase("SELECT") ? stmt.resultSetConcurrency == 1007 : !sqlhead.equalsIgnoreCase("INSERT") && !sqlhead.equalsIgnoreCase("UPDATE") && !sqlhead.equalsIgnoreCase("DELETE") && !sqlhead.equalsIgnoreCase("CREATE") && !sqlhead.equalsIgnoreCase("TRUNCATE") && !sqlhead.equalsIgnoreCase("DROP") && !sqlhead.equalsIgnoreCase("ALTER");
        }
        return readonly;
    }

    public static RWSite distribute(DmdbStatement stmt, String sql) {
        RWSite dest = null;
        if (!RWUtil2.isStandbyAlive(stmt.connection)) {
            log.debug((Object)stmt.connection, "distribute", "to Primary because standby not alive");
            dest = stmt.connection.rwInfo.toPrimary();
        } else if (stmt instanceof DmdbPreparedStatement ? !stmt.rwInfo.readOnly : !RWUtil2.checkReadonly(stmt, sql)) {
            log.debug((Object)stmt.connection, "distribute", "to Primary because sql not readonly");
            dest = stmt.connection.rwInfo.toPrimary();
        } else if (stmt.connection.rwInfo.distribute == RWSite.PRIMARY && !stmt.connection.getTransFinish() || stmt.connection.rwInfo.distribute == RWSite.STANDBY && !stmt.connection.rwInfo.connStandby.getTransFinish()) {
            dest = stmt.connection.rwInfo.distribute;
            log.debug((Object)stmt.connection, "distribute", "to " + (Object)((Object)dest) + " because trx not finish");
        } else if (!stmt.connection.rwAutoDistribute) {
            log.debug((Object)stmt.connection, "distribute", "to Primary because rwAutoDistribute=0 and readOnly=" + stmt.connection.readOnly);
            dest = stmt.connection.readOnly ? stmt.connection.rwInfo.toStandby() : stmt.connection.rwInfo.toPrimary();
        } else if (stmt.connection.isoLevel != 8) {
            log.debug((Object)stmt.connection, "distribute", "to distribute: d-" + (Object)((Object)stmt.connection.rwInfo.distribute) + ", pf-" + stmt.connection.getTransFinish() + ", sf-" + stmt.connection.rwInfo.connStandby.getTransFinish());
            dest = stmt.connection.rwInfo.toAny();
            log.debug((Object)stmt.connection, "distribute", "to " + (Object)((Object)dest) + " because new distribute");
        } else {
            log.debug((Object)stmt.connection, "distribute", "to Primary because else");
            dest = stmt.connection.rwInfo.toPrimary();
        }
        if (dest == RWSite.STANDBY && !RWUtil2.isStandbyStatementValid(stmt)) {
            try {
                stmt.rwInfo.stmtStandby = stmt instanceof DmdbCallableStatement ? stmt.connection.rwInfo.connStandby.do_prepareCall(stmt.nativeSql, stmt.resultSetType, stmt.resultSetConcurrency, stmt.resultSetHoldability) : (stmt instanceof DmdbPreparedStatement ? stmt.connection.rwInfo.connStandby.do_prepareStatement(stmt.nativeSql, stmt.resultSetType, stmt.resultSetConcurrency, stmt.resultSetHoldability) : stmt.connection.rwInfo.connStandby.do_createStatement(stmt.resultSetType, stmt.resultSetConcurrency, stmt.resultSetHoldability));
            }
            catch (Exception exception) {
                dest = stmt.connection.rwInfo.toPrimary();
            }
        }
        stmt.rwInfo.stmtCurrent = dest == RWSite.PRIMARY ? stmt : stmt.rwInfo.stmtStandby;
        return dest;
    }

    public static boolean isStandbyAlive(DmdbConnection connection) {
        return connection.rwInfo.connStandby != null && !connection.rwInfo.connStandby.do_isClosed();
    }

    public static boolean isStandbyStatementValid(DmdbStatement statement) {
        return statement.rwInfo.stmtStandby != null && !statement.rwInfo.stmtStandby.do_isClosed();
    }
}

