/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.stat.util;

import dm.jdbc.util.DriverUtil;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;

public class JSONWriter {
    private StringBuilder out = new StringBuilder();

    public void writeArrayStart() {
        this.write('[');
    }

    public void writeComma() {
        this.write(',');
    }

    public void writeArrayEnd() {
        this.write(']');
    }

    public void writeNull() {
        this.write("null");
    }

    public void writeObject(Object o2) {
        if (o2 == null) {
            this.writeNull();
            return;
        }
        if (o2 instanceof String) {
            this.writeString((String)o2);
            return;
        }
        if (o2 instanceof Number) {
            this.write(o2.toString());
            return;
        }
        if (o2 instanceof Boolean) {
            this.write(o2.toString());
            return;
        }
        if (o2 instanceof Date) {
            this.writeDate((Date)o2);
            return;
        }
        if (o2 instanceof Collection) {
            this.writeArray((Collection)o2);
            return;
        }
        if (o2 instanceof Throwable) {
            this.writeError((Throwable)o2);
            return;
        }
        if (o2 instanceof int[]) {
            int[] array = (int[])o2;
            this.write('[');
            int i2 = 0;
            while (i2 < array.length) {
                if (i2 != 0) {
                    this.write(',');
                }
                this.write(array[i2]);
                ++i2;
            }
            this.write(']');
            return;
        }
        if (o2 instanceof long[]) {
            long[] array = (long[])o2;
            this.write('[');
            int i3 = 0;
            while (i3 < array.length) {
                if (i3 != 0) {
                    this.write(',');
                }
                this.write(array[i3]);
                ++i3;
            }
            this.write(']');
            return;
        }
        if (o2 instanceof TabularData) {
            this.writeTabularData((TabularData)o2);
            return;
        }
        if (o2 instanceof CompositeData) {
            this.writeCompositeData((CompositeData)o2);
            return;
        }
        if (o2 instanceof Map) {
            this.writeMap((Map)o2);
            return;
        }
        throw new IllegalArgumentException("not support type : " + o2.getClass());
    }

    public void writeDate(Date date) {
        if (date == null) {
            this.writeNull();
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.writeString(dateFormat.format(date));
    }

    public void writeError(Throwable error) {
        if (error == null) {
            this.writeNull();
            return;
        }
        this.write("{\"Class\":");
        this.writeString(error.getClass().getName());
        this.write(",\"Message\":");
        this.writeString(error.getMessage());
        this.write(",\"StackTrace\":");
        this.writeString(DriverUtil.getStackTrace(error));
        this.write('}');
    }

    public void writeArray(Object[] array) {
        if (array == null) {
            this.writeNull();
            return;
        }
        this.write('[');
        int i2 = 0;
        while (i2 < array.length) {
            if (i2 != 0) {
                this.write(',');
            }
            this.writeObject(array[i2]);
            ++i2;
        }
        this.write(']');
    }

    public void writeArray(Collection<Object> list) {
        if (list == null) {
            this.writeNull();
            return;
        }
        int entryIndex = 0;
        this.write('[');
        for (Object entry : list) {
            if (entryIndex != 0) {
                this.write(',');
            }
            this.writeObject(entry);
            ++entryIndex;
        }
        this.write(']');
    }

    public void writeString(String text) {
        if (text == null) {
            this.writeNull();
            return;
        }
        this.write('\"');
        int i2 = 0;
        while (i2 < text.length()) {
            char c2 = text.charAt(i2);
            if (c2 == '\"') {
                this.write("\\\"");
            } else if (c2 == '\n') {
                this.write("\\n");
            } else if (c2 == '\r') {
                this.write("\\r");
            } else if (c2 == '\\') {
                this.write("\\\\");
            } else if (c2 == '\t') {
                this.write("\\t");
            } else if (c2 < '\u0010') {
                this.write("\\u000");
                this.write(Integer.toHexString(c2));
            } else if (c2 < ' ') {
                this.write("\\u00");
                this.write(Integer.toHexString(c2));
            } else if (c2 >= '\u007f' && c2 <= '\u00a0') {
                this.write("\\u00");
                this.write(Integer.toHexString(c2));
            } else {
                this.write(c2);
            }
            ++i2;
        }
        this.write('\"');
    }

    public void writeTabularData(TabularData tabularData) {
        if (tabularData == null) {
            this.writeNull();
            return;
        }
        int entryIndex = 0;
        this.write('[');
        for (Object item : tabularData.values()) {
            if (entryIndex != 0) {
                this.write(',');
            }
            CompositeData row = (CompositeData)item;
            this.writeCompositeData(row);
            ++entryIndex;
        }
        this.write(']');
    }

    public void writeCompositeData(CompositeData compositeData) {
        if (compositeData == null) {
            this.writeNull();
            return;
        }
        int entryIndex = 0;
        this.write('{');
        for (String key : compositeData.getCompositeType().keySet()) {
            if (entryIndex != 0) {
                this.write(',');
            }
            this.writeString(key);
            this.write(':');
            Object value = compositeData.get(key);
            this.writeObject(value);
            ++entryIndex;
        }
        this.write('}');
    }

    public void writeMap(Map<String, Object> map) {
        if (map == null) {
            this.writeNull();
            return;
        }
        int entryIndex = 0;
        this.write('{');
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entryIndex != 0) {
                this.write(',');
            }
            this.writeString(entry.getKey());
            this.write(':');
            this.writeObject(entry.getValue());
            ++entryIndex;
        }
        this.write('}');
    }

    protected void write(String text) {
        this.out.append(text);
    }

    protected void write(char c2) {
        this.out.append(c2);
    }

    protected void write(int c2) {
        this.out.append(c2);
    }

    protected void write(long c2) {
        this.out.append(c2);
    }

    public String toString() {
        return this.out.toString();
    }
}

