/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.plugin.fldr;

import dm.jdbc.plugin.fldr.ColumnInfo;
import dm.jdbc.plugin.fldr.HorizontalTableInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableInfo {
    private List<ColumnInfo> columnInfos;
    private Map<String, Short> nameIdMap;
    private HorizontalTableInfo hTableHead;
    public Map<String, List<Object[]>> hTableNameData = new HashMap<String, List<Object[]>>();
    public int autoIncrementColId;

    public TableInfo() {
    }

    public TableInfo(List<ColumnInfo> columnInfos, Map<String, Short> nameIdMap, HorizontalTableInfo hTableHead) {
        this.columnInfos = columnInfos;
        this.nameIdMap = nameIdMap;
        this.hTableHead = hTableHead;
    }

    public List<ColumnInfo> getColumnInfos() {
        return this.columnInfos;
    }

    public void setColumnInfos(List<ColumnInfo> columnInfos) {
        this.columnInfos = columnInfos;
    }

    public Map<String, Short> getNameIdMap() {
        return this.nameIdMap;
    }

    public void setNameIdMap(Map<String, Short> nameIdMap) {
        this.nameIdMap = nameIdMap;
    }

    public HorizontalTableInfo gethTableHead() {
        return this.hTableHead;
    }

    public void sethTableHead(HorizontalTableInfo hTableHead) {
        this.hTableHead = hTableHead;
    }

    public Short getColumnIdByName(String columnName) throws SQLException {
        if (columnName == null || columnName.length() == 0) {
            throw new SQLException("Column name\u4e0d\u80fd\u4e3a\u7a7a");
        }
        columnName = columnName.toUpperCase();
        if (this.nameIdMap == null || this.nameIdMap.size() == 0) {
            throw new SQLException(String.format("\u4e0d\u5b58\u5728\u8be5\u5217: %s", columnName));
        }
        Short columnId = this.nameIdMap.get(columnName);
        if (columnId == null) {
            throw new SQLException(String.format("\u4e0d\u5b58\u5728\u8be5\u5217: %s", columnName));
        }
        return columnId;
    }

    public Map<String, List<Object[]>> getHTabPartition(Object[] singleRow) throws SQLException {
        if (this.hTableHead == null) {
            throw new SQLException("\u4e0d\u5b58\u5728\u6c34\u5e73\u5206\u533a\u5b50\u8868");
        }
        HorizontalTableInfo head = this.hTableHead;
        while (head.getChildren() != null && head.getChildren().size() > 0) {
            short[] partitionColIds = head.getPartitionColIds();
            short[] sqlType = head.getSqlType();
            int index = -1;
            int maxIndex = Integer.MIN_VALUE;
            int i2 = 0;
            while (i2 < sqlType.length) {
                switch (sqlType[i2]) {
                    case 7: {
                        index = this.compareInt(head, i2, singleRow[partitionColIds[i2]]);
                        maxIndex = index > maxIndex ? index : maxIndex;
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: {
                        index = this.compareVarchar(head, i2, singleRow[partitionColIds[i2]]);
                        maxIndex = index > maxIndex ? index : maxIndex;
                        break;
                    }
                }
                ++i2;
            }
            if (maxIndex < 0) continue;
            head = head.getChildren().get(maxIndex);
        }
        List<Object[]> data = this.hTableNameData.get(head.getTableName());
        if (data == null) {
            data = new ArrayList<Object[]>();
            data.add(singleRow);
            this.hTableNameData.put(head.getTableName(), data);
        } else {
            data.add(singleRow);
        }
        return this.hTableNameData;
    }

    private int compareInt(HorizontalTableInfo node, int index, Object value) throws SQLException {
        Object[] targets = node.getBoundaries().get(index);
        int[] includeFlag = node.getIncludeFlag();
        int result = -1;
        try {
            result = Arrays.binarySearch(targets, value);
        }
        catch (Exception e2) {
            throw new SQLException(String.format(String.valueOf(e2.getMessage()) + "\n CompareInt Index: %s Value: %s", index, value));
        }
        if (result < 0) {
            result = -1 - result;
        }
        if (value.equals(targets[result]) && includeFlag[result] == 0 && ++result >= targets.length) {
            throw new SQLException("\u8be5\u503c\u8d85\u8fc7\u5206\u533a\u8fb9\u754c\u503c");
        }
        return result;
    }

    private int compareVarchar(HorizontalTableInfo node, int index, Object value) throws SQLException {
        try {
            return this.compareInt(node, index, value);
        }
        catch (Exception e2) {
            throw new SQLException(String.format(String.valueOf(e2.getMessage()) + "\n CompareVarchar Index: %s Value: %s", index, value));
        }
    }
}

