/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import dm.jdbc.desc.conf.DmSvcConf;
import dm.jdbc.driver.DBError;
import dm.jdbc.util.DateUtil;
import dm.jdbc.util.StringUtil;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DateFormatOracle {
    public int language = DmSvcConf.GLOBAL.getLanguage();
    public int scale = 9;
    public YearElement Y = new YearElement();
    public SYearElement SY = new SYearElement();
    public HH12Element HH12 = new HH12Element();
    public HH24Element HH24 = new HH24Element();
    public MIElement MI = new MIElement();
    public SSElement SS = new SSElement();
    public AMElement AM = new AMElement();
    public MonthElement Month = new MonthElement();
    public MonElement Mon = new MonElement();
    public MMElement MM = new MMElement();
    public DDElement DD = new DDElement();
    public TZHElement TZH = new TZHElement();
    public TZMElement TZM = new TZMElement();
    public FElement F = new FElement();
    public List<Object> formatElementList = new ArrayList<Object>();
    public String pattern;
    private static ThreadLocal<DateFormatOracle> formats = new ThreadLocal();
    private boolean PM = false;
    private boolean TZNegative = false;

    public void setPattern(String pattern) {
        if (!StringUtil.equals(pattern, this.pattern)) {
            this.pattern = pattern;
            this.formatElementList.clear();
            this.analysePattern(pattern);
        }
    }

    /*
     * Unable to fully structure code
     */
    public int[] parse(String str) {
        this.clearBeforParse();
        dt = new int[8];
        today = new Date(System.currentTimeMillis());
        dt[0] = today.getYear() + 1900;
        dt[1] = today.getMonth() + 1;
        dt[2] = today.getDate();
        dt[7] = -2147483648;
        offset = 0;
        try {
            str = str.trim();
            for (Object obj : this.formatElementList) {
                if (offset < str.length()) ** GOTO lbl15
                break;
lbl-1000:
                // 1 sources

                {
                    ++offset;
lbl15:
                    // 2 sources

                    ** while (str.charAt((int)offset) == ' ' && !StringUtil.equals((String)" ", (String)obj.toString()))
                }
lbl16:
                // 1 sources

                if (obj instanceof Element) {
                    offset = ((Element)obj).parse(str, offset, dt);
                    continue;
                }
                if (StringUtil.equals(" ", obj.toString())) {
                    offset += str.charAt(offset) == ' ' ? 1 : 0;
                    continue;
                }
                offset += obj.toString().length();
            }
            if (offset < str.length()) {
                DBError.ECJDBC_INVALID_DATETIME_VALUE.throwz(new Object[]{str});
            }
            if (this.PM) {
                dt[3] = (dt[3] + 12) % 24;
            }
            if (this.TZNegative) {
                dt[7] = -dt[7];
            }
            if (dt[2] > DateUtil.getDaysOfMonth(dt[0], dt[1]) || dt[2] < 1) {
                DBError.ECJDBC_INVALID_DATETIME_VALUE.throwz(new Object[]{str});
            }
            if (dt[7] != -2147483648 && (dt[7] > 840 || dt[7] <= -780)) {
                DBError.ECJDBC_INVALID_DATETIME_VALUE.throwz(new Object[]{str});
            }
        }
        catch (SQLException sqle) {
            if (sqle.getErrorCode() == DBError.ECJDBC_INVALID_DATETIME_VALUE.errCode || sqle.getErrorCode() == DBError.ECJDBC_INVALID_DATETIME_FORMAT.errCode) {
                DBError.throwRuntimeException(sqle.getMessage(), sqle);
            }
            DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason, sqle);
        }
        catch (Exception e) {
            DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason, e);
        }
        return dt;
    }

    public static int[] parse(String str, String pattern, int language) {
        DateFormatOracle f2 = DateFormatOracle.getFormat();
        f2.setPattern(pattern);
        f2.language = language;
        int[] ret = f2.parse(str);
        return ret;
    }

    public static String format(int[] dt, String pattern, int scale, int language) {
        DateFormatOracle f2 = DateFormatOracle.getFormat();
        f2.setPattern(pattern);
        f2.language = language;
        f2.scale = scale;
        String ret = f2.format(dt);
        return ret;
    }

    public String format(int[] dt) {
        StringBuilder sf = new StringBuilder();
        boolean tzStart = false;
        for (Object obj : this.formatElementList) {
            if (!tzStart && (obj instanceof TZHElement || obj instanceof TZMElement)) {
                tzStart = true;
                sf.append(dt[7] < 0 ? "-" : "+");
            }
            if (obj instanceof Element) {
                sf.append(((Element)obj).format(dt));
                continue;
            }
            sf.append(obj);
        }
        return sf.toString();
    }

    private void clearBeforParse() {
        this.PM = false;
        this.TZNegative = false;
    }

    private static DateFormatOracle getFormat() {
        DateFormatOracle format = formats.get();
        if (format == null) {
            format = new DateFormatOracle();
        }
        return format;
    }

    private List<Object> analysePattern(String pattern) {
        pattern = pattern.trim();
        int len = pattern.length();
        ArrayList<String> splitPatterns = new ArrayList<String>();
        int starti = 0;
        char curChar = '\u0000';
        int i2 = 0;
        while (i2 < len) {
            curChar = pattern.charAt(i2);
            if (!Character.isLetterOrDigit(curChar)) {
                if (i2 > starti) {
                    splitPatterns.add(pattern.substring(starti, i2));
                }
                splitPatterns.add(String.valueOf(curChar));
                starti = i2 + 1;
            } else if (i2 == len - 1) {
                splitPatterns.add(pattern.substring(starti, i2 + 1));
            }
            ++i2;
        }
        block1: for (String subPattern : splitPatterns) {
            if (subPattern.length() != 1 || Character.isLetterOrDigit(subPattern.charAt(0))) {
                String fmtWord = subPattern;
                Element element = null;
                while (subPattern != null) {
                    int i3 = subPattern.length();
                    while (i3 > 0) {
                        fmtWord = subPattern.substring(0, i3);
                        element = this.getFormatElement(fmtWord);
                        if (element != null) {
                            String lastFormatElement;
                            if ((element == this.TZH || element == this.TZM) && ("+".equals(lastFormatElement = this.formatElementList.get(this.formatElementList.size() - 1).toString()) || "-".equals(lastFormatElement))) {
                                this.formatElementList.remove(this.formatElementList.size() - 1);
                            }
                            this.formatElementList.add(element);
                            subPattern = i3 == subPattern.length() ? null : subPattern.substring(i3, subPattern.length());
                            break;
                        }
                        --i3;
                    }
                    if (i3 != 0) continue;
                    this.formatElementList.add(subPattern);
                    continue block1;
                }
                continue;
            }
            this.formatElementList.add(subPattern);
        }
        return this.formatElementList;
    }

    private Element getFormatElement(String word) {
        if ("HH".equalsIgnoreCase(word) || "HH12".equalsIgnoreCase(word)) {
            return this.HH12;
        }
        if ("HH24".equalsIgnoreCase(word)) {
            return this.HH24;
        }
        if ("MI".equalsIgnoreCase(word)) {
            return this.MI;
        }
        if ("SS".equalsIgnoreCase(word)) {
            return this.SS;
        }
        if ("AM".equalsIgnoreCase(word) || "A.M.".equalsIgnoreCase(word) || "PM".equalsIgnoreCase(word) || "P.M.".equalsIgnoreCase(word)) {
            return this.AM;
        }
        if ("MONTH".equals(word)) {
            this.Month.upperCase = true;
            this.Month.lowerCase = false;
            return this.Month;
        }
        if ("month".equals(word)) {
            this.Month.upperCase = false;
            this.Month.lowerCase = true;
            return this.Month;
        }
        if ("Month".equalsIgnoreCase(word)) {
            this.Month.upperCase = false;
            this.Month.lowerCase = false;
            return this.Month;
        }
        if ("MON".equals(word)) {
            this.Mon.upperCase = true;
            this.Mon.lowerCase = false;
            return this.Mon;
        }
        if ("mon".equals(word)) {
            this.Mon.upperCase = false;
            this.Mon.lowerCase = true;
            return this.Mon;
        }
        if ("Mon".equalsIgnoreCase(word)) {
            this.Mon.upperCase = false;
            this.Mon.lowerCase = false;
            return this.Mon;
        }
        if ("MM".equalsIgnoreCase(word)) {
            return this.MM;
        }
        if ("DD".equalsIgnoreCase(word)) {
            return this.DD;
        }
        if ("TZH".equalsIgnoreCase(word)) {
            return this.TZH;
        }
        if ("TZM".equalsIgnoreCase(word)) {
            return this.TZM;
        }
        if (StringUtil.startWithIgnoreCase(word, "Y")) {
            this.Y.len = word.length();
            return this.Y;
        }
        if (StringUtil.startWithIgnoreCase(word, "SY")) {
            this.SY.len = word.length();
            return this.SY;
        }
        if (StringUtil.startWithIgnoreCase(word, "F")) {
            try {
                int count;
                word = word.toUpperCase();
                int numIndex = word.toUpperCase().lastIndexOf("F") + 1;
                this.F.len = count = numIndex < word.length() ? Integer.valueOf(word.substring(numIndex, word.length())) : -1;
                return this.F;
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private String formatInt(int value, int len) {
        int pow = (int)Math.pow(10.0, len);
        if (value >= pow) {
            value %= pow;
        }
        return String.valueOf(value += pow).substring(1);
    }

    public static void main(String[] args) {
        int[] dt = DateFormatOracle.parse("-201-01-01", "SYYYY-MM-DD", 1);
        System.out.println(DateFormatOracle.format(dt, "SYYYY-MM-DD", -1, 1));
    }

    class AMElement
    extends Element {
        AMElement() {
        }

        @Override
        int parse(String str, int offset, int[] dt) {
            str = str.substring(offset, offset + 2);
            DateFormatOracle.this.PM = DateFormatOracle.this.language == 0 ? StringUtil.equalsIgnoreCase("\u4e0b\u5348", str) : StringUtil.equalsIgnoreCase("PM", str);
            return offset + 2;
        }

        @Override
        String format(int[] dt) {
            int hour = dt[3];
            if (DateFormatOracle.this.language == 0) {
                return hour > 12 ? "\u4e0b\u5348" : "\u4e0a\u5348";
            }
            return hour > 12 ? "PM" : "AM";
        }
    }

    class DDElement
    extends Element {
        DDElement() {
        }

        @Override
        int parse(String str, int offset, int[] dt) throws Exception {
            int strLen = 0;
            int i2 = offset;
            while (i2 < offset + 2 && i2 < str.length()) {
                if (!Character.isLetterOrDigit(str.charAt(i2))) break;
                ++strLen;
                ++i2;
            }
            str = str.substring(offset, offset + strLen);
            int day = Integer.parseInt(str);
            if (day > 31 || day < 1) {
                DBError.ECJDBC_INVALID_DATETIME_VALUE.throwz(new Object[0]);
            }
            dt[2] = day;
            return offset + strLen;
        }

        @Override
        String format(int[] dt) {
            return DateFormatOracle.this.formatInt(dt[2], 2);
        }
    }

    abstract class Element {
        Element() {
        }

        abstract int parse(String var1, int var2, int[] var3) throws Exception;

        abstract String format(int[] var1);
    }

    class FElement
    extends Element {
        int len = -1;

        FElement() {
        }

        @Override
        int parse(String str, int offset, int[] dt) {
            int strLen = 0;
            int maxLen = this.len > 0 ? this.len : 9;
            int i2 = offset;
            while (i2 < offset + maxLen && i2 < str.length()) {
                if (!Character.isLetterOrDigit(str.charAt(i2))) break;
                ++strLen;
                ++i2;
            }
            str = str.substring(offset, offset + strLen);
            int ms = Integer.parseInt(str);
            dt[6] = ms = strLen < 9 ? ms * (int)Math.pow(10.0, 9 - strLen) : ms / (int)Math.pow(10.0, strLen - 9);
            return offset + strLen;
        }

        @Override
        String format(int[] dt) {
            int msLen = this.len > 0 ? this.len : DateFormatOracle.this.scale;
            return DateUtil.formatMilliSecond(dt[6], msLen);
        }
    }

    class HH12Element
    extends Element {
        HH12Element() {
        }

        @Override
        int parse(String str, int offset, int[] dt) throws Exception {
            int strLen = 0;
            int i2 = offset;
            while (i2 < offset + 2 && i2 < str.length()) {
                if (!Character.isLetterOrDigit(str.charAt(i2))) break;
                ++strLen;
                ++i2;
            }
            str = str.substring(offset, offset + strLen);
            int hour = Integer.parseInt(str);
            if (hour > 12 || hour < 1) {
                DBError.ECJDBC_INVALID_DATETIME_VALUE.throwz(new Object[0]);
            }
            dt[3] = hour;
            return offset + strLen;
        }

        @Override
        String format(int[] dt) {
            String ret = null;
            int value = dt[3];
            ret = value > 12 || value == 0 ? DateFormatOracle.this.formatInt(Math.abs(value - 12), 2) : DateFormatOracle.this.formatInt(value, 2);
            return ret;
        }
    }

    class HH24Element
    extends Element {
        HH24Element() {
        }

        @Override
        int parse(String str, int offset, int[] dt) throws SQLException {
            int strLen = 0;
            int i2 = offset;
            while (i2 < offset + 2 && i2 < str.length()) {
                if (!Character.isLetterOrDigit(str.charAt(i2))) break;
                ++strLen;
                ++i2;
            }
            str = str.substring(offset, offset + strLen);
            int hour = Integer.parseInt(str);
            if (hour > 23 || hour < 0) {
                DBError.ECJDBC_INVALID_DATETIME_VALUE.throwz(new Object[0]);
            }
            dt[3] = hour;
            return offset + strLen;
        }

        @Override
        String format(int[] dt) {
            return DateFormatOracle.this.formatInt(dt[3], 2);
        }
    }

    class MIElement
    extends Element {
        MIElement() {
        }

        @Override
        int parse(String str, int offset, int[] dt) throws Exception {
            int strLen = 0;
            int i2 = offset;
            while (i2 < offset + 2 && i2 < str.length()) {
                if (!Character.isLetterOrDigit(str.charAt(i2))) break;
                ++strLen;
                ++i2;
            }
            str = str.substring(offset, offset + strLen);
            int minute = Integer.parseInt(str);
            if (minute > 59 || minute < 0) {
                DBError.ECJDBC_INVALID_DATETIME_VALUE.throwz(new Object[0]);
            }
            dt[4] = minute;
            return offset + strLen;
        }

        @Override
        String format(int[] dt) {
            return DateFormatOracle.this.formatInt(dt[4], 2);
        }
    }

    class MMElement
    extends Element {
        MMElement() {
        }

        @Override
        int parse(String str, int offset, int[] dt) throws Exception {
            int strLen = 0;
            int i2 = offset;
            while (i2 < offset + 2 && i2 < str.length()) {
                if (!Character.isLetterOrDigit(str.charAt(i2))) break;
                ++strLen;
                ++i2;
            }
            str = str.substring(offset, offset + strLen);
            int month = Integer.parseInt(str);
            if (month > 12 || month < 1) {
                DBError.ECJDBC_INVALID_DATETIME_VALUE.throwz(new Object[0]);
            }
            dt[1] = month;
            return offset + strLen;
        }

        @Override
        String format(int[] dt) {
            return DateFormatOracle.this.formatInt(dt[1], 2);
        }
    }

    class MonElement
    extends Element {
        boolean upperCase = false;
        boolean lowerCase = false;
        String[] nameList = new String[]{"", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

        MonElement() {
        }

        @Override
        int parse(String str, int offset, int[] dt) throws Exception {
            if (DateFormatOracle.this.language == 0) {
                int mon;
                int index = str.indexOf("\u6708", offset);
                if (index == -1) {
                    DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwz(new Object[0]);
                }
                if ((mon = Integer.parseInt(str.substring(offset, index))) > 12 || mon < 1) {
                    DBError.ECJDBC_INVALID_DATETIME_VALUE.throwz(new Object[0]);
                }
                dt[1] = mon;
                return index + 1;
            }
            str = str.substring(offset, offset + 3);
            int mon = 0;
            int i2 = 1;
            while (i2 < this.nameList.length) {
                if (StringUtil.equalsIgnoreCase(str, this.nameList[i2])) {
                    mon = i2;
                    break;
                }
                ++i2;
            }
            if (mon == 0) {
                DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwz(new Object[0]);
            }
            dt[1] = mon;
            return offset + 3;
        }

        @Override
        String format(int[] dt) {
            int value = dt[1];
            if (DateFormatOracle.this.language == 0) {
                return String.valueOf(value) + "\u6708";
            }
            return this.upperCase ? this.nameList[value].toUpperCase() : (this.lowerCase ? this.nameList[value].toLowerCase() : this.nameList[value]);
        }
    }

    class MonthElement
    extends Element {
        boolean upperCase = false;
        boolean lowerCase = false;
        String[] nameList = new String[]{"", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};

        MonthElement() {
        }

        @Override
        int parse(String str, int offset, int[] dt) throws Exception {
            if (DateFormatOracle.this.language == 0) {
                int mon;
                int index = str.indexOf("\u6708", offset);
                if (index == -1) {
                    DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwz(new Object[0]);
                }
                if ((mon = Integer.parseInt(str.substring(offset, index))) > 12 || mon < 1) {
                    DBError.ECJDBC_INVALID_DATETIME_VALUE.throwz(new Object[0]);
                }
                dt[1] = mon;
                return index + 1;
            }
            str = str.substring(offset).toLowerCase();
            int mon = 0;
            int i2 = 1;
            while (i2 < this.nameList.length) {
                if (StringUtil.startWithIgnoreCase(str, this.nameList[i2])) {
                    mon = i2;
                    break;
                }
                ++i2;
            }
            if (mon == 0) {
                DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason);
            }
            dt[1] = mon;
            return offset + this.nameList[mon].length();
        }

        @Override
        String format(int[] dt) {
            int value = dt[1];
            if (DateFormatOracle.this.language == 0) {
                return String.valueOf(value) + "\u6708";
            }
            return this.upperCase ? this.nameList[value].toUpperCase() : (this.lowerCase ? this.nameList[value].toLowerCase() : this.nameList[value]);
        }
    }

    class SSElement
    extends Element {
        SSElement() {
        }

        @Override
        int parse(String str, int offset, int[] dt) throws Exception {
            int strLen = 0;
            int i2 = offset;
            while (i2 < offset + 2 && i2 < str.length()) {
                if (!Character.isLetterOrDigit(str.charAt(i2))) break;
                ++strLen;
                ++i2;
            }
            str = str.substring(offset, offset + strLen);
            int second = Integer.parseInt(str);
            if (second > 59 || second < 0) {
                DBError.ECJDBC_INVALID_DATETIME_VALUE.throwz(new Object[0]);
            }
            dt[5] = second;
            return offset + strLen;
        }

        @Override
        String format(int[] dt) {
            return DateFormatOracle.this.formatInt(dt[5], 2);
        }
    }

    class SYearElement
    extends Element {
        int len = 5;

        SYearElement() {
        }

        @Override
        int parse(String str, int offset, int[] dt) {
            int strLen = 0;
            boolean sign = false;
            int start = offset;
            if (str.charAt(start) == '-') {
                sign = true;
                ++start;
            } else if (str.charAt(start) == '+') {
                sign = false;
                ++start;
            }
            int i2 = start;
            while (i2 < offset + this.len && i2 < str.length()) {
                if (!Character.isLetterOrDigit(str.charAt(i2))) break;
                ++strLen;
                ++i2;
            }
            str = str.substring(start, start + strLen);
            if (this.len < 5) {
                String today = String.valueOf(dt[0]);
                dt[0] = Integer.parseInt(String.valueOf(today.substring(0, 4 - this.len + 1)) + str);
            } else {
                dt[0] = Integer.parseInt(str);
            }
            if (sign) {
                dt[0] = -dt[0];
            }
            return start + strLen;
        }

        @Override
        String format(int[] dt) {
            if (dt[0] < 0) {
                return "-" + DateFormatOracle.this.formatInt(-dt[0], this.len - 1);
            }
            return DateFormatOracle.this.formatInt(dt[0], this.len - 1);
        }
    }

    class TZHElement
    extends Element {
        TZHElement() {
        }

        @Override
        int parse(String str, int offset, int[] dt) throws Exception {
            if (str.charAt(offset) == '+') {
                ++offset;
            } else if (str.charAt(offset) == '-') {
                ++offset;
                DateFormatOracle.this.TZNegative = true;
            }
            int strLen = 0;
            int i2 = offset;
            while (i2 < offset + 2 && i2 < str.length()) {
                if (!Character.isLetterOrDigit(str.charAt(i2))) break;
                ++strLen;
                ++i2;
            }
            str = str.substring(offset, offset + strLen);
            int tzh = Integer.parseInt(str);
            if (tzh > 23 || tzh < 0) {
                DBError.ECJDBC_INVALID_DATETIME_VALUE.throwz(new Object[0]);
            }
            dt[7] = dt[7] == Integer.MIN_VALUE ? tzh : dt[7] + (tzh *= 60);
            return offset + strLen;
        }

        @Override
        String format(int[] dt) {
            int value = dt[7] != Integer.MIN_VALUE ? Math.abs(dt[7]) / 60 : 0;
            return DateFormatOracle.this.formatInt(value, 2);
        }
    }

    class TZMElement
    extends Element {
        TZMElement() {
        }

        @Override
        int parse(String str, int offset, int[] dt) throws Exception {
            if (str.charAt(offset) == '+') {
                ++offset;
            } else if (str.charAt(offset) == '-') {
                ++offset;
                DateFormatOracle.this.TZNegative = true;
            }
            int strLen = 0;
            int i2 = offset;
            while (i2 < offset + 2 && i2 < str.length()) {
                if (!Character.isLetterOrDigit(str.charAt(i2))) break;
                ++strLen;
                ++i2;
            }
            str = str.substring(offset, offset + strLen);
            int tzm = Integer.parseInt(str);
            if (tzm > 59 || tzm < 0) {
                DBError.ECJDBC_INVALID_DATETIME_VALUE.throwz(new Object[0]);
            }
            dt[7] = dt[7] == Integer.MIN_VALUE ? tzm : dt[7] + tzm;
            return offset + strLen;
        }

        @Override
        String format(int[] dt) {
            int value = dt[7] != Integer.MIN_VALUE ? Math.abs(dt[7]) % 60 : 0;
            return DateFormatOracle.this.formatInt(value, 2);
        }
    }

    class YearElement
    extends Element {
        int len = 4;

        YearElement() {
        }

        @Override
        int parse(String str, int offset, int[] dt) {
            int strLen = 0;
            int i2 = offset;
            while (i2 < offset + this.len && i2 < str.length()) {
                if (!Character.isLetterOrDigit(str.charAt(i2))) break;
                ++strLen;
                ++i2;
            }
            str = str.substring(offset, offset + strLen);
            if (this.len < 4) {
                String today = String.valueOf(dt[0]);
                dt[0] = Integer.parseInt(String.valueOf(today.substring(0, 4 - this.len)) + str);
            } else {
                dt[0] = Integer.parseInt(str);
            }
            return offset + strLen;
        }

        @Override
        String format(int[] dt) {
            return DateFormatOracle.this.formatInt(Math.abs(dt[0]), this.len);
        }
    }
}

