/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.input;

import java.util.Iterator;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.store.impl.StandaloneSequenceStore;
import kd.bos.algox.datachannel.mem.MemDataSetCache;

public class DataSetLocalCacheInput
implements Input {
    private static final long serialVersionUID = 4994848568634223232L;
    private RowMeta rowMeta;
    private String id;

    public DataSetLocalCacheInput(DataSet dataSet) {
        this.rowMeta = dataSet.getRowMeta();
        this.writeData(dataSet);
    }

    private void writeData(DataSet dataSet) {
        StandaloneSequenceStore store = new StandaloneSequenceStore(this.rowMeta);
        store.write((Iterator)dataSet);
        this.id = "localcache:" + UUID.randomUUID().toString().replace("-", "");
        MemDataSetCache.put((String)this.id, (AutoCloseable)store);
    }

    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    public String getId() {
        return this.id;
    }
}

