/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.input;

import kd.bos.algo.AlgoException;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class OrmInput
implements Input {
    private static final long serialVersionUID = -342283476069474203L;
    private RequestContext rc;
    private String algoKey;
    private String entityName;
    private String selectFields;
    private QFilter[] filters;
    private RowMeta rowMeta;

    public OrmInput(String algoKey, String entityName, String selectFields, QFilter[] filters) {
        this(algoKey, entityName, selectFields, filters, null);
    }

    public OrmInput(String algoKey, String entityName, String selectFields, QFilter[] filters, RowMeta rowMeta) {
        this.algoKey = algoKey;
        this.entityName = entityName;
        this.selectFields = selectFields;
        this.filters = filters;
        this.rowMeta = rowMeta == null ? ORM.create().createRowMeta(entityName, selectFields) : rowMeta;
        RequestContext r = RequestContext.get();
        if (r == null) {
            throw new AlgoException("RequestContext can't be null.");
        }
        this.rc = RequestContext.copy((RequestContext)r);
    }

    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    public RequestContext getRequestContext() {
        return this.rc;
    }

    public String getAlgoKey() {
        return this.algoKey;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getSelectFields() {
        return this.selectFields;
    }

    public QFilter[] getFilters() {
        return this.filters;
    }
}

