/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.input.executor;

import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.InputExecutor;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.RowFactory;
import kd.bos.algo.input.OrmInput;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;

public class OrmInputExecutor
extends InputExecutor<OrmInput> {
    private static final Log log = LogFactory.getLog(OrmInputExecutor.class);
    private transient DataSet dataSet;

    public OrmInputExecutor(OrmInput input) {
        super((Input)input, input.getRowMeta());
    }

    public void close() {
        if (this.dataSet != null) {
            try {
                this.dataSet.close();
            }
            catch (Throwable t) {
                log.error("error when close DataSet", t);
            }
        }
    }

    public Row next() {
        if (!this.dataSet.hasNext()) {
            return null;
        }
        Row row = this.dataSet.next();
        return this.convertRow(row);
    }

    public void open() {
        RequestContext.set((RequestContext)((OrmInput)this.input).getRequestContext());
        this.dataSet = ORM.create().queryDataSet(((OrmInput)this.input).getAlgoKey(), ((OrmInput)this.input).getEntityName(), ((OrmInput)this.input).getSelectFields(), ((OrmInput)this.input).getFilters());
    }

    public boolean hasNext() {
        return this.dataSet.hasNext();
    }

    protected Row convertRow(Row row) {
        if (this.dataTypes == null) {
            return row;
        }
        return RowFactory.createRow((RowMeta)this.rowMeta, (Object[])((AbstractRow)row).values());
    }
}

