/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap;

import java.io.Closeable;
import java.sql.SQLException;
import java.util.Iterator;
import kd.bos.algo.Input;
import kd.bos.algo.InputExecutor;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.input.BatchInputExecutorsRowIterator;
import kd.bos.algo.dataset.input.InputExecutorFactory;
import kd.bos.algo.dataset.input.InputExecutorRowIterator;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.RowIteratorTable;
import kd.bos.algo.olap.dbsource.Table;
import kd.bos.algo.olap.dbsource.TableManager;
import kd.bos.algo.olap.dbsource.TableProvider;

public class InputTableSource
extends TableProvider {
    private Input[] inputs;

    InputTableSource(TableManager manager, Input ... inputs) {
        super(manager);
        this.inputs = inputs;
    }

    public Table createTable() throws SQLException, OlapException {
        if (this.inputs.length == 1) {
            InputExecutorRowIterator iter = new InputExecutorRowIterator(InputExecutorFactory.create((Input)this.inputs[0]));
            return new RowIteratorTable(this.inputs[0].getRowMeta(), (Iterator<Row>)iter, (Closeable)iter);
        }
        InputExecutor[] executors = new InputExecutor[this.inputs.length];
        for (int i = 0; i < this.inputs.length; ++i) {
            executors[i] = InputExecutorFactory.create((Input)this.inputs[i]);
        }
        BatchInputExecutorsRowIterator iter = new BatchInputExecutorsRowIterator(executors);
        return new RowIteratorTable(this.inputs[0].getRowMeta(), (Iterator<Row>)iter, (Closeable)iter);
    }
}

