/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.dbsource.Table;

public class RowIteratorTable
implements Table {
    private Iterator<Row> iter;
    private RowMeta rowMeta;
    private Row row = null;
    private Closeable closer;

    public RowIteratorTable(RowMeta rowMeta, Iterator<Row> iter, Closeable closer) {
        this.rowMeta = rowMeta;
        this.iter = iter;
        this.closer = closer;
    }

    public int getColumnCount() throws OlapException {
        return this.rowMeta.getFieldCount();
    }

    public int getColumnType(int index) throws OlapException {
        return 0;
    }

    public int getColumnIndex(String name) throws OlapException {
        return this.rowMeta.getFieldIndex(name);
    }

    public String[] getColumnNames() throws OlapException {
        return this.rowMeta.getFieldNames();
    }

    public boolean next() throws OlapException {
        boolean b = this.iter.hasNext();
        this.row = b ? this.iter.next() : null;
        return b;
    }

    public Object getValue(int index) throws OlapException {
        return this.row.get(index);
    }

    public Object[] getValues() throws OlapException {
        return ((AbstractRow)this.row).values();
    }

    public void close() {
        if (this.closer != null) {
            try {
                this.closer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

