/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.cluster.client.local;

import kd.bos.algox.AlgoXException;
import kd.bos.algox.cluster.ClusterClient;
import kd.bos.algox.core.JobContext;
import kd.bos.algox.flink.cluster.ClusterClientMan;
import kd.bos.algox.flink.cluster.client.local.LocalConfigurationLoader;
import kd.bos.algox.flink.cluster.client.local.LocalMasterRuntimeContext;
import kd.bos.algox.flink.cluster.client.local.LocalMasterStarter;
import kd.bos.algox.flink.cluster.client.local.LocalWorkerStarter;
import kd.bos.algox.jobman.JobDetail;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;

public class LocalClusterClient
implements ClusterClient {
    public static LocalClusterClient instance = new LocalClusterClient();
    private long startingTime = System.currentTimeMillis();
    private boolean enable = true;
    private boolean started;

    public LocalClusterClient() {
        if ("false".equals(System.getProperty("algox.local.enable"))) {
            this.enable = false;
            return;
        }
        this.start();
    }

    private void start() {
        if (!this.started) {
            LocalMasterStarter.startup();
            LocalWorkerStarter.startup();
            this.started = true;
        }
    }

    private void ensureStart() {
        int max = 3000;
        if (System.currentTimeMillis() - this.startingTime < (long)max) {
            try {
                Thread.sleep(max - (int)(System.currentTimeMillis() - this.startingTime));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public Object submitJob(JobContext context, int timeoutSeconds) {
        if (!this.enable) {
            throw new AlgoXException("AlgoX local cluster disabled.");
        }
        this.ensureStart();
        Configuration configuration = LocalMasterRuntimeContext.getConfiguration();
        DispatcherGateway dispatcher = LocalMasterRuntimeContext.getDispatcherGateway();
        return ClusterClientMan.submitJob(context, configuration, dispatcher, timeoutSeconds, true);
    }

    public JobDetail getJobDetail(Object jobId) {
        DispatcherGateway dispatcher = LocalMasterRuntimeContext.getDispatcherGateway();
        return ClusterClientMan.getJobDetail(jobId, dispatcher);
    }

    public boolean isLocal() {
        return true;
    }

    public String getMonitorUrl() {
        return LocalConfigurationLoader.getWebUrl();
    }
}

