/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.cluster.client.local;

import java.io.IOException;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.NetAddressUtils;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.TaskManagerOptions;

public class LocalConfigurationLoader {
    private static final String KEY_masterPort = "algox.local.master.port";
    private static final String KEY_masterWebPort = "algox.local.master.webport";
    private static final String KEY_masterMemory = "algox.local.master.memory";
    private static final String KEY_masterJobStore_cacheSize = "algox.local.master.jobstore.cacheSize";
    private static final String KEY_masterJobStore_expireTime = "algox.local.master.jobstore.expireTime";
    private static final String KEY_workerMemory = "algox.local.worker.memory";
    private static final String KEY_workerSlots = "algox.local.worker.threads";
    private static final Configuration localConfiguration = LocalConfigurationLoader.getConfiguration();

    private static Configuration getConfiguration() {
        Integer masterWebPort;
        Integer masterPort = ConfigurationUtil.getInteger((String)KEY_masterPort);
        if (masterPort == null) {
            try {
                masterPort = NetAddressUtils.getAvailablePort((int)7749);
            }
            catch (IOException e) {
                masterPort = 7749;
            }
            System.setProperty(KEY_masterPort, masterPort.toString());
        }
        if ((masterWebPort = ConfigurationUtil.getInteger((String)KEY_masterWebPort)) == null) {
            int start = 7750 > masterPort ? 7750 : masterPort + 1;
            try {
                masterWebPort = NetAddressUtils.getAvailablePort((int)start);
            }
            catch (IOException e) {
                masterWebPort = 7750;
            }
            System.setProperty(KEY_masterWebPort, masterWebPort.toString());
        }
        Integer masterHeap = ConfigurationUtil.getInteger((String)KEY_masterMemory, (Integer)100);
        Long jobStore_cacheSize = ConfigurationUtil.getLong((String)KEY_masterJobStore_cacheSize, (Long)0xC800000L);
        Long jobStore_expireTime = ConfigurationUtil.getLong((String)KEY_masterJobStore_expireTime, (Long)86400L);
        Configuration configuration = new Configuration();
        configuration.setString((ConfigOption<String>)JobManagerOptions.ADDRESS, "localhost");
        configuration.setString((ConfigOption<String>)TaskManagerOptions.HOST, "localhost");
        configuration.setString("taskmanager.hostname", "localhost");
        configuration.setInteger((ConfigOption<Integer>)RestOptions.PORT, (int)masterWebPort);
        configuration.setInteger((ConfigOption<Integer>)JobManagerOptions.PORT, (int)masterPort);
        configuration.setInteger((ConfigOption<Integer>)JobManagerOptions.JOB_MANAGER_HEAP_MEMORY, (int)masterHeap);
        configuration.setLong((ConfigOption<Long>)JobManagerOptions.JOB_STORE_CACHE_SIZE, (long)jobStore_cacheSize);
        configuration.setLong((ConfigOption<Long>)JobManagerOptions.JOB_STORE_EXPIRATION_TIME, (long)jobStore_expireTime);
        Integer workerHeap = ConfigurationUtil.getInteger((String)KEY_workerMemory, (Integer)1024);
        Integer workerSlots = ConfigurationUtil.getInteger((String)KEY_workerSlots, (Integer)32);
        configuration.setLong((ConfigOption<Long>)TaskManagerOptions.MANAGED_MEMORY_SIZE, (long)workerHeap.intValue());
        configuration.setInteger((ConfigOption<Integer>)TaskManagerOptions.NUM_TASK_SLOTS, (int)workerSlots);
        return configuration;
    }

    public static Configuration loadMasterConfiguration() {
        return localConfiguration;
    }

    public static Configuration loadWorkerConfiguration() {
        return localConfiguration;
    }

    public static int getWebPort() {
        return localConfiguration.getInteger((ConfigOption<Integer>)RestOptions.PORT);
    }

    public static String getWebUrl() {
        return "http://localhost:" + LocalConfigurationLoader.getWebPort();
    }
}

