/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.cluster.client.local;

import kd.bos.algox.flink.cluster.client.local.LocalConfigurationLoader;
import kd.bos.algox.flink.cluster.client.local.LocalMasterRuntimeContext;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.dispatcher.ArchivedExecutionGraphStore;
import org.apache.flink.runtime.dispatcher.Dispatcher;
import org.apache.flink.runtime.dispatcher.HistoryServerArchivist;
import org.apache.flink.runtime.entrypoint.ClusterConfiguration;
import org.apache.flink.runtime.entrypoint.StandaloneSessionClusterEntrypoint;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.metrics.groups.JobManagerMetricGroup;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.SignalHandler;
import org.slf4j.Logger;

public class LocalMasterStarter
extends StandaloneSessionClusterEntrypoint {
    public LocalMasterStarter(Configuration configuration) {
        super(configuration);
    }

    public void onFatalError(Throwable exception) {
        LOG.error("Fatal error occurred in the flink master.", exception);
    }

    protected Dispatcher createDispatcher(Configuration configuration, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, ResourceManagerGateway resourceManagerGateway, BlobServer blobServer, HeartbeatServices heartbeatServices, JobManagerMetricGroup jobManagerMetricGroup, String metricQueryServicePath, ArchivedExecutionGraphStore archivedExecutionGraphStore, FatalErrorHandler fatalErrorHandler, String restAddress, HistoryServerArchivist historyServerArchivist) throws Exception {
        Dispatcher dispatcher = super.createDispatcher(configuration, rpcService, highAvailabilityServices, resourceManagerGateway, blobServer, heartbeatServices, jobManagerMetricGroup, metricQueryServicePath, archivedExecutionGraphStore, fatalErrorHandler, restAddress, historyServerArchivist);
        LocalMasterRuntimeContext.setDispatcherGateway(dispatcher);
        return dispatcher;
    }

    protected static Configuration loadConfiguration(ClusterConfiguration clusterConfiguration) {
        Configuration configuration = GlobalConfiguration.loadConfiguration((String)clusterConfiguration.getConfigDir());
        int restPort = clusterConfiguration.getRestPort();
        if (restPort >= 0) {
            configuration.setInteger((ConfigOption<Integer>)RestOptions.PORT, restPort);
        }
        return configuration;
    }

    public static void startup() {
        EnvironmentInformation.logEnvironmentInfo((Logger)LOG, (String)LocalMasterStarter.class.getSimpleName(), (String[])new String[0]);
        SignalHandler.register((Logger)LOG);
        JvmShutdownSafeguard.installAsShutdownHook((Logger)LOG);
        Configuration configuration = LocalConfigurationLoader.loadMasterConfiguration();
        LocalMasterStarter entrypoint = new LocalMasterStarter(configuration);
        entrypoint.startCluster();
        LocalMasterRuntimeContext.setConfiguration(configuration);
    }
}

