/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.cluster.client.local;

import java.io.IOException;
import java.util.concurrent.Callable;
import kd.bos.algo.AlgoException;
import kd.bos.algox.flink.cluster.client.local.LocalConfigurationLoader;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.taskexecutor.TaskManagerRunner;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.SignalHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalWorkerStarter
extends TaskManagerRunner {
    private static final Logger LOG = LoggerFactory.getLogger(LocalWorkerStarter.class);

    public LocalWorkerStarter(Configuration configuration, ResourceID resourceId) throws Exception {
        super(configuration, resourceId);
    }

    @Override
    public void onFatalError(Throwable exception) {
        LOG.error("Fatal error occurred while executing the TaskManager in flink worker.", exception);
    }

    public static void startup() {
        EnvironmentInformation.logEnvironmentInfo((Logger)LOG, (String)"TaskManager", (String[])new String[0]);
        SignalHandler.register((Logger)LOG);
        JvmShutdownSafeguard.installAsShutdownHook((Logger)LOG);
        long maxOpenFileHandles = EnvironmentInformation.getOpenFileHandlesLimit();
        if (maxOpenFileHandles != -1L) {
            LOG.info("Maximum number of open file descriptors is {}.", (Object)maxOpenFileHandles);
        } else {
            LOG.info("Cannot determine the maximum number of open file descriptors");
        }
        final Configuration configuration = LocalConfigurationLoader.loadWorkerConfiguration();
        try {
            FileSystem.initialize(configuration);
        }
        catch (IOException t) {
            throw new AlgoException("Error while setting the default filesystem scheme from configuration.", (Throwable)t);
        }
        try {
            SecurityUtils.install((SecurityConfiguration)new SecurityConfiguration(configuration));
            SecurityUtils.getInstalledContext().runSecured(new Callable(){

                public Void call() throws Exception {
                    TaskManagerRunner.runTaskManager(configuration, ResourceID.generate());
                    return null;
                }
            });
        }
        catch (Throwable t) {
            LOG.error("TaskManager initialization failed.", t);
        }
    }
}

