/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.cluster.client.remote;

import kd.bos.algox.cluster.ClusterClient;
import kd.bos.algox.core.JobContext;
import kd.bos.algox.flink.cluster.ClusterClientMan;
import kd.bos.algox.flink.rpc.MasterRpcService;
import kd.bos.algox.flink.utils.ObjectSerde;
import kd.bos.algox.jobman.JobDetail;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.service.register.ServiceRegister;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.jobgraph.JobGraph;

public class RemoteClusterClient
implements ClusterClient {
    public static RemoteClusterClient instance = new RemoteClusterClient();
    private static final String APPID = "bos";

    public Object submitJob(JobContext context, int timeoutSeconds) {
        MasterRpcService service = (MasterRpcService)ServiceLookup.lookup(MasterRpcService.class, (String)APPID);
        Configuration configuration = service.getMasterConfiguration();
        JobGraph jobGraph = ClusterClientMan.createJobGraph(context, configuration);
        jobGraph.getJobConfiguration().setBoolean("disableLocalModel", true);
        byte[] bytes = ObjectSerde.toBytes(jobGraph);
        return service.submitJob(bytes, timeoutSeconds);
    }

    public JobDetail getJobDetail(Object jobId) {
        MasterRpcService service = (MasterRpcService)ServiceLookup.lookup(MasterRpcService.class, (String)APPID);
        return service.getJobDetail(jobId);
    }

    public boolean isLocal() {
        return false;
    }

    public String getMonitorUrl() {
        MasterRpcService service = (MasterRpcService)ServiceLookup.lookup(MasterRpcService.class, (String)APPID);
        Configuration configuration = service.getMasterConfiguration();
        String host = configuration.getString((ConfigOption<String>)JobManagerOptions.ADDRESS);
        int port = configuration.getInteger((ConfigOption<Integer>)RestOptions.PORT);
        return "http://" + host + ":" + port;
    }

    static {
        ServiceRegister.registerConsumer((String)"MasterRpcService", (String)"interface=kd.bos.algox.flink.rpc.MasterRpcService");
    }
}

