/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.cluster.master;

import kd.bos.algo.AlgoException;
import kd.bos.instance.Instance;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.NetAddressUtils;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RestOptions;

public class MasterConfig {
    private static final String KEY_masterJobStore_cacheSize = "algox.master.jobstore.cacheSize";
    private static final String KEY_masterJobStore_expireTime = "algox.master.jobstore.expireTime";
    private static Configuration configuration = MasterConfig.getConfiguration();
    private static String webUrl;

    public static Configuration loadConfiguration() {
        return configuration;
    }

    private static Configuration getConfiguration() {
        String clusterId = ConfigurationUtil.getString((String)"algox.cluster.name", (String)Instance.getClusterName());
        String zookeeper = ConfigurationUtil.getString((String)"algox.cluster.zookeeper");
        if (zookeeper == null) {
            throw new AlgoException("algox.cluster.zookeeper can't be null.");
        }
        String storageDir = ConfigurationUtil.getString((String)"algox.cluster.storageDir");
        if (storageDir == null) {
            storageDir = System.getProperty("java.io.tmpdir");
        }
        Integer masterWebPort = ConfigurationUtil.getInteger((String)"algox.master.webport", (Integer)7760);
        Integer masterHeap = ConfigurationUtil.getInteger((String)"algox.master.memory", (Integer)100);
        Configuration configuration = new Configuration();
        configuration.setInteger((ConfigOption<Integer>)RestOptions.PORT, (int)masterWebPort);
        configuration.setString((ConfigOption<String>)HighAvailabilityOptions.HA_CLUSTER_ID, clusterId);
        configuration.setString((ConfigOption<String>)HighAvailabilityOptions.HA_MODE, "zookeeper");
        configuration.setString((ConfigOption<String>)HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, zookeeper);
        configuration.setString((ConfigOption<String>)HighAvailabilityOptions.HA_STORAGE_PATH, storageDir);
        configuration.setInteger((ConfigOption<Integer>)JobManagerOptions.JOB_MANAGER_HEAP_MEMORY, (int)masterHeap);
        Long jobStore_cacheSize = ConfigurationUtil.getLong((String)KEY_masterJobStore_cacheSize, (Long)0xC800000L);
        Long jobStore_expireTime = ConfigurationUtil.getLong((String)KEY_masterJobStore_expireTime, (Long)86400L);
        configuration.setLong((ConfigOption<Long>)JobManagerOptions.JOB_STORE_CACHE_SIZE, (long)jobStore_cacheSize);
        configuration.setLong((ConfigOption<Long>)JobManagerOptions.JOB_STORE_EXPIRATION_TIME, (long)jobStore_expireTime);
        String host = NetAddressUtils.getLocalIpAddress();
        if (host != null) {
            configuration.setString((ConfigOption<String>)JobManagerOptions.ADDRESS, host);
        }
        webUrl = "http://" + host + ":" + masterWebPort;
        return configuration;
    }

    public String getWebUrl() {
        return webUrl;
    }
}

