/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.cluster.master;

import java.util.concurrent.Executor;
import kd.bos.algox.flink.cluster.master.MasterConfig;
import kd.bos.algox.flink.cluster.master.MasterRuntimeContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.register.ServiceRegister;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.TransientBlobService;
import org.apache.flink.runtime.dispatcher.ArchivedExecutionGraphStore;
import org.apache.flink.runtime.dispatcher.Dispatcher;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.dispatcher.DispatcherRestEndpoint;
import org.apache.flink.runtime.dispatcher.HistoryServerArchivist;
import org.apache.flink.runtime.entrypoint.ClusterConfiguration;
import org.apache.flink.runtime.entrypoint.StandaloneSessionClusterEntrypoint;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.metrics.groups.JobManagerMetricGroup;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.SignalHandler;
import org.apache.flink.runtime.webmonitor.retriever.LeaderGatewayRetriever;
import org.apache.flink.runtime.webmonitor.retriever.MetricQueryServiceRetriever;
import org.slf4j.Logger;

public class MasterStarter
extends StandaloneSessionClusterEntrypoint {
    private static Log log = LogFactory.getLog(MasterStarter.class);
    private static boolean started;

    public MasterStarter(Configuration configuration) {
        super(configuration);
    }

    public void onFatalError(Throwable exception) {
        exception.printStackTrace();
        log.error("Fatal error occurred in the flink master.", exception);
    }

    protected DispatcherRestEndpoint createRestEndpoint(Configuration configuration, LeaderGatewayRetriever<DispatcherGateway> dispatcherGatewayRetriever, LeaderGatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever, TransientBlobService transientBlobService, Executor executor, MetricQueryServiceRetriever metricQueryServiceRetriever, LeaderElectionService leaderElectionService) throws Exception {
        DispatcherRestEndpoint ret = super.createRestEndpoint(configuration, dispatcherGatewayRetriever, resourceManagerGatewayRetriever, transientBlobService, executor, metricQueryServiceRetriever, leaderElectionService);
        MasterRuntimeContext.setDispatcherGatewayRetriever(dispatcherGatewayRetriever);
        return ret;
    }

    protected Dispatcher createDispatcher(Configuration configuration, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, ResourceManagerGateway resourceManagerGateway, BlobServer blobServer, HeartbeatServices heartbeatServices, JobManagerMetricGroup jobManagerMetricGroup, String metricQueryServicePath, ArchivedExecutionGraphStore archivedExecutionGraphStore, FatalErrorHandler fatalErrorHandler, String restAddress, HistoryServerArchivist historyServerArchivist) throws Exception {
        Dispatcher dispatcher = super.createDispatcher(configuration, rpcService, highAvailabilityServices, resourceManagerGateway, blobServer, heartbeatServices, jobManagerMetricGroup, metricQueryServicePath, archivedExecutionGraphStore, fatalErrorHandler, restAddress, historyServerArchivist);
        MasterRuntimeContext.setDispatcherGateway(dispatcher);
        return dispatcher;
    }

    protected static Configuration loadConfiguration(ClusterConfiguration clusterConfiguration) {
        Configuration configuration = GlobalConfiguration.loadConfiguration((String)clusterConfiguration.getConfigDir());
        int restPort = clusterConfiguration.getRestPort();
        if (restPort >= 0) {
            configuration.setInteger((ConfigOption<Integer>)RestOptions.PORT, restPort);
        }
        return configuration;
    }

    public static void startup() {
        if (!MasterRuntimeContext.isEnable()) {
            log.warn("Algox master is disabled.");
            return;
        }
        if (started) {
            return;
        }
        started = true;
        ServiceRegister.registerService((String)"MasterRpcService", (String)"interface=kd.bos.algox.flink.rpc.MasterRpcService\nclass=kd.bos.algox.flink.rpc.MasterRpcServiceImpl");
        EnvironmentInformation.logEnvironmentInfo((Logger)LOG, (String)MasterStarter.class.getSimpleName(), (String[])new String[0]);
        SignalHandler.register((Logger)LOG);
        JvmShutdownSafeguard.installAsShutdownHook((Logger)LOG);
        Configuration configuration = MasterConfig.loadConfiguration();
        MasterStarter entrypoint = new MasterStarter(configuration);
        MasterRuntimeContext.setConfiguration(configuration);
        entrypoint.startCluster();
    }
}

