/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.cluster.worker;

import kd.bos.algo.AlgoException;
import kd.bos.instance.Instance;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.NetAddressUtils;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.TaskManagerOptions;

public class WorkerConfig {
    public static Configuration loadConfiguration() {
        String clusterId = ConfigurationUtil.getString((String)"algox.cluster.name", (String)Instance.getClusterName());
        String zookeeper = ConfigurationUtil.getString((String)"algox.cluster.zookeeper");
        if (zookeeper == null) {
            throw new AlgoException("algox.cluster.zookeeper can't be null.");
        }
        String storageDir = ConfigurationUtil.getString((String)"algox.cluster.storageDir");
        if (storageDir == null) {
            storageDir = System.getProperty("java.io.tmpdir");
        }
        Configuration configuration = new Configuration();
        configuration.setString((ConfigOption<String>)HighAvailabilityOptions.HA_CLUSTER_ID, clusterId);
        configuration.setString((ConfigOption<String>)HighAvailabilityOptions.HA_MODE, "zookeeper");
        configuration.setString((ConfigOption<String>)HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, zookeeper);
        configuration.setString((ConfigOption<String>)HighAvailabilityOptions.HA_STORAGE_PATH, storageDir);
        Integer workerHeap = ConfigurationUtil.getInteger((String)"algox.worker.memory", (Integer)1024);
        Integer workerSlots = ConfigurationUtil.getInteger((String)"algox.worker.threads", (Integer)32);
        configuration.setLong((ConfigOption<Long>)TaskManagerOptions.MANAGED_MEMORY_SIZE, (long)workerHeap.intValue());
        configuration.setInteger((ConfigOption<Integer>)TaskManagerOptions.NUM_TASK_SLOTS, (int)workerSlots);
        String host = NetAddressUtils.getLocalIpAddress();
        if (host != null) {
            configuration.setString((ConfigOption<String>)TaskManagerOptions.HOST, host);
            configuration.setString("taskmanager.hostname", host);
        }
        return configuration;
    }
}

