/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.core;

import kd.bos.algox.core.JobContext;
import kd.bos.algox.flink.core.FakeEnvironment;
import kd.bos.algox.flink.core.translate.Translate;
import kd.bos.context.RequestContext;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.Optimizer;
import org.apache.flink.optimizer.costs.CostEstimator;
import org.apache.flink.optimizer.costs.DefaultCostEstimator;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plantranslate.JobGraphGenerator;
import org.apache.flink.runtime.jobgraph.JobGraph;

public class JobGraphTranslate {
    public static JobGraph translate(JobContext context, Configuration configuration) {
        Optimizer optimizer = new Optimizer(new DataStatistics(), (CostEstimator)new DefaultCostEstimator(), configuration);
        FakeEnvironment env = new FakeEnvironment(optimizer);
        env.setParallelism(context.getParallelism());
        Translate.translate((ExecutionEnvironment)env, context.getDataSinks());
        OptimizedPlan plan = env.getOptimizedPlan(context.getJobName());
        JobGraphGenerator jobGraphGenerator = new JobGraphGenerator(configuration);
        JobGraph jobGraph = jobGraphGenerator.compileJobGraph(plan);
        jobGraph.setAllowQueuedScheduling(true);
        RequestContext rc = RequestContext.get();
        if (rc != null) {
            rc = RequestContext.copy((RequestContext)rc);
            jobGraph.getJobConfiguration().put("requestContext", rc);
        }
        return jobGraph;
    }
}

