/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.core.inout;

import java.io.IOException;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataType;
import kd.bos.algox.RowX;
import kd.bos.algox.flink.type.TypeUtil;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.PreparedBatch;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.flink.api.common.io.RichOutputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.configuration.Configuration;

public class DBOutputFormat
extends RichOutputFormat<RowX>
implements ResultTypeQueryable<RowX> {
    private static final long serialVersionUID = -2821686075873207315L;
    private static final Log LOG = LogFactory.getLog(DBOutputFormat.class);
    private static final int DEFAULT_BATCH_INTERVAL = 5000;
    private int batchCount = 0;
    private RequestContext rc;
    private String sql;
    private PreparedBatch batch;
    private int[] sqlTypes;
    private int batchInterval = 5000;
    private String routeKey;
    private DataType[] dataTypes;
    private boolean needTx;
    private TXHandle tx;

    public DBOutputFormat(RequestContext rc, String routeKey, String sql) {
        this.routeKey = routeKey;
        this.sql = sql;
        this.rc = rc;
    }

    public void setDataTypes(DataType[] dataTypes) {
        this.dataTypes = dataTypes;
        this.sqlTypes = DBOutputFormat.convertToSqlTypes(dataTypes);
    }

    public void setSqlTypes(int[] sqlTypes) {
        this.sqlTypes = sqlTypes;
    }

    public void setBatchInterval(int batchInterval) {
        if (batchInterval > 100) {
            this.batchInterval = batchInterval;
        }
    }

    public void setRequestContext(RequestContext rc) {
        this.rc = rc;
    }

    public DataType[] getDataTypes() {
        return this.dataTypes;
    }

    private static int[] convertToSqlTypes(DataType[] dataTypes) {
        int[] sqlTypes = new int[dataTypes.length];
        for (int i = 0; i < sqlTypes.length; ++i) {
            sqlTypes[i] = DataType.toSqlType((DataType)dataTypes[i]);
        }
        return sqlTypes;
    }

    public void close() throws IOException {
        RequestContext.set(null);
        if (this.batch != null) {
            this.flush();
            try {
                this.batch.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.batch = null;
        }
        if (this.tx != null) {
            this.tx.close();
            this.tx = null;
        }
    }

    public void configure(Configuration configuration) {
    }

    public void open(int arg0, int arg1) throws IOException {
        RequestContext.set((RequestContext)this.rc);
        if (this.needTx) {
            this.tx = TX.required((String)"AlgoX.DBOutput");
        }
        this.batch = DB.prepareBatch((DBRoute)DBRoute.of((String)this.routeKey), (String)this.sql);
    }

    public void writeRecord(RowX out) throws IOException {
        for (int i = 0; i < out.size(); ++i) {
            if (this.sqlTypes == null) {
                this.batch.setParam(i, out.get(i));
                continue;
            }
            this.batch.setParam(i, (Object)new SqlParameter(this.sqlTypes[i], out.get(i)));
        }
        this.batch.addBatch();
        ++this.batchCount;
        if (this.batchCount >= this.batchInterval) {
            this.flush();
        }
    }

    void flush() {
        this.batch.executeBatch();
        this.batchCount = 0;
    }

    public TypeInformation<RowX> getProducedType() {
        if (this.dataTypes == null) {
            throw new AlgoException("dataTypes needs, please setDataTypes first.");
        }
        return TypeUtil.toRowXType((DataType[])this.dataTypes);
    }

    public void setNeedTx(boolean needTx) {
        this.needTx = needTx;
    }
}

