/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.core.myfunc;

import java.util.Arrays;
import kd.bos.algo.RowMeta;
import kd.bos.algo.util.Aggregator;
import kd.bos.algox.RowX;
import kd.bos.algox.core.AggField;
import kd.bos.algox.flink.type.RowXTypeInfo;
import kd.bos.algox.flink.type.TypeUtil;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Collector;

public class MyAggregatorFunction
extends RichGroupReduceFunction<RowX, RowX>
implements ResultTypeQueryable<RowX>,
GroupCombineFunction<RowX, RowX> {
    private static final long serialVersionUID = 1L;
    private RowXTypeInfo typeInfo;
    private Aggregator[] aggregators;
    private int[] fieldPositions;
    private AggField[] aggFields;

    public MyAggregatorFunction(RowMeta sourceMeta, RowMeta rowMeta, AggField[] aggFields) {
        this.aggFields = aggFields;
        this.typeInfo = TypeUtil.toRowXType((RowMeta)rowMeta);
        this.fieldPositions = new int[aggFields.length];
        for (int i = 0; i < aggFields.length; ++i) {
            this.fieldPositions[i] = sourceMeta.getFieldIndex(aggFields[i].field);
        }
    }

    public TypeInformation<RowX> getProducedType() {
        return this.typeInfo;
    }

    public void open(Configuration parameters) throws Exception {
        this.aggregators = new Aggregator[this.aggFields.length];
        for (int i = 0; i < this.aggFields.length; ++i) {
            this.aggregators[i] = Aggregator.getAggregator((String)this.aggFields[i].getFuncName());
        }
    }

    public void reduce(Iterable<RowX> iter, Collector<RowX> collector) throws Exception {
        Object[] retValues = null;
        for (RowX row : iter) {
            int i;
            if (retValues == null) {
                retValues = Arrays.copyOf(row.values(), row.values().length);
                for (i = 0; i < this.aggregators.length; ++i) {
                    retValues[this.fieldPositions[i]] = null;
                }
            }
            for (i = 0; i < this.aggregators.length; ++i) {
                retValues[this.fieldPositions[i]] = this.aggregators[i].appendValue(retValues[this.fieldPositions[i]], row.get(this.fieldPositions[i]));
            }
        }
        for (int i = 0; i < this.aggregators.length; ++i) {
            retValues[this.fieldPositions[i]] = this.aggregators[i].getValue(retValues[this.fieldPositions[i]]);
        }
        collector.collect((Object)new RowX(retValues));
    }

    public void combine(Iterable<RowX> iter, Collector<RowX> collector) throws Exception {
        if (this.hasCount()) {
            for (RowX row : iter) {
                collector.collect((Object)row);
            }
        } else {
            this.reduce(iter, collector);
        }
    }

    private boolean hasCount() {
        for (AggField field : this.aggFields) {
            if (1 != field.func) continue;
            return true;
        }
        return false;
    }
}

