/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.core.translate;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.DataSetX;
import kd.bos.algox.Grouper;
import kd.bos.algox.RowX;
import kd.bos.algox.core.AbstractDataSetX;
import kd.bos.algox.core.AggField;
import kd.bos.algox.core.AggregatorDataSetX;
import kd.bos.algox.flink.core.myfunc.MyAggregatorFunction;
import kd.bos.algox.flink.core.myfunc.MySelectMapFunction;
import kd.bos.algox.flink.core.translate.Translate;
import kd.bos.algox.flink.core.translate.Translator;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.MapOperator;

public class AggregatorTranslator
extends Translator<AggregatorDataSetX> {
    public AggregatorTranslator(AggregatorDataSetX source) {
        super(source);
    }

    @Override
    public DataSet<RowX> go(ExecutionEnvironment env, Map<DataSetX, DataSet<RowX>> dup) {
        GroupReduceOperator operator;
        AbstractDataSetX xs = (AbstractDataSetX)((AggregatorDataSetX)this.x).getSource();
        DataSet<RowX> source = Translate.translateDataSet(env, (DataSetX)xs, dup);
        RowMeta sourceRowMeta = xs.getRowMeta();
        ArrayList<Field> selectFields = new ArrayList<Field>();
        Grouper groupBy = ((AggregatorDataSetX)this.x).getGroupBy();
        if (groupBy != null && groupBy.getFields() != null) {
            String[] groupFields;
            for (String s : groupFields = ((AggregatorDataSetX)this.x).getGroupBy().getFields()) {
                selectFields.add(sourceRowMeta.getField(s));
            }
        }
        for (AggField field : ((AggregatorDataSetX)this.x).getAggFieldList()) {
            selectFields.add(sourceRowMeta.getField(field.field));
        }
        Field[] fields = selectFields.toArray(new Field[0]);
        RowMeta selectRowMeta = new RowMeta(fields);
        MySelectMapFunction selectFunc = new MySelectMapFunction(selectRowMeta, xs.getRowMeta());
        MapOperator dataset = source.map((MapFunction)selectFunc);
        dataset.name("Aggregation(1) at " + ((AggregatorDataSetX)this.x).getLocation());
        MyAggregatorFunction func = new MyAggregatorFunction(selectRowMeta, ((AggregatorDataSetX)this.x).getRowMeta(), ((AggregatorDataSetX)this.x).getAggFieldList().toArray(new AggField[0]));
        if (groupBy != null && groupBy.getFields() != null) {
            int[] indexes = new int[groupBy.getFields().length];
            for (int i = 0; i < indexes.length; ++i) {
                indexes[i] = i;
            }
            operator = dataset.groupBy(indexes).reduceGroup((GroupReduceFunction)func);
        } else {
            operator = dataset.reduceGroup((GroupReduceFunction)func);
        }
        operator.name("Aggregation(2) at " + ((AggregatorDataSetX)this.x).getLocation());
        return operator;
    }
}

