/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.core.translate;

import kd.bos.algo.AlgoException;
import kd.bos.algo.CustomizedOutput;
import kd.bos.algo.Output;
import kd.bos.algo.RowMeta;
import kd.bos.algo.output.DataSetCacheOutput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algo.output.DbOutput;
import kd.bos.algo.output.IgnoreOutput;
import kd.bos.algo.output.PrintOutput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.RowX;
import kd.bos.algox.flink.core.inout.CustomizedOutputFormat;
import kd.bos.algox.flink.core.inout.DBOutputFormat;
import kd.bos.algox.flink.core.inout.DataChannelOutputFormat;
import kd.bos.algox.flink.core.inout.DataSetCacheOutputFormat;
import kd.bos.algox.flink.core.inout.IgnoreOutputFormat;
import kd.bos.algox.flink.core.inout.PrintOutputFormat;
import kd.bos.algox.flink.core.inout.SingleCustomizedOutputFormat;
import kd.bos.algox.flink.core.inout.SingleDBOutputFormat;
import org.apache.flink.api.common.io.RichOutputFormat;

public class OutputTranslate {
    public static RichOutputFormat<RowX> translate(DataSetX source, Output output) {
        if (output instanceof DbOutput) {
            return OutputTranslate.translateDB(source, (DbOutput)output);
        }
        if (output instanceof DataSetOutput) {
            return OutputTranslate.translateDataSet(source, (DataSetOutput)output);
        }
        if (output instanceof DataSetCacheOutput) {
            return OutputTranslate.translateDataSetCache(source, (DataSetCacheOutput)output);
        }
        if (output instanceof PrintOutput) {
            return OutputTranslate.translatePrint(source, (PrintOutput)output);
        }
        if (output instanceof IgnoreOutput) {
            return OutputTranslate.translateIgnore(source, (IgnoreOutput)output);
        }
        if (output instanceof CustomizedOutput) {
            return OutputTranslate.translateCustomized(source, (CustomizedOutput)output);
        }
        throw new AlgoException("Unimplements output type: " + output.getClass());
    }

    private static RichOutputFormat<RowX> translateCustomized(DataSetX source, CustomizedOutput output) {
        if (output.isSingleParallel()) {
            return new SingleCustomizedOutputFormat(output);
        }
        return new CustomizedOutputFormat(output);
    }

    private static RichOutputFormat<RowX> translateIgnore(DataSetX source, IgnoreOutput output) {
        return new IgnoreOutputFormat(source.getRowMeta());
    }

    private static RichOutputFormat<RowX> translatePrint(DataSetX source, PrintOutput output) {
        return new PrintOutputFormat(source.getRowMeta());
    }

    private static RichOutputFormat<RowX> translateDataSet(DataSetX source, DataSetOutput output) {
        RowMeta rowMeta = output.getRowMeta();
        if (rowMeta == null) {
            rowMeta = source.getRowMeta();
        }
        return new DataChannelOutputFormat(rowMeta, output.getId());
    }

    private static RichOutputFormat<RowX> translateDataSetCache(DataSetX source, DataSetCacheOutput output) {
        RowMeta rowMeta = output.getRowMeta();
        if (rowMeta == null) {
            rowMeta = source.getRowMeta();
        }
        DataSetCacheOutputFormat outputFormat = new DataSetCacheOutputFormat(rowMeta, output.getId(), output.getCacheHint());
        return outputFormat;
    }

    private static RichOutputFormat<RowX> translateDB(DataSetX source, DbOutput output) {
        RowMeta rowMeta = output.getRowMeta();
        if (rowMeta == null) {
            rowMeta = source.getRowMeta();
        }
        DBOutputFormat dbo = null;
        dbo = output.isSingleParallel() ? new SingleDBOutputFormat(output.getRequestContext(), output.getRouteKey(), output.getSql()) : new DBOutputFormat(output.getRequestContext(), output.getRouteKey(), output.getSql());
        dbo.setNeedTx(output.isNeedTx());
        dbo.setBatchInterval(output.getBatchInterval());
        dbo.setDataTypes(rowMeta.getDataTypes());
        if (output.getSqlTypes() != null) {
            dbo.setSqlTypes(output.getSqlTypes());
        }
        return dbo;
    }
}

