/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.hack.io.network;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.algox.AlgoXException;
import org.apache.flink.runtime.hack.io.network.DataQueue;

public class BlockingDataQueue
implements DataQueue {
    private BlockingQueue<Object> bq;
    private AtomicBoolean finished = new AtomicBoolean(false);
    private volatile boolean fetchEof;

    public BlockingDataQueue(int size) {
        this(new LinkedBlockingQueue<Object>(size));
    }

    public BlockingDataQueue(BlockingQueue<Object> bq) {
        this.bq = bq;
    }

    @Override
    public boolean offer(Object row, long timeout, TimeUnit unit) {
        if (this.finished.get()) {
            throw new AlgoXException("Can't put row when finished.");
        }
        try {
            return this.bq.offer(row, timeout, unit);
        }
        catch (InterruptedException e) {
            throw new AlgoXException("Can't put row because of been Interupted.", (Throwable)e);
        }
    }

    @Override
    public Object poll(long timeout, TimeUnit unit) {
        if (this.fetchEof) {
            return null;
        }
        if (this.finished.get()) {
            if (this.bq.size() > 0) {
                return this.bq.poll();
            }
            this.fetchEof = true;
            return null;
        }
        try {
            return this.bq.poll(timeout, unit);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public void finish() {
        this.finished.set(true);
    }

    @Override
    public boolean isFinished() {
        return this.finished.get();
    }

    public boolean isFetchEof() {
        return this.fetchEof;
    }

    public void clear() {
        this.bq.clear();
        this.finished.set(true);
    }

    @Override
    public int size() {
        return this.bq.size();
    }
}

