/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.hack.io.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.flink.runtime.hack.io.network.DataTransfer;

public class DataTarget {
    private final BlockingQueue<Object> queue;
    private List<DataTransfer> sourceList = Collections.synchronizedList(new ArrayList());
    private boolean finished;

    public DataTarget(int capacity) {
        this.queue = new LinkedBlockingQueue<Object>(capacity);
    }

    public boolean offer(Object o, long timeout, TimeUnit unit) throws InterruptedException {
        return this.queue.offer(o, timeout, unit);
    }

    public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.queue.poll(timeout, unit);
    }

    public void addSource(DataTransfer dataTransfer) {
        this.sourceList.add(dataTransfer);
    }

    public void removeSource(DataTransfer dataTransfer) {
        this.sourceList.remove(dataTransfer);
        if (this.sourceList.isEmpty()) {
            this.finished = true;
        }
    }

    public boolean isFinished() {
        return this.finished;
    }
}

