/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.flink.runtime.io.network.netty.NettyBufferPool;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.io.network.netty.NettyProtocol;
import org.apache.flink.runtime.io.network.netty.NettyServer;
import org.apache.flink.shaded.netty4.io.netty.bootstrap.Bootstrap;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelException;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelFuture;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInitializer;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelOption;
import org.apache.flink.shaded.netty4.io.netty.channel.EventLoopGroup;
import org.apache.flink.shaded.netty4.io.netty.channel.epoll.Epoll;
import org.apache.flink.shaded.netty4.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.flink.shaded.netty4.io.netty.channel.epoll.EpollSocketChannel;
import org.apache.flink.shaded.netty4.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.flink.shaded.netty4.io.netty.channel.socket.SocketChannel;
import org.apache.flink.shaded.netty4.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.SslHandler;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NettyClient {
    private static final Logger LOG = LoggerFactory.getLogger(NettyClient.class);
    private final NettyConfig config;
    private NettyProtocol protocol;
    private Bootstrap bootstrap;
    private SSLContext clientSSLContext = null;

    NettyClient(NettyConfig config) {
        this.config = config;
    }

    void init(NettyProtocol protocol, NettyBufferPool nettyBufferPool) throws IOException {
        Preconditions.checkState((this.bootstrap == null ? 1 : 0) != 0, (Object)"Netty client has already been initialized.");
        this.protocol = protocol;
        long start = System.currentTimeMillis();
        this.bootstrap = new Bootstrap();
        switch (this.config.getTransportType()) {
            case NIO: {
                this.initNioBootstrap();
                break;
            }
            case EPOLL: {
                this.initEpollBootstrap();
                break;
            }
            case AUTO: {
                if (Epoll.isAvailable()) {
                    this.initEpollBootstrap();
                    LOG.info("Transport type 'auto': using EPOLL.");
                    break;
                }
                this.initNioBootstrap();
                LOG.info("Transport type 'auto': using NIO.");
            }
        }
        this.bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)(this.config.getClientConnectTimeoutSeconds() * 1000));
        this.bootstrap.option(ChannelOption.ALLOCATOR, (Object)nettyBufferPool);
        int receiveAndSendBufferSize = this.config.getSendAndReceiveBufferSize();
        if (receiveAndSendBufferSize > 0) {
            this.bootstrap.option(ChannelOption.SO_SNDBUF, (Object)receiveAndSendBufferSize);
            this.bootstrap.option(ChannelOption.SO_RCVBUF, (Object)receiveAndSendBufferSize);
        }
        try {
            this.clientSSLContext = this.config.createClientSSLContext();
        }
        catch (Exception e) {
            throw new IOException("Failed to initialize SSL Context for the Netty client", e);
        }
        long end = System.currentTimeMillis();
        LOG.info("Successful initialization (took {} ms).", (Object)(end - start));
    }

    NettyConfig getConfig() {
        return this.config;
    }

    Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    void shutdown() {
        long start = System.currentTimeMillis();
        if (this.bootstrap != null) {
            if (this.bootstrap.group() != null) {
                this.bootstrap.group().shutdownGracefully();
            }
            this.bootstrap = null;
        }
        long end = System.currentTimeMillis();
        LOG.info("Successful shutdown (took {} ms).", (Object)(end - start));
    }

    private void initNioBootstrap() {
        String name = "Flink Netty Client (" + this.config.getServerPort() + ")";
        NioEventLoopGroup nioGroup = new NioEventLoopGroup(this.config.getClientNumThreads(), NettyServer.getNamedThreadFactory(name));
        ((Bootstrap)this.bootstrap.group((EventLoopGroup)nioGroup)).channel(NioSocketChannel.class);
    }

    private void initEpollBootstrap() {
        String name = "Flink Netty Client (" + this.config.getServerPort() + ")";
        EpollEventLoopGroup epollGroup = new EpollEventLoopGroup(this.config.getClientNumThreads(), NettyServer.getNamedThreadFactory(name));
        ((Bootstrap)this.bootstrap.group((EventLoopGroup)epollGroup)).channel(EpollSocketChannel.class);
    }

    ChannelFuture connect(final InetSocketAddress serverSocketAddress) {
        Preconditions.checkState((this.bootstrap != null ? 1 : 0) != 0, (Object)"Client has not been initialized yet.");
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel channel) throws Exception {
                if (NettyClient.this.clientSSLContext != null) {
                    SSLEngine sslEngine = NettyClient.this.clientSSLContext.createSSLEngine(serverSocketAddress.getAddress().getCanonicalHostName(), serverSocketAddress.getPort());
                    sslEngine.setUseClientMode(true);
                    if (!serverSocketAddress.getAddress().isLoopbackAddress()) {
                        SSLParameters newSSLParameters = sslEngine.getSSLParameters();
                        NettyClient.this.config.setSSLVerifyHostname(newSSLParameters);
                        sslEngine.setSSLParameters(newSSLParameters);
                    }
                    channel.pipeline().addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
                }
                channel.pipeline().addLast(NettyClient.this.protocol.getClientChannelHandlers());
            }
        });
        try {
            return this.bootstrap.connect((SocketAddress)serverSocketAddress);
        }
        catch (ChannelException e) {
            if (e.getCause() instanceof SocketException && e.getCause().getMessage().equals("Too many open files") || e.getCause() instanceof ChannelException && e.getCause().getCause() instanceof SocketException && e.getCause().getCause().getMessage().equals("Too many open files")) {
                throw new ChannelException("The operating system does not offer enough file handles to open the network connection. Please increase the number of available file handles.", e.getCause());
            }
            throw e;
        }
    }
}

