/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.net.InetAddress;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.net.SSLUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyConfig {
    private static final Logger LOG = LoggerFactory.getLogger(NettyConfig.class);
    public static final ConfigOption<Integer> NUM_ARENAS = ConfigOptions.key((String)"taskmanager.network.netty.num-arenas").defaultValue((Object)-1).withDeprecatedKeys(new String[]{"taskmanager.net.num-arenas"}).withDescription("The number of Netty arenas.");
    public static final ConfigOption<Integer> NUM_THREADS_SERVER = ConfigOptions.key((String)"taskmanager.network.netty.server.numThreads").defaultValue((Object)-1).withDeprecatedKeys(new String[]{"taskmanager.net.server.numThreads"}).withDescription("The number of Netty server threads.");
    public static final ConfigOption<Integer> NUM_THREADS_CLIENT = ConfigOptions.key((String)"taskmanager.network.netty.client.numThreads").defaultValue((Object)-1).withDeprecatedKeys(new String[]{"taskmanager.net.client.numThreads"}).withDescription("The number of Netty client threads.");
    public static final ConfigOption<Integer> CONNECT_BACKLOG = ConfigOptions.key((String)"taskmanager.network.netty.server.backlog").defaultValue((Object)0).withDeprecatedKeys(new String[]{"taskmanager.net.server.backlog"}).withDescription("The netty server connection backlog.");
    public static final ConfigOption<Integer> CLIENT_CONNECT_TIMEOUT_SECONDS = ConfigOptions.key((String)"taskmanager.network.netty.client.connectTimeoutSec").defaultValue((Object)120).withDeprecatedKeys(new String[]{"taskmanager.net.client.connectTimeoutSec"}).withDescription("The Netty client connection timeout.");
    public static final ConfigOption<Integer> SEND_RECEIVE_BUFFER_SIZE = ConfigOptions.key((String)"taskmanager.network.netty.sendReceiveBufferSize").defaultValue((Object)0).withDeprecatedKeys(new String[]{"taskmanager.net.sendReceiveBufferSize"}).withDescription("The Netty send and receive buffer size. This defaults to the system buffer size (cat /proc/sys/net/ipv4/tcp_[rw]mem) and is 4 MiB in modern Linux.");
    public static final ConfigOption<String> TRANSPORT_TYPE = ConfigOptions.key((String)"taskmanager.network.netty.transport").defaultValue((Object)"nio").withDeprecatedKeys(new String[]{"taskmanager.net.transport"}).withDescription("The Netty transport type, either \"nio\" or \"epoll\"");
    static final String SERVER_THREAD_GROUP_NAME = "Flink Netty Server";
    static final String CLIENT_THREAD_GROUP_NAME = "Flink Netty Client";
    private final InetAddress serverAddress;
    private final int serverPort;
    private final int memorySegmentSize;
    private final int numberOfSlots;
    private final Configuration config;

    public NettyConfig(InetAddress serverAddress, int serverPort, int memorySegmentSize, int numberOfSlots, Configuration config) {
        this.serverAddress = (InetAddress)Preconditions.checkNotNull((Object)serverAddress);
        Preconditions.checkArgument((serverPort >= 0 && serverPort <= 65536 ? 1 : 0) != 0, (Object)"Invalid port number.");
        this.serverPort = serverPort;
        Preconditions.checkArgument((memorySegmentSize > 0 ? 1 : 0) != 0, (Object)"Invalid memory segment size.");
        this.memorySegmentSize = memorySegmentSize;
        Preconditions.checkArgument((numberOfSlots > 0 ? 1 : 0) != 0, (Object)"Number of slots");
        this.numberOfSlots = numberOfSlots;
        this.config = (Configuration)Preconditions.checkNotNull((Object)config);
        LOG.info(this.toString());
    }

    InetAddress getServerAddress() {
        return this.serverAddress;
    }

    int getServerPort() {
        return this.serverPort;
    }

    int getMemorySegmentSize() {
        return this.memorySegmentSize;
    }

    public int getNumberOfSlots() {
        return this.numberOfSlots;
    }

    public int getServerConnectBacklog() {
        return this.config.getInteger(CONNECT_BACKLOG);
    }

    public int getNumberOfArenas() {
        int configValue = this.config.getInteger(NUM_ARENAS);
        return configValue == -1 ? this.numberOfSlots : configValue;
    }

    public int getServerNumThreads() {
        int configValue = this.config.getInteger(NUM_THREADS_SERVER);
        return configValue == -1 ? this.numberOfSlots : configValue;
    }

    public int getClientNumThreads() {
        int configValue = this.config.getInteger(NUM_THREADS_CLIENT);
        return configValue == -1 ? this.numberOfSlots : configValue;
    }

    public int getClientConnectTimeoutSeconds() {
        return this.config.getInteger(CLIENT_CONNECT_TIMEOUT_SECONDS);
    }

    public int getSendAndReceiveBufferSize() {
        return this.config.getInteger(SEND_RECEIVE_BUFFER_SIZE);
    }

    public TransportType getTransportType() {
        String transport;
        switch (transport = this.config.getString(TRANSPORT_TYPE)) {
            case "nio": {
                return TransportType.NIO;
            }
            case "epoll": {
                return TransportType.EPOLL;
            }
        }
        return TransportType.AUTO;
    }

    public SSLContext createClientSSLContext() throws Exception {
        SSLContext clientSSLContext = null;
        if (this.getSSLEnabled()) {
            clientSSLContext = SSLUtils.createSSLClientContext((Configuration)this.config);
        }
        return clientSSLContext;
    }

    public SSLContext createServerSSLContext() throws Exception {
        SSLContext serverSSLContext = null;
        if (this.getSSLEnabled()) {
            serverSSLContext = SSLUtils.createSSLServerContext((Configuration)this.config);
        }
        return serverSSLContext;
    }

    public boolean getSSLEnabled() {
        return this.config.getBoolean((ConfigOption<Boolean>)TaskManagerOptions.DATA_SSL_ENABLED) && SSLUtils.getSSLEnabled((Configuration)this.config);
    }

    public void setSSLVerAndCipherSuites(SSLEngine engine) {
        SSLUtils.setSSLVerAndCipherSuites((SSLEngine)engine, (Configuration)this.config);
    }

    public void setSSLVerifyHostname(SSLParameters sslParams) {
        SSLUtils.setSSLVerifyHostname((Configuration)this.config, (SSLParameters)sslParams);
    }

    public boolean isCreditBasedEnabled() {
        return this.config.getBoolean((ConfigOption<Boolean>)TaskManagerOptions.NETWORK_CREDIT_MODEL);
    }

    public String toString() {
        String format = "NettyConfig [server address: %s, server port: %d, ssl enabled: %s, memory segment size (bytes): %d, transport type: %s, number of server threads: %d (%s), number of client threads: %d (%s), server connect backlog: %d (%s), client connect timeout (sec): %d, send/receive buffer size (bytes): %d (%s)]";
        String def = "use Netty's default";
        String man = "manual";
        return String.format(format, new Object[]{this.serverAddress, this.serverPort, this.getSSLEnabled() ? "true" : "false", this.memorySegmentSize, this.getTransportType(), this.getServerNumThreads(), this.getServerNumThreads() == 0 ? def : man, this.getClientNumThreads(), this.getClientNumThreads() == 0 ? def : man, this.getServerConnectBacklog(), this.getServerConnectBacklog() == 0 ? def : man, this.getClientConnectTimeoutSeconds(), this.getSendAndReceiveBufferSize(), this.getSendAndReceiveBufferSize() == 0 ? def : man});
    }

    static enum TransportType {
        NIO,
        EPOLL,
        AUTO;

    }
}

