/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.flink.runtime.io.network.netty.NettyBufferPool;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.io.network.netty.NettyProtocol;
import org.apache.flink.runtime.util.FatalExitExceptionHandler;
import org.apache.flink.shaded.guava18.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.shaded.netty4.io.netty.bootstrap.ServerBootstrap;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelFuture;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInitializer;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelOption;
import org.apache.flink.shaded.netty4.io.netty.channel.EventLoopGroup;
import org.apache.flink.shaded.netty4.io.netty.channel.epoll.Epoll;
import org.apache.flink.shaded.netty4.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.flink.shaded.netty4.io.netty.channel.epoll.EpollServerSocketChannel;
import org.apache.flink.shaded.netty4.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.flink.shaded.netty4.io.netty.channel.socket.SocketChannel;
import org.apache.flink.shaded.netty4.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.SslHandler;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NettyServer {
    private static final ThreadFactoryBuilder THREAD_FACTORY_BUILDER = new ThreadFactoryBuilder().setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)FatalExitExceptionHandler.INSTANCE);
    private static final Logger LOG = LoggerFactory.getLogger(NettyServer.class);
    private final NettyConfig config;
    private ServerBootstrap bootstrap;
    private ChannelFuture bindFuture;
    private SSLContext serverSSLContext = null;
    private InetSocketAddress localAddress;

    NettyServer(NettyConfig config) {
        this.config = (NettyConfig)Preconditions.checkNotNull((Object)config);
        this.localAddress = null;
    }

    void init(final NettyProtocol protocol, NettyBufferPool nettyBufferPool) throws IOException {
        int receiveAndSendBufferSize;
        Preconditions.checkState((this.bootstrap == null ? 1 : 0) != 0, (Object)"Netty server has already been initialized.");
        long start = System.currentTimeMillis();
        this.bootstrap = new ServerBootstrap();
        switch (this.config.getTransportType()) {
            case NIO: {
                this.initNioBootstrap();
                break;
            }
            case EPOLL: {
                this.initEpollBootstrap();
                break;
            }
            case AUTO: {
                if (Epoll.isAvailable()) {
                    this.initEpollBootstrap();
                    LOG.info("Transport type 'auto': using EPOLL.");
                    break;
                }
                this.initNioBootstrap();
                LOG.info("Transport type 'auto': using NIO.");
            }
        }
        this.bootstrap.localAddress(this.config.getServerAddress(), this.config.getServerPort());
        this.bootstrap.option(ChannelOption.ALLOCATOR, (Object)nettyBufferPool);
        this.bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)nettyBufferPool);
        if (this.config.getServerConnectBacklog() > 0) {
            this.bootstrap.option(ChannelOption.SO_BACKLOG, (Object)this.config.getServerConnectBacklog());
        }
        if ((receiveAndSendBufferSize = this.config.getSendAndReceiveBufferSize()) > 0) {
            this.bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)receiveAndSendBufferSize);
            this.bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)receiveAndSendBufferSize);
        }
        int defaultHighWaterMark = 65536;
        int newLowWaterMark = this.config.getMemorySegmentSize() + 1;
        int newHighWaterMark = 2 * this.config.getMemorySegmentSize();
        if (newLowWaterMark > 65536) {
            this.bootstrap.childOption(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)newHighWaterMark);
            this.bootstrap.childOption(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, (Object)newLowWaterMark);
        } else {
            this.bootstrap.childOption(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, (Object)newLowWaterMark);
            this.bootstrap.childOption(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)newHighWaterMark);
        }
        try {
            this.serverSSLContext = this.config.createServerSSLContext();
        }
        catch (Exception e) {
            throw new IOException("Failed to initialize SSL Context for the Netty Server", e);
        }
        this.bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel channel) throws Exception {
                if (NettyServer.this.serverSSLContext != null) {
                    SSLEngine sslEngine = NettyServer.this.serverSSLContext.createSSLEngine();
                    NettyServer.this.config.setSSLVerAndCipherSuites(sslEngine);
                    sslEngine.setUseClientMode(false);
                    channel.pipeline().addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
                }
                channel.pipeline().addLast(protocol.getServerChannelHandlers());
            }
        });
        this.bindFuture = this.bootstrap.bind().syncUninterruptibly();
        this.localAddress = (InetSocketAddress)this.bindFuture.channel().localAddress();
        long end = System.currentTimeMillis();
        LOG.info("Successful initialization (took {} ms). Listening on SocketAddress {}.", (Object)(end - start), (Object)this.bindFuture.channel().localAddress().toString());
    }

    NettyConfig getConfig() {
        return this.config;
    }

    ServerBootstrap getBootstrap() {
        return this.bootstrap;
    }

    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    void shutdown() {
        long start = System.currentTimeMillis();
        if (this.bindFuture != null) {
            this.bindFuture.channel().close().awaitUninterruptibly();
            this.bindFuture = null;
        }
        if (this.bootstrap != null) {
            if (this.bootstrap.group() != null) {
                this.bootstrap.group().shutdownGracefully();
            }
            this.bootstrap = null;
        }
        long end = System.currentTimeMillis();
        LOG.info("Successful shutdown (took {} ms).", (Object)(end - start));
    }

    private void initNioBootstrap() {
        String name = "Flink Netty Server (" + this.config.getServerPort() + ")";
        NioEventLoopGroup nioGroup = new NioEventLoopGroup(this.config.getServerNumThreads(), NettyServer.getNamedThreadFactory(name));
        this.bootstrap.group((EventLoopGroup)nioGroup).channel(NioServerSocketChannel.class);
    }

    private void initEpollBootstrap() {
        String name = "Flink Netty Server (" + this.config.getServerPort() + ")";
        EpollEventLoopGroup epollGroup = new EpollEventLoopGroup(this.config.getServerNumThreads(), NettyServer.getNamedThreadFactory(name));
        this.bootstrap.group((EventLoopGroup)epollGroup).channel(EpollServerSocketChannel.class);
    }

    public static ThreadFactory getNamedThreadFactory(String name) {
        return THREAD_FACTORY_BUILDER.setNameFormat(name + " Thread %d").build();
    }
}

