/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.ArrayDeque;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.hack.io.network.DataTransfer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.util.Preconditions;

public abstract class ResultSubpartition {
    protected final int index;
    protected final ResultPartition parent;
    protected final ArrayDeque<BufferConsumer> buffers = new ArrayDeque();
    @GuardedBy(value="buffers")
    private int buffersInBacklog;
    private long totalNumberOfBuffers;
    private long totalNumberOfBytes;
    protected DataTransfer dataTransfer;

    public ResultSubpartition(int index, ResultPartition parent) {
        this.index = index;
        this.parent = parent;
        this.dataTransfer = new DataTransfer();
    }

    public DataTransfer getDataTransfer() {
        return this.dataTransfer;
    }

    public abstract void addToTransfer(Object var1);

    protected void updateStatistics(BufferConsumer buffer) {
        ++this.totalNumberOfBuffers;
    }

    protected void updateStatistics(Buffer buffer) {
        this.totalNumberOfBytes += (long)buffer.getSize();
    }

    protected long getTotalNumberOfBuffers() {
        return this.totalNumberOfBuffers;
    }

    protected long getTotalNumberOfBytes() {
        return this.totalNumberOfBytes;
    }

    protected void onConsumedSubpartition() {
        this.parent.onConsumedSubpartition(this.index);
    }

    protected Throwable getFailureCause() {
        return this.parent.getFailureCause();
    }

    public abstract boolean add(BufferConsumer var1) throws IOException;

    public abstract void flush();

    public abstract void finish() throws IOException;

    public abstract void release() throws IOException;

    public abstract ResultSubpartitionView createReadView(BufferAvailabilityListener var1) throws IOException;

    abstract int releaseMemory() throws IOException;

    public abstract boolean isReleased();

    @VisibleForTesting
    public int getBuffersInBacklog() {
        return this.buffersInBacklog;
    }

    public abstract int unsynchronizedGetNumberOfQueuedBuffers();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decreaseBuffersInBacklog(Buffer buffer) {
        ArrayDeque<BufferConsumer> arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            return this.decreaseBuffersInBacklogUnsafe(buffer != null && buffer.isBuffer());
        }
    }

    protected int decreaseBuffersInBacklogUnsafe(boolean isBuffer) {
        assert (Thread.holdsLock(this.buffers));
        if (isBuffer) {
            --this.buffersInBacklog;
        }
        return this.buffersInBacklog;
    }

    protected void increaseBuffersInBacklog(BufferConsumer buffer) {
        assert (Thread.holdsLock(this.buffers));
        if (buffer != null && buffer.isBuffer()) {
            ++this.buffersInBacklog;
        }
    }

    public static final class BufferAndBacklog {
        private final Buffer buffer;
        private final boolean isMoreAvailable;
        private final int buffersInBacklog;
        private final boolean nextBufferIsEvent;

        public BufferAndBacklog(Buffer buffer, boolean isMoreAvailable, int buffersInBacklog, boolean nextBufferIsEvent) {
            this.buffer = (Buffer)Preconditions.checkNotNull((Object)buffer);
            this.buffersInBacklog = buffersInBacklog;
            this.isMoreAvailable = isMoreAvailable;
            this.nextBufferIsEvent = nextBufferIsEvent;
        }

        public Buffer buffer() {
            return this.buffer;
        }

        public boolean isMoreAvailable() {
            return this.isMoreAvailable;
        }

        public int buffersInBacklog() {
            return this.buffersInBacklog;
        }

        public boolean nextBufferIsEvent() {
            return this.nextBufferIsEvent;
        }
    }
}

