/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.hack.io.network.DataTransfer;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.io.network.partition.consumer.InputGateListener;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.shaded.guava18.com.google.common.collect.Maps;
import org.apache.flink.shaded.guava18.com.google.common.collect.Sets;
import org.apache.flink.util.Preconditions;

public class UnionInputGate
implements InputGate,
InputGateListener {
    private final InputGate[] inputGates;
    private final Set<InputGate> inputGatesWithRemainingData;
    private final ArrayDeque<InputGate> inputGatesWithData = new ArrayDeque();
    private final Set<InputGate> enqueuedInputGatesWithData = new HashSet<InputGate>();
    private final int totalNumberOfInputChannels;
    private volatile InputGateListener inputGateListener;
    private final Map<InputGate, Integer> inputGateToIndexOffsetMap;
    private boolean requestedPartitionsFlag;

    public UnionInputGate(InputGate ... inputGates) {
        this.inputGates = (InputGate[])Preconditions.checkNotNull((Object)inputGates);
        Preconditions.checkArgument((inputGates.length > 1 ? 1 : 0) != 0, (Object)"Union input gate should union at least two input gates.");
        this.inputGateToIndexOffsetMap = Maps.newHashMapWithExpectedSize((int)inputGates.length);
        this.inputGatesWithRemainingData = Sets.newHashSetWithExpectedSize((int)inputGates.length);
        int currentNumberOfInputChannels = 0;
        for (InputGate inputGate : inputGates) {
            if (inputGate instanceof UnionInputGate) {
                throw new UnsupportedOperationException("Cannot union a union of input gates.");
            }
            this.inputGateToIndexOffsetMap.put((InputGate)Preconditions.checkNotNull((Object)inputGate), currentNumberOfInputChannels);
            this.inputGatesWithRemainingData.add(inputGate);
            currentNumberOfInputChannels += inputGate.getNumberOfInputChannels();
            inputGate.registerListener(this);
        }
        this.totalNumberOfInputChannels = currentNumberOfInputChannels;
    }

    @Override
    public int getNumberOfInputChannels() {
        return this.totalNumberOfInputChannels;
    }

    @Override
    public boolean isFinished() {
        for (InputGate inputGate : this.inputGates) {
            if (inputGate.isFinished()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void requestPartitions() throws IOException, InterruptedException {
        if (!this.requestedPartitionsFlag) {
            for (InputGate inputGate : this.inputGates) {
                inputGate.requestPartitions();
            }
            this.requestedPartitionsFlag = true;
        }
    }

    @Override
    public Optional<BufferOrEvent> getNextBufferOrEvent() throws IOException, InterruptedException {
        if (this.inputGatesWithRemainingData.isEmpty()) {
            return Optional.empty();
        }
        this.requestPartitions();
        InputGateWithData inputGateWithData = this.waitAndGetNextInputGate();
        InputGate inputGate = inputGateWithData.inputGate;
        BufferOrEvent bufferOrEvent = inputGateWithData.bufferOrEvent;
        if (bufferOrEvent.moreAvailable()) {
            this.queueInputGate(inputGate);
        }
        if (bufferOrEvent.isEvent() && bufferOrEvent.getEvent().getClass() == EndOfPartitionEvent.class && inputGate.isFinished()) {
            Preconditions.checkState((!bufferOrEvent.moreAvailable() ? 1 : 0) != 0);
            if (!this.inputGatesWithRemainingData.remove(inputGate)) {
                throw new IllegalStateException("Couldn't find input gate in set of remaining input gates.");
            }
        }
        int channelIndexOffset = this.inputGateToIndexOffsetMap.get(inputGate);
        bufferOrEvent.setChannelIndex(channelIndexOffset + bufferOrEvent.getChannelIndex());
        bufferOrEvent.setMoreAvailable(bufferOrEvent.moreAvailable() || inputGateWithData.moreInputGatesAvailable);
        return Optional.of(bufferOrEvent);
    }

    @Override
    public Optional<BufferOrEvent> pollNextBufferOrEvent() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputGateWithData waitAndGetNextInputGate() throws IOException, InterruptedException {
        boolean moreInputGatesAvailable;
        InputGate inputGate;
        Optional<BufferOrEvent> bufferOrEvent;
        do {
            ArrayDeque<InputGate> arrayDeque = this.inputGatesWithData;
            synchronized (arrayDeque) {
                while (this.inputGatesWithData.size() == 0) {
                    this.inputGatesWithData.wait();
                }
                inputGate = this.inputGatesWithData.remove();
                this.enqueuedInputGatesWithData.remove(inputGate);
                moreInputGatesAvailable = this.enqueuedInputGatesWithData.size() > 0;
            }
        } while (!(bufferOrEvent = inputGate.pollNextBufferOrEvent()).isPresent());
        return new InputGateWithData(inputGate, bufferOrEvent.get(), moreInputGatesAvailable);
    }

    @Override
    public void sendTaskEvent(TaskEvent event) throws IOException {
        for (InputGate inputGate : this.inputGates) {
            inputGate.sendTaskEvent(event);
        }
    }

    @Override
    public void registerListener(InputGateListener listener) {
        if (this.inputGateListener != null) {
            throw new IllegalStateException("Multiple listeners");
        }
        this.inputGateListener = listener;
    }

    @Override
    public int getPageSize() {
        int pageSize = -1;
        for (InputGate gate : this.inputGates) {
            if (pageSize == -1) {
                pageSize = gate.getPageSize();
                continue;
            }
            if (gate.getPageSize() == pageSize) continue;
            throw new IllegalStateException("Found input gates with different page sizes.");
        }
        return pageSize;
    }

    @Override
    public void notifyInputGateNonEmpty(InputGate inputGate) {
        this.queueInputGate((InputGate)Preconditions.checkNotNull((Object)inputGate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueInputGate(InputGate inputGate) {
        InputGateListener listener;
        int availableInputGates;
        ArrayDeque<InputGate> arrayDeque = this.inputGatesWithData;
        synchronized (arrayDeque) {
            if (this.enqueuedInputGatesWithData.contains(inputGate)) {
                return;
            }
            availableInputGates = this.inputGatesWithData.size();
            this.inputGatesWithData.add(inputGate);
            this.enqueuedInputGatesWithData.add(inputGate);
            if (availableInputGates == 0) {
                this.inputGatesWithData.notifyAll();
            }
        }
        if (availableInputGates == 0 && (listener = this.inputGateListener) != null) {
            listener.notifyInputGateNonEmpty(this);
        }
    }

    public DataTransfer[] getDataTransfers() {
        ArrayList<DataTransfer> result = new ArrayList<DataTransfer>();
        for (InputGate inputGate : this.inputGates) {
            if (inputGate instanceof SingleInputGate) {
                for (DataTransfer q : ((SingleInputGate)inputGate).getDataTransfers()) {
                    result.add(q);
                }
                continue;
            }
            for (DataTransfer q : ((UnionInputGate)inputGate).getDataTransfers()) {
                result.add(q);
            }
        }
        return result.toArray(new DataTransfer[result.size()]);
    }

    private static class InputGateWithData {
        private final InputGate inputGate;
        private final BufferOrEvent bufferOrEvent;
        private final boolean moreInputGatesAvailable;

        InputGateWithData(InputGate inputGate, BufferOrEvent bufferOrEvent, boolean moreInputGatesAvailable) {
            this.inputGate = (InputGate)Preconditions.checkNotNull((Object)inputGate);
            this.bufferOrEvent = (BufferOrEvent)Preconditions.checkNotNull((Object)bufferOrEvent);
            this.moreInputGatesAvailable = moreInputGatesAvailable;
        }
    }
}

