/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.burlap.io;

import com.caucho.burlap.io.AbstractBurlapInput;
import com.caucho.burlap.io.Deserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;

public class BasicDeserializer
extends Deserializer {
    public static final int NULL = 0;
    public static final int BOOLEAN = 1;
    public static final int BYTE = 2;
    public static final int SHORT = 3;
    public static final int INTEGER = 4;
    public static final int LONG = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    public static final int CHARACTER = 8;
    public static final int STRING = 9;
    public static final int DATE = 10;
    public static final int BOOLEAN_ARRAY = 11;
    public static final int BYTE_ARRAY = 12;
    public static final int SHORT_ARRAY = 13;
    public static final int INTEGER_ARRAY = 14;
    public static final int LONG_ARRAY = 15;
    public static final int FLOAT_ARRAY = 16;
    public static final int DOUBLE_ARRAY = 17;
    public static final int CHARACTER_ARRAY = 18;
    public static final int STRING_ARRAY = 19;
    public static final int OBJECT_ARRAY = 20;
    private int _code;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class array$Z;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$S;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$J;
    static /* synthetic */ Class array$F;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public BasicDeserializer(int code) {
        this._code = code;
    }

    public Class getType() {
        switch (this._code) {
            case 0: {
                return Void.TYPE;
            }
            case 1: {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = BasicDeserializer.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            case 2: {
                return class$java$lang$Byte == null ? (class$java$lang$Byte = BasicDeserializer.class$("java.lang.Byte")) : class$java$lang$Byte;
            }
            case 3: {
                return class$java$lang$Short == null ? (class$java$lang$Short = BasicDeserializer.class$("java.lang.Short")) : class$java$lang$Short;
            }
            case 4: {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = BasicDeserializer.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            case 5: {
                return class$java$lang$Long == null ? (class$java$lang$Long = BasicDeserializer.class$("java.lang.Long")) : class$java$lang$Long;
            }
            case 6: {
                return class$java$lang$Float == null ? (class$java$lang$Float = BasicDeserializer.class$("java.lang.Float")) : class$java$lang$Float;
            }
            case 7: {
                return class$java$lang$Double == null ? (class$java$lang$Double = BasicDeserializer.class$("java.lang.Double")) : class$java$lang$Double;
            }
            case 8: {
                return class$java$lang$Character == null ? (class$java$lang$Character = BasicDeserializer.class$("java.lang.Character")) : class$java$lang$Character;
            }
            case 9: {
                return class$java$lang$String == null ? (class$java$lang$String = BasicDeserializer.class$("java.lang.String")) : class$java$lang$String;
            }
            case 10: {
                return class$java$util$Date == null ? (class$java$util$Date = BasicDeserializer.class$("java.util.Date")) : class$java$util$Date;
            }
            case 11: {
                return array$Z == null ? (array$Z = BasicDeserializer.class$("[Z")) : array$Z;
            }
            case 12: {
                return array$B == null ? (array$B = BasicDeserializer.class$("[B")) : array$B;
            }
            case 13: {
                return array$S == null ? (array$S = BasicDeserializer.class$("[S")) : array$S;
            }
            case 14: {
                return array$I == null ? (array$I = BasicDeserializer.class$("[I")) : array$I;
            }
            case 15: {
                return array$J == null ? (array$J = BasicDeserializer.class$("[J")) : array$J;
            }
            case 16: {
                return array$F == null ? (array$F = BasicDeserializer.class$("[F")) : array$F;
            }
            case 17: {
                return array$D == null ? (array$D = BasicDeserializer.class$("[D")) : array$D;
            }
            case 18: {
                return array$C == null ? (array$C = BasicDeserializer.class$("[C")) : array$C;
            }
            case 19: {
                return array$Ljava$lang$String == null ? (array$Ljava$lang$String = BasicDeserializer.class$("[Ljava.lang.String;")) : array$Ljava$lang$String;
            }
            case 20: {
                return array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = BasicDeserializer.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object;
            }
        }
        throw new UnsupportedOperationException();
    }

    public Object readObject(AbstractBurlapInput in) throws IOException {
        switch (this._code) {
            case 1: {
                return new Boolean(in.readBoolean());
            }
            case 2: {
                return new Byte((byte)in.readInt());
            }
            case 3: {
                return new Short((short)in.readInt());
            }
            case 4: {
                return new Integer(in.readInt());
            }
            case 5: {
                return new Long(in.readLong());
            }
            case 6: {
                return new Float((float)in.readDouble());
            }
            case 7: {
                return new Double(in.readDouble());
            }
            case 9: {
                return in.readString();
            }
            case 8: {
                return new Character((char)in.readInt());
            }
            case 10: {
                return new Date(in.readUTCDate());
            }
            case 12: {
                return in.readBytes();
            }
            case 18: {
                String s = in.readString();
                if (s == null) {
                    return null;
                }
                int len = s.length();
                char[] chars = new char[len];
                s.getChars(0, len, chars, 0);
                return chars;
            }
        }
        throw new UnsupportedOperationException("deserializer:" + this.getType());
    }

    public Object readList(AbstractBurlapInput in, int length) throws IOException {
        switch (this._code) {
            case 11: {
                if (length >= 0) {
                    boolean[] data = new boolean[length];
                    in.addRef(data);
                    for (int i = 0; i < data.length; ++i) {
                        data[i] = in.readBoolean();
                    }
                    in.readListEnd();
                    return data;
                }
                ArrayList<Boolean> list = new ArrayList<Boolean>();
                while (!in.isEnd()) {
                    list.add(new Boolean(in.readBoolean()));
                }
                in.readListEnd();
                boolean[] data = new boolean[list.size()];
                in.addRef(data);
                for (int i = 0; i < data.length; ++i) {
                    data[i] = (Boolean)list.get(i);
                }
                return data;
            }
            case 13: {
                if (length >= 0) {
                    short[] data = new short[length];
                    in.addRef(data);
                    for (int i = 0; i < data.length; ++i) {
                        data[i] = (short)in.readInt();
                    }
                    in.readListEnd();
                    return data;
                }
                ArrayList<Short> list = new ArrayList<Short>();
                while (!in.isEnd()) {
                    list.add(new Short((short)in.readInt()));
                }
                in.readListEnd();
                short[] data = new short[list.size()];
                for (int i = 0; i < data.length; ++i) {
                    data[i] = (Short)list.get(i);
                }
                in.addRef(data);
                return data;
            }
            case 14: {
                if (length >= 0) {
                    int[] data = new int[length];
                    in.addRef(data);
                    for (int i = 0; i < data.length; ++i) {
                        data[i] = in.readInt();
                    }
                    in.readListEnd();
                    return data;
                }
                ArrayList<Integer> list = new ArrayList<Integer>();
                while (!in.isEnd()) {
                    list.add(new Integer(in.readInt()));
                }
                in.readListEnd();
                int[] data = new int[list.size()];
                for (int i = 0; i < data.length; ++i) {
                    data[i] = (Integer)list.get(i);
                }
                in.addRef(data);
                return data;
            }
            case 15: {
                if (length >= 0) {
                    long[] data = new long[length];
                    in.addRef(data);
                    for (int i = 0; i < data.length; ++i) {
                        data[i] = in.readLong();
                    }
                    in.readListEnd();
                    return data;
                }
                ArrayList<Long> list = new ArrayList<Long>();
                while (!in.isEnd()) {
                    list.add(new Long(in.readLong()));
                }
                in.readListEnd();
                long[] data = new long[list.size()];
                for (int i = 0; i < data.length; ++i) {
                    data[i] = (Long)list.get(i);
                }
                in.addRef(data);
                return data;
            }
            case 16: {
                if (length >= 0) {
                    float[] data = new float[length];
                    in.addRef(data);
                    for (int i = 0; i < data.length; ++i) {
                        data[i] = (float)in.readDouble();
                    }
                    in.readListEnd();
                    return data;
                }
                ArrayList<Float> list = new ArrayList<Float>();
                while (!in.isEnd()) {
                    list.add(new Float(in.readDouble()));
                }
                in.readListEnd();
                float[] data = new float[list.size()];
                for (int i = 0; i < data.length; ++i) {
                    data[i] = ((Float)list.get(i)).floatValue();
                }
                in.addRef(data);
                return data;
            }
            case 17: {
                if (length >= 0) {
                    double[] data = new double[length];
                    in.addRef(data);
                    for (int i = 0; i < data.length; ++i) {
                        data[i] = in.readDouble();
                    }
                    in.readListEnd();
                    return data;
                }
                ArrayList<Double> list = new ArrayList<Double>();
                while (!in.isEnd()) {
                    list.add(new Double(in.readDouble()));
                }
                in.readListEnd();
                double[] data = new double[list.size()];
                in.addRef(data);
                for (int i = 0; i < data.length; ++i) {
                    data[i] = ((Double)list.get(i)).intValue();
                }
                return data;
            }
            case 19: {
                if (length >= 0) {
                    String[] data = new String[length];
                    in.addRef(data);
                    for (int i = 0; i < data.length; ++i) {
                        data[i] = in.readString();
                    }
                    in.readListEnd();
                    return data;
                }
                ArrayList<String> list = new ArrayList<String>();
                while (!in.isEnd()) {
                    list.add(in.readString());
                }
                in.readListEnd();
                String[] data = new String[list.size()];
                in.addRef(data);
                for (int i = 0; i < data.length; ++i) {
                    data[i] = (String)list.get(i);
                }
                return data;
            }
            case 20: {
                if (length >= 0) {
                    Object[] data = new Object[length];
                    in.addRef(data);
                    for (int i = 0; i < data.length; ++i) {
                        data[i] = in.readObject();
                    }
                    in.readListEnd();
                    return data;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                in.addRef(list);
                while (!in.isEnd()) {
                    list.add(in.readObject());
                }
                in.readListEnd();
                Object[] data = new Object[list.size()];
                for (int i = 0; i < data.length; ++i) {
                    data[i] = list.get(i);
                }
                return data;
            }
        }
        throw new UnsupportedOperationException(String.valueOf(this));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

