/*
 * Decompiled with CFR 0.152.
 */
package elite.ast;

import elite.ast.ApplyExpression;
import elite.ast.BinaryExpression;
import elite.ast.CompoundExpression;
import elite.ast.ConditionalExpression;
import elite.ast.ConstantExpression;
import elite.ast.DeclarationExpression;
import elite.ast.ExpressionTransformer;
import elite.ast.ExpressionType;
import elite.ast.IdentifierExpression;
import elite.ast.LambdaExpression;
import elite.ast.ListExpression;
import elite.ast.MapExpression;
import elite.ast.MemberExpression;
import elite.ast.NewExpression;
import elite.ast.RangeExpression;
import elite.ast.TupleExpression;
import elite.ast.UnaryExpression;
import elite.lang.Range;
import elite.lang.Symbol;
import elite.lang.annotation.Expando;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import org.operamasks.el.eval.EvaluationContext;
import org.operamasks.el.parser.ELNode;
import org.operamasks.el.parser.Parser;

public abstract class Expression {
    protected ExpressionType nodeType;
    protected ELNode node;

    protected Expression(ExpressionType nodeType) {
        this.nodeType = nodeType;
    }

    protected Expression(ExpressionType nodeType, ELNode node) {
        this.nodeType = nodeType;
        this.node = node;
    }

    public ExpressionType getNodeType() {
        return this.nodeType;
    }

    protected abstract ELNode toInternal();

    public ELNode getNode() {
        if (this.node == null) {
            this.node = this.toInternal();
        }
        return this.node;
    }

    public Object evaluate(ELContext elctx) {
        return this.getNode().getValue(new EvaluationContext(elctx));
    }

    public static Expression valueOf(ELNode node) {
        return new ExpressionTransformer().transform(node);
    }

    public static Expression parse(String text) {
        ELNode node = Parser.parse(text);
        return Expression.valueOf(node);
    }

    public static Expression ADD(Object left, Object right) {
        return new BinaryExpression(ExpressionType.ADD, Expression.arg(left), Expression.arg(right));
    }

    @Expando(name="+")
    public static Expression __add__(Object left, Object right) {
        return Expression.ADD(left, right);
    }

    public static Expression AND(Object left, Object right) {
        return new BinaryExpression(ExpressionType.AND, Expression.arg(left), Expression.arg(right));
    }

    public static Expression APPLY(Object expression, Object ... arguments) {
        return new ApplyExpression(Expression.arg(expression), Expression.args(arguments));
    }

    public static Expression ASSIGN(Object left, Object right) {
        return new BinaryExpression(ExpressionType.ASSIGN, Expression.arg(left), Expression.arg(right));
    }

    public static Expression BITWISE_AND(Object left, Object right) {
        return new BinaryExpression(ExpressionType.BITWISE_AND, Expression.arg(left), Expression.arg(right));
    }

    @Expando(name="&")
    public static Expression __bitand__(Object left, Object right) {
        return Expression.BITWISE_AND(left, right);
    }

    public static Expression BITWISE_OR(Object left, Object right) {
        return new BinaryExpression(ExpressionType.BITWISE_OR, Expression.arg(left), Expression.arg(right));
    }

    @Expando(name="|")
    public static Expression __bitor__(Object left, Object right) {
        return Expression.BITWISE_OR(left, right);
    }

    public static Expression COALESCE(Object left, Object right) {
        return new BinaryExpression(ExpressionType.COALESCE, Expression.arg(left), Expression.arg(right));
    }

    public static Expression COMPOUND(Expression ... expressions) {
        return new CompoundExpression(expressions);
    }

    public static Expression CONDITION(Object test, Object left, Object right) {
        return new ConditionalExpression(Expression.arg(test), Expression.arg(left), Expression.arg(right));
    }

    public static Expression CONST(Object value) {
        return new ConstantExpression(Expression.const_node(value));
    }

    private static ELNode const_node(Object value) {
        if (value == null) {
            return new ELNode.NULL(0);
        }
        if (value instanceof Boolean) {
            return new ELNode.BOOLEANVAL(0, (Boolean)value);
        }
        if (value instanceof Character) {
            return new ELNode.CHARVAL(0, ((Character)value).charValue());
        }
        if (value instanceof Number) {
            return new ELNode.NUMBER(0, (Number)value);
        }
        if (value instanceof String) {
            return new ELNode.STRINGVAL(0, (String)value);
        }
        if (value instanceof Symbol) {
            return new ELNode.SYMBOL(0, (Symbol)value);
        }
        if (value instanceof Object[]) {
            Object[] tuple = (Object[])value;
            ELNode[] elems = new ELNode[tuple.length];
            for (int i = 0; i < tuple.length; ++i) {
                elems[i] = Expression.const_node(tuple[i]);
            }
            return new ELNode.TUPLE(0, elems);
        }
        if (value instanceof Range) {
            Range r = (Range)value;
            ELNode begin = Expression.const_node(r.getBegin());
            ELNode next = Expression.const_node(r.getBegin() + r.getStep());
            ELNode end = r.isUnbound() ? null : Expression.const_node(r.getEnd());
            return new ELNode.RANGE(0, begin, next, end, r.isExcludeEnd());
        }
        if (value instanceof List) {
            List list = (List)value;
            int size = list.size();
            ELNode[] elems = new ELNode[size];
            for (int i = 0; i < size; ++i) {
                elems[i] = Expression.const_node(list.get(i));
            }
            return new ELNode.LIST(0, elems, null);
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            int size = map.size();
            ELNode[] keys = new ELNode[size];
            ELNode[] values = new ELNode[size];
            Iterator it = map.entrySet().iterator();
            int i = 0;
            while (it.hasNext()) {
                Map.Entry e = it.next();
                keys[i] = Expression.const_node(e.getKey());
                values[i] = Expression.const_node(e.getValue());
                ++i;
            }
            return new ELNode.MAP(0, keys, values);
        }
        throw new IllegalArgumentException();
    }

    public static Expression DEFINE(Object name, Object expression) {
        return new DeclarationExpression(Expression.name(name), Expression.arg(expression));
    }

    public static Expression FUNCTION(Object name, Object[] parameters, Object body) {
        return new DeclarationExpression(Expression.name(name), Expression.LAMBDA(name, parameters, body));
    }

    public static Expression DIVIDE(Object left, Object right) {
        return new BinaryExpression(ExpressionType.DIVIDE, Expression.arg(left), Expression.arg(right));
    }

    @Expando(name="/")
    public static Expression __div__(Object left, Object right) {
        return Expression.DIVIDE(left, right);
    }

    public static Expression EMPTY(Object right) {
        return new UnaryExpression(ExpressionType.EMPTY, Expression.arg(right));
    }

    public static Expression EQUAL(Object left, Object right) {
        return new BinaryExpression(ExpressionType.EQUAL, Expression.arg(left), Expression.arg(right));
    }

    public static Expression GREATER_THAN(Object left, Object right) {
        return new BinaryExpression(ExpressionType.GREATER_THAN, Expression.arg(left), Expression.arg(right));
    }

    public static Expression GREATER_THAN_OR_EQUAL(Object left, Object right) {
        return new BinaryExpression(ExpressionType.GREATER_THAN, Expression.arg(left), Expression.arg(right));
    }

    public static Expression ID(String name) {
        return new IdentifierExpression(name);
    }

    public static Expression ID(Symbol name) {
        return new IdentifierExpression(name.getName());
    }

    public static Expression IN(Object left, Object right) {
        return new BinaryExpression(ExpressionType.IN, Expression.arg(left), Expression.arg(right));
    }

    public static Expression INSTANCEOF(Object expression, String type) {
        return new BinaryExpression(ExpressionType.INSTANCEOF, Expression.arg(expression), Expression.CONST(type));
    }

    public static Expression LAMBDA(Object name, Object[] parameters, Object body) {
        return new LambdaExpression(Expression.name(name), Expression.names(parameters), Expression.arg(body));
    }

    public static Expression LAMBDA(Object name, Object param, Expression body) {
        return new LambdaExpression(Expression.name(name), new String[]{Expression.name(param)}, body);
    }

    public static Expression LAMBDA(Object[] parameters, Expression body) {
        return new LambdaExpression(null, Expression.names(parameters), body);
    }

    public static Expression LAMBDA(Object param, Expression body) {
        return new LambdaExpression(null, new String[]{Expression.name(param)}, body);
    }

    public static Expression LEFT_SHIFT(Object left, Object right) {
        return new BinaryExpression(ExpressionType.LEFT_SHIFT, Expression.arg(left), Expression.arg(right));
    }

    @Expando(name="<<")
    public static Expression __shl__(Object left, Object right) {
        return Expression.LEFT_SHIFT(left, right);
    }

    public static Expression LESS_THAN(Object left, Object right) {
        return new BinaryExpression(ExpressionType.LESS_THAN, Expression.arg(left), Expression.arg(right));
    }

    public static Expression LESS_THAN_OR_EQUAL(Object left, Object right) {
        return new BinaryExpression(ExpressionType.LESS_THAN_OR_EQUAL, Expression.arg(left), Expression.arg(right));
    }

    public static Expression LIST(Object ... elements) {
        return new ListExpression(Expression.args(elements));
    }

    public static Expression MAP(Map map) {
        int size = map.size();
        Expression[] keys = new Expression[size];
        Expression[] values = new Expression[size];
        Iterator it = map.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry e = it.next();
            keys[i] = Expression.arg(e.getKey());
            values[i] = Expression.arg(e.getValue());
            ++i;
        }
        return new MapExpression(keys, values);
    }

    public static Expression MEMBER(Object expression, Object field) {
        return new MemberExpression(Expression.arg(expression), Expression.arg(field));
    }

    public static Expression REMAINDER(Object left, Object right) {
        return new BinaryExpression(ExpressionType.REMAINDER, Expression.arg(left), Expression.arg(right));
    }

    @Expando(name="%")
    public static Expression __rem__(Object left, Object right) {
        return Expression.REMAINDER(left, right);
    }

    public static Expression MULTIPLY(Object left, Object right) {
        return new BinaryExpression(ExpressionType.MULTIPLY, Expression.arg(left), Expression.arg(right));
    }

    @Expando(name="*")
    public static Expression __mul__(Object left, Object right) {
        return Expression.MULTIPLY(left, right);
    }

    public static Expression NEGATE(Object right) {
        return new UnaryExpression(ExpressionType.NEGATE, Expression.arg(right));
    }

    @Expando
    public static Expression __neg__(Object right) {
        return Expression.NEGATE(right);
    }

    public static Expression NEW(Object type, Object ... arguments) {
        return new NewExpression(Expression.name(type), Expression.args(arguments));
    }

    public static Expression NOT(Object right) {
        return new UnaryExpression(ExpressionType.NOT, Expression.arg(right));
    }

    public static Expression NOT_EQUAL(Object left, Object right) {
        return new BinaryExpression(ExpressionType.NOT_EQUAL, Expression.arg(left), Expression.arg(right));
    }

    public static Expression OR(Object left, Object right) {
        return new BinaryExpression(ExpressionType.OR, Expression.arg(left), Expression.arg(right));
    }

    public static Expression PARENTHESIS(Object expression) {
        return new UnaryExpression(ExpressionType.PARENTHESIS, Expression.arg(expression));
    }

    public static Expression POST_DECREMENT(Object left) {
        return new UnaryExpression(ExpressionType.POST_DECREMENT, Expression.arg(left));
    }

    public static Expression POST_INCREMENT(Object left) {
        return new UnaryExpression(ExpressionType.POST_INCREMENT, Expression.arg(left));
    }

    public static Expression POWER(Object left, Object right) {
        return new BinaryExpression(ExpressionType.POWER, Expression.arg(left), Expression.arg(right));
    }

    @Expando(name="^")
    public static Expression __pow__(Object left, Object right) {
        return Expression.POWER(left, right);
    }

    public static Expression PRE_DECREMENT(Object right) {
        return new UnaryExpression(ExpressionType.PRE_DECREMENT, Expression.arg(right));
    }

    public static Expression PRE_INCREMENT(Object right) {
        return new UnaryExpression(ExpressionType.PRE_INCREMENT, Expression.arg(right));
    }

    public static Expression RANGE(Object begin, Object next, Object end) {
        return new RangeExpression(Expression.arg(begin), next == null ? null : Expression.arg(next), end == null ? null : Expression.arg(end));
    }

    public static Expression RANGE(Object begin, Object end) {
        return new RangeExpression(Expression.arg(begin), null, Expression.arg(end));
    }

    public static Expression RIGHT_SHIFT(Object left, Object right) {
        return new BinaryExpression(ExpressionType.RIGHT_SHIFT, Expression.arg(left), Expression.arg(right));
    }

    @Expando(name=">>")
    public static Expression __shr__(Object left, Object right) {
        return Expression.RIGHT_SHIFT(left, right);
    }

    public static Expression SAFEREF(Object left, Object right) {
        return new BinaryExpression(ExpressionType.SAFEREF, Expression.arg(left), Expression.arg(right));
    }

    public static Expression SUBTRACT(Object left, Object right) {
        return new BinaryExpression(ExpressionType.SUBTRACT, Expression.arg(left), Expression.arg(right));
    }

    @Expando(name="-")
    public static Expression __sub__(Object left, Object right) {
        return Expression.SUBTRACT(left, right);
    }

    public static Expression TUPLE(Object ... elements) {
        return new TupleExpression(Expression.args(elements));
    }

    public static Expression UNARY_PLUS(Object right) {
        return new UnaryExpression(ExpressionType.UNARY_PLUS, Expression.arg(right));
    }

    @Expando
    public static Expression __pos__(Object right) {
        return Expression.UNARY_PLUS(right);
    }

    public static Expression UNSIGNED_RIGHT_SHIFT(Object left, Object right) {
        return new BinaryExpression(ExpressionType.UNSIGNED_RIGHT_SHIFT, Expression.arg(left), Expression.arg(right));
    }

    @Expando(name=">>>")
    public static Expression __ushr__(Object left, Object right) {
        return Expression.UNSIGNED_RIGHT_SHIFT(left, right);
    }

    public static Expression XOR(Object left, Object right) {
        return new BinaryExpression(ExpressionType.XOR, Expression.arg(left), Expression.arg(right));
    }

    @Expando
    public static Expression __xor__(Object left, Object right) {
        return Expression.XOR(left, right);
    }

    private static Expression arg(Object arg) {
        if (arg instanceof Expression) {
            return (Expression)arg;
        }
        if (arg instanceof Symbol) {
            return Expression.ID((Symbol)arg);
        }
        return Expression.CONST(arg);
    }

    private static Expression[] args(Object ... args) {
        if (args instanceof Expression[]) {
            return (Expression[])args;
        }
        if (args.length == 1 && args[0] instanceof Expression[]) {
            return (Expression[])args[0];
        }
        Expression[] exps = new Expression[args.length];
        for (int i = 0; i < args.length; ++i) {
            exps[i] = Expression.arg(args[i]);
        }
        return exps;
    }

    private static String name(Object param) {
        if (param instanceof String) {
            return (String)param;
        }
        if (param instanceof Symbol) {
            return ((Symbol)param).getName();
        }
        throw new IllegalArgumentException("" + param);
    }

    private static String[] names(Object[] params) {
        String[] names = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            names[i] = Expression.name(params[i]);
        }
        return names;
    }
}

