/*
 * Decompiled with CFR 0.152.
 */
package elite.ast;

import elite.ast.ApplyExpression;
import elite.ast.BinaryExpression;
import elite.ast.CompoundExpression;
import elite.ast.ConditionalExpression;
import elite.ast.ConstantExpression;
import elite.ast.DeclarationExpression;
import elite.ast.Expression;
import elite.ast.ExpressionType;
import elite.ast.GenericExpression;
import elite.ast.IdentifierExpression;
import elite.ast.LambdaExpression;
import elite.ast.ListExpression;
import elite.ast.MapExpression;
import elite.ast.MemberExpression;
import elite.ast.NewExpression;
import elite.ast.RangeExpression;
import elite.ast.TupleExpression;
import elite.ast.UnaryExpression;
import org.operamasks.el.parser.ELNode;

final class ExpressionTransformer
extends ELNode.Visitor {
    protected Expression result;

    ExpressionTransformer() {
    }

    public Expression transform(ELNode exp) {
        if (exp == null) {
            return null;
        }
        exp.accept(this);
        Expression result = this.result;
        this.result = null;
        result.node = exp;
        return result;
    }

    public Expression[] transform(ELNode[] args) {
        if (args == null) {
            return null;
        }
        Expression[] result = new Expression[args.length];
        for (int i = 0; i < args.length; ++i) {
            result[i] = this.transform(args[i]);
        }
        return result;
    }

    public void visit(ELNode.DEFINE e) {
        this.result = new DeclarationExpression(e.id, this.transform(e.expr));
    }

    public void visit(ELNode.IDENT e) {
        this.result = new IdentifierExpression(e.id);
    }

    public void visit(ELNode.ACCESS e) {
        this.result = new MemberExpression(this.transform(e.right), this.transform(e.index));
    }

    public void visit(ELNode.APPLY e) {
        this.result = new ApplyExpression(this.transform(e.right), this.transform(e.args));
    }

    public void visit(ELNode.NEW e) {
        this.result = new NewExpression(e.base, this.transform(e.args));
    }

    public void visit(ELNode.LAMBDA e) {
        String[] params = new String[e.vars.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = e.vars[i].id;
        }
        this.result = new LambdaExpression(e.name, params, this.transform(e.body));
    }

    public void visit(ELNode.COMPOUND e) {
        this.result = new CompoundExpression(this.transform(e.exps));
    }

    public void visit(ELNode.ASSIGN e) {
        this.result = new BinaryExpression(ExpressionType.ASSIGN, this.transform(e.left), this.transform(e.right));
    }

    public void visit(ELNode.COND e) {
        this.result = new ConditionalExpression(this.transform(e.cond), this.transform(e.left), this.transform(e.right));
    }

    public void visit(ELNode.COALESCE e) {
        this.result = new BinaryExpression(ExpressionType.COALESCE, this.transform(e.left), this.transform(e.right));
    }

    public void visit(ELNode.SAFEREF e) {
        this.result = new BinaryExpression(ExpressionType.SAFEREF, this.transform(e.left), this.transform(e.right));
    }

    public void visit(ELNode.OR e) {
        this.result = new BinaryExpression(ExpressionType.OR, this.transform(e.left), this.transform(e.right));
    }

    public void visit(ELNode.AND e) {
        this.result = new BinaryExpression(ExpressionType.AND, this.transform(e.left), this.transform(e.right));
    }

    public void visit(ELNode.BITOR e) {
        this.result = new BinaryExpression(ExpressionType.BITWISE_OR, this.transform(e.left), this.transform(e.right));
    }

    public void visit(ELNode.BITAND e) {
        this.result = new BinaryExpression(ExpressionType.BITWISE_AND, this.transform(e.left), this.transform(e.right));
    }

    public void visit(ELNode.XOR e) {
        this.result = new BinaryExpression(ExpressionType.XOR, this.transform(e.left), this.transform(e.right));
    }

    public void visit(ELNode.SHL e) {
        this.result = new BinaryExpression(ExpressionType.LEFT_SHIFT, this.transform(e.left), this.transform(e.right));
    }

    public void visit(ELNode.SHR e) {
        this.result = new BinaryExpression(ExpressionType.RIGHT_SHIFT, this.transform(e.left), this.transform(e.right));
    }

    public void visit(ELNode.USHR e) {
        this.result = new BinaryExpression(ExpressionType.UNSIGNED_RIGHT_SHIFT, this.transform(e.left), this.transform(e.right));
    }

    public void visit(ELNode.EQ e) {
        this.result = new BinaryExpression(ExpressionType.EQUAL, this.transform(e.left), this.transform(e.right));
    }

    public void visit(ELNode.NE e) {
        this.result = new BinaryExpression(ExpressionType.NOT_EQUAL, this.transform(e.left), this.transform(e.right));
    }

    public void visit(ELNode.IDEQ e) {
        this.result = new BinaryExpression(ExpressionType.EQUAL, this.transform(e.left), this.transform(e.right));
    }

    public void visit(ELNode.IDNE e) {
        this.result = new BinaryExpression(ExpressionType.NOT_EQUAL, this.transform(e.left), this.transform(e.right));
    }

    public void visit(ELNode.LT e) {
        this.result = new BinaryExpression(ExpressionType.LESS_THAN, this.transform(e.left), this.transform(e.right));
    }

    public void visit(ELNode.LE e) {
        this.result = new BinaryExpression(ExpressionType.LESS_THAN_OR_EQUAL, this.transform(e.left), this.transform(e.right));
    }

    public void visit(ELNode.GT e) {
        this.result = new BinaryExpression(ExpressionType.GREATER_THAN, this.transform(e.left), this.transform(e.right));
    }

    public void visit(ELNode.GE e) {
        this.result = new BinaryExpression(ExpressionType.GREATER_THAN_OR_EQUAL, this.transform(e.left), this.transform(e.right));
    }

    public void visit(ELNode.IN e) {
        this.result = new BinaryExpression(ExpressionType.IN, this.transform(e.left), this.transform(e.right));
        if (e.negative) {
            this.result = new UnaryExpression(ExpressionType.NOT, this.result);
        }
    }

    public void visit(ELNode.INSTANCEOF e) {
        this.result = new BinaryExpression(ExpressionType.INSTANCEOF, this.transform(e.right), Expression.CONST(e.type));
        if (e.negative) {
            this.result = new UnaryExpression(ExpressionType.NOT, this.result);
        }
    }

    public void visit(ELNode.ADD e) {
        this.result = new BinaryExpression(ExpressionType.ADD, this.transform(e.left), this.transform(e.right));
    }

    public void visit(ELNode.SUB e) {
        this.result = new BinaryExpression(ExpressionType.SUBTRACT, this.transform(e.left), this.transform(e.right));
    }

    public void visit(ELNode.MUL e) {
        this.result = new BinaryExpression(ExpressionType.MULTIPLY, this.transform(e.left), this.transform(e.right));
    }

    public void visit(ELNode.DIV e) {
        this.result = e instanceof ELNode.IDIV ? new BinaryExpression(ExpressionType.DIVIDE, this.transform(e.left), this.transform(e.right)) : new BinaryExpression(ExpressionType.DIVIDE, this.transform(e.left), this.transform(e.right));
    }

    public void visit(ELNode.REM e) {
        this.result = new BinaryExpression(ExpressionType.REMAINDER, this.transform(e.left), this.transform(e.right));
    }

    public void visit(ELNode.POW e) {
        this.result = new BinaryExpression(ExpressionType.POWER, this.transform(e.left), this.transform(e.right));
    }

    public void visit(ELNode.BITNOT e) {
        this.result = new UnaryExpression(ExpressionType.BITWISE_NOT, this.transform(e.right));
    }

    public void visit(ELNode.POS e) {
        this.result = new UnaryExpression(ExpressionType.UNARY_PLUS, this.transform(e.right));
    }

    public void visit(ELNode.NEG e) {
        this.result = new UnaryExpression(ExpressionType.NEGATE, this.transform(e.right));
    }

    public void visit(ELNode.NOT e) {
        this.result = new UnaryExpression(ExpressionType.NOT, this.transform(e.right));
    }

    public void visit(ELNode.INC e) {
        this.result = new UnaryExpression(e.is_preincrement ? ExpressionType.PRE_INCREMENT : ExpressionType.POST_INCREMENT, this.transform(e.right));
    }

    public void visit(ELNode.DEC e) {
        this.result = new UnaryExpression(e.is_preincrement ? ExpressionType.PRE_DECREMENT : ExpressionType.POST_DECREMENT, this.transform(e.right));
    }

    public void visit(ELNode.EMPTY e) {
        this.result = new UnaryExpression(ExpressionType.EMPTY, this.transform(e.right));
    }

    public void visit(ELNode.EXPR e) {
        this.result = new UnaryExpression(ExpressionType.PARENTHESIS, this.transform(e.right));
    }

    public void visit(ELNode.BOOLEANVAL e) {
        this.result = new ConstantExpression(e);
    }

    public void visit(ELNode.CHARVAL e) {
        this.result = new ConstantExpression(e);
    }

    public void visit(ELNode.NUMBER e) {
        this.result = new ConstantExpression(e);
    }

    public void visit(ELNode.SYMBOL e) {
        this.result = new ConstantExpression(e);
    }

    public void visit(ELNode.STRINGVAL e) {
        this.result = new ConstantExpression(e);
    }

    public void visit(ELNode.REGEXP e) {
        this.result = new ConstantExpression(e);
    }

    public void visit(ELNode.LITERAL e) {
        this.result = new ConstantExpression(e);
    }

    public void visit(ELNode.NULL e) {
        this.result = new ConstantExpression(e);
    }

    public void visit(ELNode.LIST e) {
        this.result = new ListExpression(this.transform(e.elems));
    }

    public void visit(ELNode.TUPLE e) {
        this.result = new TupleExpression(this.transform(e.elems));
    }

    public void visit(ELNode.MAP e) {
        this.result = new MapExpression(this.transform(e.keys), this.transform(e.values));
    }

    public void visit(ELNode.RANGE e) {
        this.result = new RangeExpression(this.transform(e.begin), this.transform(e.next), this.transform(e.end), e.exclude);
    }

    public void visitNode(ELNode e) {
        this.result = new GenericExpression(e);
    }
}

