/*
 * Decompiled with CFR 0.152.
 */
package elite.ast;

import elite.ast.Expression;
import elite.ast.ExpressionType;
import java.util.Arrays;
import java.util.Iterator;
import org.operamasks.el.parser.ELNode;

public class TupleExpression
extends Expression
implements Iterable {
    protected Expression[] elements;

    public TupleExpression(Expression[] elements) {
        super(ExpressionType.TUPLE);
        this.elements = elements;
    }

    public Expression[] getElements() {
        return (Expression[])this.elements.clone();
    }

    public Iterator iterator() {
        return Arrays.asList(this.elements).iterator();
    }

    protected ELNode toInternal() {
        ELNode[] exps = new ELNode[this.elements.length];
        for (int i = 0; i < exps.length; ++i) {
            exps[i] = this.elements[i].getNode();
        }
        return new ELNode.TUPLE(0, exps);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        for (int i = 0; i < this.elements.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(this.elements[i]);
        }
        buf.append(")");
        return buf.toString();
    }
}

