/*
 * Decompiled with CFR 0.152.
 */
package elite.lang;

import elite.lang.Annotation;
import elite.lang.CharRange;
import elite.lang.Closure;
import elite.lang.MathLib;
import elite.lang.Range;
import elite.lang.Seq;
import elite.lang.annotation.Alias;
import elite.lang.annotation.Expando;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ValueExpression;
import javax.script.ScriptContext;
import org.operamasks.el.eval.CharRanges;
import org.operamasks.el.eval.Control;
import org.operamasks.el.eval.DelegatingELContext;
import org.operamasks.el.eval.ELEngine;
import org.operamasks.el.eval.ELUtils;
import org.operamasks.el.eval.EvaluationContext;
import org.operamasks.el.eval.Ranges;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.el.eval.VariableMapperImpl;
import org.operamasks.el.eval.closure.AbstractClosure;
import org.operamasks.el.eval.closure.ClosureObject;
import org.operamasks.el.eval.closure.LiteralClosure;
import org.operamasks.el.eval.closure.Procedure;
import org.operamasks.el.eval.closure.VarClosure;
import org.operamasks.el.eval.seq.ArraySeq;
import org.operamasks.el.eval.seq.Cons;
import org.operamasks.el.eval.seq.DelaySeq;
import org.operamasks.el.eval.seq.FilteredSeq;
import org.operamasks.el.eval.seq.Map2Seq;
import org.operamasks.el.eval.seq.MappedSeq;
import org.operamasks.el.eval.seq.MappendSeq;
import org.operamasks.el.parser.ELNode;
import org.operamasks.el.parser.Parser;
import org.operamasks.el.resolver.MethodResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Builtin {
    private static Random prng = new Random();
    private static final ELNode.ADD __ADD__ = new ELNode.ADD(-1, null, null);
    private static final ELNode.SUB __SUB__ = new ELNode.SUB(-1, null, null);
    private static final ELNode.MUL __MUL__ = new ELNode.MUL(-1, null, null);
    private static final ELNode.DIV __DIV__ = new ELNode.DIV(-1, null, null);
    private static final ELNode.IDIV __IDIV__ = new ELNode.IDIV(-1, null, null);
    private static final ELNode.REM __REM__ = new ELNode.REM(-1, null, null);
    private static final ELNode.POW __POW__ = new ELNode.POW(-1, null, null);
    private static final ELNode.BITNOT __BITNOT__ = new ELNode.BITNOT(-1, null);
    private static final ELNode.BITOR __BITOR__ = new ELNode.BITOR(-1, null, null);
    private static final ELNode.BITAND __BITAND__ = new ELNode.BITAND(-1, null, null);
    private static final ELNode.XOR __XOR__ = new ELNode.XOR(-1, null, null);
    private static final ELNode.SHL __SHL__ = new ELNode.SHL(-1, null, null);
    private static final ELNode.SHR __SHR__ = new ELNode.SHR(-1, null, null);
    private static final ELNode.USHR __USHR__ = new ELNode.USHR(-1, null, null);
    private static final ELNode.LT __LT__ = new ELNode.LT(-1, null, null);
    private static final ELNode.LE __LE__ = new ELNode.LE(-1, null, null);
    private static final ELNode.GT __GT__ = new ELNode.GT(-1, null, null);
    private static final ELNode.GE __GE__ = new ELNode.GE(-1, null, null);
    private static final ELNode.EQ __EQ__ = new ELNode.EQ(-1, null, null);
    private static final ELNode.NE __NE__ = new ELNode.NE(-1, null, null);
    private static final ELNode.IDEQ __IDEQ__ = new ELNode.IDEQ(-1, null, null);
    private static final ELNode.IDNE __IDNE__ = new ELNode.IDNE(-1, null, null);
    private static final ELNode.EMPTY __EMPTY__ = new ELNode.EMPTY(-1, null);

    private Builtin() {
    }

    public static boolean defined(ELContext elctx, Closure var) {
        if (var instanceof VarClosure) {
            String id;
            EvaluationContext ctx = var.getContext(elctx);
            return ctx.resolveVariable(id = ((VarClosure)var).ident()) != null;
        }
        return false;
    }

    @Expando(name="new")
    public static Object __new__(ELContext elctx, Class cls, Closure ... args) {
        return ELEngine.newInstance(elctx, cls, args);
    }

    @Expando
    public static Object newArray(Class cls, int ... dimensions) {
        return Array.newInstance(cls, dimensions);
    }

    public static Object begin(ELContext elctx, Closure ... exps) {
        if (exps.length == 0) {
            return null;
        }
        int n = exps.length - 1;
        for (int i = 0; i < n; ++i) {
            exps[i].getValue(elctx);
        }
        return Builtin.yield(elctx, exps[n]);
    }

    public static Closure delay(Closure exp) {
        return exp;
    }

    public static Object force(ELContext elctx, Object promise) {
        if (promise instanceof ValueExpression) {
            return ((ValueExpression)promise).getValue(elctx);
        }
        return promise;
    }

    public static Object identity(Object x) {
        return x;
    }

    public static Closure _const(final Object c) {
        return new AbstractClosure(){

            public Object invoke(ELContext elctx, Closure[] args) {
                return c;
            }

            public int arity(ELContext elctx) {
                return 0;
            }

            public boolean isProcedure() {
                return true;
            }

            public String toString() {
                return "const(" + c + ")";
            }
        };
    }

    public static Object coalesce(ELContext elctx, Closure ... exps) {
        for (Closure exp : exps) {
            Object value = exp.getValue(elctx);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static void upto(ELContext elctx, long a, long b, Closure p) {
        while (a <= b) {
            try {
                p.call(elctx, a);
            }
            catch (Control.Break br) {
                break;
            }
            catch (Control.Continue co) {
                // empty catch block
            }
            ++a;
        }
    }

    public static void downto(ELContext elctx, long a, long b, Closure p) {
        while (a >= b) {
            try {
                p.call(elctx, a);
            }
            catch (Control.Break br) {
                break;
            }
            catch (Control.Continue co) {
                // empty catch block
            }
            --a;
        }
    }

    public static void step(ELContext elctx, Object a, Object b, Object i, Closure p) {
        block2 : switch (MathLib.signum(elctx, i)) {
            case 1: {
                while (Builtin.__le__(elctx, a, b)) {
                    try {
                        p.call(elctx, a);
                    }
                    catch (Control.Break br) {
                        break block2;
                    }
                    catch (Control.Continue co) {
                        // empty catch block
                    }
                    a = Builtin.__add__(elctx, a, i);
                }
                break;
            }
            case -1: {
                while (Builtin.__ge__(elctx, a, b)) {
                    try {
                        p.call(elctx, a);
                    }
                    catch (Control.Break br) {
                        break block2;
                    }
                    catch (Control.Continue co) {
                        // empty catch block
                    }
                    a = Builtin.__add__(elctx, a, i);
                }
                break;
            }
            default: {
                throw new ELException("step: the step cannot be zero.");
            }
        }
    }

    public static void times(ELContext elctx, int n, Closure p) {
        for (int i = 0; i < n; ++i) {
            try {
                p.call(elctx, i);
                continue;
            }
            catch (Control.Break b) {
                break;
            }
            catch (Control.Continue c) {
                // empty catch block
            }
        }
    }

    public static Annotation[] annotations(ELContext elctx, Closure var) {
        String id;
        EvaluationContext ctx;
        ValueExpression ve;
        if (var instanceof VarClosure && (ve = (ctx = var.getContext(elctx)).resolveVariable(id = ((VarClosure)var).ident())) instanceof Closure) {
            return ((Closure)ve).getAnnotations();
        }
        return new Annotation[0];
    }

    public static Annotation annotation(ELContext elctx, Closure var, String type) {
        for (Annotation a : Builtin.annotations(elctx, var)) {
            if (!a.getAnnotationType().equals(type)) continue;
            return a;
        }
        return null;
    }

    @Expando
    public static void attach(ELContext elctx, Class cls, String name, Closure closure) {
        MethodResolver resolver = MethodResolver.getInstance(elctx);
        resolver.attachMethod(cls, name, closure);
    }

    @Expando
    public static Object populate(ELContext elctx, Object base, Map<?, ?> properties) {
        if (base instanceof Map) {
            ((Map)base).putAll(properties);
        } else if (base instanceof ClosureObject) {
            ClosureObject clo = (ClosureObject)base;
            for (Map.Entry<?, ?> e : properties.entrySet()) {
                clo.setValue(elctx, e.getKey(), e.getValue());
            }
        } else {
            ELResolver resolver = elctx.getELResolver();
            for (Map.Entry<?, ?> e : properties.entrySet()) {
                resolver.setValue(elctx, base, e.getKey(), e.getValue());
            }
        }
        return base;
    }

    public static Seq list(Object ... args) {
        Cons xs = new Cons();
        int i = args.length;
        while (--i >= 0) {
            xs = new Cons(args[i], xs);
        }
        return xs;
    }

    public static Seq cons(Object head, Seq tail) {
        return new Cons(head, tail);
    }

    public static Seq range(ELContext elctx, Object a, Object b, Object i) {
        if ((a instanceof Long || a instanceof Integer) && (b instanceof Long || b instanceof Integer) && (i instanceof Long || i instanceof Integer)) {
            return Ranges.createRange(((Number)a).longValue(), ((Number)b).longValue(), ((Number)i).longValue());
        }
        if (a instanceof Character && b instanceof Character && i instanceof Integer) {
            return CharRanges.createCharRange(((Character)a).charValue(), ((Character)b).charValue(), (Integer)i);
        }
        switch (MathLib.signum(elctx, i)) {
            case 1: {
                return StepUp.make(elctx, a, b, i);
            }
            case -1: {
                return StepDown.make(elctx, a, b, i);
            }
        }
        throw new ELException("range: the step cannot be zero.");
    }

    public static Seq zip(Seq ... ls) {
        if (ls.length == 0) {
            return Cons.nil();
        }
        return ZipSeq.make(ls);
    }

    public static Seq zipwith(Closure proc, Seq ... ls) {
        if (ls.length == 0) {
            return Cons.nil();
        }
        return ZipWithSeq.make(ls, proc);
    }

    @Expando(global=true)
    public static Seq asList(Object obj) {
        return TypeCoercion.coerceToSeq(obj);
    }

    @Expando(global=true)
    public static Seq asList(Map<?, ?> map) {
        Cons head;
        Cons tail = head = new Cons();
        for (Map.Entry<?, ?> e : map.entrySet()) {
            Object[] x = new Object[]{e.getKey(), e.getValue()};
            Cons t = new Cons();
            tail.set(x);
            tail.set_tail(t);
            tail = t;
        }
        return head;
    }

    public static Object[] toArray(Collection c) {
        return c.toArray();
    }

    public static Object toArray(ELContext elctx, Collection c, Class type) {
        int size = c.size();
        Object array = Array.newInstance(type, size);
        Iterator it = c.iterator();
        for (int i = 0; i < size; ++i) {
            Array.set(array, i, TypeCoercion.coerce(elctx, it.next(), type));
        }
        return array;
    }

    @Expando(global=true)
    public static Object fill(List<Object> lst, Object item) {
        Collections.fill(lst, item);
        return lst;
    }

    @Expando(global=true)
    public static Object[] fill(ELContext elctx, Object[] a, Object x) {
        Arrays.fill(a, TypeCoercion.coerce(elctx, x, a.getClass().getComponentType()));
        return a;
    }

    @Expando(global=true)
    public static byte[] fill(byte[] a, byte x) {
        Arrays.fill(a, x);
        return a;
    }

    @Expando(global=true)
    public static char[] fill(char[] a, char x) {
        Arrays.fill(a, x);
        return a;
    }

    @Expando(global=true)
    public static short[] fill(short[] a, short x) {
        Arrays.fill(a, x);
        return a;
    }

    @Expando(global=true)
    public static int[] fill(int[] a, int x) {
        Arrays.fill(a, x);
        return a;
    }

    @Expando(global=true)
    public static long[] fill(long[] a, long x) {
        Arrays.fill(a, x);
        return a;
    }

    @Expando(global=true)
    public static float[] fill(float[] a, float x) {
        Arrays.fill(a, x);
        return a;
    }

    @Expando(global=true)
    public static double[] fill(double[] a, double x) {
        Arrays.fill(a, x);
        return a;
    }

    @Expando
    public static List push(List lst, Object item) {
        if (item instanceof Collection) {
            lst.addAll((Collection)item);
        } else if (item != null && item.getClass().isArray()) {
            lst.addAll(new ArrayAsList(item));
        } else {
            lst.add(item);
        }
        return lst;
    }

    @Expando
    public static Object pop(List lst) {
        if (!lst.isEmpty()) {
            return lst.remove(lst.size() - 1);
        }
        return null;
    }

    @Expando
    public static List unshift(List lst, Object item) {
        if (item instanceof Collection) {
            lst.addAll(0, (Collection)item);
        } else if (item != null && item.getClass().isArray()) {
            lst.addAll(0, new ArrayAsList(item));
        } else {
            lst.add(0, item);
        }
        return lst;
    }

    @Expando
    public static Object shift(List lst) {
        if (!lst.isEmpty()) {
            return lst.remove(0);
        }
        return null;
    }

    @Expando(global=true)
    public static Object map(ELContext elctx, Object base, Closure proc) {
        if (base instanceof CharSequence) {
            return Builtin.map_string(elctx, (CharSequence)base, proc);
        }
        if (base instanceof Object[]) {
            return Builtin.map_array(elctx, (Object[])base, proc);
        }
        if (base.getClass().isArray()) {
            return Builtin.map_array(elctx, base, proc);
        }
        if (base instanceof Set) {
            return Builtin.map_set(elctx, (Set)base, proc);
        }
        return MappedSeq.make(TypeCoercion.coerceToSeq(base), proc);
    }

    private static String map_string(ELContext elctx, CharSequence str, Closure proc) {
        StringBuilder buf = new StringBuilder();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = TypeCoercion.coerceToCharacter(proc.call(elctx, Character.valueOf(str.charAt(i)))).charValue();
            buf.append(c);
        }
        return buf.toString();
    }

    private static Object[] map_array(ELContext elctx, Object[] a, Closure proc) {
        int size = a.length;
        Object[] b = new Object[size];
        for (int i = 0; i < size; ++i) {
            b[i] = proc.call(elctx, a[i]);
        }
        return b;
    }

    private static Object map_array(ELContext elctx, Object a, Closure proc) {
        int size = Array.getLength(a);
        Object[] b = new Object[size];
        for (int i = 0; i < size; ++i) {
            b[i] = proc.call(elctx, Array.get(a, i));
        }
        return b;
    }

    private static Object map_set(ELContext elctx, Set set, Closure proc) {
        LinkedHashSet<Object> r = new LinkedHashSet<Object>();
        for (Object o : set) {
            r.add(proc.call(elctx, o));
        }
        return r;
    }

    public static Object map2(ELContext elctx, Object a, Object b, Closure proc) {
        if (a instanceof CharSequence && b instanceof CharSequence) {
            return Builtin.map2_string(elctx, (CharSequence)a, (CharSequence)b, proc);
        }
        if (a instanceof Object[] && b instanceof Object[]) {
            return Builtin.map2_array(elctx, (Object[])a, (Object[])b, proc);
        }
        if (a.getClass().isArray() && b.getClass().isArray()) {
            return Builtin.map2_array(elctx, a, b, proc);
        }
        return Map2Seq.make(TypeCoercion.coerceToSeq(a), TypeCoercion.coerceToSeq(b), proc);
    }

    private static String map2_string(ELContext elctx, CharSequence a, CharSequence b, Closure proc) {
        int len = Math.min(a.length(), b.length());
        StringBuilder buf = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = TypeCoercion.coerceToCharacter(proc.call(elctx, Character.valueOf(a.charAt(i)), Character.valueOf(b.charAt(i)))).charValue();
            buf.append(c);
        }
        return buf.toString();
    }

    private static Object map2_array(ELContext elctx, Object[] a, Object[] b, Closure proc) {
        int size = Math.min(a.length, b.length);
        Object[] r = new Object[size];
        for (int i = 0; i < size; ++i) {
            r[i] = proc.call(elctx, a[i], b[i]);
        }
        return r;
    }

    private static Object map2_array(ELContext elctx, Object a, Object b, Closure proc) {
        int size = Math.min(Array.getLength(a), Array.getLength(b));
        Object[] r = new Object[size];
        for (int i = 0; i < size; ++i) {
            r[i] = proc.call(elctx, Array.get(a, i), Array.get(b, i));
        }
        return r;
    }

    @Expando(global=true)
    public static Object filter(ELContext elctx, Object base, Closure pred) {
        if (base instanceof CharSequence) {
            return Builtin.filter_string(elctx, (CharSequence)base, pred);
        }
        if (base instanceof Set) {
            return Builtin.filter_set(elctx, (Set)base, pred);
        }
        return FilteredSeq.make(TypeCoercion.coerceToSeq(base), pred);
    }

    private static String filter_string(ELContext elctx, CharSequence str, Closure pred) {
        StringBuilder buf = new StringBuilder();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (!pred.test(elctx, Character.valueOf(c))) continue;
            buf.append(c);
        }
        return buf.toString();
    }

    private static Set filter_set(ELContext elctx, Set set, Closure pred) {
        LinkedHashSet r = new LinkedHashSet();
        for (Object o : set) {
            if (!pred.test(elctx, o)) continue;
            r.add(o);
        }
        return r;
    }

    @Expando(global=true)
    public static Seq mappend(Seq seq, Closure proc) {
        return MappendSeq.make(seq, proc);
    }

    @Expando(global=true)
    public static Seq flatmap(Seq seq, Closure proc) {
        return MappendSeq.make(seq, proc);
    }

    @Expando
    public static Seq[] splitWith(Seq seq, Closure pred) {
        return SplitSeq.make(seq, pred);
    }

    @Expando
    public static Seq[] splitAt(Seq seq, int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index:" + index);
        }
        Cons head = new Cons();
        for (int i = 0; i < index; ++i) {
            if (seq.isEmpty()) {
                throw new IndexOutOfBoundsException("Index:" + index);
            }
            head = new Cons(seq.get(), head);
            seq = seq.tail();
        }
        return new Seq[]{head.reverse(), seq};
    }

    @Expando(global=true)
    public static Object find(ELContext elctx, Iterable c, Closure pred) {
        for (Object e : c) {
            if (!pred.test(elctx, e)) continue;
            return e;
        }
        return null;
    }

    @Expando(global=true)
    public static boolean forall(ELContext elctx, Object xs, Closure pred) {
        if (xs == null) {
            return true;
        }
        if (xs instanceof Iterable) {
            for (Object e : (Iterable)xs) {
                if (pred.test(elctx, e)) continue;
                return false;
            }
        } else if (xs instanceof Map) {
            for (Map.Entry e : ((Map)xs).entrySet()) {
                if (pred.test(elctx, e)) continue;
                return false;
            }
        } else if (xs instanceof CharSequence) {
            CharSequence cs = (CharSequence)xs;
            int len = cs.length();
            for (int i = 0; i < len; ++i) {
                if (pred.test(elctx, Character.valueOf(cs.charAt(i)))) continue;
                return false;
            }
        } else if (xs instanceof Object[]) {
            for (Object e : (Object[])xs) {
                if (pred.test(elctx, e)) continue;
                return false;
            }
        } else if (xs.getClass().isArray()) {
            int len = Array.getLength(xs);
            for (int i = 0; i < len; ++i) {
                if (pred.test(elctx, Array.get(xs, i))) continue;
                return false;
            }
        } else {
            throw new IllegalArgumentException("not a collection type");
        }
        return true;
    }

    @Expando(global=true)
    public static boolean forany(ELContext elctx, Object xs, Closure pred) {
        block6: {
            block9: {
                block8: {
                    block7: {
                        block5: {
                            if (!(xs instanceof Iterable)) break block5;
                            for (Object e : (Iterable)xs) {
                                if (!pred.test(elctx, e)) continue;
                                return true;
                            }
                            break block6;
                        }
                        if (!(xs instanceof Map)) break block7;
                        for (Map.Entry e : ((Map)xs).entrySet()) {
                            if (!pred.test(elctx, e)) continue;
                            return true;
                        }
                        break block6;
                    }
                    if (!(xs instanceof CharSequence)) break block8;
                    CharSequence cs = (CharSequence)xs;
                    int len = cs.length();
                    for (int i = 0; i < len; ++i) {
                        if (!pred.test(elctx, Character.valueOf(cs.charAt(i)))) continue;
                        return true;
                    }
                    break block6;
                }
                if (!(xs instanceof Object[])) break block9;
                for (Object e : (Object[])xs) {
                    if (!pred.test(elctx, e)) continue;
                    return true;
                }
                break block6;
            }
            if (xs == null || !xs.getClass().isArray()) break block6;
            int len = Array.getLength(xs);
            for (int i = 0; i < len; ++i) {
                if (!pred.test(elctx, Array.get(xs, i))) continue;
                return true;
            }
        }
        return false;
    }

    @Expando(global=true)
    @Alias(value={"each", "foreach", "iterate"})
    public static void each(ELContext elctx, Object xs, Closure proc) {
        block20: {
            block24: {
                block23: {
                    block22: {
                        block21: {
                            if (!(xs instanceof Iterable)) break block21;
                            for (Object e : (Iterable)xs) {
                                try {
                                    proc.call(elctx, e);
                                }
                                catch (Control.Continue c) {
                                }
                                catch (Control.Break b) {
                                    break block20;
                                }
                            }
                            break block20;
                        }
                        if (!(xs instanceof Map)) break block22;
                        for (Map.Entry e : ((Map)xs).entrySet()) {
                            try {
                                proc.call(elctx, e);
                            }
                            catch (Control.Continue c) {
                            }
                            catch (Control.Break b) {
                                break block20;
                            }
                        }
                        break block20;
                    }
                    if (!(xs instanceof CharSequence)) break block23;
                    CharSequence cs = (CharSequence)xs;
                    int len = cs.length();
                    for (int i = 0; i < len; ++i) {
                        try {
                            proc.call(elctx, Character.valueOf(cs.charAt(i)));
                            continue;
                        }
                        catch (Control.Continue c) {
                            continue;
                        }
                        catch (Control.Break b) {
                            break block20;
                        }
                    }
                    break block20;
                }
                if (!(xs instanceof Object[])) break block24;
                for (Object e : (Object[])xs) {
                    try {
                        proc.call(elctx, e);
                    }
                    catch (Control.Continue c) {
                    }
                    catch (Control.Break b) {
                        break block20;
                    }
                }
                break block20;
            }
            if (xs == null || !xs.getClass().isArray()) break block20;
            int len = Array.getLength(xs);
            for (int i = 0; i < len; ++i) {
                try {
                    proc.call(elctx, Array.get(xs, i));
                    continue;
                }
                catch (Control.Continue c) {
                    continue;
                }
                catch (Control.Break b) {
                    break;
                }
            }
        }
    }

    @Expando
    public static Object bind(ELContext elctx, Object arg, Closure proc) {
        if (arg == null) {
            return null;
        }
        if (arg instanceof Iterable) {
            for (Object e : (Iterable)arg) {
                try {
                    proc.call(elctx, e);
                }
                catch (Control.Continue c) {
                }
                catch (Control.Break b) {
                    break;
                }
            }
            return null;
        }
        if (arg instanceof Object[]) {
            for (Object e : (Object[])arg) {
                try {
                    proc.call(elctx, e);
                }
                catch (Control.Continue c) {
                }
                catch (Control.Break b) {
                    break;
                }
            }
            return null;
        }
        if (arg.getClass().isArray()) {
            int len = Array.getLength(arg);
            for (int i = 0; i < len; ++i) {
                try {
                    proc.call(elctx, Array.get(arg, i));
                    continue;
                }
                catch (Control.Continue c) {
                    continue;
                }
                catch (Control.Break b) {
                    break;
                }
            }
            return null;
        }
        return proc.call(elctx, arg);
    }

    @Expando(name="do")
    public static Object _do(ELContext elctx, Object arg, Procedure proc) {
        if (arg == null) {
            return null;
        }
        if (arg instanceof Iterable) {
            for (Object e : (Iterable)arg) {
                try {
                    proc.call_with(elctx, e, new Closure[0]);
                }
                catch (Control.Continue c) {
                }
                catch (Control.Break b) {
                    break;
                }
            }
            return null;
        }
        if (arg instanceof Object[]) {
            for (Object e : (Object[])arg) {
                try {
                    proc.call_with(elctx, e, new Closure[0]);
                }
                catch (Control.Continue c) {
                }
                catch (Control.Break b) {
                    break;
                }
            }
            return null;
        }
        if (arg.getClass().isArray()) {
            int len = Array.getLength(arg);
            for (int i = 0; i < len; ++i) {
                try {
                    proc.call_with(elctx, Array.get(arg, i), new Closure[0]);
                    continue;
                }
                catch (Control.Continue c) {
                    continue;
                }
                catch (Control.Break b) {
                    break;
                }
            }
            return null;
        }
        return proc.call_with(elctx, arg, new Closure[0]);
    }

    @Expando(global=true)
    public static Object foldl(ELContext elctx, Object xs, Object z, Closure proc) {
        block6: {
            block9: {
                block8: {
                    block7: {
                        block5: {
                            if (!(xs instanceof Iterable)) break block5;
                            for (Object e : (Iterable)xs) {
                                z = proc.call(elctx, z, e);
                            }
                            break block6;
                        }
                        if (!(xs instanceof Map)) break block7;
                        for (Map.Entry e : ((Map)xs).entrySet()) {
                            z = proc.call(elctx, z, e);
                        }
                        break block6;
                    }
                    if (!(xs instanceof CharSequence)) break block8;
                    CharSequence cs = (CharSequence)xs;
                    int len = cs.length();
                    for (int i = 0; i < len; ++i) {
                        z = proc.call(elctx, z, Character.valueOf(cs.charAt(i)));
                    }
                    break block6;
                }
                if (!(xs instanceof Object[])) break block9;
                for (Object e : (Object[])xs) {
                    z = proc.call(elctx, z, e);
                }
                break block6;
            }
            if (xs == null || !xs.getClass().isArray()) break block6;
            int len = Array.getLength(xs);
            for (int i = 0; i < len; ++i) {
                z = proc.call(elctx, z, Array.get(xs, i));
            }
        }
        return z;
    }

    @Expando(global=true)
    public static Object foldr(ELContext elctx, Object xs, Object z, Closure proc) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (!(xs instanceof List) || !(xs instanceof RandomAccess)) break block5;
                        ListIterator i = ((List)xs).listIterator(((List)xs).size());
                        while (i.hasPrevious()) {
                            z = proc.call(elctx, i.previous(), z);
                        }
                        break block6;
                    }
                    if (xs instanceof Collection) {
                        return Builtin.foldr(elctx, ((Collection)xs).toArray(), z, proc);
                    }
                    if (!(xs instanceof CharSequence)) break block7;
                    CharSequence cs = (CharSequence)xs;
                    int i = cs.length();
                    while (--i >= 0) {
                        z = proc.call(elctx, Character.valueOf(cs.charAt(i)), z);
                    }
                    break block6;
                }
                if (!(xs instanceof Object[])) break block8;
                Object[] a = (Object[])xs;
                int i = a.length;
                while (--i >= 0) {
                    z = proc.call(elctx, a[i], z);
                }
                break block6;
            }
            if (xs == null || !xs.getClass().isArray()) break block6;
            int i = Array.getLength(xs);
            while (--i >= 0) {
                z = proc.call(elctx, Array.get(xs, i), z);
            }
        }
        return z;
    }

    public static Object fold2(ELContext elctx, Object a, Object b, Object z, Closure p) {
        block4: {
            block5: {
                block3: {
                    if (!(a instanceof Iterable) || !(b instanceof Iterable)) break block3;
                    Iterator ia = ((Iterable)a).iterator();
                    Iterator ib = ((Iterable)b).iterator();
                    while (ia.hasNext() && ib.hasNext()) {
                        z = p.call(elctx, z, ia.next(), ib.next());
                    }
                    break block4;
                }
                if (!(a instanceof Object[]) || !(b instanceof Object[])) break block5;
                Object[] aa = (Object[])a;
                Object[] ba = (Object[])b;
                int size = Math.min(aa.length, ba.length);
                for (int i = 0; i < size; ++i) {
                    z = p.call(elctx, z, aa[i], ba[i]);
                }
                break block4;
            }
            if (!a.getClass().isArray() || !b.getClass().isArray()) break block4;
            int size = Math.min(Array.getLength(a), Array.getLength(b));
            for (int i = 0; i < size; ++i) {
                z = p.call(elctx, z, Array.get(a, i), Array.get(b, i));
            }
        }
        return z;
    }

    @Expando(global=true)
    public static Seq unfold(ELContext elctx, Object init, Closure next, Closure pred) {
        return UnfoldSeq.make(elctx, init, next, pred);
    }

    @Expando(global=true)
    public static Seq unfold(ELContext elctx, Object init, Closure next) {
        return UnfoldSeq.make(elctx, init, next, null);
    }

    @Expando(global=true)
    public static void removeIf(ELContext elctx, Object xs, Closure pred) {
        Iterator<Object> it;
        if (xs instanceof Iterable) {
            it = ((Iterable)xs).iterator();
        } else if (xs instanceof Map) {
            it = ((Map)xs).entrySet().iterator();
        } else {
            return;
        }
        while (it.hasNext()) {
            if (!pred.test(elctx, it.next())) continue;
            it.remove();
        }
    }

    @Expando(global=true)
    public static Collection sort(Collection c) {
        Object[] a = c.toArray();
        Arrays.sort(a);
        return ArraySeq.make(a);
    }

    @Expando(global=true)
    public static Collection sort(ELContext elctx, Collection c, Closure comp) {
        Object[] a = c.toArray();
        Arrays.sort(a, Builtin.make_comparator(elctx, comp));
        return ArraySeq.make(a);
    }

    @Expando(global=true)
    public static Object[] sort(Object[] a) {
        a = (Object[])a.clone();
        Arrays.sort(a);
        return a;
    }

    @Expando(global=true)
    public static Object[] sort(ELContext elctx, Object[] a, Closure comp) {
        a = (Object[])a.clone();
        Arrays.sort(a, Builtin.make_comparator(elctx, comp));
        return a;
    }

    @Expando(global=true)
    public static byte[] sort(byte[] a) {
        a = (byte[])a.clone();
        Arrays.sort(a);
        return a;
    }

    @Expando(global=true)
    public static short[] sort(short[] a) {
        a = (short[])a.clone();
        Arrays.sort(a);
        return a;
    }

    @Expando(global=true)
    public static char[] sort(char[] a) {
        a = (char[])a.clone();
        Arrays.sort(a);
        return a;
    }

    @Expando(global=true)
    public static int[] sort(int[] a) {
        a = (int[])a.clone();
        Arrays.sort(a);
        return a;
    }

    @Expando(global=true)
    public static long[] sort(long[] a) {
        a = (long[])a.clone();
        Arrays.sort(a);
        return a;
    }

    @Expando(global=true)
    public static float[] sort(float[] a) {
        a = (float[])a.clone();
        Arrays.sort(a);
        return a;
    }

    @Expando(global=true)
    public static double[] sort(double[] a) {
        a = (double[])a.clone();
        Arrays.sort(a);
        return a;
    }

    @Expando(global=true)
    public static Object reverse(Object base) {
        if (base instanceof Seq) {
            return ((Seq)base).reverse();
        }
        if (base instanceof String) {
            char[] cs = ((String)base).toCharArray();
            int size = cs.length;
            int i = 0;
            int mid = size >> 1;
            int j = size - 1;
            while (i < mid) {
                char t = cs[i];
                cs[i] = cs[j];
                cs[j] = t;
                ++i;
                --j;
            }
            return new String(cs);
        }
        if (base instanceof Collection) {
            ArrayList rev = new ArrayList((Collection)base);
            Collections.reverse(rev);
            return rev;
        }
        if (base != null && base.getClass().isArray()) {
            Collections.reverse(new ArrayAsList(base));
            return base;
        }
        return null;
    }

    @Expando(global=true)
    public static Object shuffle(Object base) {
        if (base instanceof Collection) {
            ArrayList lst = new ArrayList((Collection)base);
            Collections.shuffle(lst);
            return lst;
        }
        if (base != null && base.getClass().isArray()) {
            Collections.shuffle(new ArrayAsList(base));
            return base;
        }
        return null;
    }

    @Expando(global=true)
    public static String join(Iterable c) {
        return Builtin.join(c, null);
    }

    @Expando(global=true)
    public static String join(Iterable c, String sep) {
        StringBuilder buf = new StringBuilder();
        Iterator i = c.iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Object o = i.next();
            buf.append(TypeCoercion.coerceToString(o));
            hasNext = i.hasNext();
            if (!hasNext || sep == null) continue;
            buf.append(sep);
        }
        return buf.toString();
    }

    @Expando
    public static boolean matches(CharSequence str, Object pattern) {
        if (pattern instanceof Pattern) {
            return ((Pattern)pattern).matcher(str).matches();
        }
        return ((Object)str).toString().matches(pattern.toString());
    }

    @Expando
    public static String[] match(CharSequence str, Object arg) {
        Pattern p = arg instanceof Pattern ? (Pattern)arg : Pattern.compile(TypeCoercion.coerceToString(arg));
        Matcher m = p.matcher(str);
        if (m.matches()) {
            int count = m.groupCount();
            String[] result = new String[count + 1];
            for (int i = 0; i <= count; ++i) {
                result[i] = m.group(i);
            }
            return result;
        }
        return null;
    }

    @Expando
    public static String replace(String str, Object pattern, String repl) {
        if (pattern instanceof Pattern) {
            Matcher m = ((Pattern)pattern).matcher(str);
            return m.replaceAll(repl);
        }
        if (pattern instanceof Character) {
            return str.replace(((Character)pattern).charValue(), TypeCoercion.coerceToCharacter(repl).charValue());
        }
        return str.replace(TypeCoercion.coerceToString(pattern), TypeCoercion.coerceToString(repl));
    }

    @Expando
    public static boolean isLower(Character c) {
        return Character.isLowerCase(c.charValue());
    }

    @Expando
    public static boolean isLowerCase(Character c) {
        return Character.isLowerCase(c.charValue());
    }

    @Expando
    public static boolean isUpper(Character c) {
        return Character.isUpperCase(c.charValue());
    }

    @Expando
    public static boolean isUpperCase(Character c) {
        return Character.isUpperCase(c.charValue());
    }

    @Expando
    public static boolean isDigit(Character c) {
        return Character.isDigit(c.charValue());
    }

    @Expando
    public static boolean isLetter(Character c) {
        return Character.isLetter(c.charValue());
    }

    @Expando
    public static boolean isLetterOrDigit(Character c) {
        return Character.isLetterOrDigit(c.charValue());
    }

    @Expando
    public static boolean isJavaIdentifierStart(Character c) {
        return Character.isJavaIdentifierStart(c.charValue());
    }

    @Expando
    public static boolean isJavaIdentifierPart(Character c) {
        return Character.isJavaIdentifierPart(c.charValue());
    }

    @Expando
    public static boolean isWhitespace(Character c) {
        return Character.isWhitespace(c.charValue());
    }

    @Expando
    public static boolean isSpace(Character c) {
        return Character.isWhitespace(c.charValue());
    }

    @Expando
    public static boolean isControl(Character c) {
        return Character.isISOControl(c.charValue());
    }

    @Expando
    public static char toLowerCase(Character c) {
        return Character.toLowerCase(c.charValue());
    }

    @Expando
    public static char toLower(Character c) {
        return Character.toLowerCase(c.charValue());
    }

    @Expando
    public static char toUpperCase(Character c) {
        return Character.toUpperCase(c.charValue());
    }

    @Expando
    public static char toUpper(Character c) {
        return Character.toUpperCase(c.charValue());
    }

    public static void srand(long seed) {
        prng.setSeed(seed);
    }

    public static double rand() {
        return prng.nextDouble();
    }

    public static int rand(int n) {
        return prng.nextInt(n);
    }

    public static boolean is_procedure(Object obj) {
        return obj instanceof Closure && ((Closure)((Object)obj)).isProcedure();
    }

    public static Object eval(ELContext elctx, String exp) {
        return Builtin.eval(exp, new EvaluationContext(elctx));
    }

    public static Object eval(ELContext elctx, String exp, Map<String, Object> env) {
        VariableMapperImpl vm = new VariableMapperImpl();
        for (Map.Entry<String, Object> e : env.entrySet()) {
            Object value = e.getValue();
            ValueExpression ve = value instanceof ValueExpression ? (ValueExpression)value : new LiteralClosure(value);
            vm.setVariable(e.getKey(), ve);
        }
        return Builtin.eval(exp, new EvaluationContext(elctx, null, vm));
    }

    public static Object eval(String exp, EvaluationContext env) {
        if (exp.indexOf("#{") == -1 && exp.indexOf("${") == -1) {
            exp = "#{" + exp + "}";
        }
        return Parser.parse(exp).getValue(env);
    }

    public static Thread thread(final ELContext elctx, final Closure proc) {
        return new Thread(){

            public void run() {
                proc.call(DelegatingELContext.get(elctx), new Object[0]);
            }
        };
    }

    public static Thread start_thread(ELContext elctx, Closure proc) {
        Thread t = Builtin.thread(elctx, proc);
        t.start();
        return t;
    }

    public static void print(ELContext elctx, Object obj) {
        PrintWriter out = Builtin.getPrintWriter(elctx);
        Builtin.print0(out, obj);
        out.println();
        out.flush();
    }

    private static void print0(PrintWriter out, Object obj) {
        if (obj == null) {
            out.print("null");
        } else if (obj instanceof Range || obj instanceof CharRange) {
            out.print(obj.toString());
        } else if (obj instanceof Seq) {
            boolean sep = false;
            out.print("[");
            Seq xs = (Seq)obj;
            while (!xs.isEmpty()) {
                Object x = xs.get();
                if (sep) {
                    out.print(", ");
                }
                sep = true;
                if (x instanceof String) {
                    StringBuilder buf = new StringBuilder();
                    TypeCoercion.escape(buf, (String)x);
                    out.print(buf);
                } else if (x instanceof Character) {
                    String esc = TypeCoercion.escape(((Character)x).charValue());
                    out.print("#'" + (esc != null ? esc : x) + "'");
                } else {
                    Builtin.print0(out, x);
                }
                out.flush();
                xs = xs.tail();
            }
            out.print("]");
        } else {
            out.print(TypeCoercion.coerceToString(obj));
        }
    }

    private static PrintWriter getPrintWriter(ELContext elctx) {
        ScriptContext sctx = (ScriptContext)elctx.getContext(ScriptContext.class);
        if (sctx != null) {
            Writer w = sctx.getWriter();
            if (w instanceof PrintWriter) {
                return (PrintWriter)w;
            }
            return new PrintWriter(w);
        }
        return new PrintWriter(System.out);
    }

    public static void newline(ELContext elctx) {
        PrintWriter out = Builtin.getPrintWriter(elctx);
        out.println();
        out.flush();
    }

    public static void printf(ELContext elctx, String format, Object ... args) {
        Builtin.getPrintWriter(elctx).printf(format, args);
    }

    public static String sprintf(String format, Object ... args) {
        return String.format(format, args);
    }

    @Expando
    public static String format(ELContext elctx, Number value) {
        return NumberFormat.getInstance(Builtin.getLocale(elctx)).format(value);
    }

    @Expando
    public static String format(ELContext elctx, Number value, String pattern) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Builtin.getLocale(elctx));
        DecimalFormat format = new DecimalFormat(pattern, symbols);
        return format.format(value);
    }

    @Expando
    public static String format(ELContext elctx, Date value, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern, Builtin.getLocale(elctx));
        return format.format(value);
    }

    @Alias(value={"+"})
    public static Object __add__(ELContext elctx, Object x, Object y) {
        return __ADD__.getValue(elctx, x, y);
    }

    @Alias(value={"-"})
    public static Object __sub__(ELContext elctx, Object x, Object y) {
        return __SUB__.getValue(elctx, x, y);
    }

    @Alias(value={"*"})
    public static Object __mul__(ELContext elctx, Object x, Object y) {
        return __MUL__.getValue(elctx, x, y);
    }

    @Alias(value={"/"})
    public static Object __div__(ELContext elctx, Object x, Object y) {
        return __DIV__.getValue(elctx, x, y);
    }

    @Alias(value={"div"})
    public static Object __idiv__(ELContext elctx, Object x, Object y) {
        return __IDIV__.getValue(elctx, x, y);
    }

    @Alias(value={"%", "mod"})
    public static Object __rem__(ELContext elctx, Object x, Object y) {
        return __REM__.getValue(elctx, x, y);
    }

    @Alias(value={"^"})
    public static Object __pow__(ELContext elctx, Object x, Object y) {
        return __POW__.getValue(elctx, x, y);
    }

    @Alias(value={"~"})
    public static Object __bitnot__(ELContext elctx, Object x) {
        return __BITNOT__.getValue(elctx, x);
    }

    @Alias(value={"|"})
    public static Object __bitor__(ELContext elctx, Object x, Object y) {
        return __BITOR__.getValue(elctx, x, y);
    }

    @Alias(value={"&"})
    public static Object __bitand__(ELContext elctx, Object x, Object y) {
        return __BITAND__.getValue(elctx, x, y);
    }

    @Alias(value={"xor"})
    public static Object __xor__(ELContext elctx, Object x, Object y) {
        return __XOR__.getValue(elctx, x, y);
    }

    @Alias(value={"<<", "shl"})
    public static Object __shl__(ELContext elctx, Object x, Object y) {
        return __SHL__.getValue(elctx, x, y);
    }

    @Alias(value={">>", "shr"})
    public static Object __shr__(ELContext elctx, Object x, Object y) {
        return __SHR__.getValue(elctx, x, y);
    }

    @Alias(value={">>>", "ushr"})
    public static Object __ushr__(ELContext elctx, Object x, Object y) {
        return __USHR__.getValue(elctx, x, y);
    }

    @Alias(value={"??"})
    public static Object __coalesce__(ELContext elctx, Object x, Closure y) {
        return x != null ? x : y.getValue(elctx);
    }

    @Alias(value={"<", "lt"})
    public static boolean __lt__(ELContext elctx, Object x, Object y) {
        return (Boolean)__LT__.getValue(elctx, x, y);
    }

    @Alias(value={"<=", "le"})
    public static boolean __le__(ELContext elctx, Object x, Object y) {
        return (Boolean)__LE__.getValue(elctx, x, y);
    }

    @Alias(value={">", "gt"})
    public static boolean __gt__(ELContext elctx, Object x, Object y) {
        return (Boolean)__GT__.getValue(elctx, x, y);
    }

    @Alias(value={">=", "ge"})
    public static boolean __ge__(ELContext elctx, Object x, Object y) {
        return (Boolean)__GE__.getValue(elctx, x, y);
    }

    @Alias(value={"==", "eq"})
    public static boolean __eq__(ELContext elctx, Object x, Object y) {
        return (Boolean)__EQ__.getValue(elctx, x, y);
    }

    @Alias(value={"!=", "ne"})
    public static boolean __ne__(ELContext elctx, Object x, Object y) {
        return (Boolean)__NE__.getValue(elctx, x, y);
    }

    @Alias(value={"==="})
    public static boolean __ideq__(ELContext elctx, Object x, Object y) {
        return (Boolean)__IDEQ__.getValue(elctx, x, y);
    }

    @Alias(value={"!=="})
    public static boolean __idne__(ELContext elctx, Object x, Object y) {
        return (Boolean)__IDNE__.getValue(elctx, x, y);
    }

    @Alias(value={"!", "not"})
    public static Object __not__(Object x) {
        return TypeCoercion.coerceToBoolean(x) == false;
    }

    @Alias(value={"&&", "and"})
    public static boolean __and__(ELContext elctx, boolean x, Closure y) {
        return x && TypeCoercion.coerceToBoolean(y.getValue(elctx)) != false;
    }

    @Alias(value={"||", "or"})
    public static boolean __or__(ELContext elctx, boolean x, Closure y) {
        return x || TypeCoercion.coerceToBoolean(y.getValue(elctx)) != false;
    }

    public static Object empty(ELContext elctx, Object x) {
        return __EMPTY__.getValue(elctx, x);
    }

    @Expando(name="<<")
    public static Object __lshift__(Appendable lhs, Object rhs) throws IOException {
        lhs.append(TypeCoercion.coerceToString(rhs));
        return lhs;
    }

    @Expando(name="<<")
    public static Object __lshift__(Collection lhs, Object rhs) {
        if (rhs instanceof Collection) {
            lhs.addAll((Collection)rhs);
        } else {
            lhs.add(rhs);
        }
        return lhs;
    }

    @Expando(name="+")
    public static Seq __add__(Seq lhs, Object rhs) {
        if (rhs instanceof Collection) {
            return lhs.append(TypeCoercion.coerceToSeq(rhs));
        }
        return lhs.append(Cons.make(rhs));
    }

    @Expando(name="+")
    public static Collection __add__(Collection lhs, Object rhs) {
        lhs = new ArrayList<Object>(lhs);
        if (rhs instanceof Collection) {
            lhs.addAll((Collection)rhs);
        } else {
            lhs.add(rhs);
        }
        return lhs;
    }

    @Expando(name="+=")
    public static Object __iadd__(Collection lhs, Object rhs) {
        if (rhs instanceof Collection) {
            lhs.addAll((Collection)rhs);
        } else {
            lhs.add(rhs);
        }
        return lhs;
    }

    @Expando(name="-")
    public static Seq __sub__(Seq lhs, Object rhs) {
        if (TypeCoercion.canCoerceToSeq(rhs)) {
            return MinusSeq.make(lhs, TypeCoercion.coerceToSeq(rhs));
        }
        return MinusSeq.make(lhs, rhs);
    }

    @Expando(name="-")
    public static Collection __sub__(Collection lhs, Object rhs) {
        lhs = new ArrayList(lhs);
        if (rhs instanceof Collection) {
            lhs.removeAll((Collection)rhs);
        } else {
            lhs.remove(rhs);
        }
        return lhs;
    }

    @Expando(name="-=")
    public static Collection __isub__(Collection lhs, Object rhs) {
        if (rhs instanceof Collection) {
            lhs.removeAll((Collection)rhs);
        } else {
            lhs.remove(rhs);
        }
        return lhs;
    }

    @Expando(name="|")
    public static Collection __union__(Collection lhs, Collection rhs) {
        if (lhs instanceof SortedSet) {
            lhs = new TreeSet(lhs);
            lhs.addAll(rhs);
        } else if (lhs instanceof Set) {
            lhs = new HashSet(lhs);
            lhs.addAll(rhs);
        } else {
            lhs = new ArrayList(lhs);
            lhs.removeAll(rhs);
            lhs.addAll(rhs);
        }
        return lhs;
    }

    @Expando(name="|=")
    public static Collection __iunion__(Collection lhs, Collection rhs) {
        if (lhs instanceof Set) {
            lhs.addAll(rhs);
        } else {
            lhs.removeAll(rhs);
            lhs.addAll(rhs);
        }
        return lhs;
    }

    @Expando(name="&")
    public static Collection __intersect__(Collection lhs, Collection rhs) {
        if (lhs instanceof SortedSet) {
            lhs = new TreeSet(lhs);
            lhs.retainAll(rhs);
        } else if (lhs instanceof Set) {
            lhs = new HashSet(lhs);
            lhs.retainAll(rhs);
        } else {
            lhs = new ArrayList(lhs);
            lhs.retainAll(rhs);
        }
        return lhs;
    }

    @Expando(name="&=")
    public static Collection __iintersect__(Collection lhs, Collection rhs) {
        lhs.retainAll(rhs);
        return lhs;
    }

    private static Object yield(ELContext elctx, Closure proc) {
        Object result = proc.getValue(elctx);
        if (result instanceof Closure) {
            result = ((Closure)((Object)result)).invoke(elctx, ELUtils.NO_PARAMS);
        }
        return result;
    }

    private static Comparator make_comparator(final ELContext elctx, final Closure comp) {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return TypeCoercion.coerceToInt(comp.call(elctx, o1, o2));
            }
        };
    }

    static Locale getLocale(ELContext elctx) {
        Locale locale;
        if (elctx != null && (locale = elctx.getLocale()) != null) {
            return locale;
        }
        return Locale.getDefault();
    }

    private static class ArrayAsList
    extends AbstractList
    implements RandomAccess,
    Serializable {
        private final Object a;

        ArrayAsList(Object array) {
            this.a = array;
        }

        public int size() {
            return Array.getLength(this.a);
        }

        public Object[] toArray() {
            if (this.a instanceof Object[]) {
                return (Object[])this.a;
            }
            return super.toArray();
        }

        public Object get(int index) {
            return Array.get(this.a, index);
        }

        public Object set(int index, Object value) {
            Object oldValue = Array.get(this.a, index);
            Array.set(this.a, index, value);
            return oldValue;
        }

        public int indexOf(Object o) {
            int size = Array.getLength(this.a);
            if (o == null) {
                for (int i = 0; i < size; ++i) {
                    if (Array.get(this.a, i) != null) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    if (!o.equals(Array.get(this.a, i))) continue;
                    return i;
                }
            }
            return -1;
        }

        public boolean contains(Object o) {
            return this.indexOf(o) != -1;
        }
    }

    static class MinusSeq
    extends DelaySeq {
        private Seq xs;
        private Object el;

        private MinusSeq(Seq xs, Object el) {
            this.xs = xs;
            this.el = el;
        }

        static Seq make(Seq xs, Object el) {
            if (xs.isEmpty()) {
                return xs;
            }
            return new MinusSeq(xs, el);
        }

        static Seq make(Seq xs, Seq ys) {
            if (ys.isEmpty() || xs.isEmpty()) {
                return xs;
            }
            Object y = ys.get();
            ys = ys.tail();
            return MinusSeq.make((Seq)new MinusSeq(xs, y), ys);
        }

        protected void force() {
            block2: {
                block3: {
                    Object x;
                    block1: {
                        if (this.xs == null) break block2;
                        do {
                            x = this.xs.get();
                            this.xs = this.xs.tail();
                            if (!ELNode.EQ.equals(null, x, this.el)) break block1;
                        } while (!this.xs.isEmpty());
                        this.head = null;
                        this.tail = null;
                        break block3;
                    }
                    this.head = x;
                    this.tail = MinusSeq.make(this.xs, this.el);
                }
                this.xs = null;
                this.el = null;
            }
        }
    }

    private static class UnfoldSeq
    extends DelaySeq {
        private ELContext elctx;
        private Closure next;
        private Closure pred;

        private UnfoldSeq(ELContext elctx, Object init, Closure next, Closure pred) {
            this.elctx = elctx;
            this.head = init;
            this.next = next;
            this.pred = pred;
        }

        static Seq make(ELContext elctx, Object init, Closure next, Closure pred) {
            if (pred != null && pred.test(elctx, init)) {
                return Cons.make(init);
            }
            if (pred == null && init == null) {
                return Cons.nil();
            }
            return new UnfoldSeq(elctx, init, next, pred);
        }

        protected void force() {
            if (this.next != null) {
                Closure n = this.next;
                Closure p = this.pred;
                this.pred = null;
                this.next = null;
                try {
                    this.tail = UnfoldSeq.make(this.elctx, n.call(this.elctx, this.head), n, p);
                }
                catch (Control.Break b) {
                    this.tail = Cons.nil();
                }
            }
        }
    }

    static class SplitSeq {
        protected Seq xs;
        protected Closure pred;
        protected SubSeq left;
        protected SubSeq right;

        private SplitSeq(Seq xs, Closure pred) {
            this.xs = xs;
            this.pred = pred;
            this.left = new SubSeq();
            this.right = new SubSeq();
        }

        public static Seq[] make(Seq xs, Closure pred) {
            if (xs.isEmpty()) {
                return new Seq[]{xs, xs};
            }
            SplitSeq seq = new SplitSeq(xs, pred);
            return new Seq[]{seq.left, seq.right};
        }

        protected void force() {
            if (this.xs != null) {
                Object x = this.xs.get();
                this.xs = this.xs.tail();
                SubSeq t = new SubSeq();
                if (this.pred.test(null, x)) {
                    this.left.force(x, t);
                    this.left = t;
                } else {
                    this.right.force(x, t);
                    this.right = t;
                }
                if (this.xs.isEmpty()) {
                    this.xs = null;
                    this.pred = null;
                    this.right = null;
                    this.left = null;
                }
            }
        }

        protected class SubSeq
        extends DelaySeq {
            protected SubSeq() {
            }

            protected void force() {
                while (SplitSeq.this.xs != null && this.tail == null) {
                    SplitSeq.this.force();
                }
            }

            void force(Object head, SubSeq tail) {
                this.head = head;
                this.tail = tail;
            }
        }
    }

    private static class ZipWithSeq
    extends DelaySeq {
        private Seq[] ls;
        private Closure proc;

        ZipWithSeq(Seq[] ls, Closure proc) {
            this.ls = ls;
            this.proc = proc;
        }

        static Seq make(Seq[] ls, Closure proc) {
            return new ZipWithSeq(ls, proc);
        }

        protected void force() {
            if (this.ls != null) {
                Object[] args = new Object[this.ls.length];
                for (int i = 0; i < args.length; ++i) {
                    if (this.ls[i].isEmpty()) {
                        this.ls = null;
                        this.proc = null;
                        return;
                    }
                    args[i] = this.ls[i].get();
                    this.ls[i] = this.ls[i].tail();
                }
                this.head = this.proc.call(null, args);
                this.tail = ZipWithSeq.make(this.ls, this.proc);
                this.ls = null;
                this.proc = null;
            }
        }
    }

    private static class ZipSeq
    extends DelaySeq {
        private Seq[] ls;

        ZipSeq(Seq[] ls) {
            this.ls = ls;
        }

        static Seq make(Seq[] ls) {
            return new ZipSeq(ls);
        }

        protected void force() {
            if (this.ls != null) {
                Object[] z = new Object[this.ls.length];
                for (int i = 0; i < z.length; ++i) {
                    if (this.ls[i].isEmpty()) {
                        this.ls = null;
                        return;
                    }
                    z[i] = this.ls[i].get();
                    this.ls[i] = this.ls[i].tail();
                }
                this.head = z;
                this.tail = ZipSeq.make(this.ls);
                this.ls = null;
            }
        }
    }

    private static class StepDown
    extends DelaySeq {
        private ELContext elctx;
        private Object a;
        private Object b;
        private Object i;

        StepDown(ELContext elctx, Object a, Object b, Object i) {
            this.elctx = elctx;
            this.a = a;
            this.b = b;
            this.i = i;
        }

        static Seq make(ELContext elctx, Object a, Object b, Object i) {
            if (Builtin.__lt__(elctx, a, b)) {
                return Cons.nil();
            }
            return new StepDown(elctx, a, b, i);
        }

        public int size() {
            if (this.a instanceof Number && this.b instanceof Number && this.i instanceof Number) {
                return TypeCoercion.coerceToInt(Builtin.__div__(this.elctx, Builtin.__add__(this.elctx, Builtin.__sub__(this.elctx, this.b, this.a), this.i), this.i));
            }
            return super.size();
        }

        protected void force() {
            if (this.a != null) {
                this.head = this.a;
                this.tail = StepDown.make(this.elctx, Builtin.__add__(this.elctx, this.a, this.i), this.b, this.i);
                this.i = null;
                this.b = null;
                this.a = null;
            }
        }
    }

    private static class StepUp
    extends DelaySeq {
        private ELContext elctx;
        private Object a;
        private Object b;
        private Object i;

        StepUp(ELContext elctx, Object a, Object b, Object i) {
            this.elctx = elctx;
            this.a = a;
            this.b = b;
            this.i = i;
        }

        static Seq make(ELContext elctx, Object a, Object b, Object i) {
            if (Builtin.__gt__(elctx, a, b)) {
                return Cons.nil();
            }
            return new StepUp(elctx, a, b, i);
        }

        public int size() {
            if (this.a instanceof Number && this.b instanceof Number && this.i instanceof Number) {
                return TypeCoercion.coerceToInt(Builtin.__div__(this.elctx, Builtin.__add__(this.elctx, Builtin.__sub__(this.elctx, this.b, this.a), this.i), this.i));
            }
            return super.size();
        }

        protected void force() {
            if (this.a != null) {
                this.head = this.a;
                this.tail = StepUp.make(this.elctx, Builtin.__add__(this.elctx, this.a, this.i), this.b, this.i);
                this.i = null;
                this.b = null;
                this.a = null;
            }
        }
    }
}

