/*
 * Decompiled with CFR 0.152.
 */
package elite.lang;

import elite.lang.Builtin;
import elite.lang.Closure;
import elite.lang.Decimal;
import elite.lang.Rational;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.el.ELContext;
import javax.el.ELException;
import org.operamasks.el.eval.TypeCoercion;

public final class MathLib {
    private static final long D_MASK = 2047L;
    private static final long D_BIAS = 1022L;
    private static final int D_SHIFT = 52;

    private MathLib() {
    }

    public static String hex(Number x) {
        if (x instanceof BigInteger) {
            return ((BigInteger)x).toString(16);
        }
        if (x instanceof BigDecimal) {
            return ((BigDecimal)x).toBigInteger().toString(16);
        }
        return Long.toHexString(x.longValue());
    }

    public static String oct(Number x) {
        if (x instanceof BigInteger) {
            return ((BigInteger)x).toString(8);
        }
        if (x instanceof BigDecimal) {
            return ((BigDecimal)x).toBigInteger().toString(8);
        }
        return Long.toOctalString(x.longValue());
    }

    public static Object sum(ELContext elctx, Object ... args) {
        if (args.length == 0) {
            throw new ELException("sum: expect at least 1 argument, given 0");
        }
        Object res = args[0];
        for (int i = 1; i < args.length; ++i) {
            res = Builtin.__add__(elctx, res, args[i]);
        }
        return res;
    }

    public static Object difference(ELContext elctx, Object ... args) {
        if (args.length == 0) {
            throw new ELException("difference: expect at least 1 argument, given 0");
        }
        Object res = args[0];
        for (int i = 1; i < args.length; ++i) {
            res = Builtin.__sub__(elctx, res, args[i]);
        }
        return res;
    }

    public static Object product(ELContext elctx, Object ... args) {
        if (args.length == 0) {
            throw new ELException("product: expect at least 1 argument, given 0");
        }
        Object res = args[0];
        for (int i = 1; i < args.length; ++i) {
            res = Builtin.__mul__(elctx, res, args[i]);
        }
        return res;
    }

    public static Object divide(ELContext elctx, Object ... args) {
        if (args.length == 0) {
            throw new ELException("divide: expect at least 1 argument, given 0");
        }
        Object res = args[0];
        for (int i = 1; i < args.length; ++i) {
            res = Builtin.__div__(elctx, res, args[i]);
        }
        return res;
    }

    public static Object remainder(ELContext elctx, Object x, Object y) {
        return Builtin.__rem__(elctx, x, y);
    }

    public static Number[] divmod(Number x, Number y) {
        if (x instanceof Float || y instanceof Float || x instanceof Double || y instanceof Double) {
            double xx = TypeCoercion.coerceToDouble(x);
            double yy = TypeCoercion.coerceToDouble(y);
            return new Number[]{Math.rint(xx / yy), xx % yy};
        }
        if (x instanceof BigDecimal || y instanceof BigDecimal) {
            BigDecimal xx = TypeCoercion.coerceToBigDecimal(x);
            BigDecimal yy = TypeCoercion.coerceToBigDecimal(y);
            return xx.divideAndRemainder(yy);
        }
        if (x instanceof Decimal || y instanceof Decimal) {
            Decimal xx = TypeCoercion.coerceToDecimal(x);
            Decimal yy = TypeCoercion.coerceToDecimal(y);
            return xx.divideAndRemainder(yy);
        }
        if (x instanceof Rational || y instanceof Rational) {
            Rational xx = TypeCoercion.coerceToRational(x);
            Rational yy = TypeCoercion.coerceToRational(y);
            return xx.divideAndRemainder(yy);
        }
        if (x instanceof BigInteger || y instanceof BigInteger) {
            BigInteger xx = TypeCoercion.coerceToBigInteger(x);
            BigInteger yy = TypeCoercion.coerceToBigInteger(y);
            return xx.divideAndRemainder(yy);
        }
        long xx = TypeCoercion.coerceToLong(x);
        long yy = TypeCoercion.coerceToLong(y);
        return new Number[]{xx / yy, xx % yy};
    }

    public static Object max(ELContext elctx, Object ... args) {
        if (args.length == 0) {
            throw new ELException("max: expect at least 1 argument, given 0");
        }
        Object res = args[0];
        for (int i = 1; i < args.length; ++i) {
            Object x = args[i];
            if (!Builtin.__gt__(elctx, x, res)) continue;
            res = x;
        }
        return res;
    }

    public static Object min(ELContext elctx, Object ... args) {
        if (args.length == 0) {
            throw new ELException("min: expect at least 1 argument, given 0");
        }
        Object res = args[0];
        for (int i = 1; i < args.length; ++i) {
            Object x = args[i];
            if (!Builtin.__lt__(elctx, x, res)) continue;
            res = x;
        }
        return res;
    }

    public static int compare(ELContext elctx, Object x, Object y) {
        if (x instanceof Comparable && x.getClass().isInstance(y)) {
            return ((Comparable)x).compareTo(y);
        }
        if (Builtin.__eq__(elctx, x, y)) {
            return 0;
        }
        if (Builtin.__lt__(elctx, x, y)) {
            return -1;
        }
        return 1;
    }

    public static Number abs(Number x) {
        if (x instanceof BigDecimal) {
            return ((BigDecimal)x).abs();
        }
        if (x instanceof BigInteger) {
            return ((BigInteger)x).abs();
        }
        if (x instanceof Decimal) {
            return ((Decimal)x).abs();
        }
        if (x instanceof Rational) {
            return ((Rational)x).abs();
        }
        if (x instanceof Double) {
            return Math.abs(x.doubleValue());
        }
        if (x instanceof Float) {
            return Float.valueOf(Math.abs(x.floatValue()));
        }
        if (x instanceof Long) {
            return Math.abs(x.longValue());
        }
        if (x instanceof Integer) {
            return Math.abs(x.intValue());
        }
        if (x instanceof Short) {
            return Math.abs(x.intValue());
        }
        if (x instanceof Byte) {
            return Math.abs(x.intValue());
        }
        return Math.abs(x.doubleValue());
    }

    public static int signum(ELContext elctx, Object x) {
        if (x instanceof BigDecimal) {
            return ((BigDecimal)x).signum();
        }
        if (x instanceof BigInteger) {
            return ((BigInteger)x).signum();
        }
        if (x instanceof Decimal) {
            return ((Decimal)x).signum();
        }
        if (x instanceof Rational) {
            return ((Rational)x).signum();
        }
        if (x instanceof Double) {
            return Double.compare((Double)x, 0.0);
        }
        if (x instanceof Float) {
            return Float.compare(((Float)x).floatValue(), 0.0f);
        }
        if (x instanceof Long) {
            long l = (Long)x;
            return l > 0L ? 1 : (l < 0L ? -1 : 0);
        }
        if (x instanceof Integer) {
            int i = (Integer)x;
            return i > 0 ? 1 : (i < 0 ? -1 : 0);
        }
        if (x instanceof Short) {
            short i = (Short)x;
            return i > 0 ? 1 : (i < 0 ? -1 : 0);
        }
        if (x instanceof Byte) {
            short i = ((Byte)x).byteValue();
            return i > 0 ? 1 : (i < 0 ? -1 : 0);
        }
        if (Builtin.__eq__(elctx, x, 0)) {
            return 0;
        }
        if (Builtin.__lt__(elctx, x, 0)) {
            return -1;
        }
        return 1;
    }

    public static Object gcd(ELContext elctx, Object ... args) {
        if (args.length < 2) {
            throw new ELException("gcd: expect at least 2 argument, given " + args.length);
        }
        Object res = args[0];
        for (int i = 1; i < args.length && !(res = MathLib.gcd2(elctx, res, args[i])).equals(1); ++i) {
        }
        return res;
    }

    public static Object lcm(ELContext elctx, Object ... args) {
        if (args.length < 2) {
            throw new ELException("lcm: expect at least 2 argument, given " + args.length);
        }
        Object a = args[0];
        for (int i = 1; i < args.length; ++i) {
            Object b = args[i];
            a = Builtin.__mul__(elctx, Builtin.__div__(elctx, a, MathLib.gcd2(elctx, a, b)), b);
        }
        return a;
    }

    static Object gcd2(ELContext elctx, Object a, Object b) {
        if (a instanceof Number && b instanceof Number) {
            if (a instanceof Rational || b instanceof Rational) {
                Rational g = TypeCoercion.coerceToRational(a).gcd(TypeCoercion.coerceToRational(b));
                return g.equals(Rational.ONE) ? Integer.valueOf(1) : g;
            }
            if (a instanceof BigInteger || b instanceof BigInteger) {
                BigInteger g = TypeCoercion.coerceToBigInteger(a).gcd(TypeCoercion.coerceToBigInteger(b));
                return g.equals(BigInteger.ONE) ? Integer.valueOf(1) : g;
            }
            if (a instanceof BigDecimal || b instanceof BigDecimal) {
                BigInteger g = TypeCoercion.coerceToBigInteger(a).gcd(TypeCoercion.coerceToBigInteger(b));
                return g.equals(BigInteger.ONE) ? Integer.valueOf(1) : g;
            }
            long m = Math.abs(((Number)a).longValue());
            long n = Math.abs(((Number)b).longValue());
            while (n != 0L) {
                long r = m % n;
                m = n;
                n = r;
            }
            return m;
        }
        while (!Builtin.__eq__(elctx, b, 0)) {
            Object r = Builtin.__rem__(elctx, a, b);
            a = b;
            b = r;
        }
        return a;
    }

    public static double floor(double x) {
        return Math.floor(x);
    }

    public static double ceiling(double x) {
        return Math.ceil(x);
    }

    public static double truncate(double x) {
        return (int)x;
    }

    public static long round(double x) {
        return Math.round(x);
    }

    public static double exp(double x) {
        return Math.exp(x);
    }

    public static double log(double x) {
        return Math.log(x);
    }

    public static double log10(double x) {
        return Math.log10(x);
    }

    public static double sin(double x) {
        return Math.sin(x);
    }

    public static double cos(double x) {
        return Math.cos(x);
    }

    public static double tan(double x) {
        return Math.tan(x);
    }

    public static double asin(double x) {
        return Math.asin(x);
    }

    public static double acos(double x) {
        return Math.acos(x);
    }

    public static double atan(double x) {
        return Math.atan(x);
    }

    public static double atan2(double y, double x) {
        return Math.atan2(y, x);
    }

    public static double sinh(double x) {
        return Math.sinh(x);
    }

    public static double cosh(double x) {
        return Math.cosh(x);
    }

    public static double tanh(double x) {
        return Math.tanh(x);
    }

    public static double sqrt(double x) {
        return Math.sqrt(x);
    }

    public static Object pow(ELContext elctx, Object x, Closure y) {
        return Builtin.__pow__(elctx, x, (Object)y);
    }

    public static double[] frexp(double d) {
        if (d == 0.0) {
            return new double[]{0.0, 0.0};
        }
        long x = Double.doubleToLongBits(d);
        int e = (int)((x >>> 52 & 0x7FFL) - 1022L);
        x &= 0x800FFFFFFFFFFFFFL;
        d = Double.longBitsToDouble(x |= 0x3FE0000000000000L);
        return new double[]{d, e};
    }

    public static double ldexp(double d, int e) {
        if (d == 0.0) {
            return 0.0;
        }
        long x = Double.doubleToLongBits(d);
        if ((e += (int)(x >>> 52 & 0x7FFL)) <= 0) {
            return 0.0;
        }
        if ((long)e >= 2047L) {
            return d < 0.0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        x &= 0x800FFFFFFFFFFFFFL;
        return Double.longBitsToDouble(x |= (long)e << 52);
    }
}

