/*
 * Decompiled with CFR 0.152.
 */
package elite.xml;

import elite.lang.Closure;
import elite.lang.annotation.Expando;
import elite.xml.FilterVirtualNode;
import elite.xml.IndexedVirtualNode;
import elite.xml.VirtualNode;
import elite.xml.XmlNode;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.el.ELContext;
import org.operamasks.el.eval.TypeCoercion;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContainerVirtualNode
extends VirtualNode
implements Iterable<XmlNode> {
    protected XmlNode real;

    ContainerVirtualNode(XmlNode parent, String name) {
        super(parent, name);
    }

    @Override
    protected XmlNode realize(boolean create) {
        if (this.real == null) {
            XmlNode parent = this.parent.realize(create);
            if (parent == null) {
                return null;
            }
            Node parentNode = parent.toDOM();
            Node childNode = this.firstChild(parentNode);
            if (create && childNode == null) {
                childNode = parentNode.getOwnerDocument().createElement(this.name);
                parentNode.appendChild(childNode);
            }
            this.real = XmlNode.valueOf(childNode);
        }
        return this.real;
    }

    @Override
    public Object getValue(ELContext elctx, Object property) {
        int index;
        if (property instanceof String) {
            return super.getValue(elctx, property);
        }
        if (property instanceof Number && (index = ((Number)property).intValue()) >= 0) {
            elctx.setPropertyResolved(true);
            return new IndexedVirtualNode(this.parent, this.name, index);
        }
        return null;
    }

    @Override
    public Class<?> getType(ELContext elctx, Object property) {
        if (property instanceof String) {
            return super.getType(elctx, property);
        }
        if (property instanceof Number) {
            elctx.setPropertyResolved(true);
            return XmlNode.class;
        }
        return null;
    }

    @Override
    public boolean isReadOnly(ELContext elctx, Object property) {
        if (property instanceof String) {
            return super.isReadOnly(elctx, property);
        }
        if (property instanceof Number) {
            elctx.setPropertyResolved(true);
            return false;
        }
        return false;
    }

    @Override
    public void setValue(ELContext elctx, Object property, Object value) {
        if (property instanceof String) {
            super.setValue(elctx, property, value);
            return;
        }
        if (property instanceof Number) {
            XmlNode parent = this.parent.realize(value != null);
            if (parent == null) {
                return;
            }
            Node elem = parent.toDOM();
            int index = ((Number)property).intValue();
            Node oldnode = this.child(elem, index);
            if (value == null) {
                if (oldnode != null) {
                    elem.removeChild(oldnode);
                }
            } else if (ContainerVirtualNode.canCoerceToNode(elctx, value)) {
                Node newnode = ContainerVirtualNode.coerceToNode(elctx, value);
                if (newnode != null) {
                    if (oldnode != null) {
                        elem.replaceChild(newnode, oldnode);
                    } else {
                        elem.appendChild(newnode);
                    }
                }
            } else {
                String text = TypeCoercion.coerceToString(value);
                if (oldnode != null) {
                    oldnode.setTextContent(text);
                } else {
                    Element newnode = elem.getOwnerDocument().createElement(this.name);
                    newnode.setTextContent(text);
                    elem.appendChild(newnode);
                }
            }
            elctx.setPropertyResolved(true);
            return;
        }
    }

    @Expando(name="+=")
    public XmlNode appendChild(ELContext elctx, Object value) {
        Node newnode = ContainerVirtualNode.coerceToNode(elctx, value);
        if (newnode != null) {
            Node parent = this.parent.realize(true).toDOM();
            Node refnode = this.lastChild(parent);
            if (refnode != null) {
                refnode = refnode.getNextSibling();
            }
            parent.insertBefore(newnode, refnode);
        }
        return this;
    }

    public XmlNode filter(Closure pred) {
        return new FilterVirtualNode(this.parent, this, pred);
    }

    @Override
    public Iterator<XmlNode> iterator() {
        Node elem = this.parent.toDOM();
        if (elem != null) {
            return new NodeItr(elem, this.name);
        }
        return Collections.emptyList().iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeItr
    implements Iterator<XmlNode> {
        private final String name;
        private Node parent;
        private Node next;
        private Node lastRet;

        NodeItr(Node parent, String name) {
            this.name = name;
            this.parent = parent;
            this.next = this.nextMatch(parent.getFirstChild());
        }

        private Node nextMatch(Node node) {
            while (!(node == null || node.getNodeType() == 1 && this.name.equals(node.getNodeName()))) {
                node = node.getNextSibling();
            }
            return node;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public XmlNode next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.next;
            this.next = this.nextMatch(this.lastRet.getNextSibling());
            return XmlNode.valueOf(this.lastRet);
        }

        @Override
        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            this.parent.removeChild(this.lastRet);
            this.lastRet = null;
        }
    }
}

