/*
 * Decompiled with CFR 0.152.
 */
package elite.xml;

import elite.lang.Closure;
import elite.xml.ContainerVirtualNode;
import elite.xml.DescendantVirtualNode;
import elite.xml.XmlNode;
import elite.xml.XmlNodeList;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Method;
import javax.el.ELContext;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import org.operamasks.el.eval.ELEngine;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.el.eval.closure.LiteralClosure;
import org.operamasks.el.resources.Resources;
import org.operamasks.util.DOMWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RealNode
extends XmlNode {
    private final Node dom;

    RealNode(Node dom) {
        this.dom = dom;
    }

    @Override
    public Node toDOM() {
        return this.dom;
    }

    @Override
    protected XmlNode realize(boolean create) {
        return this;
    }

    @Override
    public Object getValue(ELContext elctx, Object property) {
        if (this.dom instanceof Element && property instanceof String) {
            Element elem = (Element)this.dom;
            String name = (String)property;
            if (name.startsWith("@@")) {
                elctx.setPropertyResolved(true);
                name = name.intern();
                if (name == "@@name") {
                    return elem.getTagName();
                }
                if (name == "@@value") {
                    return elem.getTextContent();
                }
                if (name == "@@prefix") {
                    return elem.getPrefix();
                }
                if (name == "@@uri") {
                    return elem.getNamespaceURI();
                }
                if (name == "@@localName") {
                    return elem.getLocalName();
                }
                if (name == "@@parent") {
                    return XmlNode.valueOf(elem.getParentNode());
                }
                if (name == "@@first") {
                    return XmlNode.valueOf(elem.getFirstChild());
                }
                if (name == "@@last") {
                    return XmlNode.valueOf(elem.getLastChild());
                }
                if (name == "@@next") {
                    return XmlNode.valueOf(elem.getNextSibling());
                }
                if (name == "@@previous") {
                    return XmlNode.valueOf(elem.getPreviousSibling());
                }
                if (name == "@@child") {
                    return new XmlNodeList(elctx, elem, elem.getChildNodes());
                }
                throw new PropertyNotFoundException(Resources._T("EL_PROPERTY_NOT_FOUND", "XmlNode", name));
            }
            if (name.startsWith("@")) {
                Attr attr = elem.getAttributeNode(name.substring(1));
                if (attr != null) {
                    elctx.setPropertyResolved(true);
                    return attr.getValue();
                }
            } else {
                if (name.equals("_")) {
                    elctx.setPropertyResolved(true);
                    return new DescendantVirtualNode(this, "*");
                }
                elctx.setPropertyResolved(true);
                return new ContainerVirtualNode(this, name);
            }
        }
        return null;
    }

    @Override
    public Class<?> getType(ELContext elctx, Object property) {
        Object value = this.getValue(elctx, property);
        return value == null ? null : value.getClass();
    }

    @Override
    public boolean isReadOnly(ELContext elctx, Object property) {
        elctx.setPropertyResolved(true);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setValue(ELContext elctx, Object property, Object value) {
        if (!(this.dom instanceof Element) || !(property instanceof String)) return;
        Element elem = (Element)this.dom;
        String name = (String)property;
        elctx.setPropertyResolved(true);
        if (name.startsWith("@@")) {
            if ("@@value".equals(name)) {
                String text = value == null ? null : TypeCoercion.coerceToString(value);
                elem.setTextContent(text);
                return;
            } else {
                if (!"@@child".equals(name)) throw new PropertyNotWritableException(Resources._T("EL_PROPERTY_NOT_WRITABLE", "XmlNode", name));
                Node newnode = RealNode.coerceToNode(elctx, value);
                elem.setTextContent(null);
                if (newnode == null) return;
                elem.appendChild(newnode);
            }
            return;
        } else if (name.startsWith("@")) {
            name = name.substring(1);
            if (value == null) {
                elem.removeAttribute(name);
                return;
            } else {
                elem.setAttribute(name, TypeCoercion.coerceToString(value));
            }
            return;
        } else {
            Node newnode;
            if (name.equals("_")) {
                throw new PropertyNotWritableException(Resources._T("EL_PROPERTY_NOT_WRITABLE", "XmlNode", name));
            }
            if (value == null) {
                newnode = null;
            } else if (RealNode.canCoerceToNode(elctx, value)) {
                newnode = RealNode.coerceToNode(elctx, value);
            } else {
                newnode = elem.getOwnerDocument().createElement(name);
                newnode.setTextContent(TypeCoercion.coerceToString(value));
            }
            Node oldnode = null;
            Node n = elem.getFirstChild();
            while (n != null) {
                if (n.getNodeType() == 1 && name.equals(n.getNodeName())) {
                    Node k = n;
                    n = n.getNextSibling();
                    if (oldnode == null) {
                        oldnode = k;
                        continue;
                    }
                    elem.removeChild(k);
                    continue;
                }
                n = n.getNextSibling();
            }
            if (newnode != null) {
                if (oldnode != null) {
                    elem.replaceChild(newnode, oldnode);
                    return;
                } else {
                    elem.appendChild(newnode);
                }
                return;
            } else {
                if (oldnode == null) return;
                elem.removeChild(oldnode);
            }
        }
    }

    @Override
    public MethodInfo getMethodInfo(ELContext ctx, String name) throws MethodNotFoundException {
        return null;
    }

    @Override
    public Object invoke(ELContext ctx, String name, Closure[] args) throws MethodNotFoundException {
        Method method = ELEngine.resolveMethod(ctx, this.dom.getClass(), name, args);
        if (method == null) {
            throw new MethodNotFoundException("method not found: " + name);
        }
        Class<?>[] types = method.getParameterTypes();
        Closure[] values = (Closure[])args.clone();
        assert (types.length == args.length);
        for (int i = 0; i < types.length; ++i) {
            if (!Node.class.isAssignableFrom(types[i])) continue;
            Object value = args[i].getValue(ctx);
            values[i] = new LiteralClosure(RealNode.coerceToNode(ctx, value));
        }
        Object result = ELEngine.invokeMethod(ctx, this.dom, method, values);
        if (result instanceof Node) {
            result = RealNode.valueOf((Node)result);
        } else if (result instanceof NodeList) {
            result = new XmlNodeList(ctx, this.dom, (NodeList)result);
        }
        return result;
    }

    @Override
    public Object coerce(Class type) {
        if (this.textonly()) {
            return TypeCoercion.coerce(this.dom.getTextContent(), type);
        }
        return null;
    }

    public String toString() {
        if (this.textonly()) {
            return this.dom.getTextContent();
        }
        return this.toXMLString();
    }

    private boolean textonly() {
        block3: for (Node kid = this.dom.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            switch (kid.getNodeType()) {
                case 3: 
                case 4: 
                case 5: {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public String toXMLString() {
        try {
            StringWriter str = new StringWriter();
            DOMWriter writer = new DOMWriter(str);
            writer.writeNode(this.dom);
            writer.flush();
            return str.toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public int hashCode() {
        return this.dom.hashCode();
    }
}

