/*
 * Decompiled with CFR 0.152.
 */
package elite.xml;

import elite.lang.annotation.Expando;
import elite.xml.XmlNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.el.ELContext;
import javax.el.ELException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.operamasks.el.resolver.ClassResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLLib {
    private XMLLib() {
    }

    public static void __init__(ELContext elctx) {
        ClassResolver resolver = ClassResolver.getInstance(elctx);
        resolver.addImport("org.w3c.dom.*");
    }

    @Expando
    public static XmlNode toXML(ELContext elctx, String str) throws SAXException {
        try {
            return XMLLib.parse(elctx, new InputSource(new StringReader(str)));
        }
        catch (IOException ex) {
            throw new ELException((Throwable)ex);
        }
    }

    @Expando
    public static XmlNode getXML(ELContext elctx, Reader reader) throws IOException, SAXException {
        return XMLLib.parse(elctx, new InputSource(reader));
    }

    @Expando
    public static XmlNode getXML(ELContext elctx, InputStream ins) throws IOException, SAXException {
        return XMLLib.parse(elctx, new InputSource(ins));
    }

    @Expando
    public static XmlNode getXML(ELContext elctx, File file) throws IOException, SAXException {
        return XMLLib.parse(elctx, new InputSource(file.toURI().toString()));
    }

    @Expando
    public static XmlNode getXML(ELContext elctx, URL url) throws IOException, SAXException {
        return XMLLib.parse(elctx, new InputSource(url.toString()));
    }

    private static XmlNode parse(ELContext elctx, InputSource input) throws IOException, SAXException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(input);
            Element root = doc.getDocumentElement();
            Document owner = (Document)elctx.getContext(Document.class);
            if (owner == null) {
                elctx.putContext(Document.class, (Object)doc);
            } else {
                root = (Element)owner.importNode(root, true);
            }
            return XmlNode.valueOf(root);
        }
        catch (ParserConfigurationException ex) {
            throw new ELException((Throwable)ex);
        }
    }
}

