/*
 * Decompiled with CFR 0.152.
 */
package elite.xml;

import elite.xml.XmlNode;
import java.util.AbstractList;
import java.util.Collection;
import javax.el.ELContext;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlNodeList
extends AbstractList {
    protected ELContext elctx;
    protected Node parent;
    protected NodeList list;

    protected XmlNodeList(ELContext elctx, Node parent, NodeList list) {
        this.elctx = elctx;
        this.parent = parent;
        this.list = list;
    }

    public int size() {
        return this.list.getLength();
    }

    public Object get(int index) {
        if (index < 0 || index >= this.list.getLength()) {
            throw new IndexOutOfBoundsException("" + index);
        }
        return XmlNode.valueOf(this.list.item(index));
    }

    public Object set(int index, Object value) {
        if (index < 0 || index > this.list.getLength()) {
            throw new IndexOutOfBoundsException("" + index);
        }
        Node oldnode = this.list.item(index);
        Node newnode = XmlNode.coerceToNode(this.elctx, value);
        if (newnode != null) {
            if (oldnode != null) {
                this.parent.replaceChild(newnode, oldnode);
            } else {
                this.parent.appendChild(newnode);
            }
        } else if (oldnode != null) {
            this.parent.removeChild(oldnode);
        }
        return XmlNode.valueOf(oldnode);
    }

    public boolean add(Object value) {
        Node newnode = XmlNode.coerceToNode(this.elctx, value);
        if (newnode != null) {
            this.parent.appendChild(newnode);
        }
        return true;
    }

    public void add(int index, Object value) {
        if (index < 0 || index > this.list.getLength()) {
            throw new IndexOutOfBoundsException("" + index);
        }
        Node newnode = XmlNode.coerceToNode(this.elctx, value);
        if (newnode != null) {
            this.parent.insertBefore(newnode, this.list.item(index));
        }
    }

    public boolean addAll(Collection c) {
        return this.add(c);
    }

    public Object remove(int index) {
        return this.set(index, (Object)null);
    }

    public boolean remove(Object value) {
        Node node = XmlNode.coerceToNode(this.elctx, value);
        if (node == null) {
            return false;
        }
        if (node.getParentNode() == this.parent) {
            this.parent.removeChild(node);
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection c) {
        return super.removeAll(c);
    }
}

