/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval;

import elite.lang.CharRange;
import elite.lang.Seq;
import java.io.Serializable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.operamasks.el.eval.seq.AbstractSeq;
import org.operamasks.el.eval.seq.EmptySeq;

public class CharRanges {
    public static Seq createCharRange(char begin, char end, int step) {
        if (step == 1) {
            if (begin > end) {
                return EmptySeq.make();
            }
            if (begin == end) {
                return new Singleton(begin);
            }
            return new Ascending(begin, end);
        }
        if (step == -1) {
            if (begin < end) {
                return EmptySeq.make();
            }
            if (begin == end) {
                return new Singleton(begin);
            }
            return new Descending(begin, end);
        }
        if (step > 0) {
            if (begin > end) {
                return EmptySeq.make();
            }
            if (begin + step > end) {
                return new Singleton(begin);
            }
            return new StepUp(begin, end, step);
        }
        if (step < 0) {
            if (begin < end) {
                return EmptySeq.make();
            }
            if (end + step > begin) {
                return new Singleton(begin);
            }
            return new StepDown(begin, end, -step);
        }
        throw new IllegalArgumentException("illegal range step: " + step);
    }

    public static Seq createUnboundedRange(char begin, int step) {
        if (step > 0) {
            return new UnboundedStepUp(begin, step);
        }
        if (step < 0) {
            return new UnboundedStepDown(begin, -step);
        }
        throw new IllegalArgumentException("Illegal range step: " + step);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnboundedStepDown
    extends AbstractCharRange {
        private final char begin;
        private final int step;

        public UnboundedStepDown(char begin, int step) {
            this.begin = begin;
            this.step = step;
        }

        @Override
        public char getBegin() {
            return this.begin;
        }

        @Override
        public char getEnd() {
            return '\u0000';
        }

        @Override
        public int getStep() {
            return -this.step;
        }

        @Override
        public boolean isUnbound() {
            return true;
        }

        @Override
        public int size() {
            return Integer.MAX_VALUE;
        }

        @Override
        public Character get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index: " + index);
            }
            return Character.valueOf((char)(this.begin - index * this.step));
        }

        @Override
        protected int indexOf(char c) {
            if (c > this.begin) {
                return -1;
            }
            if ((this.begin - c) % this.step != 0) {
                return -1;
            }
            return (this.begin - c) / this.step;
        }

        @Override
        public String toString() {
            return "[" + this.begin + "," + (char)(this.begin - this.step) + "..*]";
        }

        @Override
        public Iterator<Character> iterator() {
            return new Iterator<Character>(){
                private char next;
                {
                    this.next = UnboundedStepDown.this.begin;
                }

                @Override
                public boolean hasNext() {
                    return true;
                }

                @Override
                public Character next() {
                    char c = this.next;
                    this.next = (char)(this.next - UnboundedStepDown.this.step);
                    return Character.valueOf(c);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public ListIterator<Character> listIterator(final int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index: " + index);
            }
            return new ListIterator<Character>(){
                private int cursor;
                {
                    this.cursor = index;
                }

                @Override
                public boolean hasNext() {
                    return true;
                }

                @Override
                public Character next() {
                    return Character.valueOf((char)(UnboundedStepDown.this.begin - this.cursor++ * UnboundedStepDown.this.step));
                }

                @Override
                public boolean hasPrevious() {
                    return this.cursor != 0;
                }

                @Override
                public Character previous() {
                    if (this.cursor == 0) {
                        throw new NoSuchElementException();
                    }
                    return Character.valueOf((char)(UnboundedStepDown.this.begin - --this.cursor * UnboundedStepDown.this.step));
                }

                @Override
                public int nextIndex() {
                    return this.cursor;
                }

                @Override
                public int previousIndex() {
                    return this.cursor - 1;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(Character o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(Character o) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnboundedStepUp
    extends AbstractCharRange {
        private final char begin;
        private final int step;

        public UnboundedStepUp(char begin, int step) {
            this.begin = begin;
            this.step = step;
        }

        @Override
        public char getBegin() {
            return this.begin;
        }

        @Override
        public char getEnd() {
            return '\uffff';
        }

        @Override
        public int getStep() {
            return this.step;
        }

        @Override
        public boolean isUnbound() {
            return true;
        }

        @Override
        public int size() {
            return 65535;
        }

        @Override
        public Character get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index: " + index);
            }
            return Character.valueOf((char)(this.begin + index * this.step));
        }

        @Override
        protected int indexOf(char c) {
            if (c < this.begin) {
                return -1;
            }
            if ((c - this.begin) % this.step != 0) {
                return -1;
            }
            return (c - this.begin) / this.step;
        }

        @Override
        public String toString() {
            if (this.step == 1) {
                return "[" + this.begin + "..*]";
            }
            return "[" + this.begin + "," + (char)(this.begin + this.step) + "..*]";
        }

        @Override
        public Iterator<Character> iterator() {
            return new Iterator<Character>(){
                private char next;
                {
                    this.next = UnboundedStepUp.this.begin;
                }

                @Override
                public boolean hasNext() {
                    return true;
                }

                @Override
                public Character next() {
                    char c = this.next;
                    this.next = (char)(this.next + UnboundedStepUp.this.step);
                    return Character.valueOf(c);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public ListIterator<Character> listIterator(final int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index: " + index);
            }
            return new ListIterator<Character>(){
                private int cursor;
                {
                    this.cursor = index;
                }

                @Override
                public boolean hasNext() {
                    return true;
                }

                @Override
                public Character next() {
                    return Character.valueOf((char)(UnboundedStepUp.this.begin + this.cursor++ * UnboundedStepUp.this.step));
                }

                @Override
                public boolean hasPrevious() {
                    return this.cursor != 0;
                }

                @Override
                public Character previous() {
                    if (this.cursor == 0) {
                        throw new NoSuchElementException();
                    }
                    return Character.valueOf((char)(UnboundedStepUp.this.begin + --this.cursor * UnboundedStepUp.this.step));
                }

                @Override
                public int nextIndex() {
                    return this.cursor;
                }

                @Override
                public int previousIndex() {
                    return this.cursor - 1;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(Character o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(Character o) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static class StepDown
    extends AbstractCharRange {
        private final char begin;
        private final char end;
        private final int step;

        public StepDown(char begin, char end, int step) {
            this.begin = begin;
            this.end = end;
            this.step = step;
        }

        public char getBegin() {
            return this.begin;
        }

        public char getEnd() {
            return this.end;
        }

        public int getStep() {
            return -this.step;
        }

        public boolean isUnbound() {
            return false;
        }

        public int size() {
            return (this.begin - this.end + this.step) / this.step;
        }

        public Character get(int index) {
            char c = (char)(this.begin - index * this.step);
            if (c < this.end || c > this.begin) {
                throw new IndexOutOfBoundsException(c + " not in range " + this);
            }
            return Character.valueOf(c);
        }

        protected int indexOf(char c) {
            if (c < this.end || c > this.begin) {
                return -1;
            }
            if ((this.begin - c) % this.step != 0) {
                return -1;
            }
            return (this.begin - c) / this.step;
        }

        public String toString() {
            return "[" + this.begin + "," + (char)(this.begin - this.step) + ".." + this.end + "]";
        }
    }

    public static class StepUp
    extends AbstractCharRange {
        private final char begin;
        private final char end;
        private final int step;

        public StepUp(char begin, char end, int step) {
            this.begin = begin;
            this.end = end;
            this.step = step;
        }

        public char getBegin() {
            return this.begin;
        }

        public char getEnd() {
            return this.end;
        }

        public int getStep() {
            return this.step;
        }

        public boolean isUnbound() {
            return false;
        }

        public int size() {
            return (this.end - this.begin + this.step) / this.step;
        }

        public Character get(int index) {
            char c = (char)(this.begin + index * this.step);
            if (c < this.begin || c > this.end) {
                throw new IndexOutOfBoundsException(c + " not in range " + this);
            }
            return Character.valueOf(c);
        }

        protected int indexOf(char c) {
            if (c < this.begin || c > this.end) {
                return -1;
            }
            if ((c - this.begin) % this.step != 0) {
                return -1;
            }
            return (c - this.begin) / this.step;
        }

        public String toString() {
            return "[" + this.begin + "," + (char)(this.begin + this.step) + ".." + this.end + "]";
        }
    }

    public static class Descending
    extends AbstractCharRange {
        private final char begin;
        private final char end;

        public Descending(char begin, char end) {
            this.begin = begin;
            this.end = end;
        }

        public char getBegin() {
            return this.begin;
        }

        public char getEnd() {
            return this.end;
        }

        public int getStep() {
            return -1;
        }

        public boolean isUnbound() {
            return false;
        }

        public int size() {
            return this.begin - this.end + 1;
        }

        public Character get(int index) {
            char c = (char)(this.begin - index);
            if (c < this.end || c > this.begin) {
                throw new IndexOutOfBoundsException(c + " not in range " + this);
            }
            return Character.valueOf(c);
        }

        protected int indexOf(char c) {
            if (c < this.end || c > this.begin) {
                return -1;
            }
            return this.begin - c;
        }

        public String toString() {
            return "[" + this.begin + "," + (char)(this.begin - '\u0001') + ".." + this.end + "]";
        }
    }

    public static class Ascending
    extends AbstractCharRange {
        private final char begin;
        private final char end;

        public Ascending(char begin, char end) {
            this.begin = begin;
            this.end = end;
        }

        public char getBegin() {
            return this.begin;
        }

        public char getEnd() {
            return this.end;
        }

        public int getStep() {
            return 1;
        }

        public boolean isUnbound() {
            return false;
        }

        public int size() {
            return this.end - this.begin + 1;
        }

        public Character get(int index) {
            char c = (char)(this.begin + index);
            if (c < this.begin | c > this.end) {
                throw new IndexOutOfBoundsException(c + " not in range " + this);
            }
            return Character.valueOf(c);
        }

        protected int indexOf(char c) {
            if (c < this.begin || c > this.end) {
                return -1;
            }
            return c - this.begin;
        }

        public String toString() {
            return "[" + this.begin + ".." + this.end + "]";
        }
    }

    public static class Singleton
    extends AbstractCharRange {
        private final char c;

        public Singleton(char c) {
            this.c = c;
        }

        public char getBegin() {
            return this.c;
        }

        public char getEnd() {
            return this.c;
        }

        public int getStep() {
            return 1;
        }

        public boolean isUnbound() {
            return false;
        }

        public int size() {
            return 1;
        }

        public Character get(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Index:" + index + ", size: 1");
            }
            return Character.valueOf(this.c);
        }

        protected int indexOf(char c) {
            return c == this.c ? 0 : -1;
        }

        public String toString() {
            return "[" + this.c + ".." + this.c + "]";
        }
    }

    private static abstract class AbstractCharRange
    extends AbstractSeq
    implements CharRange,
    RandomAccess,
    Serializable {
        private AbstractCharRange() {
        }

        public Object get() {
            return Character.valueOf(this.getBegin());
        }

        public Seq tail() {
            if (this.isUnbound()) {
                return CharRanges.createUnboundedRange((char)(this.getBegin() + this.getStep()), this.getStep());
            }
            return CharRanges.createCharRange((char)(this.getBegin() + this.getStep()), this.getEnd(), this.getStep());
        }

        public Seq last() {
            if (this.isUnbound()) {
                throw new UnsupportedOperationException();
            }
            char begin = this.getBegin();
            char end = this.getEnd();
            int step = this.getStep();
            end = (char)(begin + (end - begin) / step * step);
            return new Singleton(end);
        }

        public Seq reverse() {
            if (this.isUnbound()) {
                throw new UnsupportedOperationException();
            }
            return CharRanges.createCharRange(this.getEnd(), this.getBegin(), -this.getStep());
        }

        public int indexOf(Object o) {
            if (!(o instanceof Character)) {
                return -1;
            }
            char ch = ((Character)o).charValue();
            return this.indexOf(ch);
        }

        public boolean contains(Object o) {
            return this.indexOf(o) != -1;
        }

        protected abstract int indexOf(char var1);
    }
}

