/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval;

import elite.lang.Closure;
import elite.lang.Decimal;
import elite.lang.Rational;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELContextEvent;
import javax.el.ELContextListener;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.MethodInfo;
import javax.el.ResourceBundleELResolver;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.operamasks.el.eval.DelegatingELContext;
import org.operamasks.el.eval.ELContextImpl;
import org.operamasks.el.eval.ELUtils;
import org.operamasks.el.eval.EvaluationContext;
import org.operamasks.el.eval.EvaluationException;
import org.operamasks.el.eval.ExpressionFactoryImpl;
import org.operamasks.el.eval.StackTrace;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.el.eval.closure.ClassDefinition;
import org.operamasks.el.eval.closure.ClosureObject;
import org.operamasks.el.eval.closure.LiteralClosure;
import org.operamasks.el.eval.closure.MethodClosure;
import org.operamasks.el.parser.ELNode;
import org.operamasks.el.parser.Parser;
import org.operamasks.el.resolver.ArrayELResolver;
import org.operamasks.el.resolver.BeanPropertyELResolver;
import org.operamasks.el.resolver.ClassResolver;
import org.operamasks.el.resolver.ListELResolver;
import org.operamasks.el.resolver.MapELResolver;
import org.operamasks.el.resolver.MethodResolver;
import org.operamasks.el.resolver.SeqELResolver;
import org.operamasks.el.resolver.StringELResolver;
import org.operamasks.el.resolver.SystemClassELResolver;
import org.operamasks.el.resolver.UnitELResolver;
import org.operamasks.el.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ELEngine {
    static final ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
    private static final List<ELContextListener> listeners = new CopyOnWriteArrayList<ELContextListener>();
    private static ThreadLocal<ELContext> currentELContext = new InheritableThreadLocal<ELContext>(){

        @Override
        protected ELContext childValue(ELContext parent) {
            while (parent instanceof DelegatingELContext) {
                parent = ((DelegatingELContext)parent).getDelegate();
            }
            return new DelegatingELContext(parent);
        }
    };
    private static Set<Class> STANDARD_TYPES = new HashSet<Class>();
    public static final boolean MEASURES_AVAILABLE;

    private ELEngine() {
    }

    public static ExpressionFactory getExpressionFactory() {
        return factory;
    }

    public static void addELContextListener(ELContextListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public static void removeELContextListener(ELContextListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        listeners.remove(listener);
    }

    public static ELContext createELContext(ELResolver resolver) {
        ELContextImpl elctx = new ELContextImpl(resolver);
        ELEngine.init(elctx);
        return elctx;
    }

    public static ELContext createELContext(ELResolver resolver, VariableMapper varMapper) {
        ELContextImpl elctx = new ELContextImpl(resolver, varMapper);
        ELEngine.init(elctx);
        return elctx;
    }

    public static ELContext createELContext() {
        CompositeELResolver composite = new CompositeELResolver();
        ELEngine.addDefaultELResolvers(composite);
        composite.add((ELResolver)new ResourceBundleELResolver());
        composite.add((ELResolver)new BeanPropertyELResolver());
        return ELEngine.createELContext((ELResolver)composite);
    }

    public static ELContext createELContext(VariableMapper varMapper) {
        CompositeELResolver composite = new CompositeELResolver();
        ELEngine.addDefaultELResolvers(composite);
        composite.add((ELResolver)new ResourceBundleELResolver());
        composite.add((ELResolver)new BeanPropertyELResolver());
        return ELEngine.createELContext((ELResolver)composite, varMapper);
    }

    private static void init(ELContext elctx) {
        if (!listeners.isEmpty()) {
            ELContextEvent event = new ELContextEvent(elctx);
            for (ELContextListener listener : listeners) {
                listener.contextCreated(event);
            }
        }
    }

    public static void addDefaultELResolvers(CompositeELResolver composite) {
        composite.add((ELResolver)new SystemClassELResolver());
        composite.add((ELResolver)new MapELResolver());
        composite.add((ELResolver)new SeqELResolver());
        composite.add((ELResolver)new ListELResolver());
        composite.add((ELResolver)new ArrayELResolver());
        composite.add((ELResolver)new StringELResolver());
        if (MEASURES_AVAILABLE) {
            composite.add((ELResolver)new UnitELResolver());
        }
    }

    public static ELContext getCurrentELContext() {
        return currentELContext.get();
    }

    static ELContext setCurrentELContext(ELContext context) {
        ELContext prev = currentELContext.get();
        currentELContext.set(context);
        return prev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object evaluateExpression(ELContext elctx, String expression, Class<?> expectedType) {
        ELNode node = Parser.parse(expression);
        StackTrace.addFrame(elctx, "__eval__", null, 0);
        try {
            EvaluationContext env = new EvaluationContext(elctx);
            Object value = node.getValue(env);
            if (expectedType == null || expectedType == Object.class) {
                Object object = value;
                return object;
            }
            Object object = TypeCoercion.coerce(elctx, value, expectedType);
            return object;
        }
        finally {
            StackTrace.removeFrame(elctx);
        }
    }

    public static Method resolveMethod(ELContext elctx, Class<?> baseClass, String name, Closure[] args) {
        if (args.length == 0) {
            try {
                return baseClass.getMethod(name, new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        return ELEngine.resolveMethod(elctx, baseClass.getMethods(), name, args);
    }

    public static Method resolveMethod(ELContext elctx, Method[] methods, String name, Closure[] args) {
        int nargs;
        Class[] types;
        int argc = args.length;
        Method candidate = null;
        int shortest_distance = 0;
        for (Method method : methods) {
            if (!name.equals(method.getName()) || method.isVarArgs()) continue;
            types = method.getParameterTypes();
            nargs = types.length;
            if (nargs > 0 && types[0] == ELContext.class) {
                --nargs;
            }
            if (argc != nargs) continue;
            if (candidate == null) {
                candidate = method;
                continue;
            }
            candidate = null;
            break;
        }
        if (candidate != null) {
            return candidate;
        }
        for (Method method : methods) {
            int dist;
            block14: {
                int nfixed;
                block12: {
                    block13: {
                        if (!name.equals(method.getName())) continue;
                        types = method.getParameterTypes();
                        nargs = types.length;
                        dist = -1;
                        if (nargs > 0 && types[0] == ELContext.class) {
                            Class[] temp = new Class[nargs - 1];
                            System.arraycopy(types, 1, temp, 0, nargs - 1);
                            types = temp;
                            --nargs;
                        }
                        if (nargs != argc) break block12;
                        if (method.isVarArgs()) break block13;
                        dist = ELEngine.distanceof(elctx, types, args, nargs);
                        break block14;
                    }
                    dist = ELEngine.distanceof(elctx, types, args, nargs - 1);
                    if (dist == -1) break block14;
                    Closure varg = args[nargs - 1];
                    Class vargtype = types[nargs - 1];
                    int d = ELEngine.distanceof(elctx, varg, vargtype);
                    if (d == -1) {
                        d = ELEngine.distanceof(elctx, varg, vargtype.getComponentType());
                    }
                    if (d == -1) break block14;
                    dist += d;
                    break block14;
                }
                if (nargs >= 1 && nargs <= argc + 1 && method.isVarArgs() && (dist = ELEngine.distanceof(elctx, types, args, nfixed = nargs - 1)) != -1 && nfixed < argc) {
                    Class<?> vargtype = types[nargs - 1].getComponentType();
                    for (int i = nfixed; i < argc; ++i) {
                        int d = ELEngine.distanceof(elctx, args[i], vargtype);
                        if (d == -1) {
                            dist = -1;
                            break;
                        }
                        dist += d;
                    }
                }
            }
            if (dist == 0) {
                return method;
            }
            if (dist == -1) continue;
            if (candidate == null) {
                candidate = method;
                shortest_distance = dist;
                continue;
            }
            if (dist >= shortest_distance) continue;
            candidate = method;
            shortest_distance = dist;
        }
        return candidate;
    }

    public static Object invokeMethod(ELContext elctx, Object base, Method method, Closure[] args) {
        Class<?>[] types = method.getParameterTypes();
        int nargs = types.length;
        Object[] values = new Object[nargs];
        int iarg = 0;
        int ivarg = 0;
        boolean is_vargs = method.isVarArgs();
        if (is_vargs) {
            --nargs;
        }
        if (nargs > 0 && types[0] == ELContext.class) {
            values[0] = elctx;
            ++iarg;
        }
        while (iarg < nargs) {
            values[iarg] = ELEngine.delayed(types[iarg]) ? args[ivarg] : TypeCoercion.coerce(elctx, args[ivarg].getValue(elctx), types[iarg]);
            ++iarg;
            ++ivarg;
        }
        if (is_vargs) {
            int vargc = args.length - ivarg;
            if (vargc < 0) {
                vargc = 0;
            }
            assert (types[nargs].isArray());
            Class<?> argtype = types[nargs].getComponentType();
            if (ELEngine.delayed(argtype)) {
                if (ivarg == 0) {
                    values[nargs] = args;
                } else {
                    Closure[] vargs = new Closure[vargc];
                    System.arraycopy(args, ivarg, vargs, 0, vargc);
                    values[nargs] = vargs;
                }
            } else if (vargc == 1 && !TypeCoercion.canCoerceToSeq(argtype)) {
                Object last = args[ivarg].getValue(elctx);
                if (last instanceof List) {
                    List arglist = (List)last;
                    int count = arglist.size();
                    Object vargs = Array.newInstance(argtype, count);
                    for (int i = 0; i < count; ++i) {
                        Array.set(vargs, i, TypeCoercion.coerce(elctx, arglist.get(i), argtype));
                    }
                    values[nargs] = vargs;
                } else {
                    Object vargs = Array.newInstance(argtype, 1);
                    Array.set(vargs, 0, TypeCoercion.coerce(elctx, last, argtype));
                    values[nargs] = vargs;
                }
            } else {
                Object vargs = Array.newInstance(argtype, vargc);
                for (int i = 0; i < vargc; ++i) {
                    Array.set(vargs, i, TypeCoercion.coerce(elctx, args[ivarg++].getValue(elctx), argtype));
                }
                values[nargs] = vargs;
            }
        }
        try {
            return method.invoke(base, values);
        }
        catch (InvocationTargetException ex) {
            ELEngine.invokeError(elctx, ex.getTargetException());
        }
        catch (Exception ex) {
            ELEngine.invokeError(elctx, ex);
        }
        throw new AssertionError();
    }

    public static MethodInfo getTargetMethodInfo(ELContext elctx, Object target) {
        if (target == null) {
            return null;
        }
        if (target instanceof Closure) {
            return ((Closure)((Object)target)).getMethodInfo(elctx);
        }
        if (target instanceof ClosureObject) {
            Closure proc = ((ClosureObject)target).get_closure(elctx, "__call__");
            if (proc != null) {
                return proc.getMethodInfo(elctx);
            }
        } else {
            if (target instanceof Class) {
                Class cls = (Class)target;
                return new MethodInfo(cls.getSimpleName(), cls, new Class[]{Object.class});
            }
            MethodClosure method = MethodResolver.getInstance(elctx).resolveMethod(target.getClass(), "__call__");
            if (method != null) {
                return method.getMethodInfo(elctx);
            }
        }
        return null;
    }

    public static Object invokeTarget(ELContext elctx, Object target, Closure[] args) {
        if (target == null) {
            throw new NullPointerException();
        }
        if (target instanceof Closure) {
            return ((Closure)((Object)target)).invoke(elctx, args);
        }
        if (target instanceof ClosureObject) {
            Object result = ((ClosureObject)target).invokeSpecial(elctx, "__call__", args);
            if (result != ELUtils.NO_RESULT) {
                return result;
            }
        } else {
            if (target instanceof Class) {
                MethodClosure method;
                Class cls = (Class)target;
                if (!(args.length == 1 && ELEngine.isStandardType(cls) || (method = MethodResolver.getInstance(elctx).resolveStaticMethod(cls, "valueOf")) == null)) {
                    return method.invoke(elctx, null, args);
                }
                if (args.length != 1) {
                    throw new EvaluationException(elctx, Resources._T("EL_FN_BAD_ARG_COUNT", cls.getSimpleName(), 1, args.length));
                }
                Object result = args[0].getValue(elctx);
                return cls == Void.TYPE ? null : TypeCoercion.coerce(elctx, result, cls);
            }
            MethodClosure method = MethodResolver.getInstance(elctx).resolveMethod(target.getClass(), "__call__");
            if (method != null) {
                return method.invoke(elctx, target, args);
            }
        }
        throw new EvaluationException(elctx, Resources._T("EL_METHOD_NOT_FOUND", target.getClass().getName(), "__call__"));
    }

    private static boolean isStandardType(Class type) {
        return type.isPrimitive() || STANDARD_TYPES.contains(type);
    }

    public static Closure[] getCallArgs(Object[] args) {
        return ELEngine.getCallArgs(args, ELUtils.NO_PARAMS);
    }

    public static Closure[] getCallArgs(Object[] args, Closure[] extra) {
        if (extra == null) {
            extra = ELUtils.NO_PARAMS;
        }
        if (args.length == 0) {
            return extra;
        }
        int argc = args.length + extra.length;
        Closure[] callArgs = new Closure[argc];
        for (int i = 0; i < args.length; ++i) {
            callArgs[i] = new LiteralClosure(args[i]);
        }
        if (extra.length != 0) {
            System.arraycopy(extra, 0, callArgs, args.length, extra.length);
        }
        return callArgs;
    }

    public static Object[] getArgValues(ELContext elctx, Closure[] args) {
        if (args == null || args.length == 0) {
            return ELUtils.NO_VALUES;
        }
        Object[] values = new Object[args.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = args[i].getValue(elctx);
        }
        return values;
    }

    public static Object resolveClass(EvaluationContext context, String name) {
        ClassDefinition cls;
        ELContext elctx = context.getELContext();
        if (name == null) {
            return null;
        }
        if (name.indexOf(46) == -1 && (cls = context.resolveClass(name)) != null) {
            return cls;
        }
        return ELEngine.resolveJavaClass(elctx, name);
    }

    public static Class resolveJavaClass(ELContext elctx, String name) {
        try {
            return ClassResolver.getInstance(elctx).resolveClass(name);
        }
        catch (ClassNotFoundException ex) {
            throw new EvaluationException(elctx, "class not found: " + name);
        }
    }

    public static Constructor<?> resolveConstructor(ELContext elctx, Class<?> cls, Closure[] args) {
        Constructor<?> candidate = null;
        int shortest_dist = 0;
        for (Constructor<?> cons : cls.getConstructors()) {
            Class[] types = cons.getParameterTypes();
            if (types.length != args.length) continue;
            int d = ELEngine.distanceof(elctx, types, args, args.length);
            if (d == 0) {
                return cons;
            }
            if (d == -1) continue;
            if (candidate == null) {
                candidate = cons;
                shortest_dist = d;
                continue;
            }
            if (d >= shortest_dist) continue;
            candidate = cons;
            shortest_dist = d;
        }
        return candidate;
    }

    public static Object newInstance(ELContext elctx, Class<?> cls, Closure[] args) {
        try {
            if (Modifier.isAbstract(cls.getModifiers())) {
                throw new EvaluationException(elctx, Resources._T("EL_ABSTRACT_CLASS", cls.getName()));
            }
            if (args.length == 0) {
                return cls.newInstance();
            }
            Constructor<?> cons = ELEngine.resolveConstructor(elctx, cls, args);
            if (cons == null) {
                throw new EvaluationException(elctx, Resources._T("EL_METHOD_NOT_FOUND", cls.getName(), cls.getSimpleName()));
            }
            Class<?>[] types = cons.getParameterTypes();
            Object[] values = new Object[args.length];
            for (int i = 0; i < types.length; ++i) {
                values[i] = TypeCoercion.coerce(elctx, args[i].getValue(elctx), types[i]);
            }
            return cons.newInstance(values);
        }
        catch (InvocationTargetException ex) {
            throw new EvaluationException(elctx, ex.getTargetException());
        }
        catch (EvaluationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new EvaluationException(elctx, ex);
        }
    }

    private static int distanceof(ELContext elctx, Closure arg, Class type) {
        if (ELEngine.delayed(type)) {
            return 0;
        }
        Object value = arg.getValue(elctx);
        if (value instanceof ClosureObject) {
            value = ((ClosureObject)value).get_proxy();
        }
        if (value == null) {
            return 20;
        }
        return TypeCoercion.distanceof(value.getClass(), type);
    }

    private static int distanceof(ELContext elctx, Class[] types, Closure[] args, int nargs) {
        int dist = 0;
        for (int i = 0; i < nargs; ++i) {
            int d = ELEngine.distanceof(elctx, args[i], types[i]);
            if (d == -1) {
                return -1;
            }
            dist += d;
        }
        return dist;
    }

    private static boolean delayed(Class<?> type) {
        return type == ValueExpression.class || type == Closure.class;
    }

    private static void invokeError(ELContext elctx, Throwable cause) {
        if (cause instanceof EvaluationException) {
            throw (EvaluationException)((Object)cause);
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        throw new EvaluationException(elctx, cause);
    }

    private static boolean classPresent(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    static {
        STANDARD_TYPES.addAll(Arrays.asList(Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class, BigInteger.class, BigDecimal.class, Rational.class, Decimal.class, String.class));
        MEASURES_AVAILABLE = ELEngine.classPresent("javax.measure.Measure");
    }
}

