/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval;

import elite.lang.Closure;
import elite.xml.Namespace;
import javax.el.ELContext;
import javax.el.FunctionMapper;
import javax.el.MethodNotFoundException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.operamasks.el.eval.Frame;
import org.operamasks.el.eval.PropertyDelegate;
import org.operamasks.el.eval.StackTrace;
import org.operamasks.el.eval.closure.AbstractClosure;
import org.operamasks.el.eval.closure.ClassDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluationContext
extends AbstractClosure
implements PropertyDelegate {
    private ELContext elctx;
    private FunctionMapper fnm;
    private StackTrace trace;
    private Resolver head;
    private Resolver tail;

    public EvaluationContext(ELContext elctx) {
        this(elctx, elctx.getFunctionMapper(), elctx.getVariableMapper());
    }

    public EvaluationContext(ELContext elctx, FunctionMapper fm, VariableMapper vm) {
        this.elctx = elctx;
        this.fnm = fm;
        if (vm != null) {
            this.tail = new VMResolver(vm, null);
        }
        this.declarePrefix("xml", "http://www.w3.org/XML/1998/namespace");
        this.declarePrefix("xmlns", "http://www.w3.org/2000/xmlns/");
    }

    public ELContext getELContext() {
        return this.elctx;
    }

    public void setELContext(ELContext elctx) {
        if (elctx != this.elctx) {
            this.elctx = elctx;
            this.trace = null;
        }
    }

    public FunctionMapper getFunctionMapper() {
        return this.fnm != null ? this.fnm : this.elctx.getFunctionMapper();
    }

    public Frame getFrame() {
        if (this.trace == null) {
            this.trace = StackTrace.getInstance(this.elctx);
        }
        return this.trace.frame;
    }

    private EvaluationContext() {
    }

    public EvaluationContext pushContext() {
        EvaluationContext newctx = new EvaluationContext();
        newctx.elctx = this.elctx;
        newctx.fnm = this.fnm;
        newctx.trace = this.trace;
        newctx.head = newctx.tail = this.tail;
        return newctx;
    }

    public EvaluationContext pushContext(VariableMapper env) {
        EvaluationContext newctx = new EvaluationContext();
        newctx.elctx = this.elctx;
        newctx.fnm = this.fnm;
        newctx.trace = this.trace;
        newctx.head = this.tail;
        newctx.tail = new VMResolver(env, this.tail);
        return newctx;
    }

    public void setVariable(String name, ValueExpression value) {
        if (name.equals("xmlns") || name.startsWith("xmlns:")) {
            String prefix = name.equals("xmlns") ? "" : name.substring(6);
            Namespace namespace = new Namespace(prefix, null);
            namespace.setValue(this.elctx, value.getValue(this.elctx));
            this.internalSetVariable(name, namespace);
        } else {
            this.internalSetVariable(name, value);
        }
    }

    private void internalSetVariable(String name, ValueExpression value) {
        Resolver r = this.tail;
        while (r != this.head) {
            if (r.set(name, value)) {
                return;
            }
            r = r.next;
        }
        if (value != null) {
            this.tail = new Variable(name, value, this.tail);
        }
    }

    public ValueExpression resolveVariable(String name) {
        Resolver r = this.tail;
        while (r != null) {
            ValueExpression value = r.resolve(name);
            if (value != null) {
                return value;
            }
            r = r.next;
        }
        if (name.equals("environ")) {
            return this;
        }
        return null;
    }

    public ValueExpression resolveLocalVariable(String name) {
        Resolver r = this.tail;
        while (r != this.head) {
            ValueExpression value = r.resolve(name);
            if (value != null) {
                return value;
            }
            r = r.next;
        }
        return null;
    }

    public ClassDefinition resolveClass(String name) {
        Resolver r = this.tail;
        while (r != null) {
            ClassDefinition cls = this.resolveClass(r.resolve(name));
            if (cls != null) {
                return cls;
            }
            r = r.next;
        }
        return null;
    }

    private ClassDefinition resolveClass(ValueExpression ve) {
        Object value;
        if (ve instanceof ClassDefinition) {
            return (ClassDefinition)ve;
        }
        if (ve != null && (value = ve.getValue(this.elctx)) instanceof ClassDefinition) {
            return (ClassDefinition)value;
        }
        return null;
    }

    public void declarePrefix(String prefix, String uri) {
        String name = prefix.length() == 0 ? "xmlns" : "xmlns:" + prefix;
        this.internalSetVariable(name, new Namespace(prefix, uri));
    }

    public String getURI(String prefix) {
        String name = prefix.length() == 0 ? "xmlns" : "xmlns:" + prefix;
        ValueExpression ve = this.resolveVariable(name);
        return ve instanceof Namespace ? ((Namespace)ve).getUri() : null;
    }

    @Override
    public Object getValue(ELContext elctx, Object property) {
        ValueExpression expr;
        if (property instanceof String && (expr = this.resolveVariable((String)property)) != null) {
            Object value = expr.getValue(elctx);
            elctx.setPropertyResolved(true);
            return value;
        }
        return null;
    }

    @Override
    public Class<?> getType(ELContext elctx, Object property) {
        ValueExpression expr;
        if (property instanceof String && (expr = this.resolveVariable((String)property)) != null) {
            Class type = expr.getType(elctx);
            elctx.setPropertyResolved(true);
            return type;
        }
        return null;
    }

    @Override
    public void setValue(ELContext elctx, Object property, Object value) {
        ValueExpression expr;
        if (property instanceof String && (expr = this.resolveVariable((String)property)) != null) {
            expr.setValue(elctx, value);
            elctx.setPropertyResolved(true);
        }
    }

    @Override
    public boolean isReadOnly(ELContext elctx, Object property) {
        ValueExpression expr;
        if (property instanceof String && (expr = this.resolveVariable((String)property)) != null) {
            boolean readonly = expr.isReadOnly(elctx);
            elctx.setPropertyResolved(true);
            return readonly;
        }
        return false;
    }

    @Override
    public Object getValue(ELContext elctx) {
        return this;
    }

    @Override
    public Class<?> getType(ELContext context) {
        return EvaluationContext.class;
    }

    @Override
    public Class<?> getExpectedType() {
        return EvaluationContext.class;
    }

    @Override
    public Object invoke(ELContext elctx, Closure[] args) {
        throw new MethodNotFoundException();
    }

    static class Variable
    extends Resolver {
        String name;
        ValueExpression value;

        Variable(String name, ValueExpression value, Resolver next) {
            super(next);
            this.name = name;
            this.value = value;
        }

        ValueExpression resolve(String name) {
            if (name.equals(this.name) && this.value != null) {
                return this.value;
            }
            return null;
        }

        boolean set(String name, ValueExpression value) {
            if (name.equals(this.name)) {
                this.value = value;
                return true;
            }
            return false;
        }
    }

    static class VMResolver
    extends Resolver {
        VariableMapper vm;

        VMResolver(VariableMapper vm, Resolver next) {
            super(next);
            this.vm = vm;
        }

        ValueExpression resolve(String name) {
            return this.vm.resolveVariable(name);
        }

        boolean set(String name, ValueExpression value) {
            this.vm.setVariable(name, value);
            return true;
        }
    }

    static abstract class Resolver {
        Resolver next;

        Resolver(Resolver next) {
            this.next = next;
        }

        abstract ValueExpression resolve(String var1);

        abstract boolean set(String var1, ValueExpression var2);
    }
}

