/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval;

import javax.el.ELContext;
import javax.el.ELException;
import org.operamasks.el.eval.Frame;
import org.operamasks.el.eval.StackTrace;

public class EvaluationException
extends ELException {
    private Frame frame;

    public EvaluationException(ELContext elctx, String message) {
        super(message);
        this.frame = elctx == null ? null : StackTrace.getFrame(elctx);
    }

    public EvaluationException(ELContext elctx, Throwable cause) {
        super(cause);
        this.frame = elctx == null ? null : StackTrace.getFrame(elctx);
    }

    public EvaluationException(ELContext elctx, String message, Throwable cause) {
        super(message, cause);
        this.frame = elctx == null ? null : StackTrace.getFrame(elctx);
    }

    public String getRawMessage() {
        return super.getMessage();
    }

    public String getMessage() {
        if (this.frame == null) {
            return super.getMessage();
        }
        StringBuilder buf = new StringBuilder();
        buf.append(super.getMessage());
        buf.append("\n");
        for (Frame f = this.frame; f != null; f = f.getNext()) {
            buf.append("\tat ").append(f).append("\n");
        }
        buf.append("-------------------------");
        return buf.toString();
    }

    public String getFileName() {
        return this.frame == null ? null : this.frame.getFileName();
    }

    public int getLineNumber() {
        return this.frame == null ? -1 : this.frame.getLineNumber();
    }

    public int getColumnNumber() {
        return this.frame == null ? -1 : this.frame.getColumnNumber();
    }
}

