/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELException;
import javax.el.FunctionMapper;
import org.operamasks.el.resources.Resources;
import org.operamasks.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionMapperImpl
extends FunctionMapper
implements Serializable {
    private static final long serialVersionUID = 4287860736854130693L;
    private Map<String, Method> map = new HashMap<String, Method>();

    public Method resolveFunction(String prefix, String localName) {
        return this.map.get(this.key(prefix, localName));
    }

    public void addFunction(String prefix, String localName, Method method) {
        String key = this.key(prefix, localName);
        if (!this.map.containsKey(key)) {
            this.map.put(key, method);
        }
    }

    public void addFunction(String prefix, String localName, Class clazz, String methodName, Class[] args) {
        try {
            Method method = clazz.getMethod(methodName, args);
            this.addFunction(prefix, localName, method);
        }
        catch (NoSuchMethodException ex) {
            throw new ELException(Resources._T("EL_FN_NO_SUCH_METHOD", methodName, this.key(prefix, localName), clazz.getName()));
        }
    }

    private String key(String prefix, String localName) {
        if (prefix == null || prefix.length() == 0) {
            return localName;
        }
        return prefix + ":" + localName;
    }

    public Map<String, Method> getFunctionMap() {
        return this.map;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.map.size());
        for (Map.Entry<String, Method> e : this.map.entrySet()) {
            String varName = e.getKey();
            Method method = e.getValue();
            Class<?>[] paramTypes = method.getParameterTypes();
            out.writeUTF(varName);
            out.writeUTF(method.getDeclaringClass().getName());
            out.writeUTF(method.getName());
            out.writeInt(paramTypes.length);
            for (Class<?> type : paramTypes) {
                out.writeUTF(type.getName());
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.map = new HashMap<String, Method>();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Method method;
            String varName = in.readUTF();
            Class clazz = Utils.findClass(in.readUTF());
            String methodName = in.readUTF();
            Class[] paramTypes = new Class[in.readInt()];
            for (int j = 0; j < paramTypes.length; ++j) {
                paramTypes[j] = Utils.findClass(in.readUTF());
            }
            try {
                method = clazz.getMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException(ex);
            }
            this.map.put(varName, method);
        }
    }
}

